/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.networking.srpc;

public enum SrpcDataType {
    BOOLEAN(0),
    INT4(1),
    INT8(2),
    BYTE(6),
    BOOLEAN_ARRAY(64),
    INT4_ARRAY(65),
    INT8_ARRAY(66),
    STRING(69),
    BYTE_ARRAY(70),
    LIST(79);

    private final byte value;

    private SrpcDataType(byte value) {
        this.value = value;
    }

    public byte getType() {
        return this.value;
    }

    public static SrpcDataType isType(byte specimen) {
        byte filtered = (byte)(specimen & 0x7F);
        for (SrpcDataType srpcDataType : SrpcDataType.values()) {
            if (filtered != srpcDataType.getType()) continue;
            return srpcDataType;
        }
        throw new IllegalArgumentException("Not a valid type!");
    }
}

