/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.networking.srpc;

import de.seetec.v5.shared.networking.srpc.SrpcContext;
import de.seetec.v5.shared.networking.srpc.SrpcContextImpl;
import de.seetec.v5.shared.networking.srpc.SrpcMessage;
import java.util.LinkedList;
import java.util.List;

class SrpcContextPool {
    private final List<SrpcContextImpl> contexts;
    private final int initCap;
    private final int loThresh;
    private final int hiThresh;

    SrpcContextPool(int initCapacity) {
        this.initCap = initCapacity;
        this.loThresh = (int)((double)initCapacity * 0.25);
        this.hiThresh = initCapacity * 2;
        this.contexts = new LinkedList<SrpcContextImpl>();
        this.ensureCapacity();
    }

    synchronized SrpcContext getContext(SrpcMessage msg, long timeout) {
        this.ensureCapacity();
        if (this.contexts.size() <= 0) {
            SrpcContextImpl ctx = new SrpcContextImpl(msg, timeout);
            return ctx;
        }
        SrpcContextImpl ctx = this.contexts.remove(0);
        ctx.set(msg, timeout);
        return ctx;
    }

    synchronized void releaseContext(SrpcContextImpl ctx) {
        ctx.reset();
        this.contexts.add(ctx);
    }

    private void ensureCapacity() {
        if (this.contexts.size() < this.loThresh) {
            while (this.contexts.size() < this.initCap) {
                this.contexts.add(new SrpcContextImpl());
            }
        }
        if (this.contexts.size() > this.hiThresh) {
            this.contexts.remove(0);
        }
    }
}

