/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.networking.srpc;

import de.seetec.v5.shared.networking.srpc.SrpcContext;
import de.seetec.v5.shared.networking.srpc.SrpcContextPool;
import de.seetec.v5.shared.networking.srpc.SrpcFuture;
import de.seetec.v5.shared.networking.srpc.SrpcMessage;
import java.util.concurrent.TimeUnit;

class SrpcContextImpl
implements SrpcContext {
    public static final long DEFAULT_TIMEOUT_MILLIES = TimeUnit.MINUTES.toMillis(3L);
    private static SrpcContextPool POOL = new SrpcContextPool(10);
    private long timeout = Long.MAX_VALUE;
    private SrpcFuture future;
    private SrpcMessage message;

    SrpcContextImpl() {
        this.reset();
    }

    SrpcContextImpl(SrpcMessage msg, long timeout) {
        this.reset();
        this.set(msg, timeout);
    }

    public static SrpcContext get(SrpcMessage msg, long timeoutAsOffsetInMillis) {
        return POOL.getContext(msg, timeoutAsOffsetInMillis);
    }

    public void release() {
        POOL.releaseContext(this);
    }

    public final void reset() {
        this.timeout = Long.MAX_VALUE;
        this.future = new SrpcFuture();
        this.message = null;
    }

    public final void set(SrpcMessage msg, long timeoutAsOffsetInMillis) {
        this.timeout = timeoutAsOffsetInMillis < Long.MAX_VALUE ? System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeoutAsOffsetInMillis) : System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(DEFAULT_TIMEOUT_MILLIES);
        this.message = msg;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public SrpcFuture getFuture() {
        return this.future;
    }

    @Override
    public SrpcMessage getMessage() {
        return this.message;
    }
}

