/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.net.srpc.re;

import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.srpc.RequestWrapper;
import de.seetec.v5.shared.networking.srpc.GObject;
import de.seetec.v5.shared.networking.srpc.Methods;
import java.util.Date;
import java.util.List;

public class ReqReadGOP
extends RequestWrapper {
    private Long timestamp = null;
    private Integer transactionId = null;

    public ReqReadGOP(Long timestamp, Integer transactionId) {
        this.timestamp = timestamp;
        this.transactionId = transactionId;
    }

    @Override
    public GObject createGObject() {
        GObject goRequest = GObject.createList();
        goRequest.addChild(this.timestamp);
        goRequest.addChild(this.transactionId);
        return goRequest;
    }

    public static RequestWrapper parseGObject(GObject goRequest) {
        List<GObject> lParameters = goRequest.getChildren();
        Long timestamp = lParameters.get(0).getAsLong();
        Integer transactionID = lParameters.get(1).tryGetAsInt();
        return new ReqReadGOP(timestamp, transactionID);
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public Integer getTransactionId() {
        return this.transactionId;
    }

    public String toString() {
        String sTimestamp = "undefined";
        if (this.timestamp != null) {
            sTimestamp = Basic.longToFormattedString(this.timestamp) + "]/[" + new Date(this.timestamp);
        }
        String sTransactionId = "undefined";
        if (this.transactionId != null) {
            sTransactionId = Basic.longToFormattedString(this.transactionId);
        }
        return "[" + Methods.RE_SRPC_REQ_READGOP.methodName() + ", Timestamp=[" + sTimestamp + "], TransactionId=[" + sTransactionId + "]]";
    }
}

