/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.net.srpc;

import de.seetec.v5.shared.net.srpc.SrpcQueueCleanPolicy;
import de.seetec.v5.shared.net.srpc.re.ReqReadGOP;
import de.seetec.v5.shared.net.srpc.re.ReqReadMultipleFrames;
import de.seetec.v5.shared.net.srpc.re.ReqReadNextFrame;
import de.seetec.v5.shared.net.srpc.re.ReqReadPreviousFrame;
import de.seetec.v5.shared.networking.srpc.Methods;
import de.seetec.v5.shared.networking.srpc.RequestHandlerCallback;
import de.seetec.v5.shared.networking.srpc.SrpcMessage;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OutdatedTransactionIdPolicy
implements SrpcQueueCleanPolicy {
    private Logger logger = LogManager.getLogger((String)this.getClass().getName());

    @Override
    public boolean clean(SrpcMessage newMessage, SrpcMessage checkedMessage, Map<UUID, RequestHandlerCallback> callbacks) {
        Methods newMethod = newMessage.getMethod();
        Methods checkedMethod = checkedMessage.getMethod();
        if (checkedMethod == newMethod) {
            int newTransactionId = 0;
            int checkedTransactionId = 0;
            switch (newMethod) {
                case RE_SRPC_REQ_READGOP: {
                    newTransactionId = ((ReqReadGOP)ReqReadGOP.parseGObject(newMessage.getPayload())).getTransactionId();
                    checkedTransactionId = ((ReqReadGOP)ReqReadGOP.parseGObject(checkedMessage.getPayload())).getTransactionId();
                    break;
                }
                case RE_SRPC_REQ_READMULTIPLEFRAMES: {
                    newTransactionId = ((ReqReadMultipleFrames)ReqReadMultipleFrames.parseGObject(newMessage.getPayload())).getTransactionId();
                    checkedTransactionId = ((ReqReadMultipleFrames)ReqReadMultipleFrames.parseGObject(checkedMessage.getPayload())).getTransactionId();
                    break;
                }
                case RE_SRPC_REQ_READNEXTFRAME: {
                    newTransactionId = ((ReqReadNextFrame)ReqReadNextFrame.parseGObject(newMessage.getPayload())).getTransactionId();
                    checkedTransactionId = ((ReqReadNextFrame)ReqReadNextFrame.parseGObject(checkedMessage.getPayload())).getTransactionId();
                    break;
                }
                case RE_SRPC_REQ_READPREVIOUSFRAME: {
                    newTransactionId = ((ReqReadPreviousFrame)ReqReadPreviousFrame.parseGObject(newMessage.getPayload())).getTransactionId();
                    checkedTransactionId = ((ReqReadPreviousFrame)ReqReadPreviousFrame.parseGObject(checkedMessage.getPayload())).getTransactionId();
                    break;
                }
            }
            if (newTransactionId > checkedTransactionId) {
                this.sendResponse(checkedMessage, callbacks);
                return true;
            }
        }
        return false;
    }

    private void sendResponse(SrpcMessage checkedMessage, Map<UUID, RequestHandlerCallback> callbacks) {
        try {
            SrpcMessage rsp = SrpcMessage.createResponse(checkedMessage, null);
            rsp.setError(0);
            RequestHandlerCallback requestHandlerCallback = callbacks.remove(checkedMessage.getId());
            requestHandlerCallback.onRequestHandled(checkedMessage, rsp);
        }
        catch (Exception exception) {
            this.logger.error("Unable to respond to outdated request [" + exception.getMessage() + "]");
        }
    }
}

