/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.net.srpc;

import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.EventType;
import de.seetec.v5.shared.net.srpc.ReqNotify;
import de.seetec.v5.shared.net.srpc.SrpcMessageFilter;
import de.seetec.v5.shared.networking.srpc.Methods;
import de.seetec.v5.shared.networking.srpc.RequestHandlerCallback;
import de.seetec.v5.shared.networking.srpc.SrpcMessage;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoadAndNotifySrpcMessageFilter
implements SrpcMessageFilter {
    private Logger logger = LogManager.getLogger((String)this.getClass().getName());

    @Override
    public boolean filter(Methods method, SrpcMessage message, RequestHandlerCallback callback, Collection<SrpcMessage> currentQueue) {
        if (this.isFilterThresholdReached(currentQueue) && this.isRequestIgnorable(method, message)) {
            this.logger.warn("Ignoring " + message + ", because the queue has reached half of the limit! QueueSize=[" + Basic.longToFormattedString((long)currentQueue.size()) + "]");
            return true;
        }
        return false;
    }

    private boolean isFilterThresholdReached(Collection<SrpcMessage> currentQueue) {
        return currentQueue.size() > 125;
    }

    private boolean isRequestIgnorable(Methods method, SrpcMessage message) {
        if (method == Methods.NOTIFY) {
            ReqNotify request = (ReqNotify)ReqNotify.parseGObject(message.getPayload());
            return request.getEventType().longValue() != EventType.ENT_EVENTTYPE_CORE_STARTED.getType();
        }
        return false;
    }
}

