/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.net;

import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.SSLConstantsIntf;
import de.seetec.v5.shared.net.CipherSuitesFilter;
import de.seetec.v5.shared.net.CipherSuitesFilterMode;
import de.seetec.v5.shared.net.NetworkDispatcherHeader;
import de.seetec.v5.shared.net.SRPCDispatcherListener;
import de.seetec.v5.shared.net.SSLProtocol;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SRPCDispatcher
extends Basic
implements Runnable {
    private static final int SO_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(20L);
    private static final String CLASS_NAME = "de.seetec.v5.shared.net.SRPCDispatcher";
    private final Logger logger;
    private final Map<Long, SRPCDispatcherListener> htListener;
    private ServerSocket serverSocket = null;
    private int port = -1;
    private int maxActiveThread = 0;
    private int timeout = (int)TimeUnit.MINUTES.toMillis(2L);

    public SRPCDispatcher() {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
        this.htListener = new Hashtable<Long, SRPCDispatcherListener>();
    }

    SRPCDispatcher(int timeout) {
        this();
        this.timeout = timeout;
    }

    public void init(int nPort) throws SeeTecException {
        this.checkPortParameter(nPort);
        this.createServerSocket(true, false);
        Thread myThread = new Thread((Runnable)this, this.toString());
        myThread.start();
    }

    public void initTls(int port) throws SeeTecException {
        this.initTls(port, "../../conf/", false);
    }

    public void initTls(int port, boolean useStrictCipherSuites) throws SeeTecException {
        this.initTls(port, "../../conf/", useStrictCipherSuites);
    }

    void initTls(int nPort, String confPath) throws SeeTecException {
        this.initTls(nPort, confPath, false);
    }

    void initTls(int nPort, String confPath, boolean useStrictCipherSuites) throws SeeTecException {
        this.checkPortParameter(nPort);
        System.setProperty("jdk.tls.ephemeralDHKeySize", "2048");
        System.setProperty("jdk.tls.rejectClientInitiatedRenegotiation", "true");
        System.setProperty("javax.net.ssl.keyStore", confPath + "certificate.cer");
        System.setProperty("javax.net.ssl.keyStorePassword", "123456");
        System.setProperty("javax.net.ssl.trustStore", confPath + "certificate.cer");
        System.setProperty("javax.net.ssl.trustStorePassword", "123456");
        this.createServerSocket(false, useStrictCipherSuites);
        Thread myThread = new Thread((Runnable)this, this.toString());
        myThread.start();
    }

    private void createServerSocket(boolean plain, boolean useStrictCipherSuites) throws SeeTecException {
        long tsTimout = System.currentTimeMillis() + (long)this.timeout;
        while (true) {
            try {
                if (plain) {
                    this.serverSocket = new ServerSocket(this.port);
                    break;
                }
                this.serverSocket = SSLServerSocketFactory.getDefault().createServerSocket(this.port);
                ((SSLServerSocket)this.serverSocket).setNeedClientAuth(false);
                ((SSLServerSocket)this.serverSocket).setEnabledProtocols(new String[]{SSLProtocol.TLS12.getProtocolString(), SSLProtocol.TLS13.getProtocolString()});
                if (!useStrictCipherSuites) break;
                String[] enabledCipherSuitesFromSocket = ((SSLServerSocket)this.serverSocket).getEnabledCipherSuites();
                CipherSuitesFilter cipherSuitesFilter = new CipherSuitesFilter(CipherSuitesFilterMode.MODERN);
                String[] filteredCipherSuites = cipherSuitesFilter.filter(enabledCipherSuitesFromSocket);
                ((SSLServerSocket)this.serverSocket).setEnabledCipherSuites(filteredCipherSuites);
            }
            catch (Exception e) {
                this.checkForTimeout(tsTimout);
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
    }

    private void checkForTimeout(long tsTimout) throws SeeTecException {
        if (System.currentTimeMillis() > tsTimout) {
            throw new SeeTecException(-20010, "Cannot establish SRPCDispatcher at port [" + this.port + "]. Maybe another daemon is already active :-(");
        }
    }

    private void checkPortParameter(int port) throws RuntimeException {
        this.port = port;
        if (this.port <= 0 || this.port >= 65536) {
            throw new RuntimeException("Argument [Port]=[" + Basic.longToFormattedString((long)this.port) + "] not valid for " + this);
        }
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
                this.serverSocket = null;
            }
        }
        catch (IOException ioe) {
            this.logger.error("  Problem closing ServerSocket: " + ioe.getClass().getName() + ": " + ioe.getMessage() + " :-(");
            return -20011;
        }
        return 0;
    }

    @Override
    public void run() {
        block8: while (true) {
            try {
                while (!this.isShutdown(CLASS_NAME)) {
                    Socket socket = this.serverSocket.accept();
                    DispatcherThread dispatcherThread = new DispatcherThread();
                    try {
                        dispatcherThread.init(socket);
                        continue block8;
                    }
                    catch (Throwable ex) {
                        dispatcherThread = null;
                        try {
                            socket.close();
                        }
                        catch (Throwable ioex) {
                            this.logger.debug((Object)ioex, ioex);
                        }
                        this.logger.warn((Object)ex, ex);
                    }
                }
                break;
            }
            catch (Exception ex) {
                if (!this.isShutdown(CLASS_NAME)) {
                    this.logger.error("Error while accepting incoming connection: ", (Throwable)ex);
                }
                this.shutdown();
                break;
            }
            catch (OutOfMemoryError oomex) {
                long freeMemory = Runtime.getRuntime().freeMemory();
                long totalMemory = Runtime.getRuntime().totalMemory();
                long usedMemory = totalMemory - freeMemory;
                this.logger.fatal(oomex + " for " + this);
                this.logger.fatal("  Total Memory:   [" + Basic.longToFormattedString(totalMemory) + "]");
                this.logger.fatal("  Free  Memory:   [" + Basic.longToFormattedString(freeMemory) + "]");
                this.logger.fatal("  Used  Memory:   [" + Basic.longToFormattedString(usedMemory) + "]");
                this.logger.fatal("  Threads:        [" + Basic.longToFormattedString((long)Thread.activeCount()) + "]");
                this.shutdown();
                break;
            }
            catch (Throwable ex) {
                this.shutdown();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(SRPCDispatcherListener listener, Long entityID) {
        Map<Long, SRPCDispatcherListener> map = this.htListener;
        synchronized (map) {
            SRPCDispatcherListener oldListener = this.htListener.get(entityID);
            if (oldListener != null && !oldListener.isShutdown() && listener != oldListener) {
                this.logger.warn(oldListener + " is still running and will be discarded! New listener is " + listener);
                oldListener.shutdown();
            }
            this.htListener.put(entityID, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SRPCDispatcherListener deregisterListener(Long entityID) {
        Map<Long, SRPCDispatcherListener> map = this.htListener;
        synchronized (map) {
            return this.htListener.remove(entityID);
        }
    }

    public String toString() {
        String sThis = this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", " + this.serverSocket + "]";
    }

    public class DispatcherThread
    implements Runnable {
        private Thread thread = null;
        private Socket socket = null;

        public void init(Socket socket) {
            this.socket = socket;
            if (this.socket == null) {
                throw new RuntimeException("Argument [Socket]=null is not valid for " + this);
            }
            this.thread = new Thread((Runnable)this, this.toString());
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block21: {
                try {
                    this.socket.setSoTimeout(SO_TIMEOUT);
                    InputStream is = this.socket.getInputStream();
                    boolean bValidConnection = true;
                    byte[] serviceAdressing = new byte[64];
                    int nLen = -1;
                    long tsTimeout = System.currentTimeMillis() + (long)SO_TIMEOUT;
                    for (int nOffset = 0; nOffset < serviceAdressing.length && System.currentTimeMillis() < tsTimeout; nOffset += nLen) {
                        try {
                            nLen = is.read(serviceAdressing, nOffset, serviceAdressing.length - nOffset);
                            if (nLen >= 0) continue;
                            SRPCDispatcher.this.logger.error("No valid connection from " + this.socket + ": Header has only [" + nOffset + " B] :-(");
                            bValidConnection = false;
                            break;
                        }
                        catch (SSLHandshakeException ex) {
                            try {
                                SSLParameters pars = ((SSLSocket)this.socket).getSSLParameters();
                                SRPCDispatcher.this.logger.error(String.format("[%s] could not establish SSL/TLS connection with [%s]. Reason: %s", SRPCDispatcher.this.toString(), this.socket, ex.getCause() != null ? ex.getCause().getMessage() : ex.getMessage()));
                                SRPCDispatcher.this.logger.error(String.format("Failing Socket Parameters:%n   CipherSuites=%s%n   Protocols=%s%n   Need Client Auth = %s , Want Client Auth = %s%nSession: %s", Arrays.toString(pars.getCipherSuites()), Arrays.toString(pars.getProtocols()), pars.getNeedClientAuth(), pars.getWantClientAuth(), ((SSLSocket)this.socket).getSession()));
                            }
                            catch (ClassCastException cce) {
                                SRPCDispatcher.this.logger.error((Object)cce, (Throwable)cce);
                            }
                            catch (Exception cce) {
                                // empty catch block
                            }
                            bValidConnection = false;
                            break;
                        }
                        catch (Throwable ex) {
                            SRPCDispatcher.this.logger.error("No valid srpc connection from " + this.socket, ex);
                            SRPCDispatcher.this.logger.error(String.format("Header was [%s] bytes long by now. Header read: %s", nOffset, Arrays.toString(serviceAdressing)));
                            bValidConnection = false;
                            break;
                        }
                    }
                    if (!bValidConnection) break block21;
                    int nMagic = Basic.byteArrayToInt4(serviceAdressing, 0, 4);
                    long nServiceID = Basic.byteArrayToInt8(serviceAdressing, 4, 8);
                    byte protocol = serviceAdressing[12];
                    long nClientID = Basic.byteArrayToInt8(serviceAdressing, 21, 8);
                    NetworkDispatcherHeader networkDispatcherHeader = new NetworkDispatcherHeader(nServiceID, protocol, nClientID);
                    if (nMagic != Basic.byteArrayToInt4(SSLConstantsIntf.SSL_SRPC_TCP_HEADER)) {
                        SRPCDispatcher.this.logger.error(String.format("MAGIC of %s is not valid! MAGIC was %s , should be %s", this.socket, Integer.toHexString(nMagic), Integer.toHexString(Basic.byteArrayToInt4(SSLConstantsIntf.SSL_SRPC_TCP_HEADER))));
                        break block21;
                    }
                    int nActiveThreads = Thread.activeCount();
                    if (nActiveThreads > SRPCDispatcher.this.maxActiveThread) {
                        SRPCDispatcher.this.maxActiveThread = nActiveThreads;
                    }
                    SRPCDispatcherListener listener = null;
                    Map map = SRPCDispatcher.this.htListener;
                    synchronized (map) {
                        listener = (SRPCDispatcherListener)SRPCDispatcher.this.htListener.get(nServiceID);
                    }
                    if (listener != null && !listener.isShutdown()) {
                        if (networkDispatcherHeader.getProtocol() != 0) {
                            SRPCDispatcher.this.logger.info(String.format("Dispatching Non-SRPC-connection %s to %s ...", this.socket, listener));
                            listener.handleRequest(this.socket, networkDispatcherHeader);
                        } else {
                            listener.handleRequest(this.socket);
                        }
                        return;
                    }
                }
                catch (Throwable ex) {
                    SRPCDispatcher.this.logger.error((Object)ex, ex);
                }
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Throwable ex) {
                    SRPCDispatcher.this.logger.warn((Object)ex, ex);
                }
                this.socket = null;
            }
        }
    }
}

