/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.net;

import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.SSLConstantsIntf;
import de.seetec.v5.shared.net.HTTPBody;
import de.seetec.v5.shared.net.HTTPHeader;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HTTPResponse {
    private HTTPBody httpBody;
    private HTTPHeader httpHeader;
    private byte[] data;
    private boolean hasBody;
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());

    public HTTPResponse(byte[] data) {
        byte[] localData = this.assureDoubleCRLF(data);
        int index = Basic.indexOfByteArray(data, SSLConstantsIntf.DOUBLE_CRLF_BYTE, 0, Integer.MIN_VALUE, true);
        if (index != -1) {
            this.data = Arrays.copyOf(localData, index);
            this.httpHeader = new HTTPHeader(this.data);
            int bodyLength = data.length - 4 - this.data.length;
            if (bodyLength > 0) {
                byte[] body = Arrays.copyOfRange(localData, index + 4, localData.length);
                this.httpBody = new HTTPBody(body);
                this.hasBody = true;
            }
        }
    }

    private byte[] assureDoubleCRLF(byte[] data) {
        ArrayList<Byte> dataList = new ArrayList<Byte>();
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == 13 && (i == data.length - 1 || data[i + 1] != 10)) {
                try {
                    dataList.add(data[i]);
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    boolean bl = false;
                }
                dataList.add((byte)10);
                continue;
            }
            if (i < data.length - 1 && data[i] != 13 && data[i + 1] == 10) {
                dataList.add(data[i]);
                dataList.add((byte)13);
                dataList.add((byte)10);
                ++i;
                continue;
            }
            dataList.add(data[i]);
        }
        byte[] dataByteArray = new byte[dataList.size()];
        for (int i = 0; i < dataList.size(); ++i) {
            dataByteArray[i] = (Byte)dataList.get(i);
        }
        byte[] TRIPLE_CRLF_BYTE = new byte[]{13, 10, 13, 10, 13, 10};
        int index = Basic.indexOfByteArray(dataByteArray, TRIPLE_CRLF_BYTE, 0, true);
        while (index != -1) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                baos.write(dataByteArray, 0, index);
                baos.write(SSLConstantsIntf.DOUBLE_CRLF_BYTE);
                baos.write(dataByteArray, index + TRIPLE_CRLF_BYTE.length, dataByteArray.length - index - TRIPLE_CRLF_BYTE.length);
                dataByteArray = baos.toByteArray();
            }
            catch (Exception ex) {
                this.logger.warn("Exception while replacing triple CRLF-Bytes");
            }
            index = Basic.indexOfByteArray(dataByteArray, TRIPLE_CRLF_BYTE, 0, true);
        }
        return dataByteArray;
    }

    public HTTPBody getHttpBody() {
        return this.httpBody;
    }

    public HTTPHeader getHttpHeader() {
        return this.httpHeader;
    }

    public boolean hasBody() {
        return this.hasBody;
    }
}

