/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.logging;

import de.seetec.v5.shared.DefaultSystemTimeProvider;
import de.seetec.v5.shared.SystemTimeProvider;
import java.util.Hashtable;
import java.util.Map;

public class FloodingMgr {
    private final Map<Long, Map<Long, Long>> htErrors = new Hashtable<Long, Map<Long, Long>>();
    private final SystemTimeProvider systemTimeProvider;

    public FloodingMgr() {
        this(new DefaultSystemTimeProvider());
    }

    protected FloodingMgr(SystemTimeProvider systemTimeProvider) {
        this.systemTimeProvider = systemTimeProvider;
    }

    public int checkFlooding(long error, long etyid, long deadTime) {
        if (deadTime < 0L) {
            return -20002;
        }
        Map<Long, Long> entityIDs = this.htErrors.get(error);
        if (entityIDs == null) {
            entityIDs = new Hashtable<Long, Long>();
            entityIDs.put(etyid, this.systemTimeProvider.currentTimeMillis() + deadTime);
            this.htErrors.put(error, entityIDs);
        } else {
            Long dead = entityIDs.get(etyid);
            if (dead == null) {
                entityIDs.put(etyid, this.systemTimeProvider.currentTimeMillis() + deadTime);
            } else {
                if (dead > this.systemTimeProvider.currentTimeMillis()) {
                    return -20054;
                }
                entityIDs.put(etyid, this.systemTimeProvider.currentTimeMillis() + deadTime);
            }
        }
        return 0;
    }

    public void resetFlooding(long error, long etyid) {
        Map<Long, Long> entityIds = this.htErrors.get(error);
        if (entityIds != null) {
            entityIds.remove(etyid);
        }
    }

    public void clear() {
        this.htErrors.values().stream().forEach(map -> map.clear());
        this.htErrors.clear();
    }
}

