/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.interaction;

import de.seetec.v5.shared.interaction.SyncStatusByStatusComparator;
import de.seetec.v5.shared.interaction.SyncStatusDataObject;
import de.seetec.v5.shared.networking.srpc.GObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SyncStatusListConverter {
    public static GObject toGObject(List<SyncStatusDataObject> list) {
        if (list == null) {
            return null;
        }
        Collections.sort(list, new SyncStatusByStatusComparator());
        GObject statesWithEntities = GObject.createList();
        int lastStatus = !list.isEmpty() ? list.get(0).getStatus() : 0;
        ArrayList<Long> entities = new ArrayList<Long>();
        Iterator<SyncStatusDataObject> iterator = list.iterator();
        while (iterator.hasNext()) {
            SyncStatusDataObject syncStatusDataObject = iterator.next();
            if (lastStatus != Integer.MIN_VALUE && lastStatus != syncStatusDataObject.getStatus()) {
                SyncStatusListConverter.createStatusToIdMapping(entities, lastStatus, statesWithEntities);
            }
            entities.add(syncStatusDataObject.getID());
            lastStatus = syncStatusDataObject.getStatus();
            if (iterator.hasNext()) continue;
            SyncStatusListConverter.createStatusToIdMapping(entities, lastStatus, statesWithEntities);
        }
        return statesWithEntities;
    }

    private static void createStatusToIdMapping(List<Long> entities, int lastStatus, GObject statesWithEntities) {
        Collections.sort(entities);
        long[] entity = new long[entities.size()];
        for (int i = 0; i < entities.size(); ++i) {
            entity[i] = entities.get(i);
        }
        GObject singleStatusWithEntities = GObject.createList();
        singleStatusWithEntities.addChild(lastStatus);
        singleStatusWithEntities.addChild(entity);
        statesWithEntities.addChild(singleStatusWithEntities);
        entities.clear();
    }

    public static List<SyncStatusDataObject> fromGObject(GObject statesWithEntities) {
        if (statesWithEntities == null) {
            return null;
        }
        ArrayList<SyncStatusDataObject> list = new ArrayList<SyncStatusDataObject>();
        for (GObject singleStatusWithEntities : statesWithEntities.getChildren()) {
            int status = singleStatusWithEntities.getChildAt(0).getAsInt();
            long[] entity = singleStatusWithEntities.getChildAt(1).getAsArrayOfLong();
            for (int i = 0; i < entity.length; ++i) {
                SyncStatusDataObject syncStatusDataObject = new SyncStatusDataObject(entity[i], status);
                list.add(syncStatusDataObject);
            }
        }
        return list;
    }
}

