/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared.interaction;

import de.seetec.v5.shared.interaction.IDDataObject;
import de.seetec.v5.shared.networking.srpc.GObject;
import de.seetec.v5.shared.util.SeeTecException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class SyncEntityDataObject
extends IDDataObject {
    private static final long serialVersionUID = -1302185352900492530L;
    private String name = null;
    private Long ETTID = Long.MIN_VALUE;
    private Long MID = Long.MIN_VALUE;
    private boolean active;
    private int status = Integer.MIN_VALUE;
    private byte[] configuration = null;
    private Long physicalParent = Long.MIN_VALUE;
    private Long physicalOrder = Long.MIN_VALUE;
    private Long logicalParent = Long.MIN_VALUE;
    private Long logicalOrder = Long.MIN_VALUE;
    private Boolean deleted;
    private Long syncID = Long.MIN_VALUE;
    private String description = null;

    public SyncEntityDataObject(int code) {
        super(code);
    }

    public SyncEntityDataObject(Long ETYID, String name, Long ETTID, Long MID, boolean active, int status, byte[] configuration, Long physicalParent, Long physicalOrder, Long logicalParent, Long logicalOrder, Boolean deleted, Long syncID, String description) {
        super(ETYID);
        this.name = name;
        this.ETTID = ETTID;
        this.MID = MID;
        this.active = active;
        this.status = status;
        this.configuration = configuration;
        this.physicalParent = physicalParent;
        this.physicalOrder = physicalOrder;
        this.logicalParent = logicalParent;
        this.logicalOrder = logicalOrder;
        this.deleted = deleted;
        this.syncID = syncID;
        this.description = description;
    }

    public static SyncEntityDataObject parseResultSet(ResultSet resultSet) throws SeeTecException {
        try {
            Long MID = resultSet.getLong(4);
            MID = resultSet.wasNull() ? null : MID;
            Long physParent = resultSet.getLong(8);
            physParent = resultSet.wasNull() ? null : physParent;
            Long physOrder = resultSet.getLong(9);
            physOrder = resultSet.wasNull() ? null : physOrder;
            Long logParent = resultSet.getLong(10);
            logParent = resultSet.wasNull() ? null : logParent;
            Long logOrder = resultSet.getLong(11);
            logOrder = resultSet.wasNull() ? null : logOrder;
            Boolean deleted = resultSet.getBoolean(12);
            deleted = resultSet.wasNull() ? null : deleted;
            Long sync = resultSet.getLong(13);
            sync = resultSet.wasNull() ? null : sync;
            SyncEntityDataObject rawEntity = new SyncEntityDataObject(resultSet.getLong(1), resultSet.getString(2), resultSet.getLong(3), MID, resultSet.getBoolean(5), resultSet.getInt(6), resultSet.getBytes(7), physParent, physOrder, logParent, logOrder, deleted, sync, resultSet.getString(14));
            return rawEntity;
        }
        catch (Exception exception) {
            throw new SeeTecException(-20000, "ResultSet has not expected content.");
        }
    }

    public GObject createGObject() {
        GObject single = GObject.createList();
        single.addChild(this.getID());
        single.addChild(this.getName());
        single.addChild(this.getETTID());
        single.addChild(this.getMID());
        single.addChild(this.isActive());
        single.addChild(this.getStatus());
        single.addChild(this.getConfiguration());
        single.addChild(this.getPhysicalParent());
        single.addChild(this.getPhysicalOrder());
        single.addChild(this.getLogicalParent());
        single.addChild(this.getLogicalOrder());
        single.addChild(this.isDeleted());
        single.addChild(this.getSyncID());
        single.addChild(this.getDescription());
        return single;
    }

    public static List<SyncEntityDataObject> parseGObject(GObject goResponse) {
        ArrayList<SyncEntityDataObject> entityList = new ArrayList<SyncEntityDataObject>();
        if (goResponse != null && goResponse.getChildren() != null) {
            goResponse.getChildren().stream().forEach(goEntity -> entityList.add(SyncEntityDataObject.parseSingleEntityGObject(goEntity)));
        }
        return entityList;
    }

    private static SyncEntityDataObject parseSingleEntityGObject(GObject goEntity) {
        return new SyncEntityDataObject(goEntity.getChildAt(0).getAsLong(), goEntity.getChildAt(1).getAsString(), goEntity.getChildAt(2).getAsLong(), goEntity.getChildAt(3).tryGetAsLong(), goEntity.getChildAt(4).getAsBoolean(), goEntity.getChildAt(5).getAsInt(), goEntity.getChildAt(6).tryGetAsArrayOfByte(), goEntity.getChildAt(7).tryGetAsLong(), goEntity.getChildAt(8).tryGetAsLong(), goEntity.getChildAt(9).tryGetAsLong(), goEntity.getChildAt(10).tryGetAsLong(), goEntity.getChildAt(11).getAsBoolean(), goEntity.getChildAt(12).getAsLong(), goEntity.getChildAt(13).tryGetAsString());
    }

    public static SyncEntityDataObject createMagic() {
        return new SyncEntityDataObject(0L, "MAGIC", 0L, 0L, true, 0, null, 0L, 0L, 0L, 0L, false, -1L, null);
    }

    public boolean isMagic() {
        return this.getID() == 0L && this.getName().equals("MAGIC") && this.getETTID() == 0L && this.getMID() == 0L && this.isActive() && this.getStatus() == 0 && this.getConfiguration() == null && this.getLogicalParent() == 0L && this.getLogicalOrder() == 0L && this.getPhysicalParent() == 0L && this.getPhysicalOrder() == 0L && this.isDeleted() == false && this.getSyncID() == -1L && this.getDescription() == null;
    }

    public String getName() {
        return this.name;
    }

    public Long getETTID() {
        return this.ETTID;
    }

    public Long getMID() {
        return this.MID;
    }

    public boolean isActive() {
        return this.active;
    }

    public int getStatus() {
        return this.status;
    }

    public byte[] getConfiguration() {
        return this.configuration;
    }

    public Long getPhysicalParent() {
        return this.physicalParent;
    }

    public Long getPhysicalOrder() {
        return this.physicalOrder;
    }

    public Long getLogicalParent() {
        return this.logicalParent;
    }

    public Long getLogicalOrder() {
        return this.logicalOrder;
    }

    public Boolean isDeleted() {
        return this.deleted;
    }

    public Long getSyncID() {
        return this.syncID;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public String toString() {
        return String.format("Entity %s,'%s',Type: %s, MID: %s, Active: %s, Status: %s, PhysicalParent/Order: %s/%s, LogicalParent/Order: %s/%s, Deleted? %s, syncid: %s", this.getID(), this.name, this.ETTID, this.MID, this.active, this.status, this.physicalParent, this.physicalOrder, this.logicalParent, this.logicalOrder, this.deleted, this.syncID);
    }
}

