/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.shared;

import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class TimeHelper {
    public static String getReadableTimerange(long nTimerange) {
        if (nTimerange < 0L) {
            return "INVALID TIMERANGE";
        }
        long days = TimeUnit.MILLISECONDS.toDays(nTimerange);
        long hours = TimeUnit.MILLISECONDS.toHours(nTimerange % TimeUnit.DAYS.toMillis(1L));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(nTimerange % TimeUnit.HOURS.toMillis(1L));
        return String.format("%d d, %d h, %d m", days, hours, minutes);
    }

    public static String timeStringTillMidnight(long timeTillMidnight) {
        if (timeTillMidnight < 0L) {
            return "--:--";
        }
        long hours = TimeUnit.MILLISECONDS.toHours(timeTillMidnight);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(timeTillMidnight % TimeUnit.HOURS.toMillis(1L));
        return String.format("%02d:%02d", hours, minutes);
    }

    public static long getMillisecondsInDay() {
        return TimeHelper.getMillisecondsInDay(new Date().getTime());
    }

    public static long getMillisecondsInDay(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        long nMillisecondsOfDay = TimeUnit.HOURS.toMillis(calendar.get(11)) + TimeUnit.MINUTES.toMillis(calendar.get(12)) + TimeUnit.SECONDS.toMillis(calendar.get(13)) + (long)calendar.get(14);
        return nMillisecondsOfDay;
    }

    public static int getDaysSince1970(long ts) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(ts);
        int nActualYear = calendar.get(1);
        int nDaySince1970 = calendar.get(6);
        for (int i = 1970; i < nActualYear; ++i) {
            calendar.set(i, 11, 31, 5, 6, 7);
            nDaySince1970 += calendar.get(6);
        }
        return nDaySince1970;
    }
}

