/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared.timerange;

import de.seetec.v5.re.cm.shared.timerange.TimeRange;
import de.seetec.v5.re.cm.shared.timerange.TimeRangeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class TimeRangeList
extends ArrayList<TimeRangeInfo> {
    private static final long serialVersionUID = -7552482326892649877L;
    private boolean containsFailoverData = false;
    private boolean containsDefaultData = false;
    private Long startTimestamp = 0L;

    public TimeRangeList() {
    }

    public TimeRangeList(ArrayList<TimeRangeInfo> list) {
        super(list);
        for (TimeRangeInfo t : list) {
            if (t.isFailover()) {
                this.containsFailoverData = true;
                continue;
            }
            this.containsDefaultData = true;
        }
    }

    public TimeRangeList(TimeRangeList timeRangeInfoList) {
        for (TimeRangeInfo timeRangeInfo : timeRangeInfoList) {
            if (timeRangeInfo.isFailover()) {
                this.containsFailoverData = true;
            }
            TimeRangeInfo ri = new TimeRangeInfo(timeRangeInfo.getTimestamp(), timeRangeInfo.getLength(), timeRangeInfo.getTrack(), timeRangeInfo.isFailover());
            this.add(ri);
        }
    }

    @Override
    public boolean add(TimeRangeInfo t) {
        if (t.isFailover()) {
            this.containsFailoverData = true;
        } else {
            this.containsDefaultData = true;
        }
        return super.add(t);
    }

    @Override
    public void add(int index, TimeRangeInfo t) {
        if (t.isFailover()) {
            this.containsFailoverData = true;
        } else {
            this.containsDefaultData = true;
        }
        super.add(index, t);
    }

    @Override
    public boolean addAll(Collection<? extends TimeRangeInfo> list) {
        for (TimeRangeInfo timeRangeInfo : list) {
            if (timeRangeInfo.isFailover()) {
                this.containsFailoverData = true;
                continue;
            }
            this.containsDefaultData = true;
        }
        return super.addAll(list);
    }

    @Override
    public boolean addAll(int index, Collection<? extends TimeRangeInfo> list) {
        for (TimeRangeInfo timeRangeInfo : list) {
            if (timeRangeInfo.isFailover()) {
                this.containsFailoverData = true;
                continue;
            }
            this.containsDefaultData = true;
        }
        return super.addAll(index, list);
    }

    public TimeRangeInfo getTimeRangeInfoAtTimestamp(long timestamp) {
        for (TimeRangeInfo timeRangeInfo : this) {
            if (!timeRangeInfo.containsTimestamp(timestamp)) continue;
            return timeRangeInfo;
        }
        return null;
    }

    public TimeRangeInfo getNextTimeRangeInfo(long timestamp) {
        TimeRangeInfo timeRangeInfo = null;
        timeRangeInfo = this.getTimeRangeInfoAtTimestamp(timestamp -= this.startTimestamp.longValue());
        if (timeRangeInfo != null) {
            return timeRangeInfo;
        }
        if (this.isEmpty()) {
            return null;
        }
        if (this.size() == 1 && timestamp < ((TimeRangeInfo)this.get(0)).getTimestamp()) {
            return (TimeRangeInfo)this.get(0);
        }
        if (timestamp > ((TimeRangeInfo)this.get(this.size() - 1)).getTimestamp() + (long)((TimeRangeInfo)this.get(this.size() - 1)).getLength()) {
            return null;
        }
        for (int i = 0; i < this.size(); ++i) {
            TimeRangeInfo tri = (TimeRangeInfo)this.get(i);
            long startOfTimeRangeInfo = tri.getTimestamp();
            if (startOfTimeRangeInfo <= timestamp) continue;
            return tri;
        }
        return null;
    }

    public TimeRangeInfo getPreviousTimeRangeInfo(long timestamp) {
        if (this.isEmpty() || this.size() == 1 && (timestamp -= this.startTimestamp.longValue()) < ((TimeRangeInfo)this.get(0)).getTimestamp()) {
            return null;
        }
        TimeRangeInfo resultTimeRangeInfo = this.getTimeRangeInfoAtTimestamp(timestamp);
        if (resultTimeRangeInfo == null) {
            resultTimeRangeInfo = this.getTimeRangeInfoBeforeTimestamp(timestamp);
        }
        return resultTimeRangeInfo;
    }

    private TimeRangeInfo getTimeRangeInfoBeforeTimestamp(long timestamp) {
        TimeRangeInfo resultTimeRangeInfo = null;
        long msToTargetTimestamp = Long.MAX_VALUE;
        for (int i = this.size() - 1; i >= 0; --i) {
            TimeRangeInfo timeRangeInfo = (TimeRangeInfo)this.get(i);
            long endOfTimeRangeInfo = timeRangeInfo.getTimestamp() + (long)timeRangeInfo.getLength();
            if (endOfTimeRangeInfo >= timestamp || timestamp - endOfTimeRangeInfo >= msToTargetTimestamp) continue;
            msToTargetTimestamp = timestamp - endOfTimeRangeInfo;
            resultTimeRangeInfo = timeRangeInfo;
        }
        return resultTimeRangeInfo;
    }

    protected boolean isInMiddleOfPackage(long timestamp) {
        TimeRangeInfo t = this.getTimeRangeInfoAtTimestamp(timestamp);
        return t != null && t.getTimestamp() < timestamp && t.getTimestamp() + (long)t.getLength() > timestamp;
    }

    protected TimeRangeList insertTimeRangeInfo(TimeRangeInfo timeRangeInfo) {
        TimeRangeList timeRangeInfoList = new TimeRangeList(this);
        if (timeRangeInfo == null) {
            return timeRangeInfoList;
        }
        long endTimeStamp = timeRangeInfo.getTimestamp() + (long)timeRangeInfo.getLength();
        if (timeRangeInfoList.isEmpty()) {
            timeRangeInfoList.add(timeRangeInfo);
            if (timeRangeInfo.isFailover()) {
                timeRangeInfoList.setContainsFailoverData(true);
            }
            return timeRangeInfoList;
        }
        for (int i = 0; i < timeRangeInfoList.size(); ++i) {
            TimeRangeInfo timeRangeInfoFromList = (TimeRangeInfo)timeRangeInfoList.get(i);
            if (timeRangeInfoFromList.getTimestamp() >= endTimeStamp) continue;
            timeRangeInfoList.add(i, timeRangeInfo);
            if (timeRangeInfo.isFailover()) {
                timeRangeInfoList.setContainsFailoverData(true);
            }
            return timeRangeInfoList;
        }
        return timeRangeInfoList;
    }

    public void setStartTimestamp(Long startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public Long getStartTimestamp() {
        return this.startTimestamp;
    }

    public Long calculateRelativeTimestamp(Long absoluteTimestamp) {
        Long relativeTimestamp = absoluteTimestamp - this.getStartTimestamp();
        return relativeTimestamp;
    }

    public boolean containsFailoverData() {
        return this.containsFailoverData;
    }

    public void setContainsFailoverData(boolean containsFailoverData) {
        this.containsFailoverData = containsFailoverData;
    }

    public boolean containsDefaultData() {
        return this.containsDefaultData;
    }

    public LinkedList<Long[]> getLinkedListWithoutFailover() {
        LinkedList<Long[]> listForClient = new LinkedList<Long[]>();
        for (TimeRangeInfo tri : this) {
            listForClient.add(new Long[]{tri.getTimestamp(), tri.getTimestamp() + (long)tri.getLength()});
        }
        return listForClient;
    }

    public TimeRangeList getTimeRangeInfoForTimerange(Long from, Long till, Integer track) {
        TimeRangeList timeRangeInfoList = new TimeRangeList();
        for (TimeRangeInfo ri : this) {
            TimeRangeInfo timeRangeInfo = new TimeRangeInfo(ri);
            if (timeRangeInfo.getTimestamp() + (long)timeRangeInfo.getLength() + this.startTimestamp < from || timeRangeInfo.getTimestamp() + this.startTimestamp > till || track.byteValue() != -1 && track.byteValue() != timeRangeInfo.getTrack()) continue;
            if (timeRangeInfo.getTimestamp() + this.startTimestamp < from) {
                long oldTimestamp = timeRangeInfo.getTimestamp();
                timeRangeInfo.setTimestamp(from - this.startTimestamp);
                timeRangeInfo.setLength((int)((long)timeRangeInfo.getLength() - (timeRangeInfo.getTimestamp() - oldTimestamp)));
            }
            if (till < timeRangeInfo.getTimestamp() + (long)timeRangeInfo.getLength() + this.startTimestamp) {
                timeRangeInfo.setLength((int)(till - timeRangeInfo.getTimestamp() - this.startTimestamp));
            }
            timeRangeInfoList.add(timeRangeInfo);
        }
        return timeRangeInfoList;
    }

    private TimeRangeList splitTimeRangeInfoAt(TimeRangeInfo givenTimeRangeInfo) {
        long startTimeStamp = givenTimeRangeInfo.getTimestamp();
        long endTimeStamp = givenTimeRangeInfo.getTimestamp() + (long)givenTimeRangeInfo.getLength();
        TimeRangeList timeRangeInfoList = new TimeRangeList(this);
        TimeRangeInfo startFoundTimeRangeInfo = timeRangeInfoList.getTimeRangeInfoAtTimestamp(startTimeStamp);
        TimeRangeInfo endFoundTimeRangeInfo = timeRangeInfoList.getTimeRangeInfoAtTimestamp(endTimeStamp);
        if (startFoundTimeRangeInfo != null && endFoundTimeRangeInfo != null && startFoundTimeRangeInfo.equals(endFoundTimeRangeInfo) && timeRangeInfoList.isInMiddleOfPackage(startTimeStamp) && timeRangeInfoList.isInMiddleOfPackage(endTimeStamp)) {
            TimeRangeInfo timeRangeInfo1 = new TimeRangeInfo(startTimeStamp, (int)(endTimeStamp - startTimeStamp), startFoundTimeRangeInfo.getTrack(), startFoundTimeRangeInfo.isFailover());
            timeRangeInfoList = timeRangeInfoList.insertTimeRangeInfo(timeRangeInfo1);
            TimeRangeInfo timeRangeInfo2 = new TimeRangeInfo(startFoundTimeRangeInfo.getTimestamp(), (int)(startTimeStamp - startFoundTimeRangeInfo.getTimestamp()), startFoundTimeRangeInfo.getTrack(), startFoundTimeRangeInfo.isFailover());
            timeRangeInfoList = timeRangeInfoList.insertTimeRangeInfo(timeRangeInfo2);
            TimeRangeInfo timeRangeInfo3 = new TimeRangeInfo(endTimeStamp, (int)(startFoundTimeRangeInfo.getTimestamp() + (long)startFoundTimeRangeInfo.getLength() - endTimeStamp), startFoundTimeRangeInfo.getTrack(), startFoundTimeRangeInfo.isFailover());
            timeRangeInfoList = timeRangeInfoList.insertTimeRangeInfo(timeRangeInfo3);
            timeRangeInfoList.remove(startFoundTimeRangeInfo);
        } else {
            TimeRangeInfo[] timeRangeInfos;
            TimeRangeInfo foundTimeRangeInfo;
            if (timeRangeInfoList.isInMiddleOfPackage(startTimeStamp)) {
                foundTimeRangeInfo = timeRangeInfoList.getTimeRangeInfoAtTimestamp(startTimeStamp);
                timeRangeInfos = this.splitTimeRangeInfoByTimeStamp(foundTimeRangeInfo, startTimeStamp);
                timeRangeInfoList.add(timeRangeInfos[0]);
                timeRangeInfoList.add(timeRangeInfos[1]);
                timeRangeInfoList.remove(foundTimeRangeInfo);
            }
            if (timeRangeInfoList.isInMiddleOfPackage(endTimeStamp)) {
                foundTimeRangeInfo = timeRangeInfoList.getTimeRangeInfoAtTimestamp(endTimeStamp);
                timeRangeInfos = this.splitTimeRangeInfoByTimeStamp(foundTimeRangeInfo, endTimeStamp);
                timeRangeInfoList.add(timeRangeInfos[0]);
                timeRangeInfoList.add(timeRangeInfos[1]);
                timeRangeInfoList.remove(foundTimeRangeInfo);
            }
        }
        return timeRangeInfoList;
    }

    private TimeRangeInfo[] splitTimeRangeInfoByTimeStamp(TimeRangeInfo timeRangeInfo, long timeStampToSplit) {
        TimeRangeInfo leftTimeRangeInfo = new TimeRangeInfo(timeRangeInfo.getTimestamp(), (int)(timeStampToSplit - timeRangeInfo.getTimestamp()), timeRangeInfo.getTrack(), timeRangeInfo.isFailover());
        TimeRangeInfo rightTimeRangeInfo = new TimeRangeInfo(timeStampToSplit, (int)(timeRangeInfo.getTimestamp() + (long)timeRangeInfo.getLength() - timeStampToSplit), timeRangeInfo.getTrack(), timeRangeInfo.isFailover());
        return new TimeRangeInfo[]{leftTimeRangeInfo, rightTimeRangeInfo};
    }

    public TimeRangeList dissect(TimeRangeList timeRangeInfoList) {
        TimeRangeList timeRangeInfoListLocal = new TimeRangeList(this);
        for (TimeRangeInfo timeRangeInfo : timeRangeInfoList) {
            timeRangeInfoListLocal = timeRangeInfoListLocal.splitTimeRangeInfoAt(timeRangeInfo);
        }
        return timeRangeInfoListLocal;
    }

    public TimeRangeList purge(TimeRangeList timeRangeInfoList) {
        TimeRangeList timeRangeInfoListLocal = new TimeRangeList(this);
        for (TimeRangeInfo externalTimeRangeInfo : timeRangeInfoList) {
            boolean internalTrackIsAlarm;
            long timestampExternalTimeRangeInfo = externalTimeRangeInfo.getTimestamp();
            TimeRangeInfo internalTimeRangeInfo = timeRangeInfoListLocal.getTimeRangeInfoAtTimestamp(timestampExternalTimeRangeInfo);
            if (internalTimeRangeInfo == null || internalTimeRangeInfo.getTimestamp() != externalTimeRangeInfo.getTimestamp() || internalTimeRangeInfo.getLength() != externalTimeRangeInfo.getLength()) continue;
            boolean externalTrackIsAlarm = externalTimeRangeInfo.getTrack() != 1;
            boolean bl = internalTrackIsAlarm = internalTimeRangeInfo.getTrack() != 1;
            if (!(externalTrackIsAlarm && !externalTimeRangeInfo.isFailover() || !internalTrackIsAlarm && internalTimeRangeInfo.isFailover()) && (!externalTrackIsAlarm || internalTrackIsAlarm)) continue;
            timeRangeInfoListLocal.remove(internalTimeRangeInfo);
        }
        return timeRangeInfoListLocal;
    }

    public TimeRangeList cleanAndMerge(long cumulationDistance) {
        cumulationDistance = cumulationDistance <= 0L ? 5000L : cumulationDistance;
        TimeRangeList timeRangeInfoList = new TimeRangeList(this);
        int pointer = 0;
        while (pointer < timeRangeInfoList.size() - 1) {
            long newLength;
            TimeRangeInfo currentTimeRangeInfo = (TimeRangeInfo)timeRangeInfoList.get(pointer);
            TimeRangeInfo nextTimeRangeInfo = (TimeRangeInfo)timeRangeInfoList.get(pointer + 1);
            if (currentTimeRangeInfo.getTrack() == nextTimeRangeInfo.getTrack() && currentTimeRangeInfo.getTimestamp() + (long)currentTimeRangeInfo.getLength() + cumulationDistance >= nextTimeRangeInfo.getTimestamp() && TimeRangeInfo.isValidLength(newLength = nextTimeRangeInfo.getTimestamp() + (long)nextTimeRangeInfo.getLength() - currentTimeRangeInfo.getTimestamp())) {
                currentTimeRangeInfo.setLength((int)newLength);
                timeRangeInfoList.remove(pointer + 1);
                continue;
            }
            ++pointer;
        }
        return timeRangeInfoList;
    }

    public void rebase(long aNewOffset) {
        long diff = this.getStartTimestamp() - aNewOffset;
        if (diff != 0L) {
            for (TimeRangeInfo ref : this) {
                ref.setTimestamp(ref.getTimestamp() + diff);
            }
            this.startTimestamp = aNewOffset;
        }
    }

    public void removeDuplicates() {
        if (this.size() > 1) {
            for (int i = this.size() - 1; i > 0; --i) {
                TimeRangeInfo first = (TimeRangeInfo)this.get(i);
                TimeRangeInfo second = (TimeRangeInfo)this.get(i - 1);
                if (first.getTimestamp() != second.getTimestamp() || first.getLength() != second.getLength() || first.getTrack() != second.getTrack()) continue;
                this.remove(first);
            }
        }
    }

    public final List<TimeRange> getGaps() {
        long cumulationDistance = TimeUnit.SECONDS.toMillis(3L);
        ArrayList<TimeRange> timeRanges = new ArrayList<TimeRange>();
        Collections.sort(this);
        for (int i = 0; i < this.size() - 1; ++i) {
            TimeRangeInfo timeRangeInfo = (TimeRangeInfo)this.get(i);
            TimeRangeInfo nextTimeRangeInfo = (TimeRangeInfo)this.get(i + 1);
            long endTimestamp = this.startTimestamp + timeRangeInfo.getTimestamp() + (long)timeRangeInfo.getLength();
            long nextStartTimestamp = this.startTimestamp + nextTimeRangeInfo.getTimestamp();
            if (nextStartTimestamp - endTimestamp <= cumulationDistance) continue;
            timeRanges.add(new TimeRange(endTimestamp, nextStartTimestamp));
        }
        return timeRanges;
    }
}

