/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared.srpc;

import de.seetec.v5.shared.networking.srpc.GObject;
import de.seetec.v5.shared.networking.srpc.SrpcDataType;
import de.seetec.v5.shared.util.SeeTecException;

public final class ReqSendFirmware {
    private final String fileName;
    private final byte[] firmwareData;

    private ReqSendFirmware(String fileName, byte[] data) {
        this.fileName = fileName;
        this.firmwareData = data;
    }

    public static ReqSendFirmware parseGObject(GObject goRequest) throws SeeTecException {
        if (goRequest == null) {
            throw new SeeTecException(-20002, "GObject is null");
        }
        if (goRequest.getType() != SrpcDataType.LIST.getType()) {
            throw new SeeTecException(-20002, "GObject is not of type LIST");
        }
        if (goRequest.getChildren().size() != 2) {
            throw new SeeTecException(-20002, "GObject children count is not correct");
        }
        if (goRequest.getChildAt(0).getType() != SrpcDataType.STRING.getType()) {
            throw new SeeTecException(-20002, "GObject child 1 is not of type STRING");
        }
        if (goRequest.getChildAt(1).getType() != SrpcDataType.BYTE_ARRAY.getType()) {
            throw new SeeTecException(-20002, "GObject child 2 is not of type BYTE_ARRAY");
        }
        return new ReqSendFirmware(goRequest.getChildAt(0).getAsString(), goRequest.getChildAt(1).getAsArrayOfByte());
    }

    public String getFilename() {
        return this.fileName;
    }

    public byte[] getFirmwareData() {
        return this.firmwareData;
    }
}

