/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared.srpc;

import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.networking.srpc.GObject;
import java.util.List;

public class ReqOpenContentStream {
    private static final String MethodName = "OpenContentStream";
    private Integer nMode = null;
    private Integer port = null;
    private Long nSessionID = null;
    private String sProtocol = null;
    private Long clientID = null;

    public ReqOpenContentStream(Integer nMode, Integer port, Long nSessionID, String sProtocol, Long clientID) {
        this.nMode = nMode;
        this.port = port;
        this.nSessionID = nSessionID;
        this.clientID = clientID;
        this.sProtocol = sProtocol;
        if (this.sProtocol == null) {
            this.sProtocol = "udp";
        }
    }

    public static ReqOpenContentStream parseGObject(GObject goRequest) {
        List lParameter = goRequest.getChildren();
        Integer nMode = ((GObject)lParameter.get(0)).getAsInt();
        Integer port = ((GObject)lParameter.get(1)).getAsInt();
        Long nSessionID = ((GObject)lParameter.get(2)).getAsLong();
        String sProtocol = lParameter.size() >= 4 ? ((GObject)lParameter.get(3)).getAsString() : null;
        Long clientID = lParameter.size() >= 5 ? Long.valueOf(((GObject)lParameter.get(4)).getAsLong()) : null;
        return new ReqOpenContentStream(nMode, port, nSessionID, sProtocol, clientID);
    }

    public Integer getMode() {
        return this.nMode;
    }

    public Integer getPort() {
        return this.port;
    }

    public Long getSessionID() {
        return this.nSessionID;
    }

    public String getProtocol() {
        return this.sProtocol;
    }

    public Long getClientID() {
        return this.clientID;
    }

    public String toString() {
        return "[OpenContentStream, Mode=[" + this.nMode + "], UDPPort=[" + this.port + "], ClientID=[" + Basic.longToFormattedString((Long)this.clientID) + "], SessionID=[" + Basic.longToFormattedString((Long)this.nSessionID) + "], Protocol=[" + this.sProtocol + "]]";
    }
}

