/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared.sql;

import de.seetec.v5.re.cm.shared.StatisticalData;
import de.seetec.v5.re.cm.shared.sql.AlarmCtx;
import de.seetec.v5.re.cm.shared.sql.FrameStatisticIntf;
import de.seetec.v5.re.cm.shared.sql.PreAlarmCtx;
import de.seetec.v5.re.cm.shared.sql.StandardCtx;
import de.seetec.v5.re.cm.shared.sql.strategies.AlarmRecording;
import de.seetec.v5.re.cm.shared.sql.strategies.NoRecording;
import de.seetec.v5.re.cm.shared.sql.strategies.PreAlarmRecording;
import de.seetec.v5.re.cm.shared.sql.strategies.Recording;
import de.seetec.v5.re.cm.shared.sql.strategies.StandardRecording;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.util.NamedThreadFactory;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class StatisticalSummary {
    private final long videoSourceID;
    private final boolean additionalAlarmRecordingEnabled;
    private final FrameStatisticIntf frameStatistic;
    private final StandardCtx standardCtx = new StandardCtx();
    private final AlarmCtx alarmCtx = new AlarmCtx();
    private final PreAlarmCtx preAlarmCtx = new PreAlarmCtx();
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("StatisticalSummary"));
    private int recordingMode = -1;
    private int oldRecordingMode = -1;
    private boolean alarmRecordingActive = false;
    private boolean oldAlarmRecordingActive = false;
    private long startTime = 0L;
    private long timeElapsed = 0L;
    private long packetLossRatio = 0L;

    public StatisticalSummary(long videoSourceID, FrameStatisticIntf frameStatistic, boolean additionalAlarmRecordingEnabled) throws SeeTecException {
        this.videoSourceID = videoSourceID;
        this.additionalAlarmRecordingEnabled = additionalAlarmRecordingEnabled;
        this.frameStatistic = frameStatistic;
        if (this.frameStatistic == null) {
            throw new SeeTecException(-21601, "Argument for StatisticalSummary was null");
        }
    }

    public void init() {
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (StatisticalSummary.this.statisticalDataReceived()) {
                    StatisticalSummary.this.calculateTimeElapsed();
                    StatisticalSummary.this.addStatisticalData(StatisticalSummary.this.timeElapsed);
                }
            }
        }, 1L, 1L, TimeUnit.MINUTES);
    }

    public void notifyForReceivedFrame(ContentFrame cf) {
        if (cf.getMediatype() == 65) {
            StatisticalData statisticalData = StatisticalData.parseStatisticalData(cf.getData());
            this.packetLossRatio += statisticalData.getPaketLossRatio();
            this.packetLossRatio /= 2L;
            return;
        }
        Recording recording = this.getRealRecordingMode(this.recordingMode, this.additionalAlarmRecordingEnabled, this.alarmRecordingActive);
        recording.addNumberOfReceivedFrames(this.getNumberOfFrames(cf));
    }

    public void notifyForWrittenFrame(ContentFrame cf) {
        Recording recording;
        int payloadSize = cf.getPayloadSize();
        int numberOfFrames = this.getNumberOfFrames(cf);
        if (this.oldRecordingMode != this.recordingMode || this.oldAlarmRecordingActive != this.alarmRecordingActive) {
            this.calculateTimeElapsed();
            recording = this.getRealRecordingMode(this.oldRecordingMode, this.additionalAlarmRecordingEnabled, this.oldAlarmRecordingActive);
            recording.addTime(this.timeElapsed);
            this.oldRecordingMode = this.recordingMode;
            this.oldAlarmRecordingActive = this.alarmRecordingActive;
        }
        recording = this.getRealRecordingMode(this.recordingMode, this.additionalAlarmRecordingEnabled, this.alarmRecordingActive);
        recording.addNumberOfStoredFrames(numberOfFrames, payloadSize);
    }

    public void notifyForDiscardedFrame(ContentFrame cf) {
        int numberOfFrames = this.getNumberOfFrames(cf);
        Recording recording = this.getRealRecordingMode(this.recordingMode, this.additionalAlarmRecordingEnabled, this.alarmRecordingActive);
        recording.addNumberOfDroppedFrames(numberOfFrames);
    }

    public void setRecordingModus(int recordingMode) {
        this.recordingMode = recordingMode;
    }

    public void setAlarmRecordingActive(boolean alarmRecordingActive) {
        this.alarmRecordingActive = alarmRecordingActive;
    }

    public void shutdown() {
        this.scheduledExecutorService.shutdownNow();
    }

    private void clearHistory() {
        this.standardCtx.clear();
        this.alarmCtx.clear();
        this.preAlarmCtx.clear();
        this.packetLossRatio = 0L;
        this.timeElapsed = 0L;
    }

    void addStatisticalData(long timeElapsed) {
        long timestamp = System.currentTimeMillis();
        Recording recording = this.getRealRecordingMode(this.recordingMode, this.additionalAlarmRecordingEnabled, this.alarmRecordingActive);
        recording.addTime(timeElapsed);
        this.frameStatistic.enqueueQueryForData(this.videoSourceID, this.standardCtx, this.alarmCtx, this.preAlarmCtx, this.packetLossRatio, timestamp);
        this.clearHistory();
    }

    private void calculateTimeElapsed() {
        if (this.startTime != 0L) {
            this.timeElapsed = this.measureTime(this.startTime);
        }
        this.startTime = System.currentTimeMillis();
    }

    private boolean statisticalDataReceived() {
        return this.standardCtx.isDataReceived() || this.alarmCtx.isDataReceived() || this.preAlarmCtx.isDataReceived();
    }

    private Recording getRealRecordingMode(int recordingMode, boolean additionalAlarmRecordingExists, boolean alarmRecordingActive) {
        switch (recordingMode) {
            case 0: {
                return additionalAlarmRecordingExists ? new NoRecording() : new AlarmRecording(this.alarmCtx);
            }
            case 1: {
                return new StandardRecording(this.standardCtx);
            }
            case -1: {
                if (additionalAlarmRecordingExists) {
                    return new NoRecording();
                }
                return alarmRecordingActive ? new AlarmRecording(this.alarmCtx) : new PreAlarmRecording(this.preAlarmCtx);
            }
        }
        return new PreAlarmRecording(this.preAlarmCtx);
    }

    private int getNumberOfFrames(ContentFrame cf) {
        switch (cf.getMediatype()) {
            case 0: 
            case 33: {
                return 1;
            }
            case 35: {
                return cf.getNumberOfFrameParts();
            }
        }
        return 0;
    }

    private long measureTime(long startTime) {
        long timeRange = 0L;
        long stopTime = System.currentTimeMillis();
        if (startTime == 0L) {
            timeRange = 0L;
        } else if (startTime < stopTime) {
            timeRange = stopTime - startTime;
        }
        return timeRange;
    }
}

