/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared.sql;

import de.seetec.v5.re.cm.shared.communication.LiveReader;
import de.seetec.v5.re.cm.shared.sql.SQLDatabaseHandler;
import de.seetec.v5.re.shared.ConfigurationElement;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.TimeHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;

public class ManagerLoggingOfCameraUsage
extends Basic
implements Runnable {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.shared.sql.ManagerLoggingOfCameraUsage";
    private static final String LIVE_CAMERA_ACCESS = "LiveCameraAccess";
    private static final String TABLE_VERSION = "TableVersion";
    private static final long TSOFFSET = 1759191760896L;
    private final Logger logger;
    private Thread thread = null;
    private final List<Object[]> vLiveLogging = new Vector<Object[]>();
    private final Hashtable<LiveReader, LiveReader> registeredLiveReader = new Hashtable();
    private volatile int insertCounter = 0;
    private boolean active = false;
    private long maxStoredDataAge = -1L;
    private SQLDatabaseHandler sqlDatabaseHandler = null;

    public ManagerLoggingOfCameraUsage() {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    public int init(SQLDatabaseHandler sqlDatabaseHandler) {
        this.sqlDatabaseHandler = sqlDatabaseHandler;
        if (this.sqlDatabaseHandler == null) {
            return -21601;
        }
        if (!this.sqlDatabaseHandler.doesTableExist(LIVE_CAMERA_ACCESS)) {
            this.createTableLiveCameraAccess();
            String query = "INSERT INTO TableVersion VALUES ( " + System.currentTimeMillis() + ", '" + LIVE_CAMERA_ACCESS + "', '5.3.8' )";
            if (this.sqlDatabaseHandler.executeSqlUpdate(query) != 0) {
                this.logger.warn("Inserting version tag for table [LiveCameraAccess] failed :-(");
            }
        }
        this.thread = new Thread((Runnable)this, this.toString());
        this.thread.start();
        return 0;
    }

    public void updateConfiguration(byte[] cnf) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(cnf);
            Document xmlCnf = new SAXBuilder().build((InputStream)bais);
            ConfigurationElement root = new ConfigurationElement(xmlCnf.getRootElement());
            ConfigurationElement cnfStoreMediaLiveAccess = root.getChild("StoreMediaLiveAccess");
            if (cnfStoreMediaLiveAccess != null && cnfStoreMediaLiveAccess.getAsBoolean()) {
                ConfigurationElement cnfMaxStoredDataAge = root.getChild("MaxStoredDataAge");
                if (cnfMaxStoredDataAge != null) {
                    this.maxStoredDataAge = cnfMaxStoredDataAge.getAsInt8();
                }
                if (!this.active) {
                    this.logger.info("LoggingOfLiveCameraUsage is now ACTIVE covering a timerange of [" + TimeHelper.getReadableTimerange((long)this.maxStoredDataAge) + "]");
                }
                this.active = true;
            }
        }
        catch (Throwable ex) {
            this.logger.warn("Problems parsing logging configuration :-(", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        long tsLastCheckOfRingbuffer = -1L;
        try {
            while (!this.isShutdown(CLASS_NAME)) {
                Object[] entries;
                Object liveReader;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    Enumeration<LiveReader> enumLiveReader = this.registeredLiveReader.elements();
                    while (enumLiveReader.hasMoreElements()) {
                        liveReader = enumLiveReader.nextElement();
                        if (!liveReader.isShutdown()) continue;
                        this.registeredLiveReader.remove(liveReader);
                    }
                }
                catch (Throwable ex) {
                    this.logger.warn((Object)ex, ex);
                }
                if (this.maxStoredDataAge > 0L && Math.abs(tsLastCheckOfRingbuffer - System.currentTimeMillis()) > 3600000L) {
                    this.checkRingbuffer();
                    tsLastCheckOfRingbuffer = System.currentTimeMillis();
                }
                liveReader = this.vLiveLogging;
                synchronized (liveReader) {
                    entries = new Object[this.vLiveLogging.size()];
                    for (int i = 0; i < this.vLiveLogging.size(); ++i) {
                        entries[i] = this.vLiveLogging.get(i);
                    }
                    this.vLiveLogging.clear();
                }
                if (entries.length <= 0) continue;
                long tsStart = System.currentTimeMillis();
                for (Object entrie : entries) {
                    int pos = -1;
                    Object[] entry = (Object[])entrie;
                    Long videoSourceID = (Long)entry[++pos];
                    Long userID = (Long)entry[++pos];
                    String userName = (String)entry[++pos];
                    Integer userNameHash = (Integer)entry[++pos];
                    Long startViewing = (Long)entry[++pos];
                    Long endViewing = (Long)entry[++pos];
                    this.addEntryLiveCameraUsage(videoSourceID, userID, userName, userNameHash, startViewing, endViewing);
                }
                long duration = System.currentTimeMillis() - tsStart;
                if (duration < 1000L) continue;
                this.logger.info("LoggingOfCameraUsage: Duration to insert [" + entries.length + "] entries: [" + Basic.longToFormattedString((long)duration) + " ms]");
            }
        }
        catch (Throwable ex) {
            this.logger.warn("Problems while shutting down thread of " + this, ex);
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.thread != null) {
            long timeout = System.currentTimeMillis() + 5000L;
            while (!super.isRunFinished(CLASS_NAME)) {
                if (System.currentTimeMillis() > timeout) {
                    this.logger.warn("Thread didn't finished in time :-(");
                    break;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.thread = null;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLoggingOfLiveCameraUsage(Long videoSourceID, Long userID, String userName, Long startViewing, Long endViewing) {
        if (!this.active || this.isShutdown(CLASS_NAME)) {
            return;
        }
        Integer userNameHash = userName.trim().toUpperCase().hashCode();
        List<Object[]> list = this.vLiveLogging;
        synchronized (list) {
            this.vLiveLogging.add(new Object[]{videoSourceID, userID, userName, userNameHash, startViewing, endViewing});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int countLoggingOfLiveCameraUsage(Long[] videoSources, Long[] userIDs, String[] userNames, Long startViewingMS, Long endViewingMS) {
        if (!this.active) {
            return 0;
        }
        String query = this.createQueryLoggingOfLiveCameraUsage("SELECT COUNT(*)", videoSources, userIDs, userNames, startViewingMS, endViewingMS);
        try (Statement statement = this.sqlDatabaseHandler.getConnection().createStatement();){
            long ts = System.currentTimeMillis();
            ResultSet resultSet = statement.executeQuery(query);
            resultSet.next();
            int counter = resultSet.getInt(1);
            long duration = System.currentTimeMillis() - ts;
            this.logger.info("CountLoggingOfLiveCameraUsage: [" + query + "]");
            this.logger.info("   Duration=[" + TimeHelper.getReadableTimerange((long)duration) + "], Counter=[" + Basic.longToFormattedString((long)counter) + "]");
            int n = counter;
            return n;
        }
        catch (SQLException ex) {
            this.logger.warn((Object)ex, (Throwable)ex);
            throw new RuntimeException("Count failed :-(");
        }
    }

    public Object[] getLoggingOfLiveCameraUsage(Long[] videoSources, Long[] userIDs, String[] userNames, Long startViewing, Long endViewing) {
        if (!this.active) {
            this.logger.warn("Logging is not active!");
            return new Object[0];
        }
        return this.queryLoggingOfLiveCameraUsage(videoSources, userIDs, userNames, startViewing, endViewing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRingbuffer() {
        if (this.maxStoredDataAge <= 0L) {
            return;
        }
        long oldestAcceptedTimestamp1970 = System.currentTimeMillis() - this.maxStoredDataAge;
        long oldestAcceptedTimestamp256ms = (int)(oldestAcceptedTimestamp1970 - 1759191760896L >> 8);
        String sqlQuery = "DELETE FROM LiveCameraAccess WHERE StartViewing < " + oldestAcceptedTimestamp256ms;
        try {
            int count;
            long ts = System.currentTimeMillis();
            List<Object[]> list = this.vLiveLogging;
            synchronized (list) {
                try (Statement statement = this.sqlDatabaseHandler.getConnection().createStatement();){
                    count = statement.executeUpdate(sqlQuery);
                }
            }
            if (count > 0) {
                long duration = System.currentTimeMillis() - ts;
                this.logger.info("Removing [" + Basic.longToFormattedString((long)count) + "] entries from table [" + LIVE_CAMERA_ACCESS + "] lasts for [" + Basic.longToFormattedString((long)duration) + " ms]");
            }
        }
        catch (SQLException sqlEx) {
            this.logger.warn("Problems exeuting sql statement: " + sqlQuery, (Throwable)sqlEx);
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
        }
    }

    private int createTableLiveCameraAccess() {
        String query = "CREATE TABLE LiveCameraAccess ( VideoSourceID BIGINT NOT NULL, UserID        BIGINT, UserName      VARCHAR( 256 ), UserNameHash  INT, StartViewing  INT NOT NULL, EndViewing    INT NOT NULL )";
        int errorCode = this.sqlDatabaseHandler.executeSqlUpdate(query);
        if (errorCode != 0) {
            this.logger.error("Cannot create table <LiveCameraAccess> :-(");
            return errorCode;
        }
        String idxTimerange = "idxTimerangeLiveCameraAccess";
        query = "CREATE INDEX " + idxTimerange + " ON " + LIVE_CAMERA_ACCESS + " ( StartViewing, EndViewing )";
        errorCode = this.sqlDatabaseHandler.executeSqlUpdate(query);
        if (errorCode != 0) {
            this.logger.error("Cannot create index <" + idxTimerange + " on table <" + LIVE_CAMERA_ACCESS + "> :-(");
            return errorCode;
        }
        return 0;
    }

    public void registerLiveReader(LiveReader liveReader) {
        this.registeredLiveReader.put(liveReader, liveReader);
    }

    public void deregisterLiveReader(LiveReader liveReader) {
        this.registeredLiveReader.remove((Object)liveReader);
    }

    private void addEntryLiveCameraUsage(Long videoSourceID, Long userID, String userName, Integer userNameHash, Long startViewinginMS, Long endViewinginMS) {
        int startViewing256ms = (int)(startViewinginMS - 1759191760896L >> 8);
        int endViewingin256ms = (int)(endViewinginMS - 1759191760896L >> 8);
        StringBuilder sbColumnNames = new StringBuilder(256);
        StringBuffer sbColumnValues = new StringBuffer(256);
        sbColumnNames.append(" VideoSourceID");
        sbColumnValues.append(" ").append(videoSourceID);
        if (userID != null && userID != -1L) {
            sbColumnNames.append(", UserID");
            sbColumnValues.append(", ").append(userID);
        }
        if (userName != null && userName.length() > 0) {
            sbColumnNames.append(", UserName, UserNameHash");
            sbColumnValues.append(", '").append(userName).append("', ").append(userNameHash);
        }
        sbColumnNames.append(", StartViewing, EndViewing");
        sbColumnValues.append(", ").append(startViewing256ms).append(", ").append(endViewingin256ms);
        String query = "INSERT INTO LiveCameraAccess (" + sbColumnNames.toString() + " ) VALUES ( " + sbColumnValues + " )";
        if (this.sqlDatabaseHandler.executeSqlUpdate(query) != 0) {
            this.logger.warn("Insert failed: [" + query + "]");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object[] queryLoggingOfLiveCameraUsage(Long[] videoSources, Long[] userIDs, String[] userNames, Long startViewingMS, Long endViewingMS) {
        Vector<Object[]> vResultList = new Vector<Object[]>();
        String query = this.createQueryLoggingOfLiveCameraUsage("Select *", videoSources, userIDs, userNames, startViewingMS, endViewingMS);
        try (Statement statement = this.sqlDatabaseHandler.getConnection().createStatement();){
            long ts = System.currentTimeMillis();
            ResultSet resultSet = statement.executeQuery(query);
            while (resultSet.next()) {
                Long qVideoSourceID = resultSet.getLong("VideoSourceID");
                Long qUserID = resultSet.getLong("UserID");
                String qUserName = resultSet.getString("UserName");
                Integer qStartViewing256ms = resultSet.getInt("StartViewing");
                Integer qEndViewing256ms = resultSet.getInt("EndViewing");
                Long qStartViewingMS = ((long)qStartViewing256ms.intValue() << 8) + 1759191760896L;
                Long qEndViewingMS = ((long)qEndViewing256ms.intValue() << 8) + 1759191760896L;
                vResultList.add(new Object[]{qVideoSourceID, qUserID, qUserName, qStartViewingMS, qEndViewingMS});
            }
            try {
                Enumeration<LiveReader> enumLiveReader = this.registeredLiveReader.elements();
                while (enumLiveReader.hasMoreElements()) {
                    LiveReader liveReader = enumLiveReader.nextElement();
                    if (liveReader.isShutdown()) {
                        this.registeredLiveReader.remove((Object)liveReader);
                        continue;
                    }
                    Object[] recentResult = liveReader.getRecentLoggingOfCameraLiveUsage(videoSources, userIDs, userNames, startViewingMS, endViewingMS);
                    if (recentResult == null) continue;
                    vResultList.add(recentResult);
                }
            }
            catch (Throwable ex) {
                this.logger.warn((Object)ex, ex);
            }
            Object[] oResultList = new Object[vResultList.size()];
            for (int i = 0; i < vResultList.size(); ++i) {
                oResultList[i] = vResultList.get(i);
            }
            long duration = System.currentTimeMillis() - ts;
            this.logger.info("Query: [" + query + "]");
            this.logger.info("   Duration: [" + TimeHelper.getReadableTimerange((long)duration) + "], Results: [" + Basic.longToFormattedString((long)oResultList.length) + "]");
            Object[] objectArray = oResultList;
            return objectArray;
        }
        catch (SQLException ex) {
            this.logger.warn((Object)ex, (Throwable)ex);
            throw new RuntimeException("Query failed!");
        }
    }

    private String createQueryLoggingOfLiveCameraUsage(String sPrefix, Long[] videoSources, Long[] userIDs, String[] userNames, Long startViewingMS, Long endViewingMS) {
        int startViewing256ms;
        int i;
        StringBuilder sbQuery = new StringBuilder(sPrefix + " FROM " + LIVE_CAMERA_ACCESS + " WHERE 1=1");
        if (videoSources != null && videoSources.length > 0) {
            sbQuery.append(" AND VideoSourceID in ( ").append(videoSources[0]);
            for (i = 1; i < videoSources.length; ++i) {
                sbQuery.append(", ").append(videoSources[i]);
            }
            sbQuery.append(" )");
        }
        if (userIDs != null && userIDs.length > 0 || userNames != null && userNames.length > 0) {
            sbQuery.append(" AND ( 1=0 ");
            if (userIDs != null && userIDs.length > 0) {
                sbQuery.append(" OR UserID IN ( ").append(userIDs[0]);
                for (i = 1; i < userIDs.length; ++i) {
                    sbQuery.append(", ").append(userIDs[i]);
                }
                sbQuery.append(" )");
            }
            if (userNames != null && userNames.length > 0) {
                int i2;
                ArrayList<String> likeSearch = new ArrayList<String>();
                ArrayList<String> exactSearch = new ArrayList<String>();
                for (i2 = 0; i2 < userNames.length; ++i2) {
                    if (userNames[i2].contains("*")) {
                        String sqlSearchString = userNames[i2].substring(0, userNames[i2].indexOf(42)) + '%';
                        likeSearch.add(sqlSearchString);
                        continue;
                    }
                    exactSearch.add(userNames[i2]);
                }
                for (i2 = 0; i2 < likeSearch.size(); ++i2) {
                    sbQuery.append(" OR UserName LIKE '").append((String)likeSearch.get(i2)).append("'");
                }
                if (exactSearch.size() > 0) {
                    sbQuery.append(" OR UserName IN ( '").append((String)exactSearch.get(0)).append("'");
                    for (i2 = 1; i2 < exactSearch.size(); ++i2) {
                        sbQuery.append(", '").append((String)exactSearch.get(i2)).append("'");
                    }
                    sbQuery.append(" )");
                }
            }
            sbQuery.append(" ) ");
        }
        if (startViewingMS != null && endViewingMS != null && startViewingMS > 0L && endViewingMS > 0L) {
            startViewing256ms = (int)(startViewingMS - 1759191760896L >> 8);
            int endViewing256ms = (int)(endViewingMS - 1759191760896L >> 8);
            sbQuery.append(" AND ( StartViewing <= ").append(endViewing256ms).append(" AND EndViewing >= ").append(startViewing256ms).append(" )");
        } else if (startViewingMS != null && startViewingMS > 0L) {
            startViewing256ms = (int)(startViewingMS - 1759191760896L >> 8);
            sbQuery.append(" AND ( StartViewing <= ").append(startViewing256ms).append(" )");
        } else if (endViewingMS != null && endViewingMS > 0L) {
            int endViewing256ms = (int)(endViewingMS - 1759191760896L >> 8);
            sbQuery.append(" AND ( EndViewing >= ").append(endViewing256ms).append(" )");
        }
        return sbQuery.toString();
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.shared.sql.ManagerLoggingOfCameraUsage@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", Active=[" + this.active + "], Covered Timerange=[" + (this.active ? TimeHelper.getReadableTimerange((long)this.maxStoredDataAge) : "---") + "], #LiveLogging=[" + (this.vLiveLogging != null ? this.vLiveLogging.size() : 0) + "], #Inserts=[" + Basic.longToFormattedString((long)this.insertCounter) + "], IsShutdown=[" + this.isShutdown(CLASS_NAME) + "]]";
    }
}

