/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared.sql;

import de.seetec.v5.re.cm.shared.sql.AlarmCtx;
import de.seetec.v5.re.cm.shared.sql.FrameStatisticIntf;
import de.seetec.v5.re.cm.shared.sql.PreAlarmCtx;
import de.seetec.v5.re.cm.shared.sql.SQLDatabaseHandler;
import de.seetec.v5.re.cm.shared.sql.SqlHelper;
import de.seetec.v5.re.cm.shared.sql.StandardCtx;
import de.seetec.v5.re.cm.shared.srpc.RspGetFrameStatistic;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.util.NamedThreadFactory;
import de.seetec.v5.shared.util.SeeTecException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FrameStatistic
implements Runnable,
FrameStatisticIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.shared.sql.FrameStatistic";
    private static final Logger LOGGER = LogManager.getLogger(FrameStatistic.class);
    private static final String COL_VIDEOSOURCE_ID = "VideoSourceID";
    private static final String COL_VIDEOFRAMES_STANDARD_RECEIVED = "VideoFramesStandardReceived";
    private static final String COL_VIDEOFRAMES_STANDARD_STORED = "VideoFramesStandardStored";
    private static final String COL_VIDEOFRAMES_STANDARD_DROPPED = "VideoFramesStandardDropped";
    private static final String COL_VIDEOFRAMES_ALARM_RECEIVED = "VideoFramesAlarmReceived";
    private static final String COL_VIDEOFRAMES_ALARM_STORED = "VideoFramesAlarmStored";
    private static final String COL_VIDEOFRAMES_ALARM_DROPPED = "VideoFramesAlarmDroped";
    private static final String COL_VIDEOFRAMES_PREALARM_RECEIVED = "VideoFramesPreAlarmReceived";
    private static final String COL_VIDEOFRAMES_PREALARM_STORED = "VideoFramesPreAlarmStored";
    private static final String COL_VIDEOFRAMES_PREALARM_DROPPED = "VideoFramesPreAlarmDroped";
    private static final String COL_DATA_PACKET_LOSS_RATIO = "DataPacketLossRatio";
    private static final String COL_DATA_STANDARD_RECEIVED = "DataStandardReceived";
    private static final String COL_DATA_ALARM_RECEIVED = "DataAlarmReceived";
    private static final String COL_TIMESTAMP = "Timestamp";
    private static final String COL_STANDARD_TIMERANGE = "StandardTimerange";
    private static final String COL_ALARM_TIMERANGE = "AlarmTimerange";
    private static final String COL_PREALARM_TIMERANGE = "PreAlarmTimerange";
    private final List<String> queuedQueries = Collections.synchronizedList(new LinkedList());
    private final String tnFrameStatistic = "FrameStatistic";
    private final String tnFrameStatisticVersion = "6.11.2";
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("FrameStatistic"));
    private SQLDatabaseHandler sqlDatabaseHandler = null;
    private long lastCheckOfRingbuffer = -1L;

    @Override
    public int init(SQLDatabaseHandler sqlDatabaseHandler) {
        this.sqlDatabaseHandler = sqlDatabaseHandler;
        if (this.sqlDatabaseHandler == null) {
            return -21601;
        }
        boolean createTable = true;
        if (this.sqlDatabaseHandler.doesTableExist(this.tnFrameStatistic)) {
            String tableVersion = this.sqlDatabaseHandler.getTableVersion("FrameStatistic");
            if (tableVersion != null && tableVersion.contains("6.11.2")) {
                createTable = false;
            } else {
                LOGGER.info("Dropping table [" + this.tnFrameStatistic + "] because old version [" + tableVersion + "]");
                this.sqlDatabaseHandler.dropTable(this.tnFrameStatistic);
            }
        }
        if (createTable) {
            LOGGER.info("Creating table [" + this.tnFrameStatistic + "] ...");
            this.createTableFrameStatistic();
            this.sqlDatabaseHandler.updateTableVersion("FrameStatistic", "6.11.2");
        }
        try {
            if (this.sqlDatabaseHandler.doesIndexExist("idxVideoSourceID" + this.tnFrameStatistic)) {
                this.dropIndexes("idxVideoSourceID" + this.tnFrameStatistic);
            }
        }
        catch (SeeTecException ex) {
            LOGGER.warn("Error while removing obsolete index: VideoSourceID");
        }
        this.scheduler.scheduleAtFixedRate(this, 0L, 5L, TimeUnit.SECONDS);
        return 0;
    }

    public int shutdown() {
        this.scheduler.shutdown();
        this.queuedQueries.clear();
        return 0;
    }

    @Override
    public void run() {
        if (Math.abs(this.lastCheckOfRingbuffer - System.currentTimeMillis()) > TimeUnit.HOURS.toMillis(1L)) {
            this.checkRingbuffer();
            this.lastCheckOfRingbuffer = System.currentTimeMillis();
        }
        while (this.queuedQueries.size() > 0) {
            try {
                String query = this.queuedQueries.remove(0);
                int errorCode = this.sqlDatabaseHandler.executeSqlUpdate(query);
                if (errorCode == 0) continue;
                LOGGER.warn("Executing [" + query + "] failed with error [" + errorCode + "]");
            }
            catch (IndexOutOfBoundsException | NoSuchElementException nex) {
                LOGGER.warn((Object)nex, (Throwable)nex);
                break;
            }
        }
    }

    @Override
    public void checkRingbuffer() {
        long oldestAcceptedTimestamp = System.currentTimeMillis() - 604800000L;
        String sqlQuery = "DELETE FROM " + this.tnFrameStatistic + " WHERE " + COL_TIMESTAMP + " < " + oldestAcceptedTimestamp;
        long timestamp = System.currentTimeMillis();
        try (Statement statement = this.sqlDatabaseHandler.getConnection().createStatement();){
            int count = statement.executeUpdate(sqlQuery);
            if (count > 0) {
                long duration = System.currentTimeMillis() - timestamp;
                LOGGER.info("Removing [" + Basic.longToFormattedString((long)count) + "] entries from table [" + this.tnFrameStatistic + "] lasts for [" + Basic.longToFormattedString((long)duration) + " ms]");
                LOGGER.info("   Query=" + sqlQuery);
            }
        }
        catch (SQLException sqlEx) {
            LOGGER.warn("Problems exeuting sql statement: " + sqlQuery, (Throwable)sqlEx);
        }
        catch (Throwable ex) {
            LOGGER.warn((Object)ex, ex);
        }
    }

    @Override
    public int createTableFrameStatistic() {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("VideoSourceID BIGINT NOT NULL");
        columns.add("VideoFramesStandardReceived INT NOT NULL");
        columns.add("VideoFramesStandardStored INT NOT NULL");
        columns.add("VideoFramesStandardDropped INT NOT NULL");
        columns.add("VideoFramesAlarmReceived INT NOT NULL");
        columns.add("VideoFramesAlarmStored INT NOT NULL");
        columns.add("VideoFramesAlarmDroped INT NOT NULL");
        columns.add("VideoFramesPreAlarmReceived INT NOT NULL");
        columns.add("VideoFramesPreAlarmStored INT NOT NULL");
        columns.add("VideoFramesPreAlarmDroped INT NOT NULL");
        columns.add("DataPacketLossRatio BIGINT NOT NULL");
        columns.add("DataStandardReceived BIGINT NOT NULL");
        columns.add("DataAlarmReceived BIGINT NOT NULL");
        columns.add("Timestamp BIGINT NOT NULL");
        columns.add("StandardTimerange BIGINT NOT NULL");
        columns.add("AlarmTimerange BIGINT NOT NULL");
        columns.add("PreAlarmTimerange BIGINT NOT NULL");
        String query = SqlHelper.buildCreateTableQuery(this.tnFrameStatistic, columns);
        int errorCode = this.sqlDatabaseHandler.executeSqlUpdate(query);
        if (errorCode != 0) {
            LOGGER.error("Cannot create table <" + this.tnFrameStatistic + ">");
            return errorCode;
        }
        try {
            this.createIndexes(COL_TIMESTAMP);
        }
        catch (SeeTecException seeTecException) {
            LOGGER.error(seeTecException.getMessage());
            return seeTecException.getErrorCode();
        }
        return 0;
    }

    private void createIndexes(String idxName) throws SeeTecException {
        String completeIndexName = "idx" + idxName + this.tnFrameStatistic;
        String query = String.format("CREATE INDEX %s ON %s(%s)", completeIndexName, this.tnFrameStatistic, idxName);
        int errorCode = this.sqlDatabaseHandler.executeSqlUpdate(query);
        if (errorCode != 0) {
            throw new SeeTecException(errorCode, "Cannot create index <" + completeIndexName + " on table <" + this.tnFrameStatistic + ">");
        }
    }

    private void dropIndexes(String idxName) throws SeeTecException {
        int errorCode = this.sqlDatabaseHandler.executeSqlUpdate("DROP INDEX " + idxName);
        if (errorCode != 0) {
            throw new SeeTecException(errorCode, "Cannot create index <" + idxName + " on table <" + this.tnFrameStatistic + ">");
        }
    }

    @Override
    public void enqueueQueryForData(long videoSourceID, StandardCtx standardCtx, AlarmCtx alarmCtx, PreAlarmCtx preAlarmCtx, long dataPacketLossRatio, long timestamp) {
        LinkedHashMap<String, String> insertParamMap = new LinkedHashMap<String, String>();
        insertParamMap.put(COL_VIDEOSOURCE_ID, String.valueOf(videoSourceID));
        insertParamMap.put(COL_VIDEOFRAMES_STANDARD_RECEIVED, String.valueOf(standardCtx.videoFramesStandardReceived));
        insertParamMap.put(COL_VIDEOFRAMES_STANDARD_STORED, String.valueOf(standardCtx.videoFramesStandardStored));
        insertParamMap.put(COL_VIDEOFRAMES_STANDARD_DROPPED, String.valueOf(standardCtx.videoFramesStandardDroppped));
        insertParamMap.put(COL_VIDEOFRAMES_ALARM_RECEIVED, String.valueOf(alarmCtx.videoFramesAlarmReceived));
        insertParamMap.put(COL_VIDEOFRAMES_ALARM_STORED, String.valueOf(alarmCtx.videoFramesAlarmStored));
        insertParamMap.put(COL_VIDEOFRAMES_ALARM_DROPPED, String.valueOf(alarmCtx.videoFramesAlarmDroppped));
        insertParamMap.put(COL_VIDEOFRAMES_PREALARM_RECEIVED, String.valueOf(preAlarmCtx.videoFramesPreAlarmReceived));
        insertParamMap.put(COL_VIDEOFRAMES_PREALARM_STORED, String.valueOf(preAlarmCtx.videoFramesPreAlarmStored));
        insertParamMap.put(COL_VIDEOFRAMES_PREALARM_DROPPED, String.valueOf(preAlarmCtx.videoFramesPreAlarmDroppped));
        insertParamMap.put(COL_DATA_PACKET_LOSS_RATIO, String.valueOf(dataPacketLossRatio));
        insertParamMap.put(COL_DATA_STANDARD_RECEIVED, String.valueOf(standardCtx.dataStandardReceived));
        insertParamMap.put(COL_DATA_ALARM_RECEIVED, String.valueOf(alarmCtx.dataAlarmReceived));
        insertParamMap.put(COL_TIMESTAMP, String.valueOf(timestamp));
        insertParamMap.put(COL_STANDARD_TIMERANGE, String.valueOf(standardCtx.standardTimerange));
        insertParamMap.put(COL_ALARM_TIMERANGE, String.valueOf(alarmCtx.alarmTimerange));
        insertParamMap.put(COL_PREALARM_TIMERANGE, String.valueOf(preAlarmCtx.preAlarmTimerange));
        String query = SqlHelper.buildInsertQuery(this.tnFrameStatistic, insertParamMap);
        try {
            this.queuedQueries.add(query);
        }
        catch (Throwable throwable) {
            LOGGER.info("Adding string not possible: " + throwable.getMessage());
        }
    }

    @Override
    public HashMap<Long, RspGetFrameStatistic> readStatistic(long tsSince) throws SeeTecException {
        String sqlQuery = "SELECT VideoSourceID,  SUM( VideoFramesStandardStored ),  SUM( VideoFramesStandardDropped ),  SUM( VideoFramesAlarmStored ),  SUM( VideoFramesAlarmDroped ),  SUM( VideoFramesPreAlarmStored ),  SUM( VideoFramesPreAlarmDroped ),  AVG( DataPacketLossRatio ),  SUM( DataStandardReceived ),  SUM( DataAlarmReceived ),  SUM( StandardTimerange ),  SUM( AlarmTimerange ),  SUM( PreAlarmTimerange )  FROM " + this.tnFrameStatistic + " WHERE " + COL_TIMESTAMP + " >= " + tsSince + " GROUP BY " + COL_VIDEOSOURCE_ID;
        LOGGER.debug("Executing [" + sqlQuery + "]");
        HashMap<Long, RspGetFrameStatistic> allVideoSources = new HashMap<Long, RspGetFrameStatistic>();
        try (Statement statement = this.sqlDatabaseHandler.getConnection().createStatement();
             ResultSet resultSet = statement.executeQuery(sqlQuery);){
            while (resultSet.next()) {
                int index = 0;
                long videoSourceID = resultSet.getLong(++index);
                int sumVideoFramesStandardStored = resultSet.getInt(++index);
                int sumVideoFramesStandardDroppped = resultSet.getInt(++index);
                int sumVideoFramesAlarmStored = resultSet.getInt(++index);
                int sumVideoFramesAlarmDroppped = resultSet.getInt(++index);
                int sumVideoFramesPreAlarmStored = resultSet.getInt(++index);
                int sumVideoFramesPreAlarmDroppped = resultSet.getInt(++index);
                long avgDataPacketLossRatio = resultSet.getLong(++index);
                long sumDataStandardReceived = resultSet.getLong(++index);
                long sumDataAlarmReceived = resultSet.getLong(++index);
                long sumStandardTimerange = resultSet.getLong(++index);
                long sumAlarmTimerange = resultSet.getLong(++index);
                long sumPreAlarmTimerange = resultSet.getLong(++index);
                RspGetFrameStatistic rspGetFrameStatistic = new RspGetFrameStatistic(0, sumVideoFramesStandardStored, sumVideoFramesStandardDroppped, sumVideoFramesAlarmStored, sumVideoFramesAlarmDroppped, sumVideoFramesPreAlarmStored, sumVideoFramesPreAlarmDroppped, avgDataPacketLossRatio, sumDataStandardReceived, sumDataAlarmReceived, sumStandardTimerange, sumAlarmTimerange, sumPreAlarmTimerange);
                allVideoSources.put(videoSourceID, rspGetFrameStatistic);
            }
        }
        catch (SQLException sqlEx) {
            throw new SeeTecException(-21691, "Problems exeuting sql statement: " + sqlQuery);
        }
        catch (Throwable ex) {
            throw new SeeTecException(-21691, ex.getMessage());
        }
        return allVideoSources;
    }

    @Override
    public void deleteStatisticForVideoSource(long videoSourceId) {
        String sqlQuery = "DELETE FROM " + this.tnFrameStatistic + " WHERE " + COL_VIDEOSOURCE_ID + " = " + videoSourceId;
        try (Statement statement = this.sqlDatabaseHandler.getConnection().createStatement();){
            long ts = System.currentTimeMillis();
            int count = statement.executeUpdate(sqlQuery);
            if (count > 0) {
                long duration = System.currentTimeMillis() - ts;
                LOGGER.info("Removing [" + Basic.longToFormattedString((long)count) + "] entries from table [" + this.tnFrameStatistic + "] lasts for [" + Basic.longToFormattedString((long)duration) + " ms]");
                LOGGER.info("   Query=" + sqlQuery);
            }
        }
        catch (SQLException sqlEx) {
            LOGGER.warn("Problems executing sql statement: " + sqlQuery, (Throwable)sqlEx);
        }
        catch (Throwable ex) {
            LOGGER.warn((Object)ex, ex);
        }
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.shared.sql.FrameStatistic@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", QueuedQueries=[" + this.queuedQueries.size() + "], IsShutdown=[" + this.scheduler.isShutdown() + "]]";
    }
}

