/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared.sql;

import de.seetec.v5.re.cm.shared.sql.SQLDatabaseHandler;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.util.SeeTecException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataObjectEdgeStorageMarker {
    public static final String tnDataObjectEdgeStorageMarker = "DataObjectEdgeStorageMarker";
    private Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private Long entityID = null;
    private Long timestamp = null;

    public DataObjectEdgeStorageMarker(Long entityID, Long timestamp) throws SeeTecException {
        this.entityID = entityID;
        if (this.entityID == null || entityID < 0L) {
            throw new SeeTecException(-21601, "Parameter <entityID>=[" + entityID + "] invalid!");
        }
        this.timestamp = timestamp;
        if (this.timestamp == null || timestamp < 0L) {
            throw new SeeTecException(-21601, "Parameter <timestamp>=[" + timestamp + "] invalid!");
        }
    }

    public static void updateDatabaseSchema(SQLDatabaseHandler sqlDatabaseHandler, Logger logger) {
        String tableVersion = sqlDatabaseHandler.getTableVersion(tnDataObjectEdgeStorageMarker);
        if (tableVersion == null) {
            if (sqlDatabaseHandler.doesTableExist(tnDataObjectEdgeStorageMarker)) {
                sqlDatabaseHandler.dropTable(tnDataObjectEdgeStorageMarker);
            }
            sqlDatabaseHandler.updateTableVersion(tnDataObjectEdgeStorageMarker, "6.4.0");
            sqlDatabaseHandler.executeSqlUpdate(DataObjectEdgeStorageMarker.createCreateQuery());
            String idxEntityID = "idxEntityIDDataObjectEdgeStorageMarker";
            String query = "CREATE INDEX " + idxEntityID + " ON " + tnDataObjectEdgeStorageMarker + " ( EntityID )";
            int errorCode = sqlDatabaseHandler.executeSqlUpdate(query);
            if (errorCode != 0) {
                logger.warn("Creating index failed with error " + errorCode + " for statement [" + query + "]");
            }
        }
    }

    private String createInsertQuery() {
        return "INSERT INTO DataObjectEdgeStorageMarker (EntityID, timestamp ) VALUES ( " + this.getEntityID() + "," + this.getTimestamp() + " )";
    }

    private String createUpdateQuery() {
        return "UPDATE DataObjectEdgeStorageMarker set timestamp=" + this.getTimestamp() + " where EntityID = " + this.getEntityID();
    }

    private String createDeleteQuery() {
        return "DELETE from DataObjectEdgeStorageMarker where EntityID = " + this.getEntityID();
    }

    private static String createCreateQuery() {
        return "CREATE TABLE DataObjectEdgeStorageMarker (EntityID BIGINT NOT NULL, timestamp BIGINT NOT NULL)";
    }

    @SuppressFBWarnings(value={"SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE"}, justification="Dynamic parts are just internal numbers and no strings so I don't see the possibility of an SQL injection..")
    public int updateEntry(SQLDatabaseHandler sqlDatabaseHandler) {
        String query = null;
        try {
            Connection connection = sqlDatabaseHandler.getConnection();
            try (Statement statement = connection.createStatement();){
                ResultSet resultSet;
                query = this.getTimestamp() == 0L ? this.createDeleteQuery() : ((resultSet = statement.executeQuery("SELECT entityID FROM DataObjectEdgeStorageMarker WHERE EntityID = " + this.getEntityID())).next() ? this.createUpdateQuery() : this.createInsertQuery());
                statement.executeUpdate(query);
            }
            return 0;
        }
        catch (Throwable ex) {
            this.logger.warn("Update failed: [" + query + "]", ex);
            return -21600;
        }
    }

    public static DataObjectEdgeStorageMarker getMarker(SQLDatabaseHandler sqlDatabaseHandler, Logger logger, long entityID) {
        DataObjectEdgeStorageMarker result = null;
        String query = "SELECT timestamp FROM DataObjectEdgeStorageMarker WHERE EntityID = " + entityID;
        try {
            Connection connection = sqlDatabaseHandler.getConnection();
            try (Statement statement = connection.createStatement();){
                ResultSet resultSet = statement.executeQuery(query);
                result = resultSet.next() ? new DataObjectEdgeStorageMarker(entityID, resultSet.getLong(1)) : null;
            }
        }
        catch (Throwable ex) {
            logger.warn((Object)ex, ex);
            logger.warn("Trouble executing sql statement [" + query + "] :-(");
        }
        return result;
    }

    public static long getNumberOfMarker(SQLDatabaseHandler sqlDatabaseHandler, Logger logger) {
        long result = 0L;
        try {
            Connection connection = sqlDatabaseHandler.getConnection();
            try (Statement statement = connection.createStatement();){
                ResultSet resultSet = statement.executeQuery("SELECT count(EntityID) FROM DataObjectEdgeStorageMarker");
                if (resultSet.next()) {
                    result = resultSet.getLong(1);
                }
            }
        }
        catch (Throwable ex) {
            logger.warn((Object)ex, ex);
            logger.warn("Trouble retrieving total number of all markers.");
        }
        return result;
    }

    public Long getEntityID() {
        return this.entityID;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "[" + Basic.getClassNameAndHash((Object)this) + ", EntityID=[" + this.getEntityID() + "], Timestamp=[" + this.getTimestamp() + "]]";
    }
}

