/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared.recording;

import de.seetec.v5.re.cm.shared.recording.RecordingInfo;
import de.seetec.v5.re.cm.shared.timerange.TimeRangeInfo;
import de.seetec.v5.re.cm.shared.timerange.TimeRangeInfoContainer;
import de.seetec.v5.re.cm.shared.timerange.TimeRangeList;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class RecordingInfoList
extends ArrayList<RecordingInfo> {
    public static final long serialVersionUID = -1L;
    private int countFailoverData;
    private int countDefaultData;
    private Long absoluteStartTimestamp = 0L;
    private final transient Logger logger;

    public RecordingInfoList() {
        this.countDefaultData = 0;
        this.countFailoverData = 0;
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    public RecordingInfoList(LinkedList<RecordingInfo> recordingInfoList) {
        super(recordingInfoList);
        this.countDefaultData = 0;
        this.countFailoverData = 0;
        for (RecordingInfo recordingInfo : recordingInfoList) {
            if (recordingInfo.isFailover()) {
                ++this.countFailoverData;
                continue;
            }
            ++this.countDefaultData;
        }
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    public RecordingInfoList(RecordingInfoList recordingInfoList) {
        for (RecordingInfo recordingInfo : recordingInfoList) {
            this.add(recordingInfo);
        }
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    @Override
    public boolean add(RecordingInfo t) {
        if (t.isFailover()) {
            ++this.countFailoverData;
        } else {
            ++this.countDefaultData;
        }
        return super.add(t);
    }

    @Override
    public void add(int index, RecordingInfo t) {
        if (t.isFailover()) {
            ++this.countFailoverData;
        } else {
            ++this.countDefaultData;
        }
        super.add(index, t);
    }

    @Override
    public boolean addAll(Collection<? extends RecordingInfo> list) {
        for (RecordingInfo recordingInfo : list) {
            if (recordingInfo.isFailover()) {
                ++this.countFailoverData;
                continue;
            }
            ++this.countDefaultData;
        }
        return super.addAll(list);
    }

    @Override
    public boolean addAll(int index, Collection<? extends RecordingInfo> list) {
        for (RecordingInfo recordingInfo : list) {
            if (recordingInfo.isFailover()) {
                ++this.countFailoverData;
                continue;
            }
            ++this.countDefaultData;
        }
        return super.addAll(index, list);
    }

    @Override
    public RecordingInfo remove(int index) {
        if (((RecordingInfo)this.get(index)).isFailover()) {
            --this.countFailoverData;
        } else {
            --this.countDefaultData;
        }
        return (RecordingInfo)super.remove(index);
    }

    public void setAbsoluteStartTimestamp(Long absoluteStartTimestamp) {
        this.absoluteStartTimestamp = absoluteStartTimestamp;
    }

    public Long getAbsoluteStartTimestamp() {
        return this.absoluteStartTimestamp;
    }

    public boolean containsFailoverData() {
        return this.countFailoverData > 0;
    }

    public boolean containsDefaultData() {
        return this.countDefaultData > 0;
    }

    public int getNumberOfDefaultElements() {
        return this.countDefaultData;
    }

    public int getNumberOfFailoverElements() {
        return this.countFailoverData;
    }

    public void mergeRecordingInfo(RecordingInfoList failoverList) throws SeeTecException {
        if (this.containsFailoverData() && this.containsDefaultData()) {
            this.logger.warn("The list conatains both default and failover data");
        } else if (this.containsFailoverData() && !this.containsDefaultData() && !failoverList.containsFailoverData() && failoverList.containsDefaultData()) {
            RecordingInfoList temp;
            this.logger.warn("Invert lists");
            failoverList = temp = this;
        } else if (this.containsFailoverData() || !this.containsDefaultData() || !failoverList.containsFailoverData() || failoverList.containsDefaultData()) {
            this.logger.error("The list contains no default and no failover data");
        }
        this.dissect(failoverList);
        this.copy(failoverList);
        this.clean(failoverList);
    }

    public void cleanAndMerge(long cumulationDistance) throws SeeTecException {
        cumulationDistance = cumulationDistance <= 0L ? 5000L : cumulationDistance;
        Collections.sort(this);
        int pointer = 0;
        while (pointer < this.size() - 1) {
            long newLength;
            RecordingInfo currentRecordingInfo = (RecordingInfo)this.get(pointer);
            RecordingInfo nextRecordingInfo = (RecordingInfo)this.get(pointer + 1);
            if (currentRecordingInfo.getTrack() == nextRecordingInfo.getTrack() && currentRecordingInfo.getStartTimestamp() + (long)currentRecordingInfo.getLength() + cumulationDistance >= nextRecordingInfo.getStartTimestamp() && RecordingInfo.isValidLength(newLength = nextRecordingInfo.getStartTimestamp() + (long)nextRecordingInfo.getLength() - currentRecordingInfo.getStartTimestamp())) {
                currentRecordingInfo.setLength((int)newLength);
                this.remove(pointer + 1);
                continue;
            }
            ++pointer;
        }
    }

    public TimeRangeInfoContainer convertToTimeRangeInfoContainer() {
        TimeRangeList tempTimeRangeList = new TimeRangeList();
        for (RecordingInfo recordingInfo : this) {
            tempTimeRangeList.add(new TimeRangeInfo(recordingInfo.getStartTimestamp(), recordingInfo.getLength(), recordingInfo.getTrack(), recordingInfo.isFailover()));
        }
        tempTimeRangeList.setStartTimestamp(this.absoluteStartTimestamp);
        return new TimeRangeInfoContainer(tempTimeRangeList, this.absoluteStartTimestamp);
    }

    @Override
    public void clear() {
        this.countDefaultData = 0;
        this.countFailoverData = 0;
        this.absoluteStartTimestamp = 0L;
        super.clear();
    }

    protected void dissect(RecordingInfoList failoverList) throws SeeTecException {
        RecordingInfoList defaultList = this;
        for (int defaultIndex = 0; defaultIndex < defaultList.size(); ++defaultIndex) {
            int failoverIndex = 0;
            while (failoverIndex < failoverList.size()) {
                RecordingInfoList createRecordingInfo;
                RecordingInfo defaultInfo = (RecordingInfo)defaultList.get(defaultIndex);
                RecordingInfo failoverInfo = (RecordingInfo)failoverList.get(failoverIndex);
                if (failoverInfo.getStartTimestamp() >= defaultInfo.getEndTimestamp()) {
                    ++failoverIndex;
                    continue;
                }
                if (failoverInfo.getEndTimestamp() <= defaultInfo.getStartTimestamp()) {
                    ++failoverIndex;
                    continue;
                }
                if (failoverInfo.getStartTimestamp() < defaultInfo.getStartTimestamp()) {
                    if (failoverInfo.getEndTimestamp() == defaultInfo.getEndTimestamp()) {
                        createRecordingInfo = RecordingInfo.createRecordingInfo(defaultInfo.getStartTimestamp(), failoverInfo.getEndTimestamp(), failoverInfo.getTrack(), true);
                        if (failoverList.addAll(failoverIndex + 1, createRecordingInfo)) {
                            ++failoverIndex;
                        }
                        failoverInfo.setEndTimestamp(defaultInfo.getStartTimestamp());
                        ++failoverIndex;
                        continue;
                    }
                    if (failoverInfo.getEndTimestamp() < defaultInfo.getEndTimestamp()) {
                        createRecordingInfo = RecordingInfo.createRecordingInfo(failoverInfo.getEndTimestamp(), defaultInfo.getEndTimestamp(), defaultInfo.getTrack(), false);
                        if (defaultList.addAll(defaultIndex + 1, createRecordingInfo)) {
                            ++defaultIndex;
                        }
                        if (failoverList.addAll(failoverIndex + 1, createRecordingInfo = RecordingInfo.createRecordingInfo(defaultInfo.getStartTimestamp(), failoverInfo.getEndTimestamp(), failoverInfo.getTrack(), true))) {
                            ++failoverIndex;
                        }
                        defaultInfo.setEndTimestamp(failoverInfo.getEndTimestamp());
                        failoverInfo.setEndTimestamp(defaultInfo.getStartTimestamp());
                        ++failoverIndex;
                        continue;
                    }
                    if (failoverInfo.getEndTimestamp() <= defaultInfo.getEndTimestamp()) continue;
                    createRecordingInfo = RecordingInfo.createRecordingInfo(defaultInfo.getStartTimestamp(), defaultInfo.getEndTimestamp(), failoverInfo.getTrack(), true);
                    if (failoverList.addAll(failoverIndex + 1, createRecordingInfo)) {
                        ++failoverIndex;
                    }
                    if (failoverList.addAll(failoverIndex + 1, createRecordingInfo = RecordingInfo.createRecordingInfo(defaultInfo.getEndTimestamp(), failoverInfo.getEndTimestamp(), failoverInfo.getTrack(), true))) {
                        ++failoverIndex;
                    }
                    failoverInfo.setEndTimestamp(defaultInfo.getStartTimestamp());
                    ++failoverIndex;
                    continue;
                }
                if (failoverInfo.getStartTimestamp() == defaultInfo.getStartTimestamp()) {
                    if (failoverInfo.getEndTimestamp() > defaultInfo.getEndTimestamp()) {
                        createRecordingInfo = RecordingInfo.createRecordingInfo(defaultInfo.getEndTimestamp(), failoverInfo.getEndTimestamp(), failoverInfo.getTrack(), true);
                        if (failoverList.addAll(failoverIndex + 1, createRecordingInfo)) {
                            ++failoverIndex;
                        }
                        failoverInfo.setEndTimestamp(defaultInfo.getEndTimestamp());
                        ++failoverIndex;
                        continue;
                    }
                    if (failoverInfo.getEndTimestamp() == defaultInfo.getEndTimestamp()) {
                        ++failoverIndex;
                        continue;
                    }
                    if (failoverInfo.getEndTimestamp() >= defaultInfo.getEndTimestamp()) continue;
                    createRecordingInfo = RecordingInfo.createRecordingInfo(failoverInfo.getEndTimestamp(), defaultInfo.getEndTimestamp(), defaultInfo.getTrack(), false);
                    if (defaultList.addAll(defaultIndex + 1, createRecordingInfo)) {
                        ++defaultIndex;
                    }
                    defaultInfo.setEndTimestamp(failoverInfo.getEndTimestamp());
                    ++failoverIndex;
                    continue;
                }
                if (failoverInfo.getStartTimestamp() <= defaultInfo.getStartTimestamp()) continue;
                if (failoverInfo.getEndTimestamp() > defaultInfo.getEndTimestamp()) {
                    createRecordingInfo = RecordingInfo.createRecordingInfo(failoverInfo.getStartTimestamp(), defaultInfo.getEndTimestamp(), defaultInfo.getTrack(), false);
                    if (defaultList.addAll(defaultIndex + 1, createRecordingInfo)) {
                        ++defaultIndex;
                    }
                    if (failoverList.addAll(failoverIndex + 1, createRecordingInfo = RecordingInfo.createRecordingInfo(defaultInfo.getEndTimestamp(), failoverInfo.getEndTimestamp(), failoverInfo.getTrack(), true))) {
                        ++failoverIndex;
                    }
                    failoverInfo.setEndTimestamp(defaultInfo.getEndTimestamp());
                    defaultInfo.setEndTimestamp(failoverInfo.getStartTimestamp());
                    ++failoverIndex;
                    continue;
                }
                if (failoverInfo.getEndTimestamp() == defaultInfo.getEndTimestamp()) {
                    createRecordingInfo = RecordingInfo.createRecordingInfo(failoverInfo.getStartTimestamp(), defaultInfo.getEndTimestamp(), defaultInfo.getTrack(), false);
                    if (defaultList.addAll(defaultIndex + 1, createRecordingInfo)) {
                        ++defaultIndex;
                    }
                    defaultInfo.setEndTimestamp(failoverInfo.getStartTimestamp());
                    ++failoverIndex;
                    continue;
                }
                if (failoverInfo.getEndTimestamp() >= defaultInfo.getEndTimestamp()) continue;
                createRecordingInfo = RecordingInfo.createRecordingInfo(failoverInfo.getStartTimestamp(), failoverInfo.getEndTimestamp(), defaultInfo.getTrack(), false);
                if (defaultList.addAll(defaultIndex + 1, createRecordingInfo)) {
                    ++defaultIndex;
                }
                if (defaultList.addAll(defaultIndex + 1, createRecordingInfo = RecordingInfo.createRecordingInfo(failoverInfo.getEndTimestamp(), defaultInfo.getEndTimestamp(), defaultInfo.getTrack(), false))) {
                    ++defaultIndex;
                }
                defaultInfo.setEndTimestamp(failoverInfo.getStartTimestamp());
                ++failoverIndex;
            }
        }
        Collections.sort(defaultList);
    }

    protected void copy(RecordingInfoList failoverList) throws SeeTecException {
        RecordingInfoList defaultList = this;
        int failoverIndex = 0;
        if (defaultList.isEmpty()) {
            defaultList.addAll(failoverList);
        } else {
            block0: for (int defaultIndex = 0; defaultIndex < defaultList.size(); ++defaultIndex) {
                while (failoverIndex < failoverList.size()) {
                    RecordingInfoList createRecordingInfo;
                    RecordingInfo failoverInfo = (RecordingInfo)failoverList.get(failoverIndex);
                    RecordingInfo defaultInfo = (RecordingInfo)defaultList.get(defaultIndex);
                    RecordingInfo defaultNext = null;
                    if (defaultIndex < defaultList.size() - 1) {
                        defaultNext = (RecordingInfo)defaultList.get(defaultIndex + 1);
                    }
                    if (defaultIndex == 0 && failoverInfo.getEndTimestamp() <= defaultInfo.getStartTimestamp()) {
                        createRecordingInfo = RecordingInfo.createRecordingInfo(failoverInfo.getStartTimestamp(), failoverInfo.getEndTimestamp(), failoverInfo.getTrack(), true);
                        defaultList.addAll(0, createRecordingInfo);
                        --defaultIndex;
                        continue block0;
                    }
                    if (failoverInfo.getStartTimestamp() >= defaultInfo.getEndTimestamp() && (defaultNext != null && failoverInfo.getEndTimestamp() <= defaultNext.getStartTimestamp() || defaultNext == null)) {
                        createRecordingInfo = RecordingInfo.createRecordingInfo(failoverInfo.getStartTimestamp(), failoverInfo.getEndTimestamp(), failoverInfo.getTrack(), true);
                        defaultList.addAll(defaultIndex + 1, createRecordingInfo);
                        ++failoverIndex;
                        continue block0;
                    }
                    if (defaultNext != null && failoverInfo.getStartTimestamp() == defaultNext.getStartTimestamp() && failoverInfo.getEndTimestamp() == defaultNext.getEndTimestamp() || defaultNext != null && failoverInfo.getEndTimestamp() > defaultNext.getStartTimestamp()) continue block0;
                    ++failoverIndex;
                }
            }
        }
        Collections.sort(defaultList);
    }

    private void clean(RecordingInfoList failoverList) throws SeeTecException {
        RecordingInfoList defaultList = this;
        int failoverIndex = 0;
        block0: for (int defaultIndex = 0; defaultIndex < defaultList.size(); ++defaultIndex) {
            while (failoverIndex < failoverList.size()) {
                RecordingInfo defaultInfo = (RecordingInfo)defaultList.get(defaultIndex);
                RecordingInfo failoverInfo = (RecordingInfo)failoverList.get(failoverIndex);
                if (failoverInfo.getStartTimestamp() >= defaultInfo.getStartTimestamp()) {
                    if (failoverInfo.getStartTimestamp() > defaultInfo.getStartTimestamp()) continue block0;
                    if (defaultInfo.getTrack() != 0 && failoverInfo.getTrack() == 0) {
                        defaultInfo.setTrack(failoverInfo.getTrack());
                        defaultInfo.setIsFailover(failoverInfo.isFailover());
                    }
                }
                ++failoverIndex;
            }
        }
        Collections.sort(defaultList);
    }

    public static void adjustAbsoluteStartTimeStamp(RecordingInfoList recordingInfoList, RecordingInfoList recordingInfoListFailover) throws SeeTecException {
        long startTimestampFailover;
        long startTimestamp = recordingInfoList.getAbsoluteStartTimestamp();
        long timeDifference = startTimestamp - (startTimestampFailover = recordingInfoListFailover.getAbsoluteStartTimestamp().longValue());
        if (timeDifference < 0L) {
            for (RecordingInfo recordingInfo : recordingInfoListFailover) {
                recordingInfo.setStartTimestamp(recordingInfo.getStartTimestamp() - timeDifference);
                recordingInfo.setEndTimestamp(recordingInfo.getEndTimestamp() - timeDifference);
            }
            recordingInfoListFailover.setAbsoluteStartTimestamp(startTimestamp);
        } else if (timeDifference > 0L) {
            for (RecordingInfo recordingInfo : recordingInfoList) {
                recordingInfo.setStartTimestamp(recordingInfo.getStartTimestamp() + timeDifference);
                recordingInfo.setEndTimestamp(recordingInfo.getEndTimestamp() + timeDifference);
            }
            recordingInfoList.setAbsoluteStartTimestamp(startTimestampFailover);
        }
    }
}

