/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared.recording;

import de.seetec.v5.re.cm.shared.recording.RecordingInfoList;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public final class RecordingInfo
implements Comparable<RecordingInfo> {
    private long startTimestamp;
    private long endTimestamp;
    private int length;
    private byte track;
    private boolean isFailover = false;

    protected RecordingInfo(long startTimestamp, long endTimestamp, byte track, boolean isFailover) {
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        this.setLength(endTimestamp - startTimestamp);
        this.track = track;
        this.isFailover = isFailover;
    }

    public RecordingInfo(RecordingInfo recordingInfo) {
        this.startTimestamp = recordingInfo.getStartTimestamp();
        this.endTimestamp = recordingInfo.getEndTimestamp();
        this.length = recordingInfo.getLength();
        this.track = recordingInfo.getTrack();
        this.isFailover = recordingInfo.isFailover();
    }

    public RecordingInfo(byte[] recordingInfo) {
        if (recordingInfo.length == 10) {
            this.startTimestamp = Basic.byteArrayToInt8((byte[])recordingInfo, (int)0, (int)5);
            this.length = Basic.byteArrayToInt4((byte[])recordingInfo, (int)5, (int)4);
            this.endTimestamp = this.startTimestamp + (long)this.length;
            this.track = recordingInfo[9];
        }
    }

    public void setStartTimestamp(long startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public void setEndTimestamp(long endTimestamp) throws SeeTecException {
        this.endTimestamp = endTimestamp;
        this.setLength(endTimestamp - this.startTimestamp);
    }

    public long getEndTimestamp() {
        return this.endTimestamp;
    }

    public void setLength(int length) throws SeeTecException {
        if (!RecordingInfo.isValidLength(length)) {
            throw new SeeTecException(-21601, "Invalid length");
        }
        this.length = length;
        this.endTimestamp = this.startTimestamp + (long)length;
    }

    public void setLength(long length) {
        this.length = (int)length;
        this.endTimestamp = this.startTimestamp + (long)this.length;
    }

    public int getLength() {
        return this.length;
    }

    public void setIsFailover(boolean isFailover) {
        this.isFailover = isFailover;
    }

    public boolean isFailover() {
        return this.isFailover;
    }

    public void setTrack(byte track) {
        this.track = track;
    }

    public byte getTrack() {
        return this.track;
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(10);
        byteArrayOutputStream.write(Basic.int8ToByteArray((long)this.getStartTimestamp(), (int)5));
        byteArrayOutputStream.write(Basic.int4ToByteArray((int)this.getLength()));
        byteArrayOutputStream.write(this.track);
        return byteArrayOutputStream.toByteArray();
    }

    public boolean equals(RecordingInfo recordingInfo) {
        return recordingInfo.getStartTimestamp() == this.startTimestamp && recordingInfo.getLength() == this.length && recordingInfo.getTrack() == this.track && recordingInfo.isFailover() == this.isFailover;
    }

    @Override
    public int compareTo(RecordingInfo recordingInfo) {
        return Long.signum(this.getStartTimestamp() - recordingInfo.getStartTimestamp());
    }

    public static RecordingInfoList createRecordingInfo(long startTimestamp, long endTimestamp, byte track, boolean isFailover) throws SeeTecException {
        RecordingInfoList returnList = new RecordingInfoList();
        if (startTimestamp < 0L || endTimestamp < startTimestamp) {
            throw new SeeTecException(-21601, "Invalid timestamps: Start: " + startTimestamp + " - End: " + endTimestamp);
        }
        if (track != 1 && track != 0) {
            throw new SeeTecException(-21601, "Invalid track: " + track);
        }
        if (startTimestamp == endTimestamp) {
            return returnList;
        }
        returnList.setAbsoluteStartTimestamp(startTimestamp);
        long length = endTimestamp - startTimestamp;
        if (!RecordingInfo.isValidLength(length)) {
            do {
                returnList.add(new RecordingInfo(startTimestamp, startTimestamp + Integer.MAX_VALUE, track, isFailover));
                startTimestamp += Integer.MAX_VALUE;
            } while ((length -= Integer.MAX_VALUE) > Integer.MAX_VALUE);
        }
        returnList.add(new RecordingInfo(startTimestamp, endTimestamp, track, isFailover));
        return returnList;
    }

    public static final boolean isValidLength(long length) {
        return length >= 0L && length <= Integer.MAX_VALUE;
    }

    public static class TRACK {
        public static final byte STANDARD = 1;
        public static final byte ALARM = 0;
    }
}

