/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared.communication.transcoding.srpc;

import de.seetec.v5.re.cm.shared.communication.transcoding.srpc.TranscodingProxyInterface;
import de.seetec.v5.re.cm.shared.communication.transcoding.srpc.methods.ReqAllocateTranscodingChannel;
import de.seetec.v5.re.cm.shared.communication.transcoding.srpc.methods.ReqCloseTranscodingChannel;
import de.seetec.v5.re.cm.shared.communication.transcoding.srpc.methods.ReqSetTranscodingStreamParameter;
import de.seetec.v5.re.cm.shared.communication.transcoding.srpc.methods.ReqTranscodeFrames;
import de.seetec.v5.re.cm.shared.communication.transcoding.srpc.methods.RspAllocateTranscodingChannel;
import de.seetec.v5.re.cm.shared.communication.transcoding.srpc.methods.RspCloseTranscodingChannel;
import de.seetec.v5.re.cm.shared.communication.transcoding.srpc.methods.RspSetTranscodingStreamParameter;
import de.seetec.v5.re.cm.shared.communication.transcoding.srpc.methods.RspTranscodeFrames;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.networking.srpc.GObject;
import de.seetec.v5.shared.networking.srpc.Methods;
import de.seetec.v5.shared.networking.srpc.SrpcMessage;
import de.seetec.v5.shared.proxy.shared.SRPCProxy;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;

public final class TranscodingSrpcProxy
extends SRPCProxy
implements TranscodingProxyInterface {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.shared.communication.transcoding.srpc.TranscodingSrpcProxy";

    public TranscodingSrpcProxy() {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    public final int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    public final boolean isReady() {
        if (this.isShutdown(CLASS_NAME)) {
            return false;
        }
        return super.isReady();
    }

    @Override
    public RspAllocateTranscodingChannel AllocateTranscodingChannel(long dmId) throws SeeTecException {
        GObject goList = GObject.createList();
        goList.addChild(Long.valueOf(dmId));
        ReqAllocateTranscodingChannel reqAllocateTranscodingChannel = (ReqAllocateTranscodingChannel)ReqAllocateTranscodingChannel.parseGObject(goList);
        SrpcMessage req = SrpcMessage.createRequest((Methods)Methods.RE_SRPC_TRANSCODING_ALLOCATE_TRANSCODING_CHANNEL, (GObject)reqAllocateTranscodingChannel.createGObject());
        SrpcMessage rsp = null;
        try {
            rsp = this.newSrpc.send(req, TimeUnit.SECONDS.toMillis(30L));
        }
        catch (TimeoutException timeoutException) {
            throw new SeeTecException(-20203, timeoutException.getMessage());
        }
        catch (Exception exception) {
            this.logger.error((Object)exception, (Throwable)exception);
        }
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
        return RspAllocateTranscodingChannel.parseGObject(rsp.getPayload());
    }

    @Override
    public RspSetTranscodingStreamParameter SetTranscodingStreamParameter(long channelId, long videoSourceId, long framerate, int videoHeight, int quality, int mediaCodec, long maxBandwidth) throws SeeTecException {
        GObject goList = GObject.createList();
        goList.addChild(Long.valueOf(channelId));
        goList.addChild(Long.valueOf(videoSourceId));
        goList.addChild(Long.valueOf(framerate));
        goList.addChild(Integer.valueOf(videoHeight));
        goList.addChild(Integer.valueOf(quality));
        goList.addChild(Integer.valueOf(mediaCodec));
        goList.addChild(Long.valueOf(maxBandwidth));
        ReqSetTranscodingStreamParameter reqSetTranscodingStreamParameter = (ReqSetTranscodingStreamParameter)ReqSetTranscodingStreamParameter.parseGObject(goList);
        SrpcMessage req = SrpcMessage.createRequest((Methods)Methods.RE_SRPC_TRANSCODING_SET_TRANSCODING_STREAM_PARAMETER, (GObject)reqSetTranscodingStreamParameter.createGObject());
        SrpcMessage rsp = null;
        try {
            rsp = this.newSrpc.send(req, TimeUnit.SECONDS.toMillis(30L));
        }
        catch (TimeoutException timeoutException) {
            throw new SeeTecException(-20203, timeoutException.getMessage());
        }
        catch (Exception exception) {
            this.logger.error((Object)exception, (Throwable)exception);
        }
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
        return RspSetTranscodingStreamParameter.parseGObject(rsp.getPayload());
    }

    @Override
    public RspTranscodeFrames TranscodeFrames(long channelId, ContentFrame[] contentFrames) throws SeeTecException {
        GObject goList = GObject.createList();
        goList.addChild(Long.valueOf(channelId));
        GObject frames = GObject.createList();
        for (ContentFrame contentFrame : contentFrames) {
            GObject frame = GObject.createList();
            frame.addChild(Integer.valueOf(contentFrame.getMediatype()));
            frame.addChild(Integer.valueOf(contentFrame.getAttributes()));
            frame.addChild(Long.valueOf(contentFrame.getStartTimestamp()));
            frame.addChild(Long.valueOf(contentFrame.getEndTimestamp()));
            frame.addChild(contentFrame.getData());
            frames.addChild(frame);
        }
        goList.addChild(frames);
        ReqTranscodeFrames reqTranscodeFrames = (ReqTranscodeFrames)ReqTranscodeFrames.parseGObject(goList);
        SrpcMessage req = SrpcMessage.createRequest((Methods)Methods.RE_SRPC_TRANSCODING_TRANSCODE_FRAMES, (GObject)reqTranscodeFrames.createGObject());
        SrpcMessage rsp = null;
        try {
            rsp = this.newSrpc.send(req, TimeUnit.SECONDS.toMillis(30L));
        }
        catch (TimeoutException timeoutException) {
            throw new SeeTecException(-20203, timeoutException.getMessage());
        }
        catch (Exception exception) {
            this.logger.error((Object)exception, (Throwable)exception);
        }
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
        return RspTranscodeFrames.parseGObject(rsp.getPayload());
    }

    @Override
    public RspCloseTranscodingChannel CloseTranscodingChannel(long channelId) throws SeeTecException {
        GObject goList = GObject.createList();
        goList.addChild(Long.valueOf(channelId));
        ReqCloseTranscodingChannel reqCloseTranscodingChannel = (ReqCloseTranscodingChannel)ReqCloseTranscodingChannel.parseGObject(goList);
        SrpcMessage req = SrpcMessage.createRequest((Methods)Methods.RE_SRPC_TRANSCODING_CLOSE_TRANSCODING_CHANNEL, (GObject)reqCloseTranscodingChannel.createGObject());
        SrpcMessage rsp = null;
        try {
            rsp = this.newSrpc.send(req, TimeUnit.SECONDS.toMillis(30L));
        }
        catch (TimeoutException timeoutException) {
            throw new SeeTecException(-20203, timeoutException.getMessage());
        }
        catch (Exception exception) {
            this.logger.error((Object)exception, (Throwable)exception);
        }
        this.checkResponseForNull(rsp);
        this.checkNonNullResponseForError(rsp);
        return RspCloseTranscodingChannel.parseGObject(rsp.getPayload());
    }

    protected void checkResponseForNull(SrpcMessage response) throws SeeTecException {
        if (null == response) {
            throw new SeeTecException(-20200, "");
        }
    }
}

