/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared.communication;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.configuration.device.shared.ArrayOfCameraPreset.ArrayOfCameraPreset;
import de.seetec.v5.re.cm.device.shared.EdgeStorageHandler;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.re.cm.device.shared.videoprofile.BasicVideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.PlaybackVideoSourceClient;
import de.seetec.v5.re.cm.shared.ContentStreamIntf;
import de.seetec.v5.re.cm.shared.VideoSrvSRPCConnector;
import de.seetec.v5.re.cm.shared.communication.CameraControlPriority;
import de.seetec.v5.re.cm.shared.communication.ContentStream;
import de.seetec.v5.re.cm.shared.communication.DatabaseProxy;
import de.seetec.v5.re.cm.shared.communication.DatabaseReaderImpl;
import de.seetec.v5.re.cm.shared.communication.LiveReader;
import de.seetec.v5.re.cm.shared.communication.MDBAccessorIntf;
import de.seetec.v5.re.cm.shared.communication.transcoding.srpc.TranscodingProxyManager;
import de.seetec.v5.re.cm.shared.communication.transcoding.srpc.methods.TranscodingStreamParameter;
import de.seetec.v5.re.cm.shared.srpc.ReqAddPresetPosition;
import de.seetec.v5.re.cm.shared.srpc.ReqCameraPresets;
import de.seetec.v5.re.cm.shared.srpc.ReqGetJpegSnapshot;
import de.seetec.v5.re.cm.shared.srpc.ReqLockControl;
import de.seetec.v5.re.cm.shared.srpc.ReqLogin;
import de.seetec.v5.re.cm.shared.srpc.ReqOpenContentStream;
import de.seetec.v5.re.cm.shared.srpc.ReqReadRTSPInformation;
import de.seetec.v5.re.cm.shared.srpc.ReqRemovePresetPosition;
import de.seetec.v5.re.cm.shared.srpc.ReqRemoveRTSPInformation;
import de.seetec.v5.re.cm.shared.srpc.ReqSetAbsoluteFocus;
import de.seetec.v5.re.cm.shared.srpc.ReqSetAbsoluteIris;
import de.seetec.v5.re.cm.shared.srpc.ReqSetAbsolutePTZ;
import de.seetec.v5.re.cm.shared.srpc.ReqSetAutoFocus;
import de.seetec.v5.re.cm.shared.srpc.ReqSetAutoIris;
import de.seetec.v5.re.cm.shared.srpc.ReqSetAutoZeroLux;
import de.seetec.v5.re.cm.shared.srpc.ReqSetBandwidthLimitation;
import de.seetec.v5.re.cm.shared.srpc.ReqSetCenterPT;
import de.seetec.v5.re.cm.shared.srpc.ReqSetContinuousFocus;
import de.seetec.v5.re.cm.shared.srpc.ReqSetContinuousIris;
import de.seetec.v5.re.cm.shared.srpc.ReqSetContinuousPTZ;
import de.seetec.v5.re.cm.shared.srpc.ReqSetHomePosition;
import de.seetec.v5.re.cm.shared.srpc.ReqSetPresetPosition;
import de.seetec.v5.re.cm.shared.srpc.ReqSetStreamParameter;
import de.seetec.v5.re.cm.shared.srpc.ReqSetTranscodingStreamParameter;
import de.seetec.v5.re.cm.shared.srpc.ReqSetZeroLux;
import de.seetec.v5.re.cm.shared.srpc.ReqSetZoomArea;
import de.seetec.v5.re.cm.shared.srpc.ReqStartAlarmRecording;
import de.seetec.v5.re.cm.shared.srpc.ReqStartLiveStreaming;
import de.seetec.v5.re.cm.shared.srpc.ReqStartTalking;
import de.seetec.v5.re.cm.shared.srpc.ReqStatusService;
import de.seetec.v5.re.cm.shared.srpc.ReqStoreRTSPInformation;
import de.seetec.v5.re.cm.shared.srpc.ReqSynchronizeEdgeStorage;
import de.seetec.v5.re.cm.shared.srpc.ReqTriggerAction;
import de.seetec.v5.re.cm.shared.srpc.RspAddPresetPosition;
import de.seetec.v5.re.cm.shared.srpc.RspGetJpegSnapshot;
import de.seetec.v5.re.cm.shared.srpc.RspReadRTSPInformation;
import de.seetec.v5.re.cm.shared.srpc.RspStartAlarmRecording;
import de.seetec.v5.re.cm.shared.timerange.TimeRangeInfo;
import de.seetec.v5.re.cm.shared.timerange.TimeRangeInfoContainer;
import de.seetec.v5.re.cm.shared.timerange.TimeRangeList;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.re.shared.EdgeStorageMode;
import de.seetec.v5.re.shared.EdgeStorageParameter;
import de.seetec.v5.re.shared.MDBCnfIntf;
import de.seetec.v5.re.shared.RECore;
import de.seetec.v5.re.shared.srpc.ReqGetAlarmInstance;
import de.seetec.v5.re.shared.srpc.ReqGetAlarmInstances;
import de.seetec.v5.re.shared.srpc.ReqGetAlarmScenarioOccurrencies;
import de.seetec.v5.re.shared.srpc.ReqGetAlarmTimerange;
import de.seetec.v5.re.shared.srpc.ReqGetRecordingInfos;
import de.seetec.v5.re.shared.srpc.ReqGetWriteProtections;
import de.seetec.v5.re.shared.srpc.ReqMarkAsAlarmRecording;
import de.seetec.v5.re.shared.srpc.ReqRemoveRecording;
import de.seetec.v5.re.shared.srpc.ReqRemoveWriteProtection;
import de.seetec.v5.re.shared.srpc.ReqSetWriteProtection;
import de.seetec.v5.re.shared.srpc.ReqStatusContent;
import de.seetec.v5.re.shared.srpc.RspGetAlarmInstance;
import de.seetec.v5.re.shared.srpc.RspGetAlarmInstances;
import de.seetec.v5.re.shared.srpc.RspGetAlarmScenarioOccurrencies;
import de.seetec.v5.re.shared.srpc.RspGetAlarmTimerange;
import de.seetec.v5.re.shared.srpc.RspGetRecordingInfos;
import de.seetec.v5.re.shared.srpc.RspGetWriteProtections;
import de.seetec.v5.re.shared.srpc.RspMarkAsAlarmRecording;
import de.seetec.v5.re.shared.srpc.RspRemoveRecording;
import de.seetec.v5.re.shared.srpc.RspSetWriteProtection;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.TimeHelper;
import de.seetec.v5.shared.net.srpc.SRPCHandler;
import de.seetec.v5.shared.net.srpc.re.ReqReadGOP;
import de.seetec.v5.shared.net.srpc.re.ReqReadMultipleFrames;
import de.seetec.v5.shared.net.srpc.re.ReqReadNextFrame;
import de.seetec.v5.shared.net.srpc.re.ReqReadPreviousFrame;
import de.seetec.v5.shared.networking.srpc.GObject;
import de.seetec.v5.shared.networking.srpc.Methods;
import de.seetec.v5.shared.networking.srpc.RequestHandlerCallback;
import de.seetec.v5.shared.networking.srpc.SrpcMessage;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import java.util.concurrent.TimeUnit;

public class VideoServiceClientRequestHandler
extends SRPCHandler
implements MDBAccessorIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.shared.communication.VideoSrvCRH";
    private final long tsStartup = System.currentTimeMillis();
    private VideoSrv videoSrv = null;
    private VideoSrvSRPCConnector srpcConnector = null;
    private Long userID = null;
    private String userName = "<unknown>";
    private long clientID = -1L;
    private long lockTimeout = -1L;
    private int openingMode = -1;
    private ContentStreamIntf contentStream = null;
    private DatabaseReaderImpl databaseReader = null;
    private LiveReader liveReader = null;
    private InetAddress host = null;
    private String clientHost = null;
    private long framerate = 1000L;
    private String mpegSpeed = "";
    private boolean audioTransmission = false;
    private Integer classification = null;
    private ContentFrame lastArchiveFrame = null;
    private int lastPublishedServiceStatus = 0;
    private int[] liveResolution;
    private TranscodingProxyManager transcodingProxyManager = null;
    private boolean transcodingEnabled = false;
    private byte[] version;

    public int init(VideoSrv videoSrv, Socket socket) {
        int errorCode;
        this.videoSrv = videoSrv;
        if (this.videoSrv == null) {
            return -21601;
        }
        if (this.videoSrv.isShutdown()) {
            this.logger.warn(this.videoSrv + " is already shutting down, so reject client from " + socket);
            return -21609;
        }
        this.logger.info("New client from " + socket + " to " + this + " ...");
        this.host = socket.getInetAddress();
        this.clientHost = this.host.getHostAddress();
        try {
            this.srpcConnector = new VideoSrvSRPCConnector();
            errorCode = this.srpcConnector.init(this, socket);
            if (errorCode != 0) {
                this.logger.error("Initializing new connector with socket [" + socket + "] failed with error [" + errorCode + "]");
                return errorCode;
            }
        }
        catch (Exception ex) {
            this.logger.error("Creating new connector with socket [" + socket + "] failed", (Throwable)ex);
            return -21604;
        }
        errorCode = this.videoSrv.registerVideoServiceClientRequestHandler(this);
        if (errorCode != 0) {
            this.logger.error("Registering client failed with error [" + errorCode + "]");
            return errorCode;
        }
        this.thread = new Thread((Runnable)((Object)this), this.toString());
        this.thread.start();
        return 0;
    }

    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public int shutdown() {
        long duration;
        long tsStart;
        LiveReader actualiveReaders;
        int errorCode;
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        long tsShutdownStart = System.currentTimeMillis();
        if (this.contentStream != null) {
            this.unsubscribeFromNetworkClientReadingProxy();
            try {
                errorCode = this.contentStream.shutdown();
                if (errorCode != 0) {
                    this.logger.warn("Shutting down " + this.contentStream + " failed with error [" + errorCode + "]");
                }
            }
            catch (Throwable ex) {
                this.logger.warn((Object)ex, ex);
            }
            this.contentStream = null;
        }
        if ((actualiveReaders = this.liveReader) != null) {
            tsStart = System.currentTimeMillis();
            try {
                errorCode = this.videoSrv.removeLiveReader(actualiveReaders);
                if (errorCode != 0) {
                    this.logger.warn("Removing " + (Object)((Object)actualiveReaders) + " failed with error [" + errorCode + "]");
                }
                if ((errorCode = actualiveReaders.shutdown()) != 0) {
                    this.logger.warn("Shutting down [" + (Object)((Object)actualiveReaders) + "] failed with error [" + errorCode + "]");
                }
            }
            catch (Throwable ex) {
                this.logger.warn((Object)ex, ex);
            }
            duration = System.currentTimeMillis() - tsStart;
            if (duration > 9999L) {
                this.logger.warn("Discarding [LiveReader] of " + (Object)((Object)actualiveReaders) + " lasts for [" + Basic.longToFormattedString((long)duration) + " ms]!");
            }
        }
        tsStart = System.currentTimeMillis();
        errorCode = this.videoSrv.deregisterVideoServiceClientRequestHandler(this);
        if (errorCode != 0) {
            this.logger.warn("Deregistering client failed with error [" + errorCode + "]");
        }
        if ((duration = System.currentTimeMillis() - tsStart) > 9999L) {
            this.logger.warn("Deregistering " + this.videoSrv + " of " + this + " lasts for [" + Basic.longToFormattedString((long)duration) + " ms]!");
        }
        if (this.thread != null) {
            tsStart = System.currentTimeMillis();
            try {
                if (this.thread.isAlive()) {
                    this.thread.join(30000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!super.isRunFinished(CLASS_NAME)) {
                this.logger.warn("Thread of " + this + " didn't finish in time");
            }
            this.thread = null;
            duration = System.currentTimeMillis() - tsStart;
            if (duration > 9999L) {
                this.logger.warn("Terminating thread of " + this + " lasts for [" + Basic.longToFormattedString((long)duration) + " ms]!");
            }
        }
        if (this.srpcConnector != null) {
            long dDuration;
            tsStart = System.currentTimeMillis();
            errorCode = this.srpcConnector.shutdown();
            if (errorCode != 0) {
                this.logger.warn("Shutting down connector [" + (Object)((Object)this.srpcConnector) + "] failed with error [" + errorCode + "]");
            }
            if ((dDuration = System.currentTimeMillis() - tsStart) > 9999L) {
                this.logger.warn("Discarding " + (Object)((Object)this.srpcConnector) + " of " + this + " lasts for [" + Basic.longToFormattedString((long)dDuration) + " ms]!");
            }
            this.srpcConnector = null;
        }
        if (this.databaseReader != null) {
            tsStart = System.currentTimeMillis();
            errorCode = this.databaseReader.shutdown();
            if (errorCode != 0) {
                this.logger.warn("Shutting down [" + this.databaseReader + "] failed with error [" + errorCode + "]");
            }
            if ((duration = System.currentTimeMillis() - tsStart) > 9999L) {
                this.logger.warn("Discarding " + this.databaseReader + " of " + this + " lasts for [" + Basic.longToFormattedString((long)duration) + " ms]!");
            }
            this.databaseReader = null;
        }
        if (this.transcodingProxyManager != null) {
            this.transcodingProxyManager.shutdown();
            this.transcodingProxyManager = null;
        }
        errorCode = super.shutdown();
        duration = System.currentTimeMillis() - tsShutdownStart;
        this.logger.info("Shutdown done for " + this + " is down within [" + Basic.longToFormattedString((long)duration) + " ms]");
        return errorCode;
    }

    @Override
    public void sendContentStatus(ReqStatusContent reqContentStatus) {
        SrpcMessage request = SrpcMessage.createRequest((Methods)Methods.SSL_SRPC_REQ_STATUSCONTENT, (GObject)reqContentStatus.createGObject());
        this.sendStatus(request);
    }

    private int sendContentFrame(boolean privileged, ContentFrame[] contentFrame, boolean isSingleFrame, short transactionID, long maxVolume) {
        if (this.contentStream == null) {
            if (this.isShutdown()) {
                this.logger.warn("Cannot send ContentFrame because of shutdown of " + this);
            } else {
                this.logger.warn("No ContentStream available to send ContentFrame for " + this);
            }
            return -21609;
        }
        return this.contentStream.sendFrame(privileged, contentFrame, isSingleFrame, transactionID, maxVolume);
    }

    private int sendArchiveContentFrames(short transactionID, ContentFrame[] contentFrames, long reqFrom, long reqTo, boolean containsLastFrame) {
        if (this.contentStream == null) {
            if (this.isShutdown()) {
                this.logger.warn("Cannot send ContentFrame because of shutdown of " + this);
            } else {
                this.logger.warn("No ContentStream available to send ArchiveContentFrames for " + this);
            }
            return -21609;
        }
        return this.contentStream.sendArchiveContentFrames(transactionID, contentFrames, reqFrom, reqTo, containsLastFrame);
    }

    public int sendStatusService(int statusCode) {
        if (this.lastPublishedServiceStatus == statusCode) {
            return 0;
        }
        this.logger.info("Sending ServiceStatus=[" + statusCode + "] to " + this);
        this.lastPublishedServiceStatus = statusCode;
        ReqStatusService reqStatusService = new ReqStatusService(statusCode);
        SrpcMessage request = SrpcMessage.createRequest((Methods)Methods.CM_SRPC_REQ_STATUSSERVICE, (GObject)reqStatusService.createGObject());
        return this.sendStatus(request);
    }

    public int sendStatus(SrpcMessage msg) {
        return this.sendStatus(msg, true);
    }

    public int sendStatus(SrpcMessage request, boolean conditional) {
        Methods method = Methods.valueOf((int)request.getHash());
        if (conditional && this.databaseReader == null && this.liveReader == null && (method == Methods.SSL_SRPC_REQ_STATUSCONTENT || method == Methods.CM_SRPC_REQ_STATUSABSOLUTEPTZ)) {
            return 0;
        }
        request.setCompression((byte)1);
        request.setVersion(this.version);
        if (this.srpcConnector != null && !this.srpcConnector.isShutdown()) {
            this.srpcConnector.sendFireAndForgetREQ(request);
        }
        return 0;
    }

    public void onError(int srpcErrorCode) {
        this.shutdown();
    }

    public void run() {
        int errorCode;
        super.setRunFinished(CLASS_NAME, false);
        long tsNextStillAliveMsg = System.currentTimeMillis() + 60000L;
        long tsNextBlockingCheck = System.currentTimeMillis() + 60000L;
        long tsNextStatiUpdate = System.currentTimeMillis() + 500L;
        long idleSince = Long.MAX_VALUE;
        boolean minuteWarn = true;
        boolean hourWarn = true;
        try {
            while (true) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (tsNextStatiUpdate < System.currentTimeMillis() && this.videoSrv != null && !this.videoSrv.isShutdown()) {
                    errorCode = this.videoSrv.sendMultipleStatus(this);
                    if (errorCode != 0) {
                        this.logger.warn("Send stati failed with error [" + errorCode + "]");
                    } else {
                        idleSince = System.nanoTime();
                    }
                    tsNextStatiUpdate = System.currentTimeMillis() + 300000L;
                }
                if (tsNextStillAliveMsg < System.currentTimeMillis()) {
                    tsNextStillAliveMsg = System.currentTimeMillis() + 3600000L;
                    this.logger.info(this + " has an uptime of [" + TimeHelper.getReadableTimerange((long)this.getUptime()) + "]");
                }
                if (tsNextBlockingCheck < System.currentTimeMillis()) {
                    tsNextBlockingCheck = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(1L);
                    if (this.openingMode == 1 && this.contentStream != null && this.contentStream.isShutdown()) {
                        throw new RuntimeException(this.contentStream + " of " + this + " is already shutting down!");
                    }
                }
                if (this.videoSrv == null || this.videoSrv.isShutdown() || this.isShutdown()) break;
                SrpcMessage req = null;
                try {
                    req = this.getNextReq(1, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (req == null) {
                    long nanoNow = System.nanoTime();
                    if (nanoNow < idleSince) {
                        idleSince = nanoNow;
                        continue;
                    }
                    if (nanoNow - idleSince > TimeUnit.MINUTES.toNanos(1L) && minuteWarn) {
                        minuteWarn = false;
                        this.logger.info(String.format("Handler[%s]: Idle for 1 minute!", Integer.toHexString(this.hashCode())));
                    }
                    if (nanoNow - idleSince <= TimeUnit.HOURS.toNanos(1L) || !hourWarn) continue;
                    hourWarn = false;
                    this.logger.warn(String.format("Handler[%s]: Idle for 1 hour!", Integer.toHexString(this.hashCode())));
                    continue;
                }
                idleSince = System.nanoTime();
                RequestHandlerCallback callback = this.getCallback(req.getId());
                switch (Methods.valueOf((int)req.getHash())) {
                    case RE_SRPC_REQ_MARKASALARMRECORDING: {
                        this.execMarkAsAlarmRecording(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_STARTALARMRECORDING: {
                        this.execStartAlarmRecording(req, callback);
                        break;
                    }
                    case RE_SRPC_REQ_GETALARMINSTANCE: {
                        this.execGetAlarmInstance(req, callback);
                        break;
                    }
                    case RE_SRPC_REQ_GETALARMINSTANCES: {
                        this.execGetAlarmInstances(req, callback);
                        break;
                    }
                    case RE_SRPC_REQ_GETALARMSCENARIOOCCURRENCIES: {
                        this.execGetAlarmScenarioOccurrencies(req, callback);
                        break;
                    }
                    case MD_REQ_LOGIN: {
                        this.execLogin(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_LOCKCONTROL: {
                        this.execLockControl(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_UNLOCKCONTROL: {
                        this.execUnlockControl(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_READRTSPINFORMATION: {
                        this.execReadRTSPInformation(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_REMOVERTSPINFORMATION: {
                        this.execRemoveRTSPInformation(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_STORERTSPINFORMATION: {
                        this.execStoreRTSPInformation(req, callback);
                        break;
                    }
                    case ENT_FUNCTION_TRIGGER_ACTION: {
                        this.execTriggerAction(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_SETABSOLUTEPTZ: {
                        this.execSetAbsolutePtz(req);
                        break;
                    }
                    case CM_SRPC_REQ_SETABSOLUTEPT: {
                        this.execSetAbsolutePt(req);
                        break;
                    }
                    case CM_SRPC_REQ_SETABSOLUTEZ: {
                        this.execSetAbsoluteZ(req);
                        break;
                    }
                    case CM_SRPC_REQ_SETCONTINUOUSPTZ: {
                        this.execSetContinuousPTZ(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_SETCENTERPT: {
                        this.execSetCenterPT(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_SETZOOMAREA: {
                        this.execSetZoomArea(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_SETABSOLUTEIRIS: {
                        this.execSetAbsoluteIris(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_SETCONTINUOUSIRIS: {
                        this.execSetContinuousIris(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_SETAUTOIRIS: {
                        this.execSetAutoIris(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_SETABSOLUTEFOCUS: {
                        this.execSetAbsoluteFocus(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_SETCONTINUOUSFOCUS: {
                        this.execSetContinuousFocus(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_SETAUTOFOCUS: {
                        this.execSetAutoFocus(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_SETZEROLUX: {
                        this.execSetZeroLux(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_SETAUTOZEROLUX: {
                        this.execSetAutoZeroLux(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_STOPALLCONTROLCOMMANDS: {
                        this.execStopAllControlCommands(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_SETHOMEPOSITION: {
                        this.execSetHomePosition(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_SETPRESETPOSITION: {
                        this.execSetPresetPosition(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_OPENCONTENTSTREAM: {
                        this.execOpenContentStream(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_SETSTREAMPARAMETER: {
                        this.execSetStreamParameter(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_SET_TRANSCODING_STREAM_PARAMETER: {
                        this.execSetTranscodingStreamParameter(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_SETBANDWIDTHLIMITATION: {
                        this.execSetBandwidthLimitation(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_STARTLIVESTREAMING: {
                        this.execStartLiveStreaming(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_STOPSTREAMING: {
                        this.execStopStreaming(req, callback);
                        break;
                    }
                    case RE_SRPC_REQ_READNEXTFRAME: {
                        this.execReadNextFrame(req, callback);
                        break;
                    }
                    case RE_SRPC_REQ_READPREVIOUSFRAME: 
                    case RE_SRPC_REQ_READNEARESTFRAME: {
                        this.execReadPreviousFrame(req, callback);
                        break;
                    }
                    case RE_SRPC_REQ_READMULTIPLEFRAMES: {
                        this.execReadMultipleFrames(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_ADDPRESETPOSITION: {
                        this.execAddPresetPosition(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_REMOVEPRESETPOSITION: {
                        this.execRemovePresetPosition(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_ADDCAMERAPRESETS: {
                        this.execAddCameraPresets(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_GETCAMERAPRESETS: {
                        this.execGetCameraPresets(req, callback);
                        break;
                    }
                    case RE_SRPC_REQ_GETALARMTIMERANGE: {
                        this.execGetAlarmTimerange(req, callback);
                        break;
                    }
                    case RE_SRPC_REQ_GETRECORDINGINFOS: {
                        this.execGetRecordingInfos(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_GETJPEGSNAPSHOT: {
                        this.execGetJpegSnapshot(req, callback);
                        break;
                    }
                    case RE_SRPC_REQ_GETWRITEPROTECTIONS: {
                        this.execGetWriteProtections(req, callback);
                        break;
                    }
                    case RE_SRPC_REQ_SETWRITEPROTECTION: {
                        this.execSetWriteProtection(req, callback);
                        break;
                    }
                    case RE_SRPC_REQ_REMOVEWRITEPROTECTION: {
                        this.execRemoveWriteProtection(req, callback);
                        break;
                    }
                    case RE_SRPC_REQ_REMOVERECORDING: {
                        this.execRemoveRecording(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_MOTION_DETECTED: {
                        this.execMotionDetected(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_MOTION_END: {
                        this.execMotionEnd(req, callback);
                        break;
                    }
                    case DM_SRPC_REQ_SYNCHRONIZE_EDGE_STORAGE: {
                        this.execSynchronizeEdgeStorage(req, callback);
                        break;
                    }
                    case RE_SRPC_REQ_READGOP: {
                        this.execReadGOP(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_UPDATE_GENERIC_EVENT_TRIGGER: {
                        this.execUpdateGenericEventTrigger(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_START_TALKING: {
                        this.execStartTalking(req, callback);
                        break;
                    }
                    case CM_SRPC_REQ_STOP_TALKING: {
                        this.execStopTalking(req, callback);
                        break;
                    }
                }
            }
        }
        catch (Throwable ex) {
            this.logger.error("Thread of " + this + " terminated because of exception", ex);
        }
        super.setRunFinished(CLASS_NAME, true);
        errorCode = this.shutdown();
        if (errorCode != 0) {
            this.logger.error("[shutdown] failed with error [" + errorCode + "]");
        }
    }

    private void execLogin(SrpcMessage req, RequestHandlerCallback rhc) {
        int errorCode = 0;
        ReqLogin request = ReqLogin.parseGObject(req.getPayload());
        this.userName = request.getUserName();
        this.clientID = request.getClientID() != null ? request.getClientID() : -1L;
        this.userID = request.getUserID() != null ? request.getUserID() : Long.valueOf(-1L);
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
        rsp.setError(errorCode);
        rhc.onRequestHandled(req, rsp);
    }

    private void execLockControl(SrpcMessage req, RequestHandlerCallback rhc) {
        int errorCode = 0;
        ReqLockControl request = ReqLockControl.parseGObject(req.getPayload());
        this.lockTimeout = request.getLockTimeout();
        if (this.videoSrv != null) {
            errorCode = this.videoSrv.setControlLock(this, this.userName, this.clientID, this.lockTimeout);
        }
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
        rsp.setError(errorCode);
        rhc.onRequestHandled(req, rsp);
    }

    private void execUnlockControl(SrpcMessage req, RequestHandlerCallback rhc) {
        int errorCode = 0;
        if (this.videoSrv != null) {
            errorCode = this.videoSrv.removeControlLock(this);
        }
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
        rsp.setError(errorCode);
        rhc.onRequestHandled(req, rsp);
    }

    private void execReadRTSPInformation(SrpcMessage req, RequestHandlerCallback rhc) {
        int errorCode = 0;
        ReqReadRTSPInformation request = ReqReadRTSPInformation.parseGObject(req.getPayload());
        RspReadRTSPInformation gorsp = new RspReadRTSPInformation(this.videoSrv.getCore().readRTSPInformation(request.getKey()));
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)gorsp.createGObject());
        rsp.setError(errorCode);
        rhc.onRequestHandled(req, rsp);
    }

    private void execRemoveRTSPInformation(SrpcMessage req, RequestHandlerCallback rhc) {
        ReqRemoveRTSPInformation request = ReqRemoveRTSPInformation.parseGObject(req.getPayload());
        this.videoSrv.getCore().removeRTSPInformation(request.getKey());
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
        rsp.setError(0);
        rhc.onRequestHandled(req, rsp);
    }

    private void execStoreRTSPInformation(SrpcMessage req, RequestHandlerCallback rhc) {
        ReqStoreRTSPInformation request = ReqStoreRTSPInformation.parseGObject(req.getPayload());
        this.videoSrv.getCore().storeRTSPInformation(request.getKey(), request.getValue());
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
        rsp.setError(0);
        rhc.onRequestHandled(req, rsp);
    }

    private void execTriggerAction(SrpcMessage req, RequestHandlerCallback callback) {
        try {
            int errorCode = 0;
            de.seetec.v5.shared.net.srpc.general.ReqTriggerAction request = de.seetec.v5.shared.net.srpc.general.ReqTriggerAction.parseGObject((GObject)req.getPayload());
            long entityID = request.getActionID();
            long priority = request.getPTZPriority();
            long timeout = request.getPTZPriorityTimeout();
            if (!this.videoSrv.handlePTZPriority(new CameraControlPriority(entityID, priority, timeout, false))) {
                this.logger.info("Priority " + request + " for " + this + " not granted");
                return;
            }
            TriggerActionHandler triggerActionHandler = new TriggerActionHandler();
            try {
                errorCode = triggerActionHandler.init(request);
                if (errorCode != 0) {
                    this.logger.warn("Initializing " + triggerActionHandler + " for " + this + " failed with error [" + errorCode + "");
                }
            }
            catch (Throwable ex) {
                this.logger.warn((Object)ex, ex);
                this.logger.warn("Problems initializing " + triggerActionHandler + " for " + this);
            }
            SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
            rsp.setError(errorCode);
            callback.onRequestHandled(req, rsp);
            return;
        }
        catch (Exception errorCode) {
            try {
                ReqTriggerAction request = ReqTriggerAction.parseGObject(req.getPayload());
                if (this.videoSrv == null || this.videoSrv.isShutdown()) {
                    this.logger.warn("Associated video service " + this.videoSrv + " is already shutting down");
                    return;
                }
                boolean isCameraControlPrivileged = false;
                Long clientID = request.getClientID();
                Long lockTimeout = request.getLockTimeout();
                if (clientID != null && lockTimeout != null && clientID >= 0L) {
                    this.logger.info("Checking for access control ...");
                    isCameraControlPrivileged = this.videoSrv.isControlGranted(clientID, lockTimeout);
                }
                if ((errorCode = this.videoSrv.triggerAction(request.getActionID(), request.getAlarmScriptID(), request.getAlarmInstanceID(), request.getAlarmTimerange(), request.getGenericData(), isCameraControlPrivileged, -1L, -1L)) != 0) {
                    this.logger.warn("Triggering action failed with error [" + errorCode + "]");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
    }

    private ReqSetAbsolutePTZ prepareAbsolutePtzRequest(SrpcMessage req) {
        long timeout;
        long priority;
        ReqSetAbsolutePTZ request;
        try {
            request = ReqSetAbsolutePTZ.parseGObject(req.getPayload());
        }
        catch (IndexOutOfBoundsException ex) {
            this.logger.error("Exception while sending absolute ptz command. Please make sure server and client version are the same for " + this.videoSrv);
            return null;
        }
        if (!this.videoSrv.isControlGranted(this.clientID, this.lockTimeout)) {
            this.logger.warn("Control for " + this + " not granted");
            return null;
        }
        long entityID = request.getEntityID();
        if (!this.videoSrv.handlePTZPriority(new CameraControlPriority(entityID, priority = request.getPriority().longValue(), timeout = request.getTimeout().longValue(), true))) {
            this.logger.info("Priority " + request + " for " + this + " not granted");
            return null;
        }
        return request;
    }

    private void execSetAbsolutePtz(SrpcMessage req) {
        ReqSetAbsolutePTZ request = this.prepareAbsolutePtzRequest(req);
        if (request == null) {
            return;
        }
        int errorCode = this.videoSrv.setAbsolutePTZ(this, request.getPan(), request.getTilt(), request.getZoom());
        if (errorCode != 0) {
            this.logger.warn("Navigating to given absolute ptz position failed with error [" + errorCode + "] for " + this.videoSrv);
        }
    }

    private void execSetAbsolutePt(SrpcMessage req) {
        ReqSetAbsolutePTZ request = this.prepareAbsolutePtzRequest(req);
        if (request == null) {
            return;
        }
        int errorCode = this.videoSrv.setAbsolutePt(this, request.getPan(), request.getTilt());
        if (errorCode != 0) {
            this.logger.warn("Navigating to given absolute ptz position failed with error [" + errorCode + "] for " + this.videoSrv);
        }
    }

    private void execSetAbsoluteZ(SrpcMessage req) {
        ReqSetAbsolutePTZ request = this.prepareAbsolutePtzRequest(req);
        if (request == null) {
            return;
        }
        int errorCode = this.videoSrv.setAbsoluteZ(this, request.getZoom());
        if (errorCode != 0) {
            this.logger.warn("Navigating to given absolute ptz position failed with error [" + errorCode + "] for " + this.videoSrv);
        }
    }

    private void execSetContinuousPTZ(SrpcMessage req, RequestHandlerCallback rhc) {
        long timeout;
        long priority;
        ReqSetContinuousPTZ request;
        try {
            request = ReqSetContinuousPTZ.parseGObject(req.getPayload());
        }
        catch (IndexOutOfBoundsException ex) {
            this.logger.error("Exception while sending continuous ptz command. Please make sure server and client version are the same for " + this.videoSrv);
            return;
        }
        if (!this.videoSrv.isControlGranted(this.clientID, this.lockTimeout)) {
            this.logger.warn("Control for " + this + " not granted");
            return;
        }
        long entityID = request.getEntityID();
        if (!this.videoSrv.handlePTZPriority(new CameraControlPriority(entityID, priority = request.getPriority().longValue(), timeout = request.getTimeout().longValue(), true))) {
            this.logger.info("Priority " + request + " for " + this + " not granted");
            return;
        }
        int errorCode = this.videoSrv.setContinuousPTZ(request.getPanSpeed(), request.getTiltSpeed(), request.getZoomSpeed());
        if (errorCode != 0) {
            this.logger.warn("Navigating to given continous ptz position failed with error [" + errorCode + "] for " + this.videoSrv);
        }
    }

    private void execSetAbsoluteIris(SrpcMessage req, RequestHandlerCallback rhc) {
        long timeout;
        long priority;
        ReqSetAbsoluteIris request;
        try {
            request = ReqSetAbsoluteIris.parseGObject(req.getPayload());
        }
        catch (IndexOutOfBoundsException ex) {
            this.logger.error("Exception while sending absolute iris command. Please make sure server and client version are the same for " + this.videoSrv);
            return;
        }
        if (!this.videoSrv.isControlGranted(this.clientID, this.lockTimeout)) {
            this.logger.warn("Control for " + this + " not granted");
            return;
        }
        long entityID = request.getEntityID();
        if (!this.videoSrv.handlePTZPriority(new CameraControlPriority(entityID, priority = request.getPriority().longValue(), timeout = request.getTimeout().longValue(), true))) {
            this.logger.info("Priority " + request + " for " + this + " not granted");
            return;
        }
        int errorCode = this.videoSrv.setAbsoluteIris(request.getIris());
        if (errorCode != 0) {
            this.logger.warn("Setting absolute iris position failed with error [" + errorCode + "]");
        }
    }

    private void execSetCenterPT(SrpcMessage req, RequestHandlerCallback rhc) {
        long timeout;
        long priority;
        ReqSetCenterPT request;
        try {
            request = ReqSetCenterPT.parseGObject(req.getPayload());
        }
        catch (IndexOutOfBoundsException ex) {
            this.logger.error("Exception while sending center PT command. Please make sure server and client version are the same for " + this.videoSrv);
            return;
        }
        if (!this.videoSrv.isControlGranted(this.clientID, this.lockTimeout)) {
            this.logger.warn("Control for " + this + " not granted");
            return;
        }
        long entityID = request.getEntityID();
        if (!this.videoSrv.handlePTZPriority(new CameraControlPriority(entityID, priority = request.getPriority().longValue(), timeout = request.getTimeout().longValue(), true))) {
            this.logger.info("Priority " + request + " for " + this + " not granted ");
            return;
        }
        int errorCode = this.videoSrv.setCenterPT(request.getXPosition(), request.getYPosition(), this.liveResolution);
        if (errorCode != 0) {
            this.logger.warn("Navigating to image position failed with error [" + errorCode + "]");
        }
    }

    private void execSetZoomArea(SrpcMessage req, RequestHandlerCallback rhc) {
        long timeout;
        long priority;
        ReqSetZoomArea request;
        try {
            request = ReqSetZoomArea.parseGObject(req.getPayload());
        }
        catch (IndexOutOfBoundsException ex) {
            this.logger.error("Exception while sending zoom area command. Please make sure server and client version are the same for " + this.videoSrv);
            return;
        }
        if (!this.videoSrv.isControlGranted(this.clientID, this.lockTimeout)) {
            this.logger.warn("Control for " + this + " not granted");
            return;
        }
        long entityID = request.getEntityID();
        if (!this.videoSrv.handlePTZPriority(new CameraControlPriority(entityID, priority = request.getPriority().longValue(), timeout = request.getTimeout().longValue(), true))) {
            this.logger.info("Priority " + request + " for " + this + " not granted");
            return;
        }
        int errorCode = this.videoSrv.setZoomArea(request.getXPosition(), request.getYPosition(), request.getWidth(), request.getHeigth(), this.liveResolution);
        if (errorCode != 0) {
            this.logger.warn("Navigating to image position failed with error [" + errorCode + "]");
        }
    }

    private void execSetContinuousIris(SrpcMessage req, RequestHandlerCallback rhc) {
        long timeout;
        long priority;
        ReqSetContinuousIris request;
        try {
            request = ReqSetContinuousIris.parseGObject(req.getPayload());
        }
        catch (IndexOutOfBoundsException ex) {
            this.logger.error("Exception while sending continuous Iris command. Please make sure server and client version are the same");
            return;
        }
        if (!this.videoSrv.isControlGranted(this.clientID, this.lockTimeout)) {
            this.logger.warn("Control for " + this + " not granted");
            return;
        }
        long entityID = request.getEntityID();
        if (!this.videoSrv.handlePTZPriority(new CameraControlPriority(entityID, priority = request.getPriority().longValue(), timeout = request.getTimeout().longValue(), true))) {
            this.logger.info("Priority " + request + " for " + this + " not granted");
            return;
        }
        int errorCode = this.videoSrv.setContinuousIris(request.getIrisSpeed());
        if (errorCode != 0) {
            this.logger.warn("Setting continous iris position failed with error [" + errorCode + "]");
        }
    }

    private void execSetAutoIris(SrpcMessage req, RequestHandlerCallback rhc) {
        long timeout;
        long priority;
        ReqSetAutoIris request;
        try {
            request = ReqSetAutoIris.parseGObject(req.getPayload());
        }
        catch (IndexOutOfBoundsException ex) {
            this.logger.error("Exception while sending auto Iris command. Please make sure server and client version are the same");
            return;
        }
        if (!this.videoSrv.isControlGranted(this.clientID, this.lockTimeout)) {
            this.logger.warn("Control for " + this + " not granted");
            return;
        }
        long entityID = request.getEntityID();
        if (!this.videoSrv.handlePTZPriority(new CameraControlPriority(entityID, priority = request.getPriority().longValue(), timeout = request.getTimeout().longValue(), true))) {
            this.logger.info("Priority " + request + " for " + this + " not granted");
            return;
        }
        int errorCode = this.videoSrv.setAutoIris(request.isActive());
        if (errorCode != 0) {
            this.logger.warn("Setting auto iris position failed with error [" + errorCode + "]");
        }
    }

    private void execSetAbsoluteFocus(SrpcMessage req, RequestHandlerCallback rhc) {
        long timeout;
        long priority;
        ReqSetAbsoluteFocus request;
        try {
            request = ReqSetAbsoluteFocus.parseGObject(req.getPayload());
        }
        catch (IndexOutOfBoundsException ex) {
            this.logger.error("Exception while sending absolute focus command. Please make sure server and client version are the same");
            return;
        }
        if (!this.videoSrv.isControlGranted(this.clientID, this.lockTimeout)) {
            this.logger.warn("Control for " + this + " not granted");
            return;
        }
        long entityID = request.getEntityID();
        if (!this.videoSrv.handlePTZPriority(new CameraControlPriority(entityID, priority = request.getPriority().longValue(), timeout = request.getTimeout().longValue(), true))) {
            this.logger.info("Priority " + request + " for " + this + " not granted ");
            return;
        }
        int errorCode = this.videoSrv.setAbsoluteFocus(request.getFocus());
        if (errorCode != 0) {
            this.logger.warn("Setting absolute focus position for " + this + " failed with error [" + errorCode + "]");
        }
    }

    private void execSetContinuousFocus(SrpcMessage req, RequestHandlerCallback rhc) {
        long timeout;
        long priority;
        ReqSetContinuousFocus request;
        try {
            request = ReqSetContinuousFocus.parseGObject(req.getPayload());
        }
        catch (IndexOutOfBoundsException ex) {
            this.logger.error("Exception while sending continuous Focus command. Please make sure server and client version are the same");
            return;
        }
        if (!this.videoSrv.isControlGranted(this.clientID, this.lockTimeout)) {
            this.logger.warn("Control for " + this + " not granted");
            return;
        }
        long entityID = request.getEntityID();
        if (!this.videoSrv.handlePTZPriority(new CameraControlPriority(entityID, priority = request.getPriority().longValue(), timeout = request.getTimeout().longValue(), true))) {
            this.logger.info("Priority " + request + " for " + this + " not granted");
            return;
        }
        int errorCode = this.videoSrv.setContinuousFocus(request.getFocusSpeed());
        if (errorCode != 0) {
            this.logger.warn("Setting continous focus position failed with error [" + errorCode + "]");
        }
    }

    private void execSetAutoFocus(SrpcMessage req, RequestHandlerCallback rhc) {
        long timeout;
        long priority;
        ReqSetAutoFocus request;
        try {
            request = ReqSetAutoFocus.parseGObject(req.getPayload());
        }
        catch (IndexOutOfBoundsException ex) {
            this.logger.error("Exception while sending auto Focus command. Please make sure server and client version are the same");
            return;
        }
        if (!this.videoSrv.isControlGranted(this.clientID, this.lockTimeout)) {
            this.logger.warn("Control for " + this + " not granted");
            return;
        }
        long entityID = request.getEntityID();
        if (!this.videoSrv.handlePTZPriority(new CameraControlPriority(entityID, priority = request.getPriority().longValue(), timeout = request.getTimeout().longValue(), true))) {
            this.logger.info("Priority " + request + " for " + this + " not granted");
            return;
        }
        int errorCode = this.videoSrv.setAutoFocus(request.isActive());
        if (errorCode != 0) {
            this.logger.warn("Setting auto focus position failed with error [" + errorCode + "]");
        }
    }

    private void execSetZeroLux(SrpcMessage req, RequestHandlerCallback rhc) {
        long timeout;
        long priority;
        ReqSetZeroLux request;
        try {
            request = ReqSetZeroLux.parseGObject(req.getPayload());
        }
        catch (IndexOutOfBoundsException ex) {
            this.logger.error("Exception while sending zero Lux command. Please make sure server and client version are the same");
            return;
        }
        if (!this.videoSrv.isControlGranted(this.clientID, this.lockTimeout)) {
            this.logger.warn("Control for " + this + " not granted");
            return;
        }
        long entityID = request.getEntityID();
        if (!this.videoSrv.handlePTZPriority(new CameraControlPriority(entityID, priority = request.getPriority().longValue(), timeout = request.getTimeout().longValue(), true))) {
            this.logger.info("Priority " + request + " for " + this + " not granted");
            return;
        }
        int errorCode = this.videoSrv.setZeroLux(request.isActive());
        if (errorCode != 0) {
            this.logger.warn("Setting new zero lux value failed with error [" + errorCode + "]");
        }
    }

    private void execSetAutoZeroLux(SrpcMessage req, RequestHandlerCallback rhc) {
        long timeout;
        long priority;
        ReqSetAutoZeroLux request;
        try {
            request = ReqSetAutoZeroLux.parseGObject(req.getPayload());
        }
        catch (IndexOutOfBoundsException ex) {
            this.logger.error("Exception while sending auto zero Lux command. Please make sure server and client version are the same");
            return;
        }
        if (!this.videoSrv.isControlGranted(this.clientID, this.lockTimeout)) {
            this.logger.warn("Control for " + this + " not granted");
            return;
        }
        long entityID = request.getEntityID();
        if (!this.videoSrv.handlePTZPriority(new CameraControlPriority(entityID, priority = request.getPriority().longValue(), timeout = request.getTimeout().longValue(), true))) {
            this.logger.info("Priority " + request + " for " + this + " not granted");
            return;
        }
        int errorCode = this.videoSrv.setAutoZeroLux(request.isActive());
        if (errorCode != 0) {
            this.logger.warn("Setting auto zero lux failed with error [" + errorCode + "]");
        }
    }

    private void execSetHomePosition(SrpcMessage req, RequestHandlerCallback rhc) {
        long timeout;
        long priority;
        ReqSetHomePosition request;
        try {
            request = ReqSetHomePosition.parseGObject(req.getPayload());
        }
        catch (IndexOutOfBoundsException ex) {
            this.logger.error("Exception while setting home position command. Please make sure server and client version are the same");
            return;
        }
        if (!this.videoSrv.isControlGranted(this.clientID, this.lockTimeout)) {
            this.logger.warn("Control for " + this + " not granted");
            return;
        }
        if (!this.videoSrv.isControlGranted(this.clientID, this.lockTimeout)) {
            this.logger.warn("Control for " + this + " not granted");
            return;
        }
        long entityID = request.getEntityID();
        if (!this.videoSrv.handlePTZPriority(new CameraControlPriority(entityID, priority = request.getPriority().longValue(), timeout = request.getTimeout().longValue(), true))) {
            this.logger.info("PTZ Priority for " + this + " not granted");
            return;
        }
        int errorCode = this.videoSrv.setHomePosition();
        if (errorCode != 0) {
            this.logger.warn("Navigating to home position failed with error [" + errorCode + "]");
        }
    }

    private void execStopAllControlCommands(SrpcMessage req, RequestHandlerCallback rhc) {
        int errorCode;
        try {
            errorCode = this.videoSrv.setContinuousPTZ(0, 0, 0);
            if (errorCode != 0) {
                this.logger.warn("Stopping continous ptz failed with error [" + errorCode + "] for " + this);
            }
        }
        catch (Throwable t) {
            this.logger.warn("Stopping continous ptz failed with error for " + this);
        }
        try {
            errorCode = this.videoSrv.setContinuousFocus(0);
            if (errorCode != 0) {
                this.logger.warn("Stopping continous focus failed with error [" + errorCode + "] for " + this);
            }
        }
        catch (Throwable t) {
            this.logger.warn("Stopping continous focus failed with error for " + this);
        }
        try {
            errorCode = this.videoSrv.setContinuousIris(0);
            if (errorCode != 0) {
                this.logger.warn("Stopping continous iris failed with error [" + errorCode + "] for " + this);
            }
        }
        catch (Throwable t) {
            this.logger.warn("Stopping continous iris failed with error for " + this);
        }
    }

    private void execSetPresetPosition(SrpcMessage req, RequestHandlerCallback rhc) {
        long timeout;
        long priority;
        ReqSetPresetPosition request;
        try {
            request = ReqSetPresetPosition.parseGObject(req.getPayload());
        }
        catch (IndexOutOfBoundsException ex) {
            this.logger.error("Exception while sending preset position command. Please make sure server and client version are the same");
            return;
        }
        if (!this.videoSrv.isControlGranted(this.clientID, this.lockTimeout)) {
            this.logger.warn("Control for " + this + " not granted");
            return;
        }
        long entityID = request.getEntityID();
        if (!this.videoSrv.handlePTZPriority(new CameraControlPriority(entityID, priority = request.getPriority().longValue(), timeout = request.getTimeout().longValue(), true))) {
            this.logger.info("Priority " + request + " for " + this + " not granted");
            return;
        }
        String sPresetPosition = request.getPresetName();
        int errorCode = this.videoSrv.setPresetPosition(sPresetPosition);
        if (errorCode != 0) {
            this.logger.warn("Navigation to given preset position failed with error [" + errorCode + "]");
        }
    }

    private void execGetJpegSnapshot(SrpcMessage req, RequestHandlerCallback rhc) {
        RspGetJpegSnapshot goResp;
        int errorCode = 0;
        ReqGetJpegSnapshot request = ReqGetJpegSnapshot.parseGObject(req.getPayload());
        try {
            Integer width = request.getWidth();
            Integer height = request.getHeight();
            Integer[] resolution = null;
            if (width != null || height != null) {
                resolution = new Integer[]{width, height};
            }
            ContentFrame cfSnapshot = ((LiveCameraSrv)this.videoSrv).getJpegSnapshot(resolution);
            this.logger.info("Delivering " + cfSnapshot + " for " + this);
            goResp = new RspGetJpegSnapshot(cfSnapshot);
        }
        catch (SeeTecException se) {
            goResp = new RspGetJpegSnapshot(se.getErrorCode());
        }
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)goResp.createGObject());
        rsp.setError(errorCode);
        rhc.onRequestHandled(req, rsp);
    }

    private void execOpenContentStream(SrpcMessage req, RequestHandlerCallback rhc) {
        this.version = req.getVersion();
        if (this.version[0] == 2) {
            this.logger.warn("Open content stream with SRPC Version 2");
        }
        ReqOpenContentStream request = ReqOpenContentStream.parseGObject(req.getPayload());
        int activeThreads = Thread.activeCount();
        if (activeThreads >= RECore.getThreadLimit()) {
            this.logger.error("There are now [" + activeThreads + "] threads active. " + this + "] will be discarded!");
            this.shutdown();
            return;
        }
        if (this.contentStream != null && !this.contentStream.isShutdown()) {
            this.logger.warn("Existing " + this.contentStream + " will be killed!");
        }
        if (request.getPort() == null) {
            throw new RuntimeException("Port argument not existent");
        }
        int port = request.getPort();
        this.openingMode = request.getMode();
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Opening content stream to [" + this.clientHost + ":" + port + "] with mode [" + this.openingMode + "] ...");
        }
        try {
            ContentStreamIntf contentStream = this.videoSrv.createContentStream(this.openingMode);
            contentStream.init(this.videoSrv.getCore(), this.host, port, request.getSessionID(), request.getProtocol(), request.getClientID());
            this.contentStream = contentStream;
            if (this.openingMode == 0 && this.getDatabaseReader() == null) {
                this.contentStream.shutdown();
                this.contentStream = null;
                this.logger.warn("Cannot get valid [MDBReader] for " + this);
                this.answer(req, rhc, null, -21630, false);
                return;
            }
            if (null != this.contentStream) {
                this.contentStream.setAudioTransmission(this.audioTransmission);
            }
        }
        catch (SeeTecException seeTecException) {
            this.logger.error("Problems while opening content stream for " + this, (Throwable)seeTecException);
        }
        this.answer(req, rhc, null, 0, false);
    }

    private void execSetTranscodingStreamParameter(SrpcMessage req, RequestHandlerCallback rhc) {
        this.transcodingEnabled = true;
        int errorCode = 0;
        ReqSetTranscodingStreamParameter request = ReqSetTranscodingStreamParameter.parseGObject(req.getPayload());
        this.handleSetStreamParameter(request.getJpegSpeed(), request.getMpegSpeed(), request.hasAudioTransmission(), request.getClassification());
        try {
            this.provideTranscodingManager().setTranscodingStreamParameter(new TranscodingStreamParameter(this.videoSrv.getEntityID(), request.getFramerate(), request.getVideoHeight(), request.getQuality(), request.getMediaCodec(), request.getMaxBandwidth()));
        }
        catch (SeeTecException seeTecException) {
            errorCode = seeTecException.getErrorCode();
        }
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
        rsp.setError(errorCode);
        rhc.onRequestHandled(req, rsp);
    }

    private void execSetStreamParameter(SrpcMessage req, RequestHandlerCallback rhc) {
        this.transcodingEnabled = false;
        int errorCode = 0;
        ReqSetStreamParameter request = ReqSetStreamParameter.parseGObject(req.getPayload());
        this.handleSetStreamParameter(request.getJpegSpeed(), request.getMpegSpeed(), request.hasAudioTransmission(), request.getClassification());
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
        rsp.setError(errorCode);
        rhc.onRequestHandled(req, rsp);
    }

    private void handleSetStreamParameter(Integer jpegSpeed, String mpegSpeed, Boolean audioTransmission, Integer classification) {
        boolean mustCheckFramerate = false;
        if (jpegSpeed != null) {
            if ((long)jpegSpeed.intValue() == -1L) {
                VideoProfileHandler videoProfileHandler = null;
                try {
                    videoProfileHandler = this.videoSrv.getVideoProfileHandler(this.classification);
                    this.framerate = videoProfileHandler.getVideoSourceParameter().getFramerate();
                }
                catch (Throwable ex) {
                    this.logger.warn((Object)ex, ex);
                    this.logger.warn("Cannot set JPEG speed for " + this);
                    this.logger.warn("   VideoSrv=" + this.videoSrv);
                    this.logger.warn("   VideoClassification=[" + this.classification + "]");
                    this.logger.warn("   VideoProfileHandler=" + videoProfileHandler);
                }
            } else {
                this.framerate = jpegSpeed.intValue();
            }
            if (this.liveReader != null) {
                this.liveReader.setFramerate(this.framerate);
                mustCheckFramerate = true;
            }
        }
        if (mpegSpeed != null) {
            this.mpegSpeed = mpegSpeed.trim().toLowerCase();
            if (this.liveReader != null) {
                this.liveReader.setMpegSpeed(this.mpegSpeed);
                mustCheckFramerate = true;
            }
        }
        if (audioTransmission != null) {
            this.audioTransmission = audioTransmission;
            if (this.contentStream != null) {
                this.contentStream.setAudioTransmission(this.audioTransmission);
            }
        }
        if (!Objects.equals(this.classification, classification)) {
            this.classification = classification;
            VideoProfileHandler newVideoProfileHandler = this.videoSrv.getVideoProfileHandler(this.classification);
            if (this.liveReader != null) {
                this.liveReader.setVideoProfileHandler(newVideoProfileHandler);
            }
            this.videoSrv.invalidateAssociationOfVideoProfileHandler();
        }
        if (mustCheckFramerate) {
            this.videoSrv.checkFramerate();
        }
    }

    private void execSetBandwidthLimitation(SrpcMessage req, RequestHandlerCallback rhc) {
        ReqSetBandwidthLimitation request = ReqSetBandwidthLimitation.parseGObject(req.getPayload());
        if (this.contentStream == null || this.contentStream.isShutdown()) {
            this.logger.warn("Cannot set bandwidth limitation, because " + this.contentStream + " is invalid for " + this.videoSrv);
        } else {
            this.contentStream.setBandwidthLimitation(request.getBandwidthLimitation());
        }
    }

    private void execStartLiveStreaming(SrpcMessage req, RequestHandlerCallback rhc) {
        ReqStartLiveStreaming request;
        int transactionID;
        LiveReader liveReader;
        int errorCode;
        if (this.openingMode != 1) {
            this.logger.warn("Opening mode [" + this.openingMode + "] not valid for live streaming");
            int errorCode2 = -21632;
            this.answer(req, rhc, null, errorCode2, true);
            return;
        }
        if (this.contentStream == null || this.contentStream.isShutdown()) {
            this.logger.warn("Error [" + Basic.longToFormattedString((long)-21681L) + "], no valid content stream for " + this + " available");
            int errorCode3 = -21681;
            this.answer(req, rhc, null, errorCode3, true);
            return;
        }
        if (this.liveReader != null && !this.liveReader.isShutdown()) {
            this.logger.warn((Object)((Object)this.liveReader) + " already exists and will be killed");
            this.liveReader.shutdown();
            this.liveReader = null;
        }
        VideoProfileHandler videoProfileHandler = this.videoSrv.getVideoProfileHandler(this.classification);
        long jpegSpeed = this.framerate;
        try {
            try {
                this.liveResolution = videoProfileHandler.getVideoSourceParameter().getImageSize();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (jpegSpeed < 0L) {
                jpegSpeed = videoProfileHandler.getVideoSourceParameter().getFramerate();
                if (this.logger.isDebugEnabled()) {
                    this.logger.info("Using default JpegSpeed [" + Basic.longToFormattedString((long)jpegSpeed) + "] for " + this.videoSrv);
                }
            }
        }
        catch (ConfigurationException cex) {
            this.logger.warn("Problems with configuration of " + videoProfileHandler + ": " + cex.getMessage());
        }
        if (this.liveReader != null) {
            this.logger.warn((Object)((Object)this.liveReader) + " already created, so discarding it ...");
            try {
                this.videoSrv.removeLiveReader(this.liveReader);
                this.liveReader.shutdown();
                this.liveReader = null;
            }
            catch (Throwable ex) {
                this.logger.warn((Object)ex, ex);
            }
        }
        if ((errorCode = (liveReader = new LiveReader()).init(this.contentStream, jpegSpeed, this.mpegSpeed, videoProfileHandler, (short)(transactionID = (request = ReqStartLiveStreaming.parseGObject(req.getPayload())).getTransactionId().intValue()))) != 0) {
            this.logger.warn("Creating " + (Object)((Object)liveReader) + " failed with error [" + errorCode + "] for " + this.videoSrv);
            liveReader.shutdown();
            this.answer(req, rhc, null, errorCode, true);
            return;
        }
        this.liveReader = liveReader;
        errorCode = this.videoSrv.addLiveReader(this.liveReader);
        if (errorCode != 0) {
            this.logger.warn("Starting live stream failed with error [" + errorCode + "] for " + this.videoSrv);
        }
        this.liveReader.activateLoggingOfCameraLiveUsage(this.videoSrv, this.userID, this.userName);
        if (this.srpcConnector != null) {
            this.answer(req, rhc, null, errorCode, true);
        }
    }

    private void execStopStreaming(SrpcMessage req, RequestHandlerCallback rhc) {
        int errorCode = 0;
        if (this.liveReader != null && (errorCode = this.videoSrv.removeLiveReader(this.liveReader)) != 0) {
            this.logger.warn("Stopping live stream failed with error [" + errorCode + "] for " + this.videoSrv);
        }
        if (this.liveReader != null && (errorCode = this.liveReader.shutdown()) != 0) {
            this.logger.warn("Shutting down live stream failed with error [" + errorCode + "] for " + this.videoSrv);
        }
        this.liveReader = null;
        if (this.contentStream != null && !this.contentStream.isShutdown()) {
            this.contentStream.notifyForStoppedStreaming();
        }
        if (this.srpcConnector != null && !this.srpcConnector.isShutdown()) {
            SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
            rsp.setError(errorCode);
            rhc.onRequestHandled(req, rsp);
        }
    }

    private void execReadNextFrame(SrpcMessage req, RequestHandlerCallback rhc) {
        int errorCode = 0;
        ReqReadNextFrame request = (ReqReadNextFrame)ReqReadNextFrame.parseGObject((GObject)req.getPayload());
        short transactionID = request.getTransactionId().shortValue();
        ContentFrame contentFrameFound = null;
        ContentFrame contentFrameToSend = null;
        Integer mediatype = request.getMediatype();
        Integer track = request.getTrack();
        Long timestamp = request.getTimestamp();
        if (mediatype == null || mediatype < 0) {
            mediatype = 240;
            if (this.lastArchiveFrame != null && !this.lastArchiveFrame.isVideoFrame()) {
                this.lastArchiveFrame = null;
            }
        }
        if (this.lastArchiveFrame != null && this.lastArchiveFrame.isPacked() && timestamp != null && this.lastArchiveFrame.getStartTimestamp() <= timestamp && this.lastArchiveFrame.getEndTimestamp() >= timestamp) {
            contentFrameFound = this.lastArchiveFrame;
        }
        if (contentFrameFound == null) {
            Vector<ContentFrame> vContentFrame = new Vector<ContentFrame>();
            errorCode = this.getDatabaseReader().readNextFrame(mediatype, track, timestamp, Integer.valueOf(transactionID), vContentFrame);
            if (errorCode != 0) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
                rsp.setError(errorCode);
                rhc.onRequestHandled(req, rsp);
                return;
            }
            contentFrameFound = this.lastArchiveFrame = vContentFrame.get(2);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Using" + contentFrameFound + " ...");
        }
        contentFrameToSend = contentFrameFound.isPacked() ? contentFrameFound.getNextUnpackedContentFrame(timestamp.longValue()) : contentFrameFound;
        if (this.transcodingEnabled) {
            try {
                contentFrameToSend = this.provideTranscodingManager().transcodeFrame(contentFrameToSend);
            }
            catch (SeeTecException ex) {
                contentFrameToSend = null;
                errorCode = ex.getErrorCode();
            }
        }
        if (contentFrameToSend != null) {
            this.sendContentFrame(true, new ContentFrame[]{contentFrameToSend}, true, transactionID, 0xC00000L);
        }
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
        rsp.setError(errorCode);
        rhc.onRequestHandled(req, rsp);
    }

    private void execReadMultipleFrames(SrpcMessage req, RequestHandlerCallback rhc) {
        int errorCode = 0;
        ReqReadMultipleFrames request = (ReqReadMultipleFrames)ReqReadMultipleFrames.parseGObject((GObject)req.getPayload());
        short transactionID = request.getTransactionId().shortValue();
        long tsStart = System.currentTimeMillis();
        this.logger.info("Executing request " + request);
        this.openingMode = 0;
        try {
            if (this.contentStream == null || this.contentStream.isShutdown()) {
                this.logger.warn("Error [" + Basic.longToFormattedString((long)-21681L) + "], no valid content stream for " + this + " available");
                errorCode = -21681;
                this.answer(req, rhc, null, errorCode, true);
                return;
            }
            this.flushRecordingQueue(request.getFrom());
            ContentFrame[] contentFrames = this.getDatabaseReader().readMultipleFrames(request);
            try {
                contentFrames = this.transcodeFrames(contentFrames, this.transcodingEnabled);
            }
            catch (SeeTecException ex) {
                contentFrames = null;
                errorCode = ex.getErrorCode();
            }
            boolean isForwardPlay = request.getTill() - request.getFrom() > 0L;
            boolean containsLastFrame = this.checkIfEndIsReached(contentFrames, request.getTill(), request.getMilliFps(), isForwardPlay);
            contentFrames = this.addLastFramePseudoFrameIfNeeded(contentFrames, request.getTill(), request.getMilliFps(), isForwardPlay);
            this.sendArchiveContentFrames(transactionID, contentFrames, request.getFrom(), request.getTill(), containsLastFrame);
            SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
            rsp.setError(errorCode);
            rhc.onRequestHandled(req, rsp);
            if (contentFrames != null && contentFrames.length > 0) {
                long duration = System.currentTimeMillis() - tsStart;
                this.logger.info("   [" + contentFrames.length + "] frames delivered within [" + duration + " ms]");
            }
        }
        catch (SeeTecException ex) {
            this.logger.warn("Reading multiples frames failed with error [" + ex.getErrorCode() + "]", (Throwable)ex);
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
            rsp.setError(errorCode);
            rhc.onRequestHandled(req, rsp);
        }
    }

    private void execReadGOP(SrpcMessage req, RequestHandlerCallback rhc) {
        int errorCode;
        block9: {
            errorCode = 0;
            ReqReadGOP request = (ReqReadGOP)ReqReadGOP.parseGObject((GObject)req.getPayload());
            short transactionID = request.getTransactionId().shortValue();
            this.openingMode = 0;
            try {
                boolean containsLastFrame;
                if (this.contentStream == null || this.contentStream.isShutdown()) {
                    this.logger.warn("Error [" + Basic.longToFormattedString((long)-21681L) + "], no valid content stream available for " + this);
                    errorCode = -21681;
                    break block9;
                }
                this.flushRecordingQueue(request.getTimestamp());
                ReqReadMultipleFrames rmfAsReadGOP = new ReqReadMultipleFrames(null, Integer.valueOf(-1), request.getTimestamp(), Long.valueOf(request.getTimestamp() << 1), Long.valueOf(0x400000L), request.getTransactionId(), Long.valueOf(-1L), Long.valueOf(-1L));
                ContentFrame[] contentFrames = this.getDatabaseReader().readGOP(rmfAsReadGOP);
                try {
                    contentFrames = this.transcodeFrames(contentFrames, this.transcodingEnabled);
                }
                catch (SeeTecException ex) {
                    contentFrames = null;
                    errorCode = ex.getErrorCode();
                }
                boolean bl = containsLastFrame = contentFrames == null;
                if (this.logger.isDebugEnabled() && contentFrames != null) {
                    this.logger.info("ReadGOP [" + Core.getUniformFormattedDateTime((long)request.getTimestamp()) + "] for " + this.getContentName());
                    for (ContentFrame contentFrame : contentFrames) {
                        this.logger.info((Object)contentFrame);
                    }
                }
                this.sendArchiveContentFrames(transactionID, contentFrames, request.getTimestamp(), request.getTimestamp(), containsLastFrame);
            }
            catch (SeeTecException ex) {
                this.logger.warn("Reading GOP (multiple frames) failed with error [" + ex.getErrorCode() + "]", (Throwable)ex);
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
        rsp.setError(errorCode);
        rhc.onRequestHandled(req, rsp);
    }

    private void flushRecordingQueue(Long requestTimestamp) {
        try {
            this.videoSrv.getRecordingHandler().getDatabaseWriter().flushRecordingQueue(requestTimestamp);
        }
        catch (Throwable throwable) {
            this.logger.warn("Error flushing recording queue [" + throwable.getMessage() + "] for " + this);
        }
    }

    private ContentFrame[] transcodeFrames(ContentFrame[] contentFrames, boolean transcodingEnabled) throws SeeTecException {
        if (transcodingEnabled && contentFrames != null) {
            contentFrames = this.provideTranscodingManager().transcodeFrames(contentFrames);
        }
        return contentFrames;
    }

    private void execReadPreviousFrame(SrpcMessage req, RequestHandlerCallback rhc) {
        ReqReadPreviousFrame request = (ReqReadPreviousFrame)ReqReadPreviousFrame.parseGObject((GObject)req.getPayload());
        short transactionID = request.getTransactionId().shortValue();
        Vector<ContentFrame> vContentFrame = new Vector<ContentFrame>();
        Integer mediatype = request.getMediatype();
        Integer track = request.getTrack();
        Long timestamp = request.getTimestamp();
        int errorCode = mediatype == null ? this.readPreviousFrame(track, timestamp, Integer.valueOf(transactionID), vContentFrame) : this.getDatabaseReader().readPreviousFrame(mediatype, track, timestamp, Integer.valueOf(transactionID), vContentFrame);
        if (errorCode != 0) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
            rsp.setError(errorCode);
            rhc.onRequestHandled(req, rsp);
            return;
        }
        ContentFrame contentFrame = vContentFrame.elementAt(0);
        if (this.transcodingEnabled) {
            try {
                contentFrame = this.provideTranscodingManager().transcodeFrame(contentFrame);
            }
            catch (SeeTecException ex) {
                contentFrame = null;
                errorCode = ex.getErrorCode();
            }
        }
        if (contentFrame != null) {
            this.sendContentFrame(true, new ContentFrame[]{contentFrame}, true, transactionID, 0xC00000L);
        }
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
        rsp.setError(errorCode);
        rhc.onRequestHandled(req, rsp);
    }

    private int readPreviousFrame(Integer track, Long timestamp, Integer transactionId, Vector<ContentFrame> contentFrameVector) {
        long ts = timestamp;
        if (ts <= 0L) {
            this.logger.error("Timestamp [" + ts + "] not valid for search [ReadPreviousFrame] of " + this);
            return -21611;
        }
        for (int i = 0; i < 25; ++i) {
            if (this.logger.isDebugEnabled()) {
                this.logger.info("Reading previous frame for [" + Basic.longToFormattedString((long)ts) + "]/[" + new Date(ts) + "] ...");
            }
            ArrayList<ContentFrame> frame = new ArrayList<ContentFrame>();
            DatabaseReaderImpl reader = this.getDatabaseReader();
            int errorCode = reader.readPreviousFrame(null, track, ts, transactionId, frame);
            if (errorCode != 0) {
                return errorCode;
            }
            if (frame.size() <= 2) continue;
            ContentFrame contentFrame = (ContentFrame)frame.get(2);
            if (contentFrame.getMediatype() == 0 || contentFrame.getMediatype() == 33) {
                contentFrameVector.addElement(contentFrame);
                return 0;
            }
            ts = contentFrame.getStartTimestamp();
        }
        this.logger.warn("No useful ContentFrame found for " + this);
        return -21686;
    }

    private void execAddPresetPosition(SrpcMessage req, RequestHandlerCallback rhc) {
        Vector<byte[]> vResult = new Vector<byte[]>();
        ReqAddPresetPosition request = ReqAddPresetPosition.parseGObject(req.getPayload());
        int errorCode = this.videoSrv.addPresetPosition(vResult, request.getPresetID(), request.getPresetName());
        if (errorCode != 0) {
            this.logger.warn(request + " failed with error [" + errorCode + "] for " + this.videoSrv);
        }
        byte[] preset = null;
        if (vResult.size() > 0) {
            preset = vResult.get(0);
        }
        RspAddPresetPosition rspAddPresetPosition = new RspAddPresetPosition(preset);
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)rspAddPresetPosition.createGObject());
        rsp.setError(errorCode);
        rhc.onRequestHandled(req, rsp);
    }

    private void execRemovePresetPosition(SrpcMessage req, RequestHandlerCallback rhc) {
        ReqRemovePresetPosition request = ReqRemovePresetPosition.parseGObject(req.getPayload());
        int errorCode = this.videoSrv.removePresetPosition(request.getPresetName());
        if (errorCode != 0) {
            this.logger.warn(request + " failed with error [" + errorCode + "] for " + this.videoSrv);
        }
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
        rsp.setError(errorCode);
        rhc.onRequestHandled(req, rsp);
    }

    private void execAddCameraPresets(SrpcMessage req, RequestHandlerCallback rhc) {
        ReqCameraPresets presetsReq = (ReqCameraPresets)ReqCameraPresets.parseGObject(req.getPayload());
        int result = this.videoSrv.addCameraPresets(presetsReq.getPresets());
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
        rsp.setError(result);
        rhc.onRequestHandled(req, rsp);
    }

    private void execGetCameraPresets(SrpcMessage req, RequestHandlerCallback rhc) {
        ArrayOfCameraPreset presets = this.videoSrv.getCameraPresetsList();
        if (presets == null) {
            presets = new ArrayOfCameraPreset();
        }
        ReqCameraPresets presetsReq = new ReqCameraPresets(presets);
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)presetsReq.createGObject());
        rsp.setError(0);
        rhc.onRequestHandled(req, rsp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execGetAlarmTimerange(SrpcMessage req, RequestHandlerCallback rhc) {
        int errorCode = 0;
        ReqGetAlarmTimerange request = (ReqGetAlarmTimerange)ReqGetAlarmTimerange.parseGObject((GObject)req.getPayload());
        DatabaseProxy[] mdsProxies = null;
        try {
            SrpcMessage rsp;
            RspGetAlarmTimerange response;
            mdsProxies = this.videoSrv.getCore().createDatabaseProxies(null);
            SrpcMessage subreq = SrpcMessage.createRequest((Methods)Methods.RE_SRPC_REQ_GETALARMTIMERANGE, (GObject)request.createGObject());
            SrpcMessage subrsp = mdsProxies[0].sendGenericRequest(subreq, 30000L);
            GObject goResponse = subrsp.getPayload();
            RspGetAlarmTimerange rspGetAlarmTimerange = RspGetAlarmTimerange.parseGObject((GObject)goResponse);
            RspGetAlarmTimerange rspGetAlarmTimerangeFailover = null;
            GObject goResponseFailover = null;
            if (mdsProxies[1] != null) {
                SrpcMessage subrspFailover = mdsProxies[1].sendGenericRequest(subreq, 30000L);
                goResponseFailover = subrspFailover.getPayload();
            }
            if (goResponseFailover != null) {
                rspGetAlarmTimerangeFailover = RspGetAlarmTimerange.parseGObject(goResponseFailover);
            }
            if ((response = this.checkAlarmInstanceResponse(rspGetAlarmTimerange, rspGetAlarmTimerangeFailover)) == null) {
                errorCode = -21600;
                rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
            } else {
                rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)response.createGObject());
            }
            rsp.setError(errorCode);
            rhc.onRequestHandled(req, rsp);
            this.shutdownMDSProxies(mdsProxies);
        }
        catch (Throwable ex) {
            try {
                this.logger.error((Object)ex, ex);
                errorCode = -21600;
                SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
                rsp.setError(errorCode);
                rhc.onRequestHandled(req, rsp);
                this.shutdownMDSProxies(mdsProxies);
            }
            catch (Throwable throwable) {
                this.shutdownMDSProxies(mdsProxies);
                throw throwable;
            }
        }
    }

    public RspGetAlarmTimerange checkAlarmInstanceResponse(RspGetAlarmTimerange rspGetAlarmTimerange, RspGetAlarmTimerange rspGetAlarmTimerangeFailover) {
        Object response = rspGetAlarmTimerange == null && rspGetAlarmTimerangeFailover != null ? rspGetAlarmTimerangeFailover : (rspGetAlarmTimerange != null && rspGetAlarmTimerangeFailover == null ? rspGetAlarmTimerange : (rspGetAlarmTimerange != null && rspGetAlarmTimerangeFailover != null ? (rspGetAlarmTimerange.getStartTimestamp() == -1L ? new RspGetAlarmTimerange(rspGetAlarmTimerangeFailover.getStartTimestamp(), Long.valueOf(Math.max(rspGetAlarmTimerange.getEndTimestamp(), rspGetAlarmTimerangeFailover.getEndTimestamp()))) : (rspGetAlarmTimerangeFailover.getStartTimestamp() == -1L ? new RspGetAlarmTimerange(rspGetAlarmTimerange.getStartTimestamp(), Long.valueOf(Math.max(rspGetAlarmTimerange.getEndTimestamp(), rspGetAlarmTimerangeFailover.getEndTimestamp()))) : new RspGetAlarmTimerange(Long.valueOf(Math.min(rspGetAlarmTimerange.getStartTimestamp(), rspGetAlarmTimerangeFailover.getStartTimestamp())), Long.valueOf(Math.max(rspGetAlarmTimerange.getEndTimestamp(), rspGetAlarmTimerangeFailover.getEndTimestamp()))))) : null));
        return response;
    }

    private void execGetRecordingInfos(SrpcMessage req, RequestHandlerCallback rhc) {
        long time = System.currentTimeMillis();
        int errorCode = 0;
        ReqGetRecordingInfos request = (ReqGetRecordingInfos)ReqGetRecordingInfos.parseGObject((GObject)req.getPayload());
        TimeRangeInfoContainer localRecordingInfoContainer = this.videoSrv.getRecordingInfos(request, true, true);
        if (localRecordingInfoContainer != null) {
            long startTimestamp = localRecordingInfoContainer.getStartTimestamp();
            TimeRangeList recordingInfoList = localRecordingInfoContainer.getTimeRangeInfo();
            long failoverCounter = 0L;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            for (TimeRangeInfo recordingInfo : recordingInfoList) {
                try {
                    byteArrayOutputStream.write(recordingInfo.serialize());
                    if (!recordingInfo.isFailover()) continue;
                    ++failoverCounter;
                }
                catch (IOException exception) {
                    this.logger.error("Could not add recording info " + recordingInfo + " to list for " + this);
                }
            }
            byte[] recordingInfosByteArray = byteArrayOutputStream.toByteArray();
            GObject goResp = new RspGetRecordingInfos(Long.valueOf(startTimestamp), recordingInfosByteArray).createGObject();
            if (recordingInfoList.size() > 0) {
                TimeRangeInfo firstTimeRangeInfo = (TimeRangeInfo)recordingInfoList.get(0);
                Date firstDate = new Date(startTimestamp + firstTimeRangeInfo.getTimestamp());
                TimeRangeInfo lastTimeRangeInfo = (TimeRangeInfo)recordingInfoList.get(recordingInfoList.size() - 1);
                Date lastDate = new Date(startTimestamp + lastTimeRangeInfo.getTimestamp() + (long)lastTimeRangeInfo.getLength());
                if (this.logger.isDebugEnabled()) {
                    this.logger.info("... delivering [" + recordingInfoList.size() + "] RecordingInfos (FailoverSets: " + failoverCounter + " | From: " + firstDate + " | To: " + lastDate + ") in " + (System.currentTimeMillis() - time) + " ms] for " + this.videoSrv);
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.info("... no RecordingInfos to deliver for " + this.videoSrv);
            }
            SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)goResp);
            rsp.setCompression((byte)1);
            rsp.setError(errorCode);
            rhc.onRequestHandled(req, rsp);
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.error("No Recording Infos available for " + this);
            }
            errorCode = -21600;
            SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
            rsp.setCompression((byte)1);
            rsp.setError(errorCode);
            rhc.onRequestHandled(req, rsp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execMarkAsAlarmRecording(SrpcMessage req, RequestHandlerCallback rhc) {
        ReqMarkAsAlarmRecording request = (ReqMarkAsAlarmRecording)ReqMarkAsAlarmRecording.parseGObject((GObject)req.getPayload());
        request.setContentID(Long.valueOf(this.getContentID()));
        DatabaseProxy[] mdsProxies = null;
        try {
            mdsProxies = this.videoSrv.getCore().createDatabaseProxies(null);
            TimeRangeList list = this.videoSrv.getRecordingInfos().getTimeRangeInfo().getTimeRangeInfoForTimerange(request.getStartTimestamp(), request.getEndTimestamp(), -1);
            if (list.size() > 0) {
                boolean containsFailoverRecordings = list.containsFailoverData();
                boolean containsDefaultRecordings = list.containsDefaultData();
                SrpcMessage subreq = SrpcMessage.createRequest((Methods)Methods.RE_SRPC_REQ_MARKASALARMRECORDING, (GObject)request.createGObject());
                RspMarkAsAlarmRecording rspMarkAsAlarmRecording = null;
                if (containsDefaultRecordings) {
                    SrpcMessage subrsp = mdsProxies[0].sendGenericRequest(subreq, 30000L);
                    GObject goResponse = subrsp.getPayload();
                    rspMarkAsAlarmRecording = RspMarkAsAlarmRecording.parseGObject((GObject)goResponse);
                }
                RspMarkAsAlarmRecording rspMarkAsAlarmRecordingFailover = null;
                if (containsFailoverRecordings) {
                    GObject goResponseFailover = null;
                    if (mdsProxies[1] != null) {
                        SrpcMessage subrspFailover = mdsProxies[1].sendGenericRequest(subreq, 30000L);
                        goResponseFailover = subrspFailover.getPayload();
                    }
                    if (goResponseFailover != null) {
                        rspMarkAsAlarmRecordingFailover = RspMarkAsAlarmRecording.parseGObject(goResponseFailover);
                    }
                }
                if (rspMarkAsAlarmRecording == null && rspMarkAsAlarmRecordingFailover != null) {
                    SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)rspMarkAsAlarmRecordingFailover.createGObject());
                    rsp.setError(rspMarkAsAlarmRecordingFailover.getResultCode().intValue());
                    rhc.onRequestHandled(req, rsp);
                } else if (rspMarkAsAlarmRecording != null && rspMarkAsAlarmRecordingFailover == null) {
                    SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)rspMarkAsAlarmRecording.createGObject());
                    rsp.setError(rspMarkAsAlarmRecording.getResultCode().intValue());
                    rhc.onRequestHandled(req, rsp);
                } else if (rspMarkAsAlarmRecording == null && rspMarkAsAlarmRecordingFailover == null) {
                    SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
                    rsp.setError(0);
                    rhc.onRequestHandled(req, rsp);
                } else if (rspMarkAsAlarmRecording != null && rspMarkAsAlarmRecordingFailover != null) {
                    int resultCode = 0;
                    if (rspMarkAsAlarmRecording.getResultCode() != 0) {
                        resultCode = rspMarkAsAlarmRecording.getResultCode();
                    } else if (rspMarkAsAlarmRecordingFailover.getResultCode() != 0) {
                        resultCode = rspMarkAsAlarmRecordingFailover.getResultCode();
                    }
                    rspMarkAsAlarmRecording = new RspMarkAsAlarmRecording(Integer.valueOf(resultCode), rspMarkAsAlarmRecording.getAlarmInstanceID(), Long.valueOf(Math.min(rspMarkAsAlarmRecording.getStartTimestamp(), rspMarkAsAlarmRecordingFailover.getStartTimestamp())), Long.valueOf(Math.max(rspMarkAsAlarmRecording.getEndTimestamp(), rspMarkAsAlarmRecordingFailover.getEndTimestamp())));
                    SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)rspMarkAsAlarmRecording.createGObject());
                    rsp.setError(rspMarkAsAlarmRecording.getResultCode().intValue());
                    rhc.onRequestHandled(req, rsp);
                }
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.warn("No recordings found for " + request + " of " + this.videoSrv);
                }
                SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)new RspSetWriteProtection(Integer.valueOf(-21001), Long.valueOf(-1L), Long.valueOf(-1L)).createGObject());
                rsp.setError(-21001);
                rhc.onRequestHandled(req, rsp);
            }
            this.shutdownMDSProxies(mdsProxies);
        }
        catch (Throwable ex) {
            try {
                this.logger.error((Object)ex, ex);
                int errorCode = -21600;
                SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
                rsp.setError(errorCode);
                rhc.onRequestHandled(req, rsp);
                this.shutdownMDSProxies(mdsProxies);
            }
            catch (Throwable throwable) {
                this.shutdownMDSProxies(mdsProxies);
                throw throwable;
            }
        }
    }

    private void execStartAlarmRecording(SrpcMessage req, RequestHandlerCallback rhc) {
        int errorCode = 0;
        ReqStartAlarmRecording request = ReqStartAlarmRecording.parseGObject(req.getPayload());
        RspStartAlarmRecording gorsp = this.videoSrv.getRecordingHandler().startAlarmRecording(request);
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)gorsp.createGObject());
        rsp.setError(errorCode);
        rhc.onRequestHandled(req, rsp);
    }

    private void execGetAlarmInstance(SrpcMessage req, RequestHandlerCallback rhc) {
        int errorCode = 0;
        ReqGetAlarmInstance request = (ReqGetAlarmInstance)ReqGetAlarmInstance.parseGObject((GObject)req.getPayload());
        RspGetAlarmInstance gorsp = this.videoSrv.getCore().getAlarmProcessor().createRspGetAlarmInstance(this.videoSrv.getContentID(), request.getAlarmInstanceID());
        if (gorsp.getResultCode() != 0) {
            gorsp = this.getAlarmInstanceFromFailover(this.videoSrv.getContentID(), request.getAlarmInstanceID());
        }
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)gorsp.createGObject());
        rsp.setError(errorCode);
        rhc.onRequestHandled(req, rsp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RspGetAlarmInstance getAlarmInstanceFromFailover(long contentID, long alarmInstanceID) {
        RspGetAlarmInstance response = null;
        DatabaseProxy myFailover = null;
        DatabaseProxy[] mdsProxies = this.videoSrv.getCore().createDatabaseProxies(null);
        if (mdsProxies.length > 1 && mdsProxies[1] != null) {
            myFailover = mdsProxies[1];
        }
        try {
            if (null != myFailover) {
                response = this.getAlarmInstanceFromProxy(myFailover, contentID, alarmInstanceID);
            }
        }
        finally {
            this.shutdownMDSProxies(mdsProxies);
        }
        return response;
    }

    private RspGetAlarmInstance getAlarmInstanceFromProxy(DatabaseProxy mds, long contentID, long alarmInstanceID) {
        ArrayList<Long[]> vResult = new ArrayList<Long[]>();
        int errorCode = mds.getAlarmInstance(contentID, alarmInstanceID, vResult);
        Long[] alarmInstance = (Long[])vResult.get(0);
        long tsAlarmStart = alarmInstance[0];
        long tsAlarmEnd = alarmInstance[1];
        return new RspGetAlarmInstance(Integer.valueOf(errorCode), Long.valueOf(tsAlarmStart), Long.valueOf(tsAlarmEnd));
    }

    private void execGetAlarmInstances(SrpcMessage req, RequestHandlerCallback rhc) {
        int errorCode = 0;
        ReqGetAlarmInstances request = (ReqGetAlarmInstances)ReqGetAlarmInstances.parseGObject((GObject)req.getPayload());
        RspGetAlarmInstances gorsp = this.videoSrv.getCore().getAlarmProcessor().createRspGetAlarmInstances(this.videoSrv.getContentID(), request.getStartTimestamp(), request.getEndTimestamp());
        if (this.isShutdown()) {
            this.logger.info("Cannot deliver " + gorsp + ", because " + this + " is already shutting down");
            return;
        }
        RspGetAlarmInstances subGoRsp = this.getAlarmInstancesFromFailover(this.videoSrv.getContentID(), request.getStartTimestamp(), request.getEndTimestamp());
        if (subGoRsp.getResultCode() == 0) {
            gorsp.getAlarmInstances().addAll(subGoRsp.getAlarmInstances());
        }
        GObject responseObj = null;
        try {
            responseObj = gorsp.createGObject();
        }
        catch (IOException ex) {
            this.logger.error((Object)ex, (Throwable)ex);
        }
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)responseObj);
        rsp.setError(errorCode);
        rsp.setCompression((byte)1);
        rhc.onRequestHandled(req, rsp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RspGetAlarmInstances getAlarmInstancesFromFailover(long contentID, long tsStart, long tsEnd) {
        RspGetAlarmInstances result = new RspGetAlarmInstances(Integer.valueOf(-1), Collections.emptyList());
        DatabaseProxy[] mdsProxies = this.videoSrv.getCore().createDatabaseProxies(null);
        try {
            if (mdsProxies.length > 1 && mdsProxies[1] != null) {
                result = this.getAlarmInstancesFromProxy(mdsProxies[1], contentID, tsStart, tsEnd);
            }
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
        }
        finally {
            this.shutdownMDSProxies(mdsProxies);
        }
        return result;
    }

    private RspGetAlarmInstances getAlarmInstancesFromProxy(DatabaseProxy mds, long contentID, long tsStart, long tsEnd) {
        LinkedList<List<Long[]>> outResult = new LinkedList<List<Long[]>>();
        int errorCode = mds.getAlarmInstances(contentID, tsStart, tsEnd, outResult);
        RspGetAlarmInstances result = errorCode != 0 ? new RspGetAlarmInstances(Integer.valueOf(errorCode), Collections.emptyList()) : new RspGetAlarmInstances(Integer.valueOf(errorCode), (List)outResult.get(0));
        return result;
    }

    private void execGetAlarmScenarioOccurrencies(SrpcMessage req, RequestHandlerCallback rhc) {
        int errorCode = 0;
        ReqGetAlarmScenarioOccurrencies request = (ReqGetAlarmScenarioOccurrencies)ReqGetAlarmScenarioOccurrencies.parseGObject((GObject)req.getPayload());
        DatabaseProxy[] mdsProxies = this.videoSrv.getCore().createDatabaseProxies(null);
        RspGetAlarmScenarioOccurrencies gorsp = this.videoSrv.getCore().getAlarmProcessor().createRspGetAlarmScenarioOccurrencies(mdsProxies, this.videoSrv.getContentID(), request.getStartTimestamp(), request.getEndTimestamp());
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)gorsp.createGObject());
        rsp.setError(errorCode);
        rhc.onRequestHandled(req, rsp);
        this.shutdownMDSProxies(mdsProxies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execGetWriteProtections(SrpcMessage req, RequestHandlerCallback rhc) {
        ReqGetWriteProtections request = (ReqGetWriteProtections)ReqGetWriteProtections.parseGObject((GObject)req.getPayload());
        DatabaseProxy[] mdsProxies = null;
        request.setContentID(Long.valueOf(this.getContentID()));
        try {
            mdsProxies = this.videoSrv.getCore().createDatabaseProxies(null);
            SrpcMessage subreq = SrpcMessage.createRequest((Methods)Methods.RE_SRPC_REQ_GETWRITEPROTECTIONS, (GObject)request.createGObject());
            SrpcMessage subrsp = mdsProxies[0].sendGenericRequest(subreq, 30000L);
            GObject goResponse = subrsp.getPayload();
            GObject goResponseFailover = null;
            if (mdsProxies[1] != null) {
                SrpcMessage subrspFailover = mdsProxies[1].sendGenericRequest(subreq, 30000L);
                goResponseFailover = subrspFailover.getPayload();
            }
            RspGetWriteProtections rspGetWriteProtections = RspGetWriteProtections.parseGObject((GObject)goResponse);
            RspGetWriteProtections rspWriteprotectionsFailover = null;
            if (goResponseFailover != null) {
                rspWriteprotectionsFailover = RspGetWriteProtections.parseGObject(goResponseFailover);
            }
            if (rspWriteprotectionsFailover != null) {
                int resultCode = 0;
                if (rspGetWriteProtections.getResultCode() != 0) {
                    resultCode = rspGetWriteProtections.getResultCode();
                } else if (rspWriteprotectionsFailover.getResultCode() != 0) {
                    resultCode = rspWriteprotectionsFailover.getResultCode();
                }
                LinkedList writeProtections = rspGetWriteProtections.getWriteProtections();
                TimeRangeList timeRangeList = new TimeRangeList();
                for (Long[] values : writeProtections) {
                    timeRangeList.add(new TimeRangeInfo(values[0], (int)(values[1] - values[0]), -1, false));
                }
                LinkedList writeProtectionsFailover = rspWriteprotectionsFailover.getWriteProtections();
                for (Long[] values : writeProtectionsFailover) {
                    timeRangeList.add(new TimeRangeInfo(values[0], (int)(values[1] - values[0]), -1, true));
                }
                Collections.sort(timeRangeList);
                rspGetWriteProtections = new RspGetWriteProtections(Integer.valueOf(resultCode), timeRangeList.getLinkedListWithoutFailover());
            }
            SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)rspGetWriteProtections.createGObject());
            rsp.setError(rspGetWriteProtections.getResultCode().intValue());
            rhc.onRequestHandled(req, rsp);
            this.shutdownMDSProxies(mdsProxies);
        }
        catch (Throwable ex) {
            try {
                this.logger.error((Object)ex, ex);
                int errorCode = -21600;
                SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
                rsp.setError(errorCode);
                rhc.onRequestHandled(req, rsp);
                this.shutdownMDSProxies(mdsProxies);
            }
            catch (Throwable throwable) {
                this.shutdownMDSProxies(mdsProxies);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execSetWriteProtection(SrpcMessage req, RequestHandlerCallback rhc) {
        ReqSetWriteProtection request = (ReqSetWriteProtection)ReqSetWriteProtection.parseGObject((GObject)req.getPayload());
        DatabaseProxy[] mdsProxies = null;
        request.setContentID(Long.valueOf(this.getContentID()));
        try {
            mdsProxies = this.videoSrv.getCore().createDatabaseProxies(null);
            TimeRangeList list = this.videoSrv.getRecordingInfos().getTimeRangeInfo().getTimeRangeInfoForTimerange(request.getStart(), request.getEnd(), -1);
            if (list.size() > 0) {
                boolean containsFailoverRecordings = list.containsFailoverData();
                boolean containsDefaultRecordings = list.containsDefaultData();
                SrpcMessage subreq = SrpcMessage.createRequest((Methods)Methods.RE_SRPC_REQ_SETWRITEPROTECTION, (GObject)request.createGObject());
                RspSetWriteProtection rspSetWriteProtection = null;
                if (containsDefaultRecordings) {
                    SrpcMessage subrsp = mdsProxies[0].sendGenericRequest(subreq, 30000L);
                    GObject goResponse = subrsp.getPayload();
                    rspSetWriteProtection = RspSetWriteProtection.parseGObject((GObject)goResponse);
                }
                RspSetWriteProtection rspSetWriteProtectionFailover = null;
                if (containsFailoverRecordings) {
                    GObject goResponseFailover = null;
                    if (mdsProxies[1] != null) {
                        SrpcMessage subrspFailover = mdsProxies[1].sendGenericRequest(subreq, 30000L);
                        goResponseFailover = subrspFailover.getPayload();
                    }
                    if (goResponseFailover != null) {
                        rspSetWriteProtectionFailover = RspSetWriteProtection.parseGObject(goResponseFailover);
                    }
                }
                if (rspSetWriteProtection == null && rspSetWriteProtectionFailover != null) {
                    SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)rspSetWriteProtectionFailover.createGObject());
                    rsp.setError(rspSetWriteProtectionFailover.getResultCode().intValue());
                    rhc.onRequestHandled(req, rsp);
                } else if (rspSetWriteProtection != null && rspSetWriteProtectionFailover == null) {
                    SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)rspSetWriteProtection.createGObject());
                    rsp.setError(rspSetWriteProtection.getResultCode().intValue());
                    rhc.onRequestHandled(req, rsp);
                } else if (rspSetWriteProtection == null && rspSetWriteProtectionFailover == null) {
                    SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)new RspSetWriteProtection(Integer.valueOf(-23225), Long.valueOf(-1L), Long.valueOf(-1L)).createGObject());
                    rsp.setError(-23225);
                    rhc.onRequestHandled(req, rsp);
                } else if (rspSetWriteProtection != null && rspSetWriteProtectionFailover != null) {
                    int resultCode = 0;
                    if (rspSetWriteProtection.getResultCode() != 0) {
                        resultCode = rspSetWriteProtection.getResultCode();
                    } else if (rspSetWriteProtectionFailover.getResultCode() != 0) {
                        resultCode = rspSetWriteProtectionFailover.getResultCode();
                    }
                    rspSetWriteProtection = new RspSetWriteProtection(Integer.valueOf(resultCode), Long.valueOf(Math.min(rspSetWriteProtection.getStartTimestamp(), rspSetWriteProtectionFailover.getStartTimestamp())), Long.valueOf(Math.max(rspSetWriteProtection.getEndTimestamp(), rspSetWriteProtectionFailover.getEndTimestamp())));
                    SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)rspSetWriteProtection.createGObject());
                    rsp.setError(rspSetWriteProtection.getResultCode().intValue());
                    rhc.onRequestHandled(req, rsp);
                } else {
                    SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)new RspSetWriteProtection(Integer.valueOf(-23225), Long.valueOf(-1L), Long.valueOf(-1L)).createGObject());
                    rsp.setError(-23225);
                    rhc.onRequestHandled(req, rsp);
                }
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.info("No recordings found for " + request + " of " + this.videoSrv);
                }
                SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)new RspSetWriteProtection(Integer.valueOf(-23225), Long.valueOf(-1L), Long.valueOf(-1L)).createGObject());
                rsp.setError(-23225);
                rhc.onRequestHandled(req, rsp);
            }
            this.shutdownMDSProxies(mdsProxies);
        }
        catch (Throwable ex) {
            try {
                this.logger.error((Object)ex, ex);
                int errorCode = -21600;
                SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
                rsp.setError(errorCode);
                rhc.onRequestHandled(req, rsp);
                this.shutdownMDSProxies(mdsProxies);
            }
            catch (Throwable throwable) {
                this.shutdownMDSProxies(mdsProxies);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execRemoveWriteProtection(SrpcMessage req, RequestHandlerCallback rhc) {
        ReqRemoveWriteProtection request = (ReqRemoveWriteProtection)ReqRemoveWriteProtection.parseGObject((GObject)req.getPayload());
        DatabaseProxy[] mdsProxies = null;
        request.setContentID(Long.valueOf(this.getContentID()));
        try {
            mdsProxies = this.videoSrv.getCore().createDatabaseProxies(null);
            TimeRangeList list = this.videoSrv.getRecordingInfos().getTimeRangeInfo().getTimeRangeInfoForTimerange(request.getStart(), request.getEnd(), -1);
            if (list.size() > 0) {
                boolean containsFailoverRecordings = list.containsFailoverData();
                boolean containsDefaultRecordings = list.containsDefaultData();
                SrpcMessage subreq = SrpcMessage.createRequest((Methods)Methods.RE_SRPC_REQ_REMOVEWRITEPROTECTION, (GObject)request.createGObject());
                SrpcMessage responseDefault = null;
                if (containsDefaultRecordings) {
                    responseDefault = mdsProxies[0].sendGenericRequest(subreq, 30000L);
                }
                SrpcMessage responseFailover = null;
                if (containsFailoverRecordings && mdsProxies[1] != null) {
                    responseFailover = mdsProxies[1].sendGenericRequest(subreq, 30000L);
                }
                if (responseDefault == null && responseFailover != null) {
                    SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
                    rsp.setError(responseFailover.getError());
                    rhc.onRequestHandled(req, rsp);
                } else if (responseDefault != null && responseFailover == null) {
                    SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
                    rsp.setError(responseDefault.getError());
                    rhc.onRequestHandled(req, rsp);
                } else if (responseDefault == null && responseFailover == null) {
                    SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
                    rsp.setError(-23225);
                    rhc.onRequestHandled(req, rsp);
                } else if (responseDefault != null && responseFailover != null) {
                    int resultCode = 0;
                    if (responseDefault.getError() != 0) {
                        resultCode = responseDefault.getError();
                    } else if (responseFailover.getError() != 0) {
                        resultCode = responseFailover.getError();
                    }
                    SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
                    rsp.setError(resultCode);
                    rhc.onRequestHandled(req, rsp);
                } else {
                    int errorCode = -21600;
                    SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
                    rsp.setError(errorCode);
                    rhc.onRequestHandled(req, rsp);
                }
            }
            this.shutdownMDSProxies(mdsProxies);
        }
        catch (Throwable ex) {
            try {
                this.logger.error((Object)ex, ex);
                int errorCode = -21600;
                SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
                rsp.setError(errorCode);
                rhc.onRequestHandled(req, rsp);
                this.shutdownMDSProxies(mdsProxies);
            }
            catch (Throwable throwable) {
                this.shutdownMDSProxies(mdsProxies);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execRemoveRecording(SrpcMessage req, RequestHandlerCallback rhc) {
        ReqRemoveRecording request = (ReqRemoveRecording)ReqRemoveRecording.parseGObject((GObject)req.getPayload());
        DatabaseProxy[] mdsProxies = null;
        request.setContentID(Long.valueOf(this.getContentID()));
        try {
            mdsProxies = this.videoSrv.getCore().createDatabaseProxies(null);
            SrpcMessage subreq = SrpcMessage.createRequest((Methods)Methods.RE_SRPC_REQ_REMOVERECORDING, (GObject)request.createGObject());
            SrpcMessage subrsp = mdsProxies[0].sendGenericRequest(subreq, 30000L);
            GObject goResponse = subrsp.getPayload();
            GObject goResponseFailover = null;
            if (mdsProxies[1] != null) {
                SrpcMessage subrspFailover = mdsProxies[1].sendGenericRequest(subreq, 30000L);
                goResponseFailover = subrspFailover.getPayload();
            }
            RspRemoveRecording rspRemoveRecording = RspRemoveRecording.parseGObject((GObject)goResponse);
            RspRemoveRecording rspRemoveRecordingFailover = null;
            if (goResponseFailover != null) {
                rspRemoveRecordingFailover = RspRemoveRecording.parseGObject(goResponseFailover);
            }
            if (rspRemoveRecordingFailover != null) {
                int resultCode = 0;
                if (rspRemoveRecording.getResultCode() != 0) {
                    resultCode = rspRemoveRecording.getResultCode();
                } else if (rspRemoveRecordingFailover.getResultCode() != 0) {
                    resultCode = rspRemoveRecordingFailover.getResultCode();
                }
                rspRemoveRecording = new RspRemoveRecording(Integer.valueOf(resultCode), Long.valueOf(Math.min(rspRemoveRecording.getStartTimestamp(), rspRemoveRecordingFailover.getStartTimestamp())), Long.valueOf(Math.max(rspRemoveRecording.getEndTimestamp(), rspRemoveRecordingFailover.getEndTimestamp())));
            }
            SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)rspRemoveRecording.createGObject());
            rsp.setError(rspRemoveRecording.getResultCode().intValue());
            rhc.onRequestHandled(req, rsp);
            this.shutdownMDSProxies(mdsProxies);
        }
        catch (Throwable ex) {
            try {
                this.logger.error((Object)ex, ex);
                int errorCode = -21600;
                SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
                rsp.setError(errorCode);
                rhc.onRequestHandled(req, rsp);
                this.shutdownMDSProxies(mdsProxies);
            }
            catch (Throwable throwable) {
                this.shutdownMDSProxies(mdsProxies);
                throw throwable;
            }
        }
    }

    private void execMotionDetected(SrpcMessage req, RequestHandlerCallback rhc) {
        try {
            this.videoSrv.checkAndStartMotionRecording(false);
        }
        catch (ConfigurationException exception) {
            this.logger.error("Error while checking and/or starting ReordOnMotion for " + this.videoSrv, (Throwable)exception);
        }
    }

    private void execMotionEnd(SrpcMessage req, RequestHandlerCallback rhc) {
        try {
            this.videoSrv.checkAndStopMotionRecording(false);
        }
        catch (ConfigurationException exception) {
            this.logger.error("Error while checking and/or stopping ReordOnMotion for " + this.videoSrv, (Throwable)exception);
        }
    }

    private void execSynchronizeEdgeStorage(SrpcMessage req, RequestHandlerCallback callback) {
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Synchronize EdgeStorage manually for " + this.videoSrv);
        }
        try {
            ReqSynchronizeEdgeStorage reqSynchronizeEdgeStorage = ReqSynchronizeEdgeStorage.parseGObject(req.getPayload());
            BasicVideoProfileHandler basicVideoProfileHandler = (BasicVideoProfileHandler)this.videoSrv.getVideoProfileHandler(null);
            if (basicVideoProfileHandler != null) {
                EdgeStorageParameter edgeStorageParameter = basicVideoProfileHandler.getVideoSourceParameter().getEdgeStorageParameter();
                PlaybackVideoSourceClient playbackVideoSourceClient = basicVideoProfileHandler.providePlaybackVideoSourceClient(true);
                if (edgeStorageParameter.getEdgeStorageMode() == EdgeStorageMode.IMPORT) {
                    this.logger.info("Calling synchronization for Timerange: " + new Date(reqSynchronizeEdgeStorage.getStartTime()) + " - " + new Date(reqSynchronizeEdgeStorage.getEndTime()) + " for " + this);
                    playbackVideoSourceClient.setTimeRangeToSynchronize(reqSynchronizeEdgeStorage.getStartTime(), reqSynchronizeEdgeStorage.getEndTime());
                    this.videoSrv.setIsEdgeStorage(true);
                    EdgeStorageHandler edgeStorageHandler = this.videoSrv.getCore().getEdgeStorageHandler();
                    edgeStorageHandler.addPlaybackVideoSourceClient(playbackVideoSourceClient);
                } else if (edgeStorageParameter.getEdgeStorageMode() == EdgeStorageMode.GAP_FILLING) {
                    EdgeStorageHandler edgeStorageHandler = this.videoSrv.getCore().getEdgeStorageHandler();
                    edgeStorageHandler.addPlaybackVideoSourceClient(playbackVideoSourceClient);
                } else {
                    this.logger.warn("Edge Storage Mode not correct for doing a sync for  " + this);
                }
            } else {
                this.logger.warn("No video profile handler found while trying to synchronize EdgeStorage for " + this);
            }
        }
        catch (Throwable throwable) {
            this.logger.error("Error while trying to synchronize EdgeStorage for " + this, throwable);
        }
    }

    private void execUpdateGenericEventTrigger(SrpcMessage req, RequestHandlerCallback callback) {
        try {
            this.videoSrv.getDevice().updateGenericEventTriggerDefintion();
        }
        catch (Throwable throwable) {
            this.logger.error("Error while trying to get and update GenericEventTriggerDefinition for " + this.videoSrv.getDevice(), throwable);
        }
    }

    private void execStartTalking(SrpcMessage req, RequestHandlerCallback rhc) {
        ReqStartTalking request = ReqStartTalking.parseGObject(req.getPayload());
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
        rsp.setError(0);
        rhc.onRequestHandled(req, rsp);
        BasicVideoProfileHandler basicVideoProfileHandler = (BasicVideoProfileHandler)this.videoSrv.getVideoProfileHandler(0);
        if (this.contentStream != null) {
            int result = ((ContentStream)this.contentStream).getContentTransportQueue().getNetworkClientProxy().getNetworkClientReadingProxy().subscribe(basicVideoProfileHandler, request.getSessionId());
            if (result == 0) {
                this.logger.info(basicVideoProfileHandler + "subscribed for incoming data.");
            }
        } else {
            this.logger.error("Not possible to subscribe VideoProfileHandler for transmission: " + basicVideoProfileHandler);
        }
    }

    private void execStopTalking(SrpcMessage req, RequestHandlerCallback rhc) {
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
        rsp.setError(0);
        rhc.onRequestHandled(req, rsp);
        this.unsubscribeFromNetworkClientReadingProxy();
    }

    private void unsubscribeFromNetworkClientReadingProxy() {
        int result;
        BasicVideoProfileHandler basicVideoProfileHandler = (BasicVideoProfileHandler)this.videoSrv.getVideoProfileHandler(0);
        if (this.contentStream != null && ((ContentStream)this.contentStream).getContentTransportQueue() != null && ((ContentStream)this.contentStream).getContentTransportQueue().getNetworkClientProxy() != null && ((ContentStream)this.contentStream).getContentTransportQueue().getNetworkClientProxy().getNetworkClientReadingProxy() != null && (result = ((ContentStream)this.contentStream).getContentTransportQueue().getNetworkClientProxy().getNetworkClientReadingProxy().unsubscribe(basicVideoProfileHandler)) == 0) {
            this.logger.info(basicVideoProfileHandler + "unsubscribed.");
        }
    }

    public boolean isDatabaseReaderAvailable() {
        return this.databaseReader != null;
    }

    public boolean isLiveReaderAvailable() {
        return this.liveReader != null;
    }

    private DatabaseReaderImpl getDatabaseReader() {
        if (this.contentStream == null || this.contentStream.isShutdown()) {
            throw new RuntimeException("ContentStream [" + this.contentStream + "] not available");
        }
        if (this.openingMode == 0) {
            if (this.databaseReader != null && (!this.databaseReader.isValid() || this.databaseReader.isShutdown())) {
                this.logger.warn("Discarding [MDBReader] ...");
                this.databaseReader.shutdown();
                this.databaseReader = null;
            }
            if (this.databaseReader == null) {
                DatabaseReaderImpl tempDatabaseReader = new DatabaseReaderImpl();
                int errorCode = tempDatabaseReader.init(this, this.videoSrv.getCore());
                if (errorCode != 0) {
                    tempDatabaseReader.shutdown();
                    tempDatabaseReader = null;
                    this.logger.warn("Creating [MDBReader] failed with error [" + errorCode + "] for " + this.videoSrv);
                }
                this.databaseReader = tempDatabaseReader;
            }
            return this.databaseReader;
        }
        throw new RuntimeException("No archive mode set");
    }

    private long getUptime() {
        return System.currentTimeMillis() - this.tsStartup;
    }

    public long getClientID() {
        return this.clientID;
    }

    private void shutdownMDSProxies(DatabaseProxy[] mdsProxies) {
        if (mdsProxies != null) {
            for (DatabaseProxy mdsProxy : mdsProxies) {
                if (mdsProxy == null) continue;
                mdsProxy.shutdown();
                mdsProxy = null;
            }
        }
    }

    @Override
    public long getContentID() {
        return this.videoSrv.getServiceID();
    }

    @Override
    public String getContentName() {
        return this.videoSrv.getServiceName();
    }

    @Override
    public MDBCnfIntf getMDBCnf() {
        return this.videoSrv.getMDBCnf();
    }

    @Override
    public void setVideoMode(String videoMode) {
    }

    @Override
    public long getRecordingDuration() {
        return -1L;
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.shared.communication.VideoSrvCRH@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", " + (Object)((Object)this.srpcConnector) + ", " + this.videoSrv + ", " + this.contentStream + ", Username=[" + this.userName + "], ClientID=[" + this.clientID + "]]";
    }

    private void answer(SrpcMessage req, RequestHandlerCallback rhc, GObject result, int errorCode, boolean turnOffCompression) {
        if (this.logger.isDebugEnabled()) {
            this.logger.info(String.format("========= [%s] comp[%s] encr[%s] -> [%s] (%s) --> %s", req.getMethodName(), req.getCompression(), req.getEncryption(), result, errorCode, this));
        }
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, (GObject)result);
        rsp.setError(errorCode);
        if (turnOffCompression) {
            rsp.setCompression((byte)0);
        }
        rhc.onRequestHandled(req, rsp);
    }

    @Override
    public TimeRangeInfoContainer getRecordingInfos(ReqGetRecordingInfos request, boolean retrieveFromMDB, boolean useCleanAndMerge) {
        return this.videoSrv.getRecordingInfos(request, retrieveFromMDB, useCleanAndMerge);
    }

    private TranscodingProxyManager provideTranscodingManager() throws SeeTecException {
        if (this.transcodingProxyManager != null) {
            return this.transcodingProxyManager;
        }
        this.transcodingProxyManager = new TranscodingProxyManager();
        this.transcodingProxyManager.init(this.videoSrv.getCore());
        return this.transcodingProxyManager;
    }

    protected ContentFrame[] addLastFramePseudoFrameIfNeeded(ContentFrame[] contentFrames, long tillTimestampInMilliseconds, long requestMilliFps, boolean isForwardPlay) {
        boolean endIsReached = this.checkIfEndIsReached(contentFrames, tillTimestampInMilliseconds, requestMilliFps, isForwardPlay);
        if (endIsReached && (contentFrames == null || contentFrames.length == 0)) {
            ArrayList<ContentFrame> frames = new ArrayList<ContentFrame>(Arrays.asList(contentFrames == null ? new ContentFrame[]{} : contentFrames));
            frames.add(ContentFrame.createPseudoFrame((long)tillTimestampInMilliseconds));
            return frames.toArray(new ContentFrame[frames.size()]);
        }
        return contentFrames;
    }

    protected boolean checkIfEndIsReached(ContentFrame[] contentFrames, long tillTimestampInMilliseconds, long requestMilliFps, boolean isForwardPlay) {
        boolean endIsReached = false;
        if (contentFrames != null && contentFrames.length > 0) {
            long nextTimestamp = -1L;
            nextTimestamp = isForwardPlay ? contentFrames[contentFrames.length - 1].getEndTimestamp() : contentFrames[0].getStartTimestamp();
            if (isForwardPlay && (nextTimestamp += (long)this.getFrameDistanceWithSign(requestMilliFps, isForwardPlay)) > tillTimestampInMilliseconds || !isForwardPlay && nextTimestamp < tillTimestampInMilliseconds) {
                endIsReached = true;
            }
        } else {
            endIsReached = true;
        }
        return endIsReached;
    }

    private int getFrameDistanceWithSign(long requestMilliFps, boolean isForwardPlay) {
        int sign = 1;
        int framedistance = 1;
        if (!isForwardPlay) {
            sign = -1;
        }
        if (requestMilliFps > 0L) {
            framedistance = (int)(1000.0 / ((double)requestMilliFps / 1000.0));
        }
        return framedistance * sign;
    }

    public void setLastPublishedServiceStatus(int lastPublishedServiceStatus) {
        this.lastPublishedServiceStatus = lastPublishedServiceStatus;
    }

    private class TriggerActionHandler
    implements Runnable {
        private static final String CLASS_NAME = "TriggerActionHandler";
        private Thread thread = null;
        private de.seetec.v5.shared.net.srpc.general.ReqTriggerAction reqTriggerAction = null;

        private TriggerActionHandler() {
        }

        public int init(de.seetec.v5.shared.net.srpc.general.ReqTriggerAction reqTriggerAction) {
            this.reqTriggerAction = reqTriggerAction;
            if (this.reqTriggerAction == null) {
                return -21001;
            }
            if (Thread.activeCount() < 800) {
                this.thread = new Thread((Runnable)this, this.toString());
                this.thread.start();
            } else {
                if (VideoServiceClientRequestHandler.this.logger.isDebugEnabled()) {
                    VideoServiceClientRequestHandler.this.logger.info("Executing " + this + " within CRH thread, because already [" + Basic.longToFormattedString((long)Thread.activeCount()) + "] are active!");
                }
                this.run();
            }
            return 0;
        }

        @Override
        public void run() {
            VideoServiceClientRequestHandler.this.logger.info("Forwarding " + this.reqTriggerAction + " to " + (Object)((Object)VideoServiceClientRequestHandler.this.videoSrv.getCore()) + "...");
            long serviceID = this.reqTriggerAction.getServiceID();
            long actionID = this.reqTriggerAction.getActionID();
            try {
                Entity service = VideoServiceClientRequestHandler.this.videoSrv.getCore().getEntMgrProxy().getEntityByID(Long.valueOf(serviceID), Boolean.valueOf(false), 30000L);
                Entity action = VideoServiceClientRequestHandler.this.videoSrv.getCore().getEntMgrProxy().getEntityByID(Long.valueOf(actionID), Boolean.valueOf(false), 30000L);
                if (!Objects.equals(action.getLogicalParent(), service.getEntityID()) && Objects.equals(action.getLogicalParent(), service.getPhysicalParent())) {
                    serviceID = service.getPhysicalParent();
                }
            }
            catch (SeeTecException e) {
                VideoServiceClientRequestHandler.this.logger.warn("Error when checking for the correct service, let's try to trigger the action with the configuration we have.", (Throwable)e);
            }
            VideoServiceClientRequestHandler.this.videoSrv.getCore().delegateTriggerAction(serviceID, actionID, this.reqTriggerAction.getAlarmScriptID(), this.reqTriggerAction.getAlarmInstanceID(), this.reqTriggerAction.getAlarmTimerange(), this.reqTriggerAction.getGenericData(), this.reqTriggerAction.getPTZPriority(), this.reqTriggerAction.getPTZPriorityTimeout());
        }

        public String toString() {
            String sThis = "TriggerActionHandler@" + Integer.toHexString(this.hashCode());
            return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", " + this.reqTriggerAction + "]";
        }
    }
}

