/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared.communication;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.re.cm.shared.AlarmScenario;
import de.seetec.v5.re.cm.shared.communication.AdditionalRecordingHandlerControl;
import de.seetec.v5.re.cm.shared.communication.BaseRecordingHandler;
import de.seetec.v5.re.cm.shared.communication.DatabaseWriter;
import de.seetec.v5.re.cm.shared.communication.DatabaseWriterType;
import de.seetec.v5.re.cm.shared.communication.MDBAccessorIntf;
import de.seetec.v5.re.cm.shared.communication.RecordingEvent;
import de.seetec.v5.re.cm.shared.communication.RecordingEventHandler;
import de.seetec.v5.re.cm.shared.communication.RecordingHandlerListener;
import de.seetec.v5.re.cm.shared.srpc.ReqStartAlarmRecording;
import de.seetec.v5.re.cm.shared.srpc.RspStartAlarmRecording;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.DefaultSystemTimeProvider;
import de.seetec.v5.shared.EventType;
import de.seetec.v5.shared.SystemTimeProvider;
import de.seetec.v5.shared.proxy.ent.EntMgrProxy;
import de.seetec.v5.shared.proxy.ent.Entity;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public final class RecordingHandler
extends BaseRecordingHandler
implements Runnable,
RecordingHandlerListener {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.shared.communication.RecordingHandler";
    final Vector<RecordingEvent> recordingList = new Vector();
    private Thread myThread = null;
    private String contentName = "Name of content unknown";
    private RecordingEvent stopWithoutStart = null;
    private final RecordingEventHandler alarmsNotStarted = new RecordingEventHandler();
    private int alarmCounter = 0;
    private long alarmStart = -1L;
    private long avgAlarmDuration = 0L;
    private final Map<Long, Long> alarmStopTimestamps = new ConcurrentHashMap<Long, Long>();
    private boolean standardOrAlarmRecordingEnabled = false;
    private long preConditionEntityID = -1L;
    private volatile long standardRecordingID = -1L;
    private volatile long alarmRecordingID = -1L;
    private volatile long nextExpirationCheck = -1L;
    private final Object alarmRecordingIDSemaphore = new Object();
    private boolean standardRecordingEnabled = false;
    private boolean alarmRecordingEnabled = false;
    private long stdRecFramerate = 0L;
    private long alarmRecFramerate = 0L;
    private boolean additionalAlarmRecordingEnabled = false;
    private AdditionalRecordingHandlerControl additionalRecordingHandlerControl = null;

    public RecordingHandler() {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    public final int init(Core core, MDBAccessorIntf mdbAccessor, AdditionalRecordingHandlerControl additionalRecordingHandlerControl) {
        this.additionalRecordingHandlerControl = additionalRecordingHandlerControl;
        this.additionalAlarmRecordingEnabled = true;
        return this.init(core, mdbAccessor);
    }

    public final int init(Core core, MDBAccessorIntf mdbAccessor) {
        int errorCode = 0;
        errorCode = super.init(core, mdbAccessor, this);
        if (errorCode != 0) {
            return errorCode;
        }
        try {
            this.contentName = this.mdbAccessor.getContentName();
            this.standardOrAlarmRecordingEnabled = this.mdbAccessor.getMDBCnf().isRecordingEnabled();
            if (this.standardOrAlarmRecordingEnabled) {
                if (mdbAccessor instanceof VideoSrv) {
                    this.preConditionEntityID = ((VideoSrv)mdbAccessor).getVideoSourceCnf().getPreconditionID();
                }
                this.standardRecordingEnabled = this.mdbAccessor.getMDBCnf().isRecordingEnabled("Standard");
                this.alarmRecordingEnabled = this.mdbAccessor.getMDBCnf().isRecordingEnabled("Alarm");
                this.stdRecFramerate = this.mdbAccessor.getMDBCnf().getFramerate("Standard");
                this.alarmRecFramerate = this.mdbAccessor.getMDBCnf().getFramerate("Alarm");
                this.myThread = new Thread((Runnable)this, this.toString());
                this.myThread.start();
            } else {
                this.logger.info("No recording for " + this.mdbAccessor + " needed!");
            }
        }
        catch (Throwable throwable) {
            this.logger.error((Object)throwable, throwable);
            errorCode = -21600;
        }
        return errorCode;
    }

    @Override
    public final void run() {
        block24: {
            super.setRunFinished(CLASS_NAME, false);
            long nextTimerangeCheck = -1L;
            long nextPreConditionCheck = -1L;
            boolean preconditionRecordingActive = false;
            boolean timebasedRecordingActive = false;
            try {
                do {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        this.logger.warn("Error while sleeping...");
                    }
                    if (this.isShutdown()) break block24;
                    if (this.nextExpirationCheck < System.currentTimeMillis()) {
                        this.checkRecordingExpiration(1000L);
                    }
                    if (this.preConditionEntityID >= 0L && !timebasedRecordingActive && nextPreConditionCheck < System.currentTimeMillis()) {
                        nextPreConditionCheck = System.currentTimeMillis() + 1000L;
                        Entity entity = this.core.getEntityByID(this.preConditionEntityID);
                        boolean precondition = false;
                        if (entity == null || !entity.isEnabled().booleanValue()) {
                            precondition = true;
                        } else {
                            int status = entity.getStatus();
                            if (status < 0) {
                                precondition = true;
                            } else {
                                int entityType = entity.getEntityType().intValue();
                                if (status > 0) {
                                    if ((long)entityType == 9801L || (long)entityType == 9804L || (long)entityType == 9815L) {
                                        precondition = true;
                                    }
                                } else if ((long)entityType == 9802L || (long)entityType == 9805L || (long)entityType == 9816L) {
                                    precondition = true;
                                }
                            }
                        }
                        if (precondition) {
                            if (this.standardRecordingID < 0L) {
                                if (this.startStandardRecording() != 0) {
                                    this.logger.error("Cannot start standard recording for " + this);
                                    break block24;
                                }
                                preconditionRecordingActive = true;
                            }
                        } else if (this.standardRecordingID >= 0L) {
                            this.logger.info("Stop standard recording for [" + this.contentId + "]/[" + this.contentName + "] with id [" + this.standardRecordingID + "] because of " + entity);
                            this.stopStandardRecording();
                            preconditionRecordingActive = false;
                        }
                    }
                    if (nextTimerangeCheck >= System.currentTimeMillis() || preconditionRecordingActive) continue;
                    nextTimerangeCheck = System.currentTimeMillis() + 1000L;
                    if (this.mdbAccessor.getRecordingDuration() > 0L) {
                        if (this.standardRecordingID >= 0L) continue;
                        if (this.startStandardRecording() != 0) {
                            this.logger.error(this + " cannot start standard recording");
                            break block24;
                        }
                        timebasedRecordingActive = true;
                        continue;
                    }
                    if (this.standardRecordingID < 0L) continue;
                    this.logger.info("Stop standard recording of [" + this.contentId + "]/[" + this.contentName + "] with id [" + this.standardRecordingID + "] because of scheduler");
                    this.stopStandardRecording();
                    timebasedRecordingActive = false;
                } while (!this.core.isShutdown());
                try {
                    Thread.sleep(Math.round(Math.random() * 10000.0));
                }
                catch (InterruptedException interruptedException) {
                    this.logger.warn("Error while sleeping...");
                }
                this.logger.info("Enforce shutdown of " + this + " because of Core-shutown!");
            }
            catch (Throwable throwable) {
                this.logger.warn((Object)throwable, throwable);
                this.logger.warn(this + " has a fatal error and terminates thread");
            }
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    @Override
    public final int shutdown() {
        int errorCode;
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        this.stopAllRecordings();
        if (this.myThread != null) {
            long timeout = System.currentTimeMillis() + 30000L;
            while (!super.isRunFinished(CLASS_NAME)) {
                if (System.currentTimeMillis() > timeout) {
                    this.logger.warn("Thread of " + this + " didn't finished in time");
                    break;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    this.logger.warn("Error while sleeping...");
                }
            }
            this.myThread = null;
        }
        if ((errorCode = super.shutdown()) != 0) {
            return errorCode;
        }
        this.alarmRecFramerate = -1L;
        return 0;
    }

    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public final int startAlarmRecording(long actionID, long alarmScriptID, long alarmInstanceID, long maxRecording, byte[] genericData) {
        return this.startAlarmRecordingWithExpirationCheck(actionID, alarmScriptID, alarmInstanceID, maxRecording, genericData, false);
    }

    public final int startAlarmRecordingWithExpirationCheck(long actionID, long alarmScriptID, long alarmInstanceID, long maxRecording, byte[] genericData, boolean recordOnMotion) {
        this.checkRecordingExpiration(2000L);
        return this.startAlarmRecording(actionID, alarmScriptID, alarmInstanceID, maxRecording, genericData, recordOnMotion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int startAlarmRecording(long actionID, long alarmScriptID, long alarmInstanceID, long maxRecording, byte[] genericData, boolean recordOnMotion) {
        if (!this.standardOrAlarmRecordingEnabled) {
            return 0;
        }
        if (this.isShutdown()) {
            throw new RuntimeException(this + " is already shutting down!");
        }
        long preAlarmTimerange = 0L;
        try {
            if (genericData != null) {
                Long lastAlarmStop;
                Document xmlCnf = this.parseGenericAlarmData(genericData);
                preAlarmTimerange = this.parseGenericAlarmDataForPreAlarmTimerange(xmlCnf);
                this.setTemporaryAlarmFramerate(xmlCnf);
                this.alarmRecFramerate = this.mdbAccessor.getMDBCnf().getFramerate("Alarm");
                if (alarmScriptID >= 0L && (lastAlarmStop = this.alarmStopTimestamps.get(alarmScriptID)) != null && lastAlarmStop > System.currentTimeMillis() - preAlarmTimerange) {
                    preAlarmTimerange = System.currentTimeMillis() - lastAlarmStop - 1L;
                }
            }
        }
        catch (Exception exception) {
            this.logger.error((Object)exception, (Throwable)exception);
        }
        try {
            this.core.getAlarmProcessor().notifyAlarmStarted(this.contentId, alarmScriptID, alarmInstanceID, System.currentTimeMillis() - preAlarmTimerange, maxRecording);
        }
        catch (Throwable throwable) {
            this.logger.warn((Object)throwable, throwable);
        }
        if (this.isShutdown()) {
            this.logger.error(this + " is already shutting down");
            return -21609;
        }
        try {
            if (!this.mdbAccessor.getMDBCnf().isRecordingEnabled("Alarm")) {
                return 0;
            }
            Object throwable = this.alarmRecordingIDSemaphore;
            synchronized (throwable) {
                RecordingEvent recordingEvent;
                if (recordOnMotion || this.alarmRecordingID < 0L) {
                    this.alarmRecordingID = this.core.getTicket();
                }
                if (this.additionalAlarmRecordingEnabled) {
                    this.additionalRecordingHandlerControl.changeAdditionalRecordingMode(true);
                }
                this.alarmsNotStarted.removeRecordingEvent(alarmInstanceID);
                try {
                    int errorCode = this.getDatabaseWriter().changeRecordingMode(0, preAlarmTimerange, this.alarmRecFramerate, this.isAlarmRecordingActive());
                    if (errorCode != 0) {
                        this.logger.error("Changing recording mode to Alarm failed with error [" + errorCode + "]");
                        recordingEvent = this.createAlarmRecordingStartEvent(actionID, alarmScriptID, alarmInstanceID, maxRecording, genericData);
                        this.alarmsNotStarted.putNewRecordingEvent(alarmInstanceID, recordingEvent);
                        return errorCode;
                    }
                }
                catch (Throwable throwable2) {
                    this.logger.error("Changing recording mode to Alarm  failed with error because of  Runtime Exception [" + throwable2.getMessage() + "]");
                    RecordingEvent recordingEvent2 = this.createAlarmRecordingStartEvent(actionID, alarmScriptID, alarmInstanceID, maxRecording, genericData);
                    this.alarmsNotStarted.putNewRecordingEvent(alarmInstanceID, recordingEvent2);
                    return -23032;
                }
                recordingEvent = this.getExistingRecordingEvent(alarmInstanceID);
                if (recordingEvent != null) {
                    recordingEvent.setMaxRecording(maxRecording);
                    return 0;
                }
                recordingEvent = this.createAlarmRecordingStartEvent(actionID, alarmScriptID, alarmInstanceID, maxRecording, genericData);
                this.recordingList.addElement(recordingEvent);
                this.checkAlarmFramerate();
                this.sendRecordingEvent(this.alarmRecordingID, EventType.MDB_EVENTTYPE_ALARM_RECORDING_START, alarmInstanceID, System.currentTimeMillis() - preAlarmTimerange);
            }
            this.mdbAccessor.setVideoMode("Alarm");
        }
        catch (Exception exception) {
            this.logger.error("Cannot announce recording event for " + this, (Throwable)exception);
            return -21673;
        }
        if (this.alarmStart < 0L) {
            this.alarmStart = System.currentTimeMillis();
        }
        if (this.stopWithoutStart != null) {
            if (alarmInstanceID != this.stopWithoutStart.getAlarmInstanceID()) {
                this.logger.warn("Discarding pending " + this.stopWithoutStart + ", because AlarmInstanceID doesn't match!");
            } else {
                this.logger.warn(">>>Sending reordered " + this.stopWithoutStart);
                this.stopAlarmRecording(this.stopWithoutStart.getActionID(), this.stopWithoutStart.getAlarmScriptID(), this.stopWithoutStart.getAlarmInstanceID(), this.stopWithoutStart.getGenericData());
            }
            this.stopWithoutStart = null;
        }
        return 0;
    }

    private RecordingEvent createAlarmRecordingStartEvent(long actionID, long alarmScriptID, long alarmInstanceID, long maxRecording, byte[] genericData) {
        RecordingEvent recordingEvent = new RecordingEvent();
        recordingEvent.init(EventType.MDB_EVENTTYPE_ALARM_RECORDING_START.getType(), actionID, alarmScriptID, alarmInstanceID, maxRecording, genericData);
        recordingEvent.setAlarmFramerate(this.alarmRecFramerate);
        return recordingEvent;
    }

    private void setTemporaryAlarmFramerate(Document xmlCnf) throws NumberFormatException {
        Element alarmFPS = xmlCnf.getRootElement().getChild("AlarmFPS");
        int alarmScenarioSpecificFramerate = -1;
        if (alarmFPS != null) {
            alarmScenarioSpecificFramerate = Integer.parseInt(alarmFPS.getText());
        }
        this.mdbAccessor.getMDBCnf().setTemporaryAlarmFramerate(alarmScenarioSpecificFramerate);
    }

    private long parseGenericAlarmDataForPreAlarmTimerange(Document xmlCnf) throws RuntimeException {
        long preAlarmTimerange = 0L;
        Element preAlarm = xmlCnf.getRootElement().getChild("PreAlarm");
        if (preAlarm != null) {
            try {
                preAlarmTimerange = Long.parseLong(preAlarm.getText());
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException("Problems parsing number [" + preAlarm.getText() + "] for " + this);
            }
        }
        return preAlarmTimerange;
    }

    private Document parseGenericAlarmData(byte[] genericData) throws JDOMException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        baos.write("<root>".getBytes());
        baos.write(genericData);
        baos.write("</root>".getBytes());
        Document xmlCnf = new SAXBuilder().build((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        return xmlCnf;
    }

    private boolean isAlarmRecordingActive() {
        return this.alarmRecordingID >= 0L;
    }

    public final int startStandardRecording() {
        if (!this.standardOrAlarmRecordingEnabled) {
            return 0;
        }
        return this.startStandardRecording(-1L, -1L, -1L, 0x40000000000L, null);
    }

    public final int startStandardRecording(long actionID, long alarmScriptID, long alarmInstanceID, long maxRecording, byte[] genericData) {
        if (!this.standardOrAlarmRecordingEnabled) {
            return 0;
        }
        if (this.isShutdown()) {
            throw new RuntimeException(this + " is already shutting down!");
        }
        if (this.isShutdown()) {
            this.logger.error(this + " is already shutting down");
            return -21609;
        }
        this.checkRecordingExpiration(2000L);
        try {
            int errorCode;
            if (!this.mdbAccessor.getMDBCnf().isRecordingEnabled("Standard")) {
                this.logger.warn("Standard recording is disabled");
                return 0;
            }
            if (this.alarmRecordingID < 0L && (errorCode = this.getDatabaseWriter().changeRecordingMode(1)) != 0) {
                this.logger.error("Changing recording mode failed with error [" + errorCode + "]");
                return errorCode;
            }
            for (int i = 0; i < this.recordingList.size(); ++i) {
                RecordingEvent recordingEvent = this.recordingList.elementAt(i);
                if (alarmInstanceID != recordingEvent.getAlarmInstanceID() || EventType.MDB_EVENTTYPE_RECORDING_START.getType() != recordingEvent.getEventType()) continue;
                recordingEvent.setMaxRecording(maxRecording);
                return 0;
            }
            RecordingEvent recordingEvent = new RecordingEvent();
            recordingEvent.init(EventType.MDB_EVENTTYPE_RECORDING_START.getType(), actionID, alarmScriptID, alarmInstanceID, maxRecording, genericData);
            this.recordingList.addElement(recordingEvent);
            if (this.standardRecordingID >= 0L) {
                return 0;
            }
            this.standardRecordingID = this.core.getTicket();
            this.sendRecordingEvent(this.standardRecordingID, EventType.MDB_EVENTTYPE_RECORDING_START, alarmInstanceID, System.currentTimeMillis());
            if (this.alarmRecordingID < 0L) {
                this.mdbAccessor.setVideoMode("Standard");
            }
        }
        catch (Exception exception) {
            this.logger.error("Cannot announce recording event for " + this, (Throwable)exception);
            return -21673;
        }
        return 0;
    }

    public final int stopStandardRecording() {
        if (!this.standardOrAlarmRecordingEnabled) {
            return 0;
        }
        return this.stopStandardRecording(-1L, -1L, -1L, null);
    }

    public final int stopStandardRecording(long actionID, long alarmScriptID, long alarmInstanceID, byte[] genericData) {
        if (!this.standardOrAlarmRecordingEnabled) {
            return 0;
        }
        try {
            for (int i = 0; i < this.recordingList.size(); ++i) {
                RecordingEvent recordingEvent = this.recordingList.elementAt(i);
                if (alarmInstanceID != recordingEvent.getAlarmInstanceID() || EventType.MDB_EVENTTYPE_RECORDING_START.getType() != recordingEvent.getEventType()) continue;
                this.sendRecordingEvent(this.standardRecordingID, EventType.MDB_EVENTTYPE_RECORDING_STOP, alarmInstanceID, System.currentTimeMillis());
                this.recordingList.removeElementAt(i);
                this.logger.info(recordingEvent + " removed, now " + this.recordingList);
                return 0;
            }
        }
        catch (Exception exception) {
            this.logger.error("Cannot announce recording event for " + this, (Throwable)exception);
            return -21673;
        }
        return 0;
    }

    private int stopAllRecordings() {
        if (!this.standardOrAlarmRecordingEnabled) {
            return 0;
        }
        try {
            for (int i = this.recordingList.size() - 1; i >= 0; --i) {
                RecordingEvent recordingEvent = this.recordingList.elementAt(i);
                if (EventType.MDB_EVENTTYPE_RECORDING_START.getType() == recordingEvent.getEventType()) {
                    this.sendRecordingEvent(this.standardRecordingID, EventType.MDB_EVENTTYPE_RECORDING_STOP, recordingEvent.getAlarmInstanceID(), System.currentTimeMillis());
                    this.recordingList.removeElementAt(i);
                }
                if (EventType.MDB_EVENTTYPE_ALARM_RECORDING_START.getType() != recordingEvent.getEventType()) continue;
                this.sendRecordingEvent(this.alarmRecordingID, EventType.MDB_EVENTTYPE_ALARM_RECORDING_STOP, recordingEvent.getAlarmInstanceID(), System.currentTimeMillis());
                this.recordingList.removeElementAt(i);
                try {
                    this.core.getAlarmProcessor().notifyAlarmStopped(this.contentId, recordingEvent.getAlarmScriptID(), recordingEvent.getAlarmInstanceID());
                    continue;
                }
                catch (Throwable throwable) {
                    this.logger.warn((Object)throwable, throwable);
                }
            }
        }
        catch (Exception exception) {
            this.logger.error("Cannot announce recording event for " + this, (Throwable)exception);
            return -21673;
        }
        return 0;
    }

    public final int startAlarmRecording(long length) {
        if (!this.standardOrAlarmRecordingEnabled) {
            return 0;
        }
        return this.startAlarmRecording(length, false);
    }

    public final int startAlarmRecording(long length, boolean recordOnMotion) {
        if (!this.standardOrAlarmRecordingEnabled) {
            return 0;
        }
        return this.startAlarmRecordingWithExpirationCheck(-1L, -1L, -1L, System.currentTimeMillis() + length, null, recordOnMotion);
    }

    public final int startAlarmRecording(long preAlarm, long length, boolean recordOnMotion) {
        if (!this.standardOrAlarmRecordingEnabled) {
            return 0;
        }
        String genericDataString = "<PreAlarm>" + preAlarm + "</PreAlarm>";
        byte[] genericData = genericDataString.getBytes();
        return this.startAlarmRecordingWithExpirationCheck(-1L, -1L, -1L, System.currentTimeMillis() + length, genericData, recordOnMotion);
    }

    public final int startAlarmRecording() {
        if (!this.standardOrAlarmRecordingEnabled) {
            return 0;
        }
        return this.startAlarmRecording(-1L, -1L, -1L, 0x40000000000L, null);
    }

    public final RspStartAlarmRecording startAlarmRecording(ReqStartAlarmRecording request) {
        try {
            if (!this.standardOrAlarmRecordingEnabled || !this.mdbAccessor.getMDBCnf().isRecordingEnabled("Alarm")) {
                return new RspStartAlarmRecording(-21690, -1L);
            }
        }
        catch (Throwable throwable) {
            this.logger.error((Object)throwable, throwable);
            return new RspStartAlarmRecording(-21600, -1L);
        }
        long alarmInstanceID = request.getExternalID();
        if (alarmInstanceID < 0L) {
            alarmInstanceID = Basic.createInt8UID((SystemTimeProvider)new DefaultSystemTimeProvider());
        }
        Long preAlarmTimerange = request.getPreAlarmTimerange();
        Long postAlarmTimerange = request.getPostAlarmTimerange();
        String genericDataString = "<PreAlarm>" + preAlarmTimerange + "</PreAlarm>";
        byte[] genericData = genericDataString.getBytes();
        int errorCode = this.startAlarmRecording(-1L, -1L, alarmInstanceID, System.currentTimeMillis() + postAlarmTimerange, genericData);
        return new RspStartAlarmRecording(errorCode, alarmInstanceID);
    }

    public final void stopRecordOnMotionAlarmRecording(long postAlarm) {
        this.alarmsNotStarted.setMaxRecording(-1L, System.currentTimeMillis() + postAlarm);
        for (RecordingEvent recordingEvent : this.recordingList) {
            if (recordingEvent.getAlarmInstanceID() != -1L || recordingEvent.getEventType() != EventType.MDB_EVENTTYPE_ALARM_RECORDING_START.getType()) continue;
            recordingEvent.setMaxRecording(System.currentTimeMillis() + postAlarm);
            break;
        }
    }

    public final int stopAlarmRecording() {
        if (!this.standardOrAlarmRecordingEnabled) {
            return 0;
        }
        return this.stopAlarmRecording(-1L, -1L, -1L, null);
    }

    public final int stopAlarmRecording(long actionID, long alarmScriptID, long alarmInstanceID, byte[] genericData) {
        if (!this.standardOrAlarmRecordingEnabled) {
            return 0;
        }
        try {
            this.core.getAlarmProcessor().notifyAlarmStopped(this.contentId, alarmScriptID, alarmInstanceID);
        }
        catch (Throwable throwable) {
            this.logger.warn((Object)throwable, throwable);
        }
        this.alarmsNotStarted.removeRecordingEvent(alarmInstanceID);
        try {
            long tsTimeout = System.currentTimeMillis() + 5000L;
            while (System.currentTimeMillis() < tsTimeout) {
                for (int i = this.recordingList.size() - 1; i >= 0 && i < this.recordingList.size(); --i) {
                    Entity alarmScenarioEntity;
                    RecordingEvent recordingEvent = this.recordingList.elementAt(i);
                    if (alarmInstanceID != recordingEvent.getAlarmInstanceID() || recordingEvent.getEventType() != EventType.MDB_EVENTTYPE_ALARM_RECORDING_START.getType()) continue;
                    this.recordingList.removeElementAt(i);
                    long tsNow = System.currentTimeMillis();
                    this.sendRecordingEvent(this.alarmRecordingID, EventType.MDB_EVENTTYPE_ALARM_RECORDING_STOP, alarmInstanceID, tsNow);
                    this.alarmStopTimestamps.put(alarmScriptID, tsNow);
                    if (alarmScriptID > 0L && (alarmScenarioEntity = this.core.getEntityByID(alarmScriptID)) != null) {
                        AlarmScenario alarmScenario = new AlarmScenario();
                        alarmScenario.init(alarmScenarioEntity);
                        this.getDatabaseWriter().writeFtpOrMailExport(alarmScenario, recordingEvent.getTimestamp(), System.currentTimeMillis());
                    }
                    this.checkAlarmFramerate();
                    return 0;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Throwable throwable) {
            this.logger.error("Cannot announce recording event for " + this, throwable);
            return -21673;
        }
        if (this.stopWithoutStart != null) {
            this.logger.warn("Discarding " + this.stopWithoutStart + ", because next stop without start is appearing!");
        }
        if (alarmInstanceID > 0L) {
            long maxRecording = -1L;
            this.stopWithoutStart = new RecordingEvent();
            this.stopWithoutStart.init(EventType.MDB_EVENTTYPE_ALARM_RECORDING_STOP.getType(), actionID, alarmScriptID, alarmInstanceID, maxRecording, genericData);
            this.logger.warn(">>> Store Stop-Without-Start-Event as " + this.stopWithoutStart);
        }
        this.logger.warn(this + " cannot find correspondending start event for entity [" + this.contentId + "]/[" + this.contentName + "] with ActionID=[" + actionID + "], AlarmScriptID=[" + alarmScriptID + "], AlarmInstanceID=[" + alarmScriptID + "]. Maybe, the alarm recording is already stopped");
        return -21675;
    }

    private void checkRecordingExpiration(long delayBeforeNextCyclicExecution) {
        if (delayBeforeNextCyclicExecution < 1000L) {
            this.logger.warn("Delay for cyclic checkRecordingExpiration has to be at least 1s");
            delayBeforeNextCyclicExecution = 1000L;
        }
        this.nextExpirationCheck = System.currentTimeMillis() + delayBeforeNextCyclicExecution;
        this.checkRecordingExpiration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRecordingExpiration() {
        boolean stopAlarmRecording;
        block31: {
            if (!this.standardOrAlarmRecordingEnabled) {
                throw new RuntimeException("There is no recording, so no recording events have to be sent!");
            }
            stopAlarmRecording = true;
            boolean stopStandardRecording = true;
            try {
                RecordingEvent recordingEvent;
                int errorCode;
                RecordingEvent recordingEvent2;
                if (!this.alarmsNotStarted.isEmpty()) {
                    this.logger.info("+++ Alarms not started " + this.alarmsNotStarted.size() + " for " + this);
                }
                if ((recordingEvent2 = this.alarmsNotStarted.getAlarmRecordingEvent()) != null) {
                    this.startAlarmRecording(recordingEvent2.getActionID(), recordingEvent2.getAlarmScriptID(), recordingEvent2.getAlarmInstanceID(), recordingEvent2.getMaxRecording(), recordingEvent2.getGenericData(), true);
                }
                if ((recordingEvent2 = this.removeExpiredEvent()) != null) {
                    if (recordingEvent2.getEventType() == EventType.MDB_EVENTTYPE_RECORDING_START.getType()) {
                        errorCode = this.sendRecordingEvent(this.standardRecordingID, EventType.MDB_EVENTTYPE_RECORDING_STOP, recordingEvent2.getAlarmInstanceID(), System.currentTimeMillis());
                        if (errorCode != 0) {
                            this.logger.warn("Sending recording event " + recordingEvent2 + " failed with error [" + errorCode + "]");
                        }
                    } else if (recordingEvent2.getEventType() == EventType.MDB_EVENTTYPE_ALARM_RECORDING_START.getType()) {
                        errorCode = this.sendRecordingEvent(this.alarmRecordingID, EventType.MDB_EVENTTYPE_ALARM_RECORDING_STOP, recordingEvent2.getAlarmInstanceID(), System.currentTimeMillis());
                        if (errorCode != 0) {
                            this.logger.warn("Sending recording event " + recordingEvent2 + " failed with error [" + errorCode + "]");
                        }
                        this.alarmStopTimestamps.put(recordingEvent2.getAlarmScriptID(), System.currentTimeMillis());
                        try {
                            this.core.getAlarmProcessor().notifyAlarmStopped(this.contentId, recordingEvent2.getAlarmScriptID(), recordingEvent2.getAlarmInstanceID());
                        }
                        catch (Throwable throwable) {
                            this.logger.warn((Object)throwable, throwable);
                        }
                    } else {
                        this.logger.warn("EventType [" + recordingEvent2.getEventType() + "] unknown. Invalid " + recordingEvent2 + " for " + this);
                    }
                }
                if (this.standardRecordingID >= 0L) {
                    for (int i = 0; i < this.recordingList.size(); ++i) {
                        recordingEvent = this.recordingList.elementAt(i);
                        if (recordingEvent.getEventType() != EventType.MDB_EVENTTYPE_RECORDING_START.getType()) continue;
                        stopStandardRecording = false;
                        break;
                    }
                    if (stopStandardRecording) {
                        this.standardRecordingID = -1L;
                        if (this.alarmRecordingID < 0L && (errorCode = this.getDatabaseWriter().changeRecordingMode(-1)) != 0) {
                            this.logger.warn("Changing recording mode failed with error [" + errorCode + "]");
                        }
                    }
                }
                if (this.alarmRecordingID < 0L) break block31;
                for (int i = 0; i < this.recordingList.size(); ++i) {
                    recordingEvent = this.recordingList.elementAt(i);
                    if (recordingEvent.getEventType() != EventType.MDB_EVENTTYPE_ALARM_RECORDING_START.getType()) continue;
                    stopAlarmRecording = false;
                    break;
                }
                if (!stopAlarmRecording) break block31;
                Object i = this.alarmRecordingIDSemaphore;
                synchronized (i) {
                    this.alarmRecordingID = -1L;
                }
                if (this.additionalAlarmRecordingEnabled) {
                    try {
                        this.additionalRecordingHandlerControl.flushRecordingQueue();
                    }
                    catch (Throwable exception) {
                        this.logger.warn("Failed to flush cummulated frame buffer for AdditionalRecordingHandler [" + exception.getMessage() + "] for " + this);
                    }
                    this.additionalRecordingHandlerControl.changeAdditionalRecordingMode(false);
                }
                int recordingModeToSet = 1;
                if (this.standardRecordingID < 0L) {
                    recordingModeToSet = -1;
                }
                if ((errorCode = this.getDatabaseWriter().changeRecordingMode(recordingModeToSet)) != 0) {
                    this.logger.warn("Changing recording mode failed with error [" + errorCode + "]");
                }
            }
            catch (Throwable throwable) {
                this.logger.warn((Object)throwable, throwable);
                this.logger.warn("Problems while checking expiration of recording events --> " + this);
            }
        }
        if (stopAlarmRecording) {
            this.mdbAccessor.setVideoMode("Standard");
            if (this.alarmStart >= 0L) {
                long duration = System.currentTimeMillis() - this.alarmStart;
                this.alarmStart = -1L;
                this.avgAlarmDuration = (this.avgAlarmDuration * (long)this.alarmCounter + duration) / (long)(++this.alarmCounter);
                if (this.alarmCounter % 10 == 0) {
                    this.logger.info(this.mdbAccessor + " had [" + Basic.longToFormattedString((long)this.alarmCounter) + "] alarm recordings with an average duration of [" + Basic.longToFormattedString((long)this.avgAlarmDuration) + " ms]. Last alarm has a duration of [" + Basic.longToFormattedString((long)duration) + " ms]");
                }
            }
        } else {
            this.checkAlarmFramerate();
        }
    }

    private int sendRecordingEvent(long eventID, EventType eventType, long causeID, long event) {
        block5: {
            if (!this.standardOrAlarmRecordingEnabled) {
                throw new RuntimeException("There is no recording, so no recording events have to be sent!");
            }
            if (eventID < 0L) {
                this.logger.error("Negative EventID!");
                this.logger.error("EventID=[" + eventID + "] with EventType=[" + eventType.getDescription() + "] and CauseID=[" + causeID + "] not valid for " + this);
                return -21601;
            }
            EntMgrProxy entMgrProxy = null;
            try {
                entMgrProxy = this.core.getEntMgrProxy();
                if (entMgrProxy == null) {
                    this.logger.error("Cannot send Event, because EntMgrProxy not available: EventID=[" + eventID + "], EventType=[" + eventType.getDescription() + "], CauseID=[" + causeID + "]");
                    return -21020;
                }
                long sourceID = this.mdbAccessor.getContentID();
                long tsTimeout = 20000L;
                this.logger.info(Basic.generateIndentedMultiLineLog((String)("EventID=[" + eventID + "], EventType=[" + eventType.getDescription() + "], SourceID=[" + sourceID + "], CauseID=[" + causeID + "]")));
                entMgrProxy.announce(Long.valueOf(eventID), Long.valueOf(eventType.getType()), Long.valueOf(sourceID), Long.valueOf(causeID), Long.valueOf(event), null, tsTimeout);
            }
            catch (Exception exception) {
                this.logger.warn((Object)exception);
                if (entMgrProxy == null) break block5;
                entMgrProxy.shutdown();
            }
        }
        return 0;
    }

    public final void checkAlarmFramerate() {
        RecordingEvent recordingEvent;
        if (this.recordingList != null && this.recordingList.size() > 0 && (recordingEvent = this.recordingList.lastElement()).getEventType() == EventType.MDB_EVENTTYPE_ALARM_RECORDING_START.getType() && recordingEvent.getAlarmFramerate() > 0L) {
            this.alarmRecFramerate = recordingEvent.getAlarmFramerate();
            this.getDatabaseWriter().setAlarmRecFramerate(this.alarmRecFramerate);
            if (this.mdbAccessor != null && this.mdbAccessor instanceof VideoSrv) {
                ((VideoSrv)this.mdbAccessor).checkFramerate();
            }
        }
    }

    public final boolean isRecordingActive() {
        if (!this.standardOrAlarmRecordingEnabled) {
            return false;
        }
        if (this.alarmRecordingID < 0L && this.standardRecordingID < 0L) {
            Entity entity;
            Integer status;
            if (this.preConditionEntityID >= 0L && (status = (entity = this.core.getEntityByID(this.preConditionEntityID)).getStatus()) != null && status != 0) {
                return true;
            }
            try {
                if (this.mdbAccessor instanceof VideoSrv) {
                    return ((VideoSrv)this.mdbAccessor).getVideoSourceCnf().getPreAlarmTime() > 0L;
                }
            }
            catch (Throwable throwable) {
                this.logger.warn((Object)throwable, throwable);
            }
            return false;
        }
        return true;
    }

    public final DatabaseWriter getDatabaseWriter() {
        return super.getDatabaseWriter(this.additionalAlarmRecordingEnabled, DatabaseWriterType.DEFAULT);
    }

    public final long getFramerate() {
        if (!this.isRecordingActive()) {
            return 0L;
        }
        if (!this.standardRecordingEnabled && !this.alarmRecordingEnabled) {
            return 0L;
        }
        boolean additionalAlarmRecording = false;
        try {
            additionalAlarmRecording = ((VideoSrv)this.mdbAccessor).getVideoSourceCnf().getAlarmRecordingStreamIndex() > 0;
        }
        catch (Throwable ex) {
            this.logger.warn("Error while reading additional alarm recording index from configuration");
        }
        try {
            if (this.standardRecordingID < 0L && ((VideoSrv)this.mdbAccessor).getVideoSourceCnf().getPreAlarmTime() > 0L && !additionalAlarmRecording) {
                return this.alarmRecFramerate;
            }
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
        }
        if (this.standardRecordingEnabled && !this.isAlarmRecordingActive()) {
            return this.stdRecFramerate;
        }
        if (!this.standardRecordingEnabled && !this.isAlarmRecordingActive()) {
            return 0L;
        }
        return this.alarmRecFramerate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecordingEvent removeExpiredEvent() {
        if (this.recordingList != null && this.recordingList.size() > 0) {
            Vector<RecordingEvent> vector = this.recordingList;
            synchronized (vector) {
                for (int i = 0; i < this.recordingList.size(); ++i) {
                    RecordingEvent recordingEvent = this.recordingList.elementAt(i);
                    if (recordingEvent.getMaxRecording() >= System.currentTimeMillis() - TimeUnit.SECONDS.toMillis(2L)) continue;
                    this.recordingList.removeElementAt(i);
                    return recordingEvent;
                }
            }
        }
        return null;
    }

    private RecordingEvent getExistingRecordingEvent(long alarmInstanceID) {
        for (int i = 0; i < this.recordingList.size(); ++i) {
            RecordingEvent recordingEvent = this.recordingList.elementAt(i);
            if (alarmInstanceID != recordingEvent.getAlarmInstanceID() || EventType.MDB_EVENTTYPE_ALARM_RECORDING_START.getType() != recordingEvent.getEventType()) continue;
            return recordingEvent;
        }
        return null;
    }

    public String toString() {
        String thisAsString = "de.seetec.v5.re.cm.shared.communication.RecordingHandler@" + Integer.toHexString(this.hashCode());
        return "[" + thisAsString.substring(thisAsString.lastIndexOf(46) + 1) + ", Entity=[" + this.contentId + "]/[" + this.contentName + "]]";
    }

    @Override
    public void notifyNewDatabaseWriterCreated() {
        this.standardRecordingID = -1L;
        this.recordingList.clear();
        this.alarmStopTimestamps.clear();
    }
}

