/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared.communication;

import de.seetec.v5.re.cm.device.shared.ImageStreamPaket;
import de.seetec.v5.re.cm.shared.communication.NetworkClientReaderSubscriber;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkClientReaderPublisher {
    private final Map<NetworkClientReaderSubscriber, Long> store = new HashMap<NetworkClientReaderSubscriber, Long>();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private boolean isShutdown = false;
    protected Logger logger = null;
    ByteArrayOutputStream baos = new ByteArrayOutputStream();

    public NetworkClientReaderPublisher() {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    public int init() {
        return 0;
    }

    protected boolean isShutdown() {
        return this.isShutdown;
    }

    protected int shutdown() {
        if (this.isShutdown()) {
            return 0;
        }
        this.isShutdown = true;
        this.lock.writeLock().lock();
        try {
            this.store.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int publish(byte[] buffer) {
        if (buffer == null) {
            return -20002;
        }
        this.lock.readLock().lock();
        int numberOfNotifiedSubscribers = 0;
        try {
            this.baos.write(buffer);
            byte[] allData = this.baos.toByteArray();
            int startOfSeeTecPayload = 0;
            int endOfSeeTecPayload = 0;
            while ((startOfSeeTecPayload = Basic.indexOfByteArray((byte[])allData, (byte[])ImageStreamPaket.IMAGE_STREAM_HEADER_MAGIC, (int)endOfSeeTecPayload, (boolean)true)) != -1) {
                int framesize = Basic.byteArrayToInt4((byte[])Arrays.copyOfRange(allData, startOfSeeTecPayload + 18, startOfSeeTecPayload + 22));
                endOfSeeTecPayload = startOfSeeTecPayload + 26 + framesize;
                if (endOfSeeTecPayload > allData.length) {
                    endOfSeeTecPayload = startOfSeeTecPayload;
                    break;
                }
                if (allData.length < endOfSeeTecPayload) continue;
                ImageStreamPaket imageStreamPaket = ImageStreamPaket.deserialize(Arrays.copyOfRange(allData, startOfSeeTecPayload, endOfSeeTecPayload));
                for (Map.Entry<NetworkClientReaderSubscriber, Long> subscriber : this.store.entrySet()) {
                    if (imageStreamPaket.getSessionID() != subscriber.getValue().longValue() || imageStreamPaket.getPayload() == null) continue;
                    ContentFrame receivedContentFrame = ContentFrame.deserialize((byte[])imageStreamPaket.getPayload());
                    subscriber.getKey().notify(receivedContentFrame);
                    ++numberOfNotifiedSubscribers;
                }
            }
            this.baos = new ByteArrayOutputStream();
            this.baos.write(allData, endOfSeeTecPayload, allData.length - endOfSeeTecPayload);
            int n = numberOfNotifiedSubscribers;
            return n;
        }
        catch (SeeTecException seeTecException) {
            this.logger.error("Discaring packet cause parsing impossible: " + seeTecException.getMessage());
            int n = -20002;
            return n;
        }
        catch (Exception ex) {
            this.logger.error("Processing received bytes failed: " + ex.getMessage());
            int n = -20002;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int subscribe(NetworkClientReaderSubscriber subscriber, Long sessionID) {
        if (subscriber == null || sessionID == null) {
            return -20002;
        }
        this.lock.writeLock().lock();
        try {
            this.store.put(subscriber, sessionID);
            int n = 0;
            return n;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public int unsubscribe(NetworkClientReaderSubscriber subscriber) {
        if (subscriber == null) {
            return -20002;
        }
        this.lock.writeLock().lock();
        try {
            int n = this.store.remove(subscriber) != null ? 0 : -20110;
            return n;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

