/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared.communication;

import de.seetec.v5.shared.Basic;

public class NetworkClientProxyDeliveryStatistics {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.shared.communication.NetworkClientProxy.DeliveryStatistics";
    private int queueSize = -1;
    private boolean[] flag = null;
    private long[] ts = null;
    private int[] volume = null;
    private int pointer = -1;

    public NetworkClientProxyDeliveryStatistics(int queueSize) {
        this.queueSize = queueSize;
        this.flag = new boolean[this.queueSize];
        this.ts = new long[this.queueSize];
        this.volume = new int[this.queueSize];
    }

    public void notifyFrameSent(int data) {
        ++this.pointer;
        this.flag[this.pointer % this.queueSize] = true;
        this.ts[this.pointer % this.queueSize] = System.currentTimeMillis();
        this.volume[this.pointer % this.queueSize] = data;
    }

    public long getBandwidth(long timerange) {
        long dataVolumeSent = 0L;
        for (int i = 0; i < this.ts.length; ++i) {
            if (this.ts[i] <= System.currentTimeMillis() - timerange || !this.flag[i]) continue;
            dataVolumeSent += (long)this.volume[i];
        }
        if (dataVolumeSent > 0L) {
            return dataVolumeSent * 1000L / timerange;
        }
        return 0L;
    }

    public void resetRatioStatistics() {
        this.pointer = -1;
        this.flag = new boolean[this.queueSize];
        this.ts = new long[this.queueSize];
        this.volume = new int[this.queueSize];
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.shared.communication.NetworkClientProxy.DeliveryStatistics@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", Bandwidth=[" + Basic.longToFormattedString((long)this.getBandwidth(5000L)) + " B/s]]";
    }
}

