/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared.communication;

import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.shared.ContentStreamIntf;
import de.seetec.v5.re.cm.shared.PtzInfo;
import de.seetec.v5.re.cm.shared.sql.ManagerLoggingOfCameraUsage;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.re.shared.FramerateChecker;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.EventType;
import de.seetec.v5.shared.configuration.events.live.LiveViewEvent;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LiveReader
extends Basic {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.shared.communication.LiveReader";
    private final Logger logger = LogManager.getLogger((String)"de.seetec.v5.re.cm.shared.communication.LiveReader");
    private ContentStreamIntf contentStream = null;
    private long jpegSpeed = -1L;
    private String mpegSpeed = "full";
    private VideoProfileHandler videoProfileHandler = null;
    private FramerateChecker framerateChecker = null;
    private ManagerLoggingOfCameraUsage managerLoggingOfCameraUsage = null;
    private boolean loggingOfCameraLiveUsage = false;
    private Long videoSourceID = null;
    private Long userID = null;
    private String userName = null;
    private Long startOfStreaming = null;
    private Long endOfStreaming = null;
    private long nanoLastPresetInfo = -1L;
    private long nanoLastPtzInfo = -1L;
    private short transactionID;

    public int init(ContentStreamIntf contentStream, long jpegSpeed, String mpegSpeed, VideoProfileHandler videoProfileHandler, short transactionID) {
        this.contentStream = contentStream;
        if (this.contentStream == null) {
            this.logger.error("[ContentStream] is <null>!");
            return -21601;
        }
        this.jpegSpeed = jpegSpeed;
        if (this.jpegSpeed < 0L) {
            this.logger.error("[JpegSpeed] is invalid!");
            return -21601;
        }
        this.mpegSpeed = mpegSpeed;
        if (this.mpegSpeed == null) {
            return -21601;
        }
        this.videoProfileHandler = videoProfileHandler;
        if (this.videoProfileHandler == null) {
            return -21601;
        }
        this.transactionID = transactionID;
        this.framerateChecker = new FramerateChecker();
        this.framerateChecker.init(0L);
        return 0;
    }

    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        this.endOfStreaming = System.currentTimeMillis();
        if (this.loggingOfCameraLiveUsage) {
            this.managerLoggingOfCameraUsage.deregisterLiveReader(this);
            this.managerLoggingOfCameraUsage.addLoggingOfLiveCameraUsage(this.videoSourceID, this.userID, this.userName, this.startOfStreaming, this.endOfStreaming);
            try {
                if (this.isUserIdSet(this.userID)) {
                    LiveViewEvent liveViewEvent = new LiveViewEvent();
                    liveViewEvent.setActiveDirectoryUser(this.userName);
                    this.getVideoProfileHandler().getLiveCameraSrv().getCore().sendEvent(EventType.MDB_EVENTTYPE_LIVE_STOP, this.videoSourceID, this.userID, Basic.cutOffRoot((String)Basic.marshalXML((Object)liveViewEvent)).getBytes());
                } else {
                    this.logger.info("LiveLog Event for Server-Service suppressed" + (Object)((Object)this));
                }
            }
            catch (Exception exception) {
                this.logger.warn("Could not send Event [" + EventType.MDB_EVENTTYPE_LIVE_STOP + "] because of " + exception + " for " + (Object)((Object)this));
            }
        }
        return 0;
    }

    public void deliverFrameToLive(ContentFrame contentFrame) {
        this.deliverFrameToLive(contentFrame, false);
    }

    public void deliverBufferedFrameToLive(ContentFrame contentFrame) {
        this.deliverFrameToLive(contentFrame, true);
    }

    private void deliverFrameToLive(ContentFrame contentFrame, boolean dontKillBuffer) {
        if (this.isShutdown()) {
            this.logger.warn((Object)((Object)this) + " is already shutting down!");
            return;
        }
        if (this.contentStream == null || this.contentStream.isShutdown()) {
            this.logger.warn("No valid content stream available! Shutting down " + (Object)((Object)this) + " ...");
            this.shutdown();
            return;
        }
        try {
            long currentNanoTime = System.nanoTime();
            int attributes = 0;
            long ts = System.currentTimeMillis();
            if (Math.abs(this.nanoLastPtzInfo - currentNanoTime) > TimeUnit.SECONDS.toNanos(1L)) {
                this.nanoLastPtzInfo = currentNanoTime;
                this.sendPtzInfo(attributes, ts);
            }
            if (Math.abs(this.nanoLastPresetInfo - currentNanoTime) > TimeUnit.SECONDS.toNanos(2L)) {
                this.nanoLastPresetInfo = currentNanoTime;
                this.sendCurrentPresetPosition(attributes, ts);
            }
        }
        catch (Throwable currentNanoTime) {
            // empty catch block
        }
        if (contentFrame == null) {
            this.logger.warn("ContentFrame won't be processed cause null.");
        } else {
            if (this.getMpegSpeed().equals("reduced") && contentFrame.getMediatype() == 33 && this.getJpegFramerate() > 0L) {
                this.framerateChecker.setFramerate(this.getJpegFramerate());
                if (!this.framerateChecker.checkForFramerate(contentFrame.getStartTimestamp())) {
                    return;
                }
            }
            if (contentFrame.getMediatype() == 0) {
                this.framerateChecker.setFramerate(this.getJpegFramerate());
                if (!this.framerateChecker.checkForFramerate(contentFrame.getStartTimestamp()) && !dontKillBuffer) {
                    return;
                }
            }
            if (this.getMpegSpeed().equals("reduced") && contentFrame.getMediatype() == 35) {
                return;
            }
            if (this.getVideoProfileHandler().getMulticastGateway() != null) {
                LiveReader[] liveReaders = this.getVideoProfileHandler().getLiveCameraSrv().getLiveReaders(this.getVideoProfileHandler());
                if (liveReaders.length > 0) {
                    try {
                        this.getVideoProfileHandler().getMulticastGateway().sendContentFrame(contentFrame);
                    }
                    catch (Exception ex) {
                        this.logger.error("Problems while delivering frames to LiveReaders for " + (Object)((Object)this), (Throwable)ex);
                    }
                }
            } else {
                int errorCode = this.contentStream.sendFrame(contentFrame, this.transactionID);
                if (errorCode != 0) {
                    this.shutdown();
                    this.logger.error("Sending frame " + contentFrame + " to " + (Object)((Object)this) + " failed with error [" + errorCode + "]");
                }
            }
        }
    }

    private void sendCurrentPresetPosition(int attributes, long ts) throws UnsupportedEncodingException {
        String currentPresetPosition = this.videoProfileHandler.getLiveCameraSrv().getCurrentPresetPosition();
        if (currentPresetPosition == null || currentPresetPosition.trim().length() <= 0) {
            currentPresetPosition = "";
        }
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><CameraMetadata><CurrentPresetPosition>" + currentPresetPosition + "</CurrentPresetPosition></CameraMetadata>";
        byte[] data = xml.getBytes("UTF-8");
        ContentFrame presetPositionContentFrame = new ContentFrame(66, attributes, ts, ts, data);
        this.contentStream.sendFrame(presetPositionContentFrame, this.transactionID);
    }

    private void sendPtzInfo(int attributes, long ts) throws UnsupportedEncodingException {
        CameraControl cameraControl = this.videoProfileHandler.getLiveCameraSrv().getCameraControl();
        PtzInfo ptzInfo = cameraControl.getPtzInfo();
        if (ptzInfo == null) {
            return;
        }
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><CameraMetadata><AbsolutePTZ><Pan>" + ptzInfo.getPan() + "</Pan><Tilt>" + ptzInfo.getTilt() + "</Tilt><Zoom>" + ptzInfo.getZoom() + "</Zoom></AbsolutePTZ></CameraMetadata>";
        byte[] data = xml.getBytes("UTF-8");
        ContentFrame cf = new ContentFrame(67, attributes, ts, ts, data);
        this.contentStream.sendFrame(cf, this.transactionID);
    }

    public long getJpegFramerate() {
        return this.jpegSpeed;
    }

    public int setFramerate(long nJpegSpeed) {
        this.jpegSpeed = nJpegSpeed;
        return 0;
    }

    private String getMpegSpeed() {
        return this.mpegSpeed;
    }

    public int setMpegSpeed(String sMpegSpeed) {
        this.mpegSpeed = sMpegSpeed.trim().toLowerCase();
        return 0;
    }

    public VideoProfileHandler getVideoProfileHandler() {
        return this.videoProfileHandler;
    }

    public void setVideoProfileHandler(VideoProfileHandler videoProfileHandler) {
        this.videoProfileHandler = videoProfileHandler;
    }

    public void activateLoggingOfCameraLiveUsage(VideoSrv videoSrv, Long userID, String userName) {
        this.loggingOfCameraLiveUsage = true;
        this.managerLoggingOfCameraUsage = videoSrv.getCore().getManagerLoggingOfCameraUsage();
        this.videoSourceID = videoSrv.getEntityID();
        this.userID = userID;
        this.userName = userName;
        this.startOfStreaming = System.currentTimeMillis();
        if (this.loggingOfCameraLiveUsage) {
            this.managerLoggingOfCameraUsage.registerLiveReader(this);
            try {
                if (this.isUserIdSet(this.userID)) {
                    LiveViewEvent liveViewEvent = new LiveViewEvent();
                    liveViewEvent.setActiveDirectoryUser(this.userName);
                    this.getVideoProfileHandler().getLiveCameraSrv().getCore().sendEvent(EventType.MDB_EVENTTYPE_LIVE_START, this.videoSourceID, this.userID, Basic.cutOffRoot((String)Basic.marshalXML((Object)liveViewEvent)).getBytes());
                }
            }
            catch (Exception exception) {
                this.logger.warn("Could not send Event [" + EventType.MDB_EVENTTYPE_LIVE_START + "] because of " + exception + " for " + (Object)((Object)this));
            }
        }
    }

    public Object[] getRecentLoggingOfCameraLiveUsage(Long[] videoSources, Long[] userIDs, String[] userNames, Long startViewingMS, Long endViewingMS) {
        boolean fits;
        this.endOfStreaming = System.currentTimeMillis();
        if (this.startOfStreaming > endViewingMS || this.endOfStreaming < startViewingMS) {
            return null;
        }
        if (videoSources != null && videoSources.length > 0) {
            fits = false;
            for (Long videoSource : videoSources) {
                if (!this.videoSourceID.equals(videoSource)) continue;
                fits = true;
            }
            if (!fits) {
                return null;
            }
        }
        if (userIDs != null && userIDs.length > 0) {
            fits = false;
            for (Long userID1 : userIDs) {
                if (!this.userID.equals(userID1)) continue;
                fits = true;
            }
            if (!fits) {
                return null;
            }
        }
        return new Object[]{this.videoSourceID, this.userID, this.userName, this.startOfStreaming, this.endOfStreaming};
    }

    private boolean isUserIdSet(Long userID) {
        return userID >= 0L;
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.shared.communication.LiveReader@" + Integer.toHexString(((Object)((Object)this)).hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", jpeg speed=[" + this.getJpegFramerate() + "], mpeg speed=[" + this.getMpegSpeed() + "], VideoProfileHandler=[" + this.getVideoProfileHandler() + "], " + this.contentStream + "]";
    }
}

