/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared.communication;

import de.seetec.v5.shared.configuration.database.DMConfigurationOnDatabase;
import de.seetec.v5.shared.util.SeeTecException;

public class FailoverConfiguration {
    private final long failoverId;
    private final boolean isMirroredRecording;

    public FailoverConfiguration(DMConfigurationOnDatabase dmConfigurationOnDatabase) throws SeeTecException {
        if (dmConfigurationOnDatabase == null) {
            throw new SeeTecException(-20002, "DMConfigurationOnDatabase is null");
        }
        long failoverIdFromConfiguration = dmConfigurationOnDatabase.getFailoverID();
        this.failoverId = failoverIdFromConfiguration == 0L ? -1L : failoverIdFromConfiguration;
        this.isMirroredRecording = dmConfigurationOnDatabase.isMirroredRecording();
    }

    public boolean isMirroredRecordingActivated() {
        return this.isFailoverConfigured() && this.isMirroredRecording;
    }

    public boolean isFailoverConfigured() {
        return this.failoverId > 0L;
    }

    public boolean isFailoverChanged(FailoverConfiguration previousFailoverConfiguration) throws SeeTecException {
        if (previousFailoverConfiguration == null) {
            throw new SeeTecException(-20002, "FailoverConfiguration is null");
        }
        return this.getFailoverMdbWriterId() != previousFailoverConfiguration.getFailoverMdbWriterId();
    }

    public String toString() {
        if (this.isMirroredRecordingActivated()) {
            return "Mirrored recording configured on [" + this.getFailoverMdbWriterId() + "]";
        }
        if (this.getFailoverMdbWriterId() < 0L) {
            return "Failover not configured";
        }
        return "Failover configured on [" + this.getFailoverMdbWriterId() + "]";
    }

    public long getFailoverMdbWriterId() {
        return this.failoverId;
    }
}

