/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared.communication;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.shared.communication.DatabaseProxy;
import de.seetec.v5.re.cm.shared.communication.DatabaseReader;
import de.seetec.v5.re.cm.shared.communication.MDBAccessorIntf;
import de.seetec.v5.re.cm.shared.timerange.TimeRangeInfo;
import de.seetec.v5.re.cm.shared.timerange.TimeRangeList;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.re.shared.srpc.ReqGetRecordingInfos;
import de.seetec.v5.re.shared.srpc.ReqStatusContent;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.srpc.re.ReqReadMultipleFrames;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DatabaseReaderImpl
extends Basic
implements DatabaseReader {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.shared.communication.DatabaseReader";
    protected DatabaseProxy databaseProxy = null;
    protected DatabaseProxy failoverMdsProxy = null;
    private Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private MDBAccessorIntf mdbAccessor = null;
    private TimeRangeList recordingInfoList = null;
    private Core core = null;

    public int init(MDBAccessorIntf mdbAccessor, Core core) {
        this.mdbAccessor = mdbAccessor;
        if (this.mdbAccessor == null) {
            return -21601;
        }
        this.core = core;
        if (this.core == null) {
            return -21601;
        }
        DatabaseProxy[] proxies = this.core.createDatabaseProxies(this);
        try {
            if (proxies[0] != null) {
                this.databaseProxy = this.initDatabaseProxy(proxies[0]);
            }
        }
        catch (SeeTecException exception) {
            this.logger.warn("Could not initialize mds proxy: ", (Throwable)exception);
        }
        try {
            if (proxies[1] != null) {
                this.failoverMdsProxy = this.initDatabaseProxy(proxies[1]);
            }
        }
        catch (SeeTecException exception) {
            this.logger.warn("Could not initialize failover mds proxy: ", (Throwable)exception);
        }
        if (this.databaseProxy == null && this.failoverMdsProxy == null) {
            this.logger.error("Creating Database Proxies failed.");
            return -21600;
        }
        return 0;
    }

    private DatabaseProxy initDatabaseProxy(DatabaseProxy databaseProxy) throws SeeTecException {
        String contentName;
        long contentID = this.mdbAccessor.getContentID();
        int errorCode = databaseProxy.openContentForReading(contentID, contentName = this.mdbAccessor.getContentName());
        if (errorCode != 0) {
            databaseProxy.shutdown();
            this.logger.error("Opening content [" + contentID + "]/[" + contentName + "] failed with error [" + errorCode + "] :-(");
            throw new SeeTecException(-21630, "Exception initializing DatabaseProxy");
        }
        return databaseProxy;
    }

    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public int shutdown() {
        int errorCode;
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.databaseProxy != null) {
            errorCode = this.databaseProxy.shutdown();
            if (errorCode != 0) {
                this.logger.warn("Shutting down [" + (Object)((Object)this.databaseProxy) + "] failed with error [" + errorCode + "] :-(");
            }
            this.databaseProxy = null;
        }
        if (this.failoverMdsProxy != null) {
            errorCode = this.failoverMdsProxy.shutdown();
            if (errorCode != 0) {
                this.logger.warn("Shutting down [" + (Object)((Object)this.failoverMdsProxy) + "] failed with error [" + errorCode + "] :-(");
            }
            this.failoverMdsProxy = null;
        }
        return 0;
    }

    public final boolean isValid() {
        if (this.databaseProxy == null || this.databaseProxy.isShutdown()) {
            return false;
        }
        return !this.isShutdown();
    }

    @Override
    public void sendContentStatus(ReqStatusContent reqContentStatus) {
        this.mdbAccessor.sendContentStatus(reqContentStatus);
    }

    @Override
    public int readNextFrame(Integer mediatype, Integer track, Long timestamp, Integer transactionId, List<ContentFrame> frame) {
        TimeRangeList timeRangeList = this.getRecordingInfoList();
        if (timeRangeList == null || timeRangeList.getNextTimeRangeInfo(timestamp) == null) {
            this.logger.info("Cached Recording Infos for reading next packed frame don't match, get new ones from mdb for " + (this.mdbAccessor != null ? Long.valueOf(this.mdbAccessor.getContentID()) : ""));
            timeRangeList = this.getRecordingInfoList(true);
        }
        if (timeRangeList != null && timeRangeList.getNextTimeRangeInfo(timestamp) != null) {
            if (!timeRangeList.getNextTimeRangeInfo(timestamp).isFailover()) {
                return this.databaseProxy.readNextFrame(mediatype, track, timestamp, transactionId, frame);
            }
            return this.failoverMdsProxy.readNextFrame(mediatype, track, timestamp, transactionId, frame);
        }
        if (this.databaseProxy != null) {
            try {
                return this.databaseProxy.readNextFrame(mediatype, track, timestamp, transactionId, frame);
            }
            catch (Throwable t) {
                return -20001;
            }
        }
        return -20001;
    }

    @Override
    public int readPreviousFrame(Integer mediatype, Integer track, Long timestamp, Integer transactionId, List<ContentFrame> frame) {
        TimeRangeList timeRangeList = this.getRecordingInfoList();
        if (timeRangeList == null || timeRangeList.getNextTimeRangeInfo(timestamp) == null) {
            this.logger.info("Cached Recording Infos for reading previous frame don't match, get new ones from mdb for " + (this.mdbAccessor != null ? Long.valueOf(this.mdbAccessor.getContentID()) : ""));
            timeRangeList = this.getRecordingInfoList(true);
        }
        if (timeRangeList != null && timeRangeList.getPreviousTimeRangeInfo(timestamp) != null) {
            if (!timeRangeList.getPreviousTimeRangeInfo(timestamp).isFailover()) {
                return this.databaseProxy.readPreviousFrame(mediatype, track, timestamp, transactionId, frame);
            }
            return this.failoverMdsProxy.readPreviousFrame(mediatype, track, timestamp, transactionId, frame);
        }
        this.logger.warn("Could not read timerange information for reading previous frame. Using productive MDS as fallback ");
        return this.databaseProxy.readPreviousFrame(mediatype, track, timestamp, transactionId, frame);
    }

    @Override
    public ContentFrame[] readMultipleFrames(ReqReadMultipleFrames request) throws SeeTecException {
        ContentFrame[] contentFrames = this.getRecordingInfoList() != null && this.getRecordingInfoList().containsFailoverData() ? this.readMultipleFramesWithFailover(request) : this.databaseProxy.readMultipleFrames(request);
        if (contentFrames != null && contentFrames.length > 0 && this.isForward(request)) {
            ArrayList<ContentFrame> nextContentFrames = new ArrayList<ContentFrame>();
            int errorCode = this.readNextFrame(241, -1, contentFrames[contentFrames.length - 1].getEndTimestamp(), request.getTransactionId(), nextContentFrames);
            if (errorCode == 0) {
                ContentFrame nextContentFrame = (ContentFrame)nextContentFrames.get(2);
                if (request.getTill() > nextContentFrame.getStartTimestamp()) {
                    ArrayList<ContentFrame> contentFrameList = new ArrayList<ContentFrame>(Arrays.asList(contentFrames));
                    contentFrameList.add(nextContentFrame);
                    return contentFrameList.toArray(new ContentFrame[contentFrameList.size()]);
                }
            }
        }
        return contentFrames;
    }

    private boolean isForward(ReqReadMultipleFrames request) {
        return request.getFrom() < request.getTill();
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.shared.communication.DatabaseReader@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", " + this.mdbAccessor + "]";
    }

    private ContentFrame[] readMultipleFramesWithFailover(ReqReadMultipleFrames request) throws SeeTecException {
        TimeRangeInfo nextTimeRangeInfo;
        ContentFrame[] contentFrames;
        TimeRangeInfo timeRangeInfo = this.getTimeRangeInfoAtTimestamp(request.getFrom());
        if (timeRangeInfo == null && (timeRangeInfo = this.getRecordingInfoList().getNextTimeRangeInfo(request.getFrom() + 1L)) == null) {
            return null;
        }
        long tillValue = this.getRecordingInfoList().getStartTimestamp() + timeRangeInfo.getTimestamp() + (long)timeRangeInfo.getLength();
        if (request.getTill() != 0x7FFFFFFFFFFFFFFEL) {
            tillValue = request.getTill();
        }
        ReqReadMultipleFrames reqReadMultipleFrames = new ReqReadMultipleFrames(request.getMediatypes(), request.getTrack(), request.getFrom(), Long.valueOf(tillValue), request.getMaxVolume(), request.getTransactionId(), request.getMilliFps(), request.getPlaybackSpeed());
        ContentFrame[] contentFrameArray = contentFrames = !timeRangeInfo.isFailover() ? this.databaseProxy.readMultipleFrames(reqReadMultipleFrames) : this.failoverMdsProxy.readMultipleFrames(reqReadMultipleFrames);
        if (contentFrames.length == 0 && (nextTimeRangeInfo = this.getRecordingInfoList().getNextTimeRangeInfo(tillValue + 1L)) != null) {
            reqReadMultipleFrames = new ReqReadMultipleFrames(request.getMediatypes(), request.getTrack(), request.getFrom(), Long.valueOf(this.getRecordingInfoList().getStartTimestamp() + nextTimeRangeInfo.getTimestamp() + (long)nextTimeRangeInfo.getLength()), request.getMaxVolume(), request.getTransactionId(), request.getMilliFps(), request.getPlaybackSpeed());
            contentFrames = !nextTimeRangeInfo.isFailover() ? this.databaseProxy.readMultipleFrames(reqReadMultipleFrames) : this.failoverMdsProxy.readMultipleFrames(reqReadMultipleFrames);
        }
        return contentFrames;
    }

    private TimeRangeInfo getTimeRangeInfoAtTimestamp(long absoluteTimestamp) {
        long relativeTimestamp;
        TimeRangeList timeRangeList = this.getRecordingInfoList();
        TimeRangeInfo timeRangeInfo = timeRangeList.getTimeRangeInfoAtTimestamp(relativeTimestamp = timeRangeList.calculateRelativeTimestamp(absoluteTimestamp).longValue());
        if (timeRangeInfo == null) {
            timeRangeList = this.getRecordingInfoList(true);
            relativeTimestamp = timeRangeList.calculateRelativeTimestamp(absoluteTimestamp);
            timeRangeInfo = timeRangeList.getTimeRangeInfoAtTimestamp(relativeTimestamp);
        }
        if (timeRangeInfo == null) {
            this.logger.info("No recording info found at " + new Date(absoluteTimestamp) + " for " + this.mdbAccessor.getContentID());
        }
        return timeRangeInfo;
    }

    private TimeRangeInfo getPreviousTimeRangeInfo(long absoluteTimestamp) {
        TimeRangeList timeRangeList = this.getRecordingInfoList();
        TimeRangeInfo timeRangeInfo = timeRangeList.getPreviousTimeRangeInfo(absoluteTimestamp);
        if (timeRangeInfo == null) {
            timeRangeList = this.getRecordingInfoList(true);
            timeRangeInfo = timeRangeList.getTimeRangeInfoAtTimestamp(absoluteTimestamp);
        }
        if (timeRangeInfo == null) {
            this.logger.info("No recording info found before " + new Date(absoluteTimestamp) + " for " + this.mdbAccessor.getContentID());
        }
        return timeRangeInfo;
    }

    private TimeRangeList getRecordingInfoList() {
        return this.getRecordingInfoList(false);
    }

    private TimeRangeList getRecordingInfoList(boolean retrieveFromMDB) {
        if (this.recordingInfoList == null || retrieveFromMDB) {
            long contentID = this.mdbAccessor.getContentID();
            long cumulationDistance = 5000L;
            long alarmScenarioID = -1L;
            long startTimestamp = -1L;
            long endTimestamp = -1L;
            ReqGetRecordingInfos request = new ReqGetRecordingInfos(Long.valueOf(contentID), Long.valueOf(cumulationDistance), Long.valueOf(alarmScenarioID), Long.valueOf(startTimestamp), Long.valueOf(endTimestamp));
            this.recordingInfoList = this.mdbAccessor.getRecordingInfos(request, retrieveFromMDB, false).getTimeRangeInfo();
        }
        return this.recordingInfoList;
    }

    @Override
    public ContentFrame[] readGOP(ReqReadMultipleFrames request) throws SeeTecException {
        List<ContentFrame> contentFrameList = this.readRequestedGOP(request);
        if (contentFrameList.isEmpty()) {
            ContentFrame futureContentFrame;
            Vector<ContentFrame> futureContentFrameVector = new Vector<ContentFrame>();
            if (this.readNextFrame(241, -1, request.getFrom(), request.getTransactionId(), futureContentFrameVector) != 0) {
                futureContentFrame = new ContentFrame(259, 0, -1L, -1L, new byte[0]);
            } else {
                futureContentFrame = futureContentFrameVector.elementAt(2);
                if (futureContentFrame.isPacked()) {
                    futureContentFrame = futureContentFrame.getNextUnpackedContentFrame(request.getFrom().longValue());
                }
            }
            contentFrameList = this.readGopPreviousToContentFrame(request, futureContentFrame);
        }
        return contentFrameList.toArray(new ContentFrame[contentFrameList.size()]);
    }

    private long readIFrameInfoTimestampFromGOP(ContentFrame[] contentFrames) {
        ContentFrame iframeInfo;
        long resultTimestamp = -1L;
        if (contentFrames != null && (iframeInfo = contentFrames[contentFrames.length - 1]).isIFrameInfo()) {
            resultTimestamp = iframeInfo.getStartTimestamp();
        }
        return resultTimestamp;
    }

    private long readLastRealFrameTimestampFromGoP(ContentFrame[] contentFrames) {
        long resultTimestamp = -1L;
        if (contentFrames != null && contentFrames.length > 1) {
            for (int i = contentFrames.length - 1; i >= 0; --i) {
                ContentFrame frame = contentFrames[i];
                if (frame.isIFrameInfo()) continue;
                resultTimestamp = frame.getStartTimestamp();
                break;
            }
        }
        return resultTimestamp;
    }

    private List<ContentFrame> correctIFrameInfo(long primaryNextFullFrameTimestampAbsolute, long secondaryNextFullFrameTimestampAbsolute, List<ContentFrame> contentFrameList) {
        if (secondaryNextFullFrameTimestampAbsolute != -1L && (primaryNextFullFrameTimestampAbsolute == -1L || secondaryNextFullFrameTimestampAbsolute < primaryNextFullFrameTimestampAbsolute)) {
            contentFrameList.remove(contentFrameList.size() - 1);
            contentFrameList.add(new ContentFrame(259, 0, secondaryNextFullFrameTimestampAbsolute, secondaryNextFullFrameTimestampAbsolute, new byte[0]));
        }
        return contentFrameList;
    }

    private List<ContentFrame> readGopPreviousToContentFrame(ReqReadMultipleFrames request, ContentFrame futureContentFrame) throws SeeTecException {
        ArrayList<ContentFrame> previousContentFrameVector = new ArrayList<ContentFrame>();
        ArrayList<ContentFrame> previousContentFrameList = new ArrayList<ContentFrame>();
        TimeRangeInfo timeRangeInfo = this.getPreviousTimeRangeInfo(request.getFrom());
        if (timeRangeInfo != null) {
            long timestamp = timeRangeInfo.getTimestamp() + this.recordingInfoList.getStartTimestamp();
            long timestampPlusLength = timestamp + (long)timeRangeInfo.getLength();
            if (this.readPreviousFrame(241, -1, timestampPlusLength, request.getTransactionId(), previousContentFrameVector) == 0) {
                ContentFrame pastContentFrame = (ContentFrame)previousContentFrameVector.get(2);
                long requestTimestamp = pastContentFrame.isJpegFrame() ? timestampPlusLength : pastContentFrame.getStartTimestamp();
                ReqReadMultipleFrames reqReadMultipleFrames = new ReqReadMultipleFrames(request.getMediatypes(), request.getTrack(), Long.valueOf(requestTimestamp), Long.valueOf(requestTimestamp << 1), request.getMaxVolume(), request.getTransactionId(), request.getMilliFps(), request.getPlaybackSpeed());
                boolean isFailover = timeRangeInfo.isFailover();
                ContentFrame[] previousGOP = !isFailover ? this.databaseProxy.readMultipleFrames(reqReadMultipleFrames) : this.failoverMdsProxy.readMultipleFrames(reqReadMultipleFrames);
                previousContentFrameList.addAll(Arrays.asList(previousGOP));
                previousContentFrameList.remove(previousContentFrameList.size() - 1);
            }
        }
        previousContentFrameList.add(new ContentFrame(259, 0, futureContentFrame.getStartTimestamp(), futureContentFrame.getEndTimestamp(), new byte[0]));
        return previousContentFrameList;
    }

    private List<ContentFrame> readRequestedGOP(ReqReadMultipleFrames request) throws SeeTecException {
        List<ContentFrame> contentFrameList = new ArrayList<ContentFrame>();
        TimeRangeInfo timeRangeInfo = this.getTimeRangeInfoAtTimestamp(request.getFrom());
        if (timeRangeInfo != null) {
            boolean isFailover = timeRangeInfo.isFailover();
            ContentFrame[] contentFrames = !isFailover ? this.databaseProxy.readMultipleFrames(request) : this.failoverMdsProxy.readMultipleFrames(request);
            long secondaryNextFullFrameTimestampAbsolute = -1L;
            long primaryNextFullFrameTimestampAbsolute = this.readIFrameInfoTimestampFromGOP(contentFrames);
            long primaryNextFullFrameTimestampRelative = this.getRecordingInfoList().calculateRelativeTimestamp(primaryNextFullFrameTimestampAbsolute);
            if (!timeRangeInfo.containsTimestamp(primaryNextFullFrameTimestampRelative)) {
                Vector<ContentFrame> secondaryNextFrame = new Vector<ContentFrame>();
                long lastRealFrameTimestampFromGoP = this.readLastRealFrameTimestampFromGoP(contentFrames);
                if (lastRealFrameTimestampFromGoP != -1L && this.readNextFrame(241, -1, lastRealFrameTimestampFromGoP + 1L, request.getTransactionId(), secondaryNextFrame) == 0) {
                    ContentFrame contentFrame = secondaryNextFrame.elementAt(2);
                    if (contentFrame.isPacked()) {
                        contentFrame = contentFrame.getNextUnpackedContentFrame(lastRealFrameTimestampFromGoP + 1L);
                    }
                    secondaryNextFullFrameTimestampAbsolute = contentFrame.getStartTimestamp();
                }
            }
            contentFrameList.addAll(Arrays.asList(contentFrames));
            contentFrameList = this.correctIFrameInfo(primaryNextFullFrameTimestampAbsolute, secondaryNextFullFrameTimestampAbsolute, contentFrameList);
        }
        return contentFrameList;
    }
}

