/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared.communication;

import de.seetec.v5.re.cm.ConfigurationProvider;
import de.seetec.v5.re.cm.DeviceManagerStatistic;
import de.seetec.v5.re.cm.shared.communication.ContentTransportQueueArchiveFrames;
import de.seetec.v5.re.cm.shared.communication.ContentTransportQueueDeliveryStatistics;
import de.seetec.v5.re.cm.shared.communication.ContentTransportQueueEntry;
import de.seetec.v5.re.cm.shared.communication.NetworkClientProxy;
import de.seetec.v5.re.cm.shared.communication.TransactionID;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.Basic;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ContentTransportQueue
extends Basic {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.shared.communication.ContentTransportQueue";
    private static final int MaxQueueSize = 32768;
    private static final int HEADERSIZE = 26;
    private Logger logger = null;
    private long sessionID = -1L;
    private List<ContentTransportQueueEntry> vCTQEntries = new Vector<ContentTransportQueueEntry>();
    private List<ContentTransportQueueArchiveFrames> listArchiveFrames = new Vector<ContentTransportQueueArchiveFrames>();
    private InetAddress iHost = null;
    private int port = -1;
    private DatagramPacket datagramPacket = null;
    private byte[] udpPacket;
    private final int udpDataSize;
    private boolean discardingPFrames = true;
    private NetworkClientProxy networkClientProxy = null;
    private ContentTransportQueueDeliveryStatistics deliveryStatistics = null;
    private volatile long tsLastTryToSend = System.currentTimeMillis();
    private int cfCounterUDP = -1;
    private int cfCounterTCP = -1;
    private int previousCFCounterUDP = -1;
    private int previousCFCounterTCP = -1;

    public ContentTransportQueue(ConfigurationProvider configurationProvider) {
        this.logger = LogManager.getLogger((String)((Object)((Object)this)).getClass().getName());
        this.udpPacket = new byte[64000];
        try {
            if (configurationProvider.getDMConfigurationFromFile().getUdpPacketSize() > 0) {
                this.udpPacket = new byte[configurationProvider.getDMConfigurationFromFile().getUdpPacketSize()];
                this.logger.info("Custom UDP packet size '" + this.udpPacket.length + "' set.");
            }
        }
        catch (Exception e) {
            this.logger.debug("No custom UDP packet size set.");
        }
        this.udpDataSize = this.udpPacket.length - 26;
    }

    public int init(NetworkClientProxy networkClientProxy, InetAddress iHost, int port, long sessionID, DeviceManagerStatistic deviceManagerStatistic) {
        this.networkClientProxy = networkClientProxy;
        if (this.networkClientProxy == null) {
            throw new RuntimeException("Implementation error: Paramter [NetworkClientProxy] is [null]!");
        }
        this.iHost = iHost;
        if (this.iHost == null) {
            throw new RuntimeException("Implementation error: Paramter [Host] is [null]!");
        }
        this.port = port;
        if (this.port <= 0 || port >= 65535) {
            throw new RuntimeException("Implementation error: Paramter [Port]==[" + port + "] is invalid!");
        }
        this.sessionID = sessionID;
        if (this.sessionID < 0L) {
            throw new RuntimeException("Implementation error: Paramter [SessionID]==[" + sessionID + "] is invalid!");
        }
        this.datagramPacket = new DatagramPacket(this.udpPacket, this.udpPacket.length, iHost, port);
        this.deliveryStatistics = new ContentTransportQueueDeliveryStatistics(256, deviceManagerStatistic);
        return 0;
    }

    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return 0;
    }

    public long getSessionID() {
        return this.sessionID;
    }

    public int putArchiveFrames(short transactionID, ContentFrame[] contentFrames, long reqFrom, long reqTo, boolean containsLastFrame) {
        this.listArchiveFrames.add(new ContentTransportQueueArchiveFrames(transactionID, contentFrames, reqFrom, reqTo, containsLastFrame));
        return 0;
    }

    public int putContentFrame(boolean privileged, long tsWishToSend, ContentFrame[] contentFrames, boolean isSingleFrameStreaming, short transactionID, boolean isAudioTransmission) {
        return this.putContentFrame(privileged, tsWishToSend, contentFrames, isSingleFrameStreaming, transactionID, isAudioTransmission, 0xC00000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int putContentFrame(boolean privileged, long tsWishToSend, ContentFrame[] contentFrames, boolean isSingleFrameStreaming, short transactionID, boolean isAudioTransmission, long maxVolume) {
        if (System.currentTimeMillis() - this.tsLastTryToSend > 120000L) {
            this.logger.error("Seems to be no attempt to send frames, so shutting down --> " + (Object)((Object)this));
            this.networkClientProxy.shutdown();
            this.isShutdown();
            throw new RuntimeException("Seams to be no attempt to send frames, so shutting down --> " + (Object)((Object)this));
        }
        long tsStart = -1L;
        for (ContentFrame cf : contentFrames) {
            if (tsStart < 0L) {
                tsStart = cf.getStartTimestamp();
                continue;
            }
            if (tsStart > cf.getStartTimestamp()) {
                this.logger.info("Disordering detected for " + (Object)((Object)this));
                for (ContentFrame tmp : contentFrames) {
                    this.logger.info("   " + tmp);
                }
                break;
            }
            tsStart = cf.getStartTimestamp();
        }
        List<ContentTransportQueueEntry> list = this.vCTQEntries;
        synchronized (list) {
            for (ContentFrame contentFrame : contentFrames) {
                boolean bDiscardAllVideoFrames;
                ContentFrame cf;
                if (privileged) {
                    this.vCTQEntries.add(new ContentTransportQueueEntry(privileged, tsWishToSend, contentFrame, isSingleFrameStreaming, transactionID, maxVolume));
                    continue;
                }
                if (contentFrame != null && contentFrame.getMediatype() == 16 && !isAudioTransmission) continue;
                if (contentFrame.getMediatype() == 33 || contentFrame.getMediatype() == 0) {
                    boolean discardQueue = false;
                    if (Math.abs(contentFrame.getEndTimestamp() - System.currentTimeMillis()) < 1000L) {
                        int countFullVideoFrames = 0;
                        for (int i = 0; i < this.vCTQEntries.size(); ++i) {
                            cf = this.vCTQEntries.get(i).getContentFrame();
                            if (cf.getMediatype() != 33 && cf.getMediatype() != 0 || ++countFullVideoFrames <= 64) continue;
                            this.logger.info("Too many live full video frames queued, so only using recent one!");
                            discardQueue = true;
                            break;
                        }
                    }
                    if (this.vCTQEntries.size() > 8192) {
                        discardQueue = true;
                        this.logger.warn("Suspicious size [" + this.vCTQEntries.size() + "] for output queue to " + this.networkClientProxy);
                    }
                    if (discardQueue) {
                        for (int i = 0; i < this.vCTQEntries.size(); ++i) {
                            ContentFrame cf2 = this.vCTQEntries.get(i).getContentFrame();
                            this.deliveryStatistics.notifyFrameDiscarded(System.currentTimeMillis(), cf2.getFrameSize(), cf2.getMediatype());
                        }
                        this.vCTQEntries.clear();
                    }
                }
                boolean bl = bDiscardAllVideoFrames = this.vCTQEntries.size() > 32768;
                if (bDiscardAllVideoFrames) {
                    this.discardingPFrames = true;
                }
                if (bDiscardAllVideoFrames) {
                    for (int i = this.vCTQEntries.size() - 1; i >= 0; --i) {
                        ContentTransportQueueEntry entry = this.vCTQEntries.get(i);
                        cf = entry.getContentFrame();
                        if (entry.isPrivileged() || cf.getMediatype() != 0 && cf.getMediatype() != 33 && cf.getMediatype() != 35) continue;
                        this.deliveryStatistics.notifyFrameDiscarded(System.currentTimeMillis(), cf.getData().length, cf.getMediatype());
                        cf = null;
                        this.vCTQEntries.remove(i);
                    }
                }
                if ((bDiscardAllVideoFrames || this.discardingPFrames) && contentFrame.getMediatype() == 35) {
                    this.deliveryStatistics.notifyFrameDiscarded(System.currentTimeMillis(), contentFrame.getData().length, contentFrame.getMediatype());
                    contentFrame = null;
                    continue;
                }
                if (!(privileged || contentFrame.getMediatype() != 0 && contentFrame.getMediatype() != 33 && contentFrame.getMediatype() != 35)) {
                    long deliveryRatio = this.deliveryStatistics.getShortRangeRatio(contentFrame);
                    if (deliveryRatio > this.deliveryStatistics.getDatarateRatio()) {
                        this.discardingPFrames = true;
                        this.deliveryStatistics.notifyFrameDiscarded(System.currentTimeMillis(), contentFrame.getData().length, contentFrame.getMediatype());
                        contentFrame = null;
                        continue;
                    }
                    deliveryRatio = this.deliveryStatistics.getLongRangeRatio(contentFrame);
                    if (deliveryRatio > this.deliveryStatistics.getDatarateRatio()) {
                        this.discardingPFrames = true;
                        this.deliveryStatistics.notifyFrameDiscarded(System.currentTimeMillis(), contentFrame.getData().length, contentFrame.getMediatype());
                        contentFrame = null;
                        continue;
                    }
                }
                if (contentFrame.getMediatype() == 0 || contentFrame.getMediatype() == 33) {
                    this.discardingPFrames = false;
                }
                this.vCTQEntries.add(new ContentTransportQueueEntry(privileged, tsWishToSend, contentFrame, isSingleFrameStreaming, transactionID, maxVolume));
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendContentFrame(DatagramSocket udpSocket) throws IOException {
        this.tsLastTryToSend = System.currentTimeMillis();
        TransactionID transactionID = new TransactionID(0);
        byte[] transmissionFrame = this.createTransmissionFrame(transactionID);
        if (transmissionFrame == null) {
            transmissionFrame = this.createArchiveTransmissionFrame(transactionID);
        }
        if (transmissionFrame != null && transmissionFrame.length > 0) {
            DatagramPacket datagramPacket = this.datagramPacket;
            synchronized (datagramPacket) {
                long tsTransmissionStart = System.currentTimeMillis();
                ++this.cfCounterUDP;
                for (int i = 0; i < transmissionFrame.length; i += this.udpDataSize) {
                    int count;
                    byte[] nextUdpPacket = null;
                    nextUdpPacket = i + this.udpDataSize < transmissionFrame.length ? this.udpPacket : new byte[transmissionFrame.length - i + 26];
                    Basic.int4ToByteArray((int)1592257553, (byte[])nextUdpPacket, (int)0, (int)4);
                    Basic.int8ToByteArray((long)this.sessionID, (byte[])nextUdpPacket, (int)4, (int)8);
                    Basic.int8ToByteArray((long)transactionID.getTransactionID(), (byte[])nextUdpPacket, (int)12, (int)2);
                    Basic.int8ToByteArray((long)this.cfCounterUDP, (byte[])nextUdpPacket, (int)14, (int)4);
                    Basic.int4ToByteArray((int)transmissionFrame.length, (byte[])nextUdpPacket, (int)18, (int)4);
                    Basic.int4ToByteArray((int)i, (byte[])nextUdpPacket, (int)22, (int)4);
                    System.arraycopy(transmissionFrame, i, nextUdpPacket, 26, nextUdpPacket.length - 26);
                    this.datagramPacket.setData(nextUdpPacket);
                    if (this.logger.isDebugEnabled() && (count = this.countOccurrenceOfByteArray(nextUdpPacket, Basic.int4ToByteArray((int)1592257601))) > 1) {
                        this.logger.warn("This current transmissionFrame includes to many MediaFrames for Live Streaming: #" + count);
                    }
                    udpSocket.send(this.datagramPacket);
                }
                if (this.cfCounterUDP - this.previousCFCounterUDP != 1) {
                    this.logger.error("Previous content frame number: " + this.previousCFCounterUDP + " , current content frame counter: " + this.cfCounterUDP);
                }
                this.previousCFCounterUDP = this.cfCounterUDP;
                long transmissionTime = System.currentTimeMillis() - tsTransmissionStart;
                if (transmissionTime > 999L) {
                    this.logger.info("TransmissionTime for [" + Basic.longToFormattedString((long)transmissionFrame.length) + " B]=[" + Basic.longToFormattedString((long)transmissionTime) + " ms], this=" + (Object)((Object)this));
                }
            }
            return transmissionFrame.length;
        }
        return 0;
    }

    private int countOccurrenceOfByteArray(byte[] buffer, byte[] pattern) {
        int count = 0;
        int indexOfByteArray = ContentTransportQueue.indexOfByteArray((byte[])buffer, (byte[])pattern, (int)0);
        while (indexOfByteArray > 0) {
            ++count;
            indexOfByteArray = ContentTransportQueue.indexOfByteArray((byte[])buffer, (byte[])pattern, (int)indexOfByteArray);
        }
        return count;
    }

    public int sendContentFrame(OutputStream os) throws IOException {
        this.tsLastTryToSend = System.currentTimeMillis();
        TransactionID transactionID = new TransactionID(0);
        byte[] transmissionFrame = this.createTransmissionFrame(transactionID);
        if (transmissionFrame == null) {
            transmissionFrame = this.createArchiveTransmissionFrame(transactionID);
        }
        if (transmissionFrame != null && transmissionFrame.length > 0) {
            int count;
            long tsTransmissionStart = System.currentTimeMillis();
            ++this.cfCounterTCP;
            byte[] tcpPacket = new byte[26 + transmissionFrame.length];
            Basic.int4ToByteArray((int)1592257553, (byte[])tcpPacket, (int)0, (int)4);
            Basic.int8ToByteArray((long)this.sessionID, (byte[])tcpPacket, (int)4, (int)8);
            Basic.int8ToByteArray((long)transactionID.getTransactionID(), (byte[])tcpPacket, (int)12, (int)2);
            Basic.int8ToByteArray((long)this.cfCounterTCP, (byte[])tcpPacket, (int)14, (int)4);
            Basic.int4ToByteArray((int)transmissionFrame.length, (byte[])tcpPacket, (int)18, (int)4);
            Basic.int4ToByteArray((int)0, (byte[])tcpPacket, (int)22, (int)4);
            System.arraycopy(transmissionFrame, 0, tcpPacket, 26, tcpPacket.length - 26);
            if (tcpPacket.length >= 10000000) {
                this.logger.info("---------[ MulticontentFrame TCP ]-----------------------");
                this.logger.info("   transmissionFrame.length=[" + Basic.longToFormattedString((long)transmissionFrame.length) + " B]");
                this.logger.info("   tcpPacket.length=[" + Basic.longToFormattedString((long)tcpPacket.length) + " B]");
            }
            if (this.logger.isDebugEnabled() && (count = this.countOccurrenceOfByteArray(tcpPacket, Basic.int4ToByteArray((int)1592257601))) > 1) {
                this.logger.warn("This current transmissionFrame includes to many MediaFrames for Live Streaming: #" + count);
            }
            os.write(tcpPacket);
            if (this.cfCounterTCP - this.previousCFCounterTCP != 1) {
                this.logger.error("Previous content frame number: " + this.previousCFCounterTCP + " , current content frame counter: " + this.cfCounterTCP);
            }
            this.previousCFCounterTCP = this.cfCounterTCP;
            long transmissionTime = System.currentTimeMillis() - tsTransmissionStart;
            if (transmissionTime > 999L) {
                this.logger.info("TransmissionTime for [" + Basic.longToFormattedString((long)transmissionFrame.length) + " B]=[" + Basic.longToFormattedString((long)transmissionTime) + " ms], this=" + (Object)((Object)this));
            }
            return transmissionFrame.length;
        }
        return 0;
    }

    public long getTimeBasedLength() {
        try {
            if (this.vCTQEntries.size() > 0) {
                long fts = this.vCTQEntries.get(0).getContentFrame().getStartTimestamp();
                if (fts > 0L) {
                    return System.currentTimeMillis() - fts;
                }
                this.logger.info("Queue empty for " + (Object)((Object)this));
            }
        }
        catch (Throwable t) {
            this.logger.warn("Trouble determing time based length for " + (Object)((Object)this));
        }
        return 0L;
    }

    public long getDatarate() {
        return this.deliveryStatistics.getSendDatarate();
    }

    public long getFullDatarate(long timerange) {
        return this.deliveryStatistics.getFullDatarate(timerange);
    }

    public void setDatarateRatio(long datarateRatio) {
        if (datarateRatio < 0L) {
            throw new RuntimeException("Invalid argument [DatarateRatio]==[" + datarateRatio + "] for " + (Object)((Object)this));
        }
        this.deliveryStatistics.setDatarateRatio(datarateRatio);
    }

    public void setBandwidthLimitation(int bandwidthLimitation) {
        this.networkClientProxy.setBandwidthLimitation(bandwidthLimitation);
    }

    public void notifyForStoppedStreaming() {
        if (this.deliveryStatistics != null) {
            this.deliveryStatistics.notifyForStoppedStreaming();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] createArchiveTransmissionFrame(TransactionID transactionID) {
        List<ContentTransportQueueArchiveFrames> list = this.listArchiveFrames;
        synchronized (list) {
            if (this.listArchiveFrames.size() <= 0) {
                return null;
            }
            ContentTransportQueueArchiveFrames archiveFrames = this.listArchiveFrames.remove(0);
            ContentFrame[] contentFrames = archiveFrames.getContentFrames();
            transactionID.setTransactionID(archiveFrames.getTransactionID());
            try {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                if (contentFrames != null && contentFrames.length > 0) {
                    long startTimeStampFirstContentFrame = contentFrames[0].getStartTimestamp();
                    long startTimeStampLastContentFrame = contentFrames[contentFrames.length - 1].getStartTimestamp();
                    buffer.write(Basic.int4ToByteArray((int)1592257569));
                    buffer.write(Basic.int8ToByteArray((long)startTimeStampFirstContentFrame));
                    buffer.write(Basic.int8ToByteArray((long)startTimeStampLastContentFrame));
                    if (archiveFrames.getContainsLastFrame()) {
                        buffer.write(1);
                    } else {
                        buffer.write(0);
                    }
                    for (ContentFrame cf : contentFrames) {
                        try {
                            buffer.write(cf.createTransmissionFrame());
                        }
                        catch (Exception exception) {
                            this.logger.error(exception.getClass().getName() + " while createTransmissionFrame: " + exception.getMessage() + " for " + cf.toString());
                        }
                    }
                    long timerange = startTimeStampLastContentFrame - startTimeStampFirstContentFrame;
                    this.logger.debug("Delivering [" + contentFrames.length + "] archive frames with volume=[" + Basic.longToFormattedString((long)buffer.size()) + " B] and timerange=[" + Basic.longToFormattedString((long)timerange) + " ms] for TransactionID=[" + transactionID.getTransactionID() + "]");
                    this.logger.debug("   FirstFrame : " + contentFrames[0]);
                    this.logger.debug("   LastFrame  : " + contentFrames[contentFrames.length - 1]);
                } else {
                    buffer.write(Basic.int4ToByteArray((int)1592257569));
                    buffer.write(Basic.int8ToByteArray((long)archiveFrames.getRequestedTimerangeFrom()));
                    buffer.write(Basic.int8ToByteArray((long)archiveFrames.getRequestedTimerangeTo()));
                    buffer.write(1);
                    this.logger.info("No archive frames to deliver for TransactionID=[" + transactionID.getTransactionID() + "]");
                }
                return buffer.toByteArray();
            }
            catch (IOException ex) {
                this.logger.error("Exception while creating Multiple Frames for " + (Object)((Object)this));
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] createTransmissionFrame(TransactionID transactionID) {
        boolean multiframe = false;
        int contentFramesSize = 0;
        List<ContentTransportQueueEntry> list = this.vCTQEntries;
        synchronized (list) {
            for (ContentTransportQueueEntry contentTransportQueueEntry : this.vCTQEntries) {
                if (contentTransportQueueEntry.isLastFrame()) {
                    transactionID.setTransactionID(contentTransportQueueEntry.getTransactionID());
                    this.vCTQEntries.remove(contentTransportQueueEntry);
                    return this.createEmptyMultiContentFrame();
                }
                if (contentTransportQueueEntry.getWishToSend() > System.currentTimeMillis()) continue;
                transactionID.setTransactionID(contentTransportQueueEntry.getTransactionID());
                if (contentTransportQueueEntry.isIsSingleFrame()) {
                    ContentFrame cf = contentTransportQueueEntry.getContentFrame();
                    this.vCTQEntries.remove(contentTransportQueueEntry);
                    this.deliveryStatistics.notifyFrameSent(System.currentTimeMillis(), contentTransportQueueEntry.getContentFrameSize() + 26, contentTransportQueueEntry.getContentFrame().getMediatype());
                    return cf.createTransmissionFrame();
                }
                multiframe = true;
                break;
            }
            if (multiframe) {
                ArrayList<ContentTransportQueueEntry> contentFrames = new ArrayList<ContentTransportQueueEntry>();
                for (ContentTransportQueueEntry ctqEntry : this.vCTQEntries) {
                    if (ctqEntry.getWishToSend() <= System.currentTimeMillis() && !ctqEntry.isIsSingleFrame() && ctqEntry.getTransactionID() == transactionID.getTransactionID()) {
                        contentFrames.add(ctqEntry);
                        this.deliveryStatistics.notifyFrameSent(System.currentTimeMillis(), ctqEntry.getContentFrameSize() + 26, ctqEntry.getContentFrame().getMediatype());
                        if ((long)(contentFramesSize += ctqEntry.getContentFrameSize()) > ctqEntry.getMaxVolume()) {
                            this.logger.info("Sending packet. Limit of [" + Basic.longToFormattedString((long)(ctqEntry.getMaxVolume() >> 10)) + " KB] size reached for " + (Object)((Object)this));
                        }
                    } else if (ctqEntry.isIsSingleFrame() && ctqEntry.getTransactionID() == transactionID.getTransactionID()) {
                        this.logger.info("Sending one more single frame. Transaction id: " + transactionID);
                    }
                    ctqEntry = null;
                }
                if (!contentFrames.isEmpty()) {
                    for (ContentTransportQueueEntry ctqEntry : contentFrames) {
                        this.vCTQEntries.remove(ctqEntry);
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(contentFramesSize);
                    long startTimeStampFirstContentFrame = ((ContentTransportQueueEntry)contentFrames.get(0)).getContentFrame().getStartTimestamp();
                    long startTimeStampLastContentFrame = ((ContentTransportQueueEntry)contentFrames.get(contentFrames.size() - 1)).getContentFrame().getStartTimestamp();
                    try {
                        byteArrayOutputStream.write(Basic.int4ToByteArray((int)1592257569));
                        byteArrayOutputStream.write(Basic.int8ToByteArray((long)startTimeStampFirstContentFrame));
                        byteArrayOutputStream.write(Basic.int8ToByteArray((long)startTimeStampLastContentFrame));
                        byteArrayOutputStream.write(0);
                        long timerange = startTimeStampLastContentFrame - startTimeStampFirstContentFrame;
                        this.logger.debug("Delivering [" + contentFrames.size() + "] frames with [" + Basic.longToFormattedString((long)timerange) + " ms] for transaction id [" + transactionID.getTransactionID() + "]");
                        this.logger.debug("   FirstFrame : " + ((ContentTransportQueueEntry)contentFrames.get(0)).getContentFrame());
                        this.logger.debug("   LastFrame  : " + ((ContentTransportQueueEntry)contentFrames.get(contentFrames.size() - 1)).getContentFrame());
                        for (int i = 0; i < contentFrames.size(); ++i) {
                            byteArrayOutputStream.write(((ContentTransportQueueEntry)contentFrames.get(i)).getContentFrame().createTransmissionFrame());
                        }
                    }
                    catch (IOException ex) {
                        this.logger.error("Exception while creating Multiple Frames for " + (Object)((Object)this));
                        return null;
                    }
                    return byteArrayOutputStream.toByteArray();
                }
            }
            return null;
        }
    }

    private byte[] createEmptyMultiContentFrame() {
        ByteArrayOutputStream transmissionFrame = new ByteArrayOutputStream();
        try {
            transmissionFrame.write(Basic.int4ToByteArray((int)1592257569));
            transmissionFrame.write(Basic.int8ToByteArray((long)System.currentTimeMillis()));
            transmissionFrame.write(Basic.int8ToByteArray((long)System.currentTimeMillis()));
            transmissionFrame.write(1);
        }
        catch (IOException ex) {
            return null;
        }
        return transmissionFrame.toByteArray();
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.shared.communication.ContentTransportQueue@" + Integer.toHexString(((Object)((Object)this)).hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", [" + this.iHost + ":" + this.port + "], Session=[" + Basic.longToFormattedString((long)this.sessionID) + "], Entries=[" + Basic.longToFormattedString((long)this.vCTQEntries.size()) + "], " + this.deliveryStatistics + "]";
    }

    public NetworkClientProxy getNetworkClientProxy() {
        return this.networkClientProxy;
    }

    public int getUdpPacketSize() {
        return this.udpPacket.length;
    }
}

