/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared.communication;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.shared.communication.DatabaseWriter;
import de.seetec.v5.re.cm.shared.communication.DatabaseWriterRepository;
import de.seetec.v5.re.cm.shared.communication.DatabaseWriterType;
import de.seetec.v5.re.cm.shared.communication.MDBAccessorIntf;
import de.seetec.v5.re.cm.shared.communication.MDBWriterFactoryImpl;
import de.seetec.v5.re.cm.shared.communication.RecordingHandlerListener;
import de.seetec.v5.shared.Basic;
import org.apache.logging.log4j.Logger;

public class BaseRecordingHandler
extends Basic {
    protected static final String CLASS_NAME = "de.seetec.v5.re.cm.shared.communication.BaseRecordingHandler";
    private final Object DATABASEWRITER_SEMAPHORE = new Object();
    protected Logger logger = null;
    protected Core core = null;
    protected MDBAccessorIntf mdbAccessor = null;
    protected long contentId = -1L;
    private DatabaseWriter databaseWriter = null;
    private RecordingHandlerListener recordingHandlerListener = null;

    public int init(Core core, MDBAccessorIntf mdbAccessor, RecordingHandlerListener recordingHandlerListener) {
        int errorCode = 0;
        this.mdbAccessor = mdbAccessor;
        if (this.mdbAccessor == null) {
            return -21601;
        }
        this.core = core;
        if (this.core == null) {
            return -21601;
        }
        this.contentId = this.mdbAccessor.getContentID();
        this.recordingHandlerListener = recordingHandlerListener;
        return errorCode;
    }

    public int shutdown() {
        int errorCode = 0;
        if (this.databaseWriter != null) {
            errorCode = this.databaseWriter.shutdown();
            if (errorCode != 0) {
                this.logger.warn("Shutting down " + this.databaseWriter + " of " + (Object)((Object)this) + " failed with error [" + errorCode + "]");
            }
            this.databaseWriter = null;
        }
        return errorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final DatabaseWriter getDatabaseWriter(boolean additionalAlarmRecordingEnabled, DatabaseWriterType databaseWriterType) {
        int errorCode = 0;
        Object object = this.DATABASEWRITER_SEMAPHORE;
        synchronized (object) {
            if (this.databaseWriter != null && !this.databaseWriter.isShutdown()) {
                return this.databaseWriter;
            }
            if (this.core != null && this.core.isShutdown()) {
                this.logger.warn((Object)((Object)this.core) + " is already shutting down!");
                return null;
            }
            if (this.isShutdown(CLASS_NAME)) {
                this.logger.warn((Object)((Object)this) + " is already shutting down!");
                return null;
            }
            try {
                MDBWriterFactoryImpl mdbWriterFactory = new MDBWriterFactoryImpl(additionalAlarmRecordingEnabled, this.core, this.mdbAccessor, databaseWriterType);
                this.databaseWriter = new DatabaseWriterRepository(this.core.getConfigurationProvider(), mdbWriterFactory);
                this.databaseWriter.init();
            }
            catch (Exception e) {
                if (this.databaseWriter != null) {
                    this.databaseWriter.shutdown();
                }
                this.logger.error("Connecting MultimediaDatabase failed with error [" + errorCode + "] ");
                throw new RuntimeException("Initializing [LocalStorageDatabaseWriter] failed with error [" + errorCode + "] ");
            }
            if (this.recordingHandlerListener != null) {
                this.recordingHandlerListener.notifyNewDatabaseWriterCreated();
            }
        }
        return this.databaseWriter;
    }
}

