/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.Service;
import de.seetec.v5.re.cm.shared.TCPAlarmSrvCnf;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class TCPAlarmSrv
extends Service
implements Runnable {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.shared.TCPAlarmSrv";
    private TCPAlarmSrvCnf srvCnf = null;
    private int tcpPort = -1;
    private long deadTime = -1L;
    private Thread myThread = null;
    private ServerSocket serverSocket = null;

    @Override
    public int init(Core core, Device device, Entity entity) {
        int errorCode = super.init(core, device, entity);
        if (errorCode != 0) {
            return errorCode;
        }
        this.srvCnf = new TCPAlarmSrvCnf();
        errorCode = this.srvCnf.init(entity);
        if (errorCode != 0) {
            return errorCode;
        }
        try {
            this.tcpPort = this.srvCnf.getTCPPort();
            this.deadTime = this.srvCnf.getDeadTime();
        }
        catch (ConfigurationException cex) {
            this.logger.error("Invalid configuration of " + this);
            return -21602;
        }
        try {
            this.serverSocket = new ServerSocket(this.tcpPort);
        }
        catch (IOException ioex) {
            this.logger.error("Cannot bind to port [" + this.tcpPort + "]", (Throwable)ioex);
            return -21610;
        }
        errorCode = this.getCore().registerEntity(entity.getEntityID(), entity.getEntityType());
        if (errorCode != 0) {
            this.logger.error("Registering service " + entity + " failed with error [" + errorCode + "]");
            return errorCode;
        }
        try {
            this.getCore().setEntityStatus(entity.getEntityID(), 0);
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
        }
        this.myThread = new Thread((Runnable)this, this.toString());
        this.myThread.start();
        this.logger.info(this + " started at port [" + this.tcpPort + "] ...");
        return 0;
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (Throwable ex) {
                this.logger.warn((Object)ex, ex);
            }
            this.serverSocket = null;
        }
        if (this.myThread != null) {
            long timeout = System.currentTimeMillis() + 30000L;
            while (!super.isRunFinished(CLASS_NAME)) {
                if (System.currentTimeMillis() > timeout) {
                    this.logger.warn("Thread of " + this + " didn't finished in time :-(");
                    break;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.myThread = null;
        }
        return super.shutdown();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        long lastAlarm = -1L;
        Socket socket = null;
        try {
            while (!this.isShutdown(CLASS_NAME)) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    socket = this.serverSocket.accept();
                    if (!this.isShutdown(CLASS_NAME) && !this.getCore().isShutdown()) {
                        if (lastAlarm + this.deadTime > System.currentTimeMillis()) {
                            this.logger.info("Alarm [" + socket + "] is within dead time and will be ignored");
                        } else {
                            lastAlarm = System.currentTimeMillis();
                            this.logger.info("New alarm triggered by [" + socket + "] for " + this.device + " ...");
                            this.sendEvent();
                        }
                        socket.close();
                    }
                    break;
                }
                catch (Throwable ex) {
                    if (socket == null) continue;
                    try {
                        socket.close();
                        socket = null;
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    private int sendEvent() {
        long sourceID = this.srvCnf.getEntity().getEntityID();
        this.logger.info("Event of source [" + sourceID + "] from " + this);
        return super.getCore().sendApplicationEvent(sourceID);
    }

    @Override
    public int checkService() {
        return 0;
    }

    @Override
    public String toString() {
        String sThis = "de.seetec.v5.re.cm.shared.TCPAlarmSrv@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", TCPPort=[" + this.tcpPort + "], DeadTime=[" + Basic.longToFormattedString((long)this.deadTime) + " ms]]";
    }
}

