/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared;

import de.seetec.v5.re.shared.ConfigurationElement;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class StatisticalData {
    private static final Logger LOGGER = LogManager.getLogger((String)StatisticalData.class.getName());
    private static Document statsDataPaket = null;
    private long milliFPSVideoPerSecond = Long.MIN_VALUE;
    private long milliFPSAudioPerSecond = Long.MIN_VALUE;
    private long bitVideoPerSecond = Long.MIN_VALUE;
    private long bitAudioPerSecond = Long.MIN_VALUE;
    private long paketLossRatio = Long.MIN_VALUE;
    private long maxVideoJitter = Long.MIN_VALUE;

    private StatisticalData(long milliFPSVideoPerSecond, long milliFPSAudioPerSecond, long bitVideoPerSecond, long bitAudioPerSecond, long paketLossRatio, long maxVideoJitter) {
        this.milliFPSVideoPerSecond = milliFPSVideoPerSecond;
        this.milliFPSAudioPerSecond = milliFPSAudioPerSecond;
        this.bitVideoPerSecond = bitVideoPerSecond;
        this.bitAudioPerSecond = bitAudioPerSecond;
        this.paketLossRatio = paketLossRatio;
        this.maxVideoJitter = maxVideoJitter;
    }

    public static byte[] createStatisticalData(long milliFPSVideoPerSecond, long milliFPSAudioPerSecond, long bitVideoPerSecond, long bitAudioPerSecond, long paketLossRatio, long maxVideoJitter) throws UnsupportedEncodingException {
        XMLOutputter outputter = new XMLOutputter("   ", true);
        Element eRoot = new Element("StatisticalData");
        eRoot.addContent(new Element("FpsVideo").setText(String.format("%d", milliFPSVideoPerSecond)));
        eRoot.addContent(new Element("FpsAudio").setText(String.format("%d", milliFPSAudioPerSecond)));
        eRoot.addContent(new Element("BiTVideo").setText(String.format("%d", bitVideoPerSecond)));
        eRoot.addContent(new Element("BiTAudio").setText(String.format("%d", bitAudioPerSecond)));
        eRoot.addContent(new Element("PaketLossRatio").setText(String.format("%d", paketLossRatio)));
        eRoot.addContent(new Element("MaxJitter").setText(String.format("%d", maxVideoJitter)));
        statsDataPaket = new Document(eRoot);
        return outputter.outputString(statsDataPaket).getBytes("UTF-8");
    }

    public static StatisticalData parseStatisticalData(byte[] data) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            statsDataPaket = new SAXBuilder().build((InputStream)bais);
            ConfigurationElement confElement = new ConfigurationElement(statsDataPaket.getRootElement());
            return new StatisticalData(confElement.getChild("FpsVideo").getAsInt8(), confElement.getChild("FpsAudio").getAsInt8(), confElement.getChild("BiTVideo").getAsInt8(), confElement.getChild("BiTAudio").getAsInt8(), confElement.getChild("PaketLossRatio").getAsInt8(), confElement.getChild("MaxJitter").getAsInt8());
        }
        catch (Exception ex) {
            LOGGER.warn((Object)ex, (Throwable)ex);
            LOGGER.warn("Parsing statistical data failed.");
            return null;
        }
    }

    public long getMilliFPSVideoPerSecond() {
        return this.milliFPSVideoPerSecond;
    }

    public long getMilliFPSAudioPerSecond() {
        return this.milliFPSAudioPerSecond;
    }

    public long getBitVideoPerSecond() {
        return this.bitVideoPerSecond;
    }

    public long getBitAudioPerSecond() {
        return this.bitAudioPerSecond;
    }

    public long getPaketLossRatio() {
        return this.paketLossRatio;
    }

    public long getMaxVideoJitter() {
        return this.maxVideoJitter;
    }
}

