/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.TimeRangeResult;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.re.cm.shared.communication.DatabaseProxy;
import de.seetec.v5.re.cm.shared.communication.DatabaseProxyListener;
import de.seetec.v5.re.cm.shared.srpc.RspGetFrameStatistic;
import de.seetec.v5.re.cm.shared.timerange.TimeRangeInfo;
import de.seetec.v5.re.cm.shared.timerange.TimeRangeInfoContainer;
import de.seetec.v5.re.cm.shared.timerange.TimeRangeList;
import de.seetec.v5.re.shared.DeviceCnf;
import de.seetec.v5.re.shared.VideoSourceCnf;
import de.seetec.v5.re.shared.VideoSourceParameter;
import de.seetec.v5.re.shared.configuration.camerarecordingstatistic.CameraRecordingStatistic;
import de.seetec.v5.re.shared.configuration.camerarecordingstatistic.ContentStatistic;
import de.seetec.v5.re.shared.configuration.camerarecordingstatistic.Contents;
import de.seetec.v5.re.shared.configuration.camerarecordingstatistic.TrackStatistic;
import de.seetec.v5.re.shared.srpc.RspGetCameraRecordingStatistics;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.xml.sax.SAXException;

public class RecordingStatistic {
    private final Core core;
    private final Logger logger;

    public RecordingStatistic(Core myCore) {
        this.core = myCore;
        this.logger = LogManager.getLogger(this.getClass());
    }

    public RspGetCameraRecordingStatistics getCameraRecordingStatistics(RspGetCameraRecordingStatistics response, Long granularity) throws ConfigurationException, SeeTecException, JDOMException, SAXException, JAXBException {
        long duration = System.currentTimeMillis();
        int resultCode = this.getCameraRecordingStatisticsFromDBProxies(response, granularity);
        this.logger.debug("Duration for reading recording statistics from MDS: " + (System.currentTimeMillis() - duration));
        duration = System.currentTimeMillis();
        if (resultCode == 0) {
            CameraRecordingStatistic cameraRecordingStatistic = (CameraRecordingStatistic)Basic.unmarshalXML(CameraRecordingStatistic.class, (Object)response.getCameraRecordingStatistics());
            Contents contents = cameraRecordingStatistic.getContents();
            List contentStatisticList = contents.getContent();
            long timeStampNow = System.currentTimeMillis();
            HashMap<Long, RspGetFrameStatistic> fullDerbyStatistic = this.core.getFrameStatistic().readStatistic(timeStampNow - granularity);
            this.logger.debug("Duration for reading statistics from local derby: " + (System.currentTimeMillis() - duration));
            duration = System.currentTimeMillis();
            for (ContentStatistic contentStatistic : contentStatisticList) {
                long videoSourceID = contentStatistic.getCameraSourceID();
                this.addStaticContentStatisticInformation(contentStatistic);
                this.setVideoInformation(contentStatistic, timeStampNow - granularity, timeStampNow, fullDerbyStatistic.get(videoSourceID));
            }
            cameraRecordingStatistic.setContents(contents);
            this.logger.debug("Duration for setVideoInformation: " + (System.currentTimeMillis() - duration));
            try {
                response = new RspGetCameraRecordingStatistics(Integer.valueOf(resultCode), Basic.marshalUTF8XML((Object)cameraRecordingStatistic).getBytes());
            }
            catch (FileNotFoundException | JAXBException | SAXException exception) {
                this.logger.error("Could not marshal cameraRecordingStatistic [" + exception.getMessage() + "]");
            }
        }
        return response;
    }

    private ContentStatistic addStaticContentStatisticInformation(ContentStatistic contentStatistic) {
        if (contentStatistic == null) {
            return null;
        }
        long videoSourceID = contentStatistic.getCameraSourceID();
        Entity videoSourceEntity = this.core.getEntityByID(videoSourceID);
        if (videoSourceEntity == null) {
            this.logger.error("Not possible to fetch information for ID = " + videoSourceID);
            return contentStatistic;
        }
        contentStatistic.setCameraName(videoSourceEntity.getEntityName());
        contentStatistic.setCameraModel(videoSourceEntity.getEntityType());
        Entity videoServerEntity = this.core.getEntityByID(videoSourceEntity.getPhysicalParent());
        if (videoServerEntity == null) {
            this.logger.error("Not possible to fetch information for device of source  = " + videoSourceID + "/" + videoSourceEntity.getEntityName());
            return contentStatistic;
        }
        try {
            if (videoServerEntity.isEnabled().booleanValue()) {
                contentStatistic.setStatusOfRecording(videoSourceEntity.getStatus());
            } else {
                contentStatistic.setStatusOfRecording(Integer.valueOf(-1));
            }
        }
        catch (Exception exception) {
            contentStatistic.setStatusOfRecording(Integer.valueOf(-1));
        }
        DeviceCnf deviceCnf = new DeviceCnf(null);
        if (deviceCnf.init(videoServerEntity.getConfiguration()) != 0) {
            this.logger.error("Not possible to read information for device of source  = " + videoSourceID + "/" + videoSourceEntity.getEntityName());
            return contentStatistic;
        }
        try {
            contentStatistic.setCameraIP(deviceCnf.getHardwareHost());
        }
        catch (ConfigurationException configurationException) {
            this.logger.info("Not possible to extract host information for " + videoSourceID + "/" + videoSourceEntity.getEntityName() + ". Message: " + configurationException.getMessage());
        }
        try {
            Element root = deviceCnf.getDocument().getRootElement();
            String DEVICE_DEFINITION_NAME = "DeviceDefinition";
            DeviceDefinition deviceDefinitionFromConfiguration = Device.unmarshalDefinition(root.getChild(DEVICE_DEFINITION_NAME), DeviceDefinition.class);
            contentStatistic.setCameraFirmware(deviceDefinitionFromConfiguration.getSignature());
            contentStatistic.setCameraManufacturer(deviceDefinitionFromConfiguration.getManufacturer());
            contentStatistic.setCameraModelName(deviceDefinitionFromConfiguration.getName());
        }
        catch (SeeTecException seetecException) {
            this.logger.debug("Not possible to extract some information for static driver " + videoSourceID + "/" + videoSourceEntity.getEntityName() + ". Message: " + seetecException.getMessage());
        }
        VideoSourceParameter standardVideoSourceParameter = new VideoSourceParameter();
        standardVideoSourceParameter.init(videoSourceEntity, null, "Standard", null);
        if (contentStatistic.getStandardTrack() == null) {
            contentStatistic.setStandardTrack(new TrackStatistic());
        }
        try {
            this.setTrackInformation(contentStatistic.getStandardTrack(), standardVideoSourceParameter);
        }
        catch (ConfigurationException configurationException) {
            this.logger.info("Not possible to extract some standard recording information for " + videoSourceID + "/" + videoSourceEntity.getEntityName() + ". Message: " + configurationException.getMessage());
        }
        if (contentStatistic.getAlarmTrack() == null) {
            contentStatistic.setAlarmTrack(new TrackStatistic());
        }
        try {
            VideoSourceCnf videoSourceCnf = new VideoSourceCnf();
            if (videoSourceCnf.init(videoSourceEntity) == 0) {
                VideoSourceParameter alarmVideoSourceParameter = new VideoSourceParameter();
                int alarmRecordingStreamIndex = videoSourceCnf.getAlarmRecordingStreamIndex();
                if (alarmRecordingStreamIndex != 0) {
                    String alarmRecordingProfileName = VideoSourceParameter.getAdditionalVideoProfiles((byte[])videoSourceEntity.getConfiguration())[--alarmRecordingStreamIndex];
                    this.logger.info("Stream to use for alarm recording: " + alarmRecordingProfileName);
                    alarmVideoSourceParameter.init(videoSourceEntity, alarmRecordingProfileName, null, null);
                } else {
                    alarmVideoSourceParameter.init(videoSourceEntity, null, "Alarm", null);
                }
                this.setTrackInformation(contentStatistic.getAlarmTrack(), alarmVideoSourceParameter);
            }
        }
        catch (ConfigurationException configurationException) {
            this.logger.info("Not possible to extract some alarm recording information for " + videoSourceID + "/" + videoSourceEntity.getEntityName() + ". Message: " + configurationException.getMessage());
        }
        return contentStatistic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCameraRecordingStatisticsFromDBProxies(RspGetCameraRecordingStatistics response, Long granularity) {
        DatabaseProxy databaseProxy = null;
        int resultCode = 0;
        try {
            databaseProxy = this.core.createDatabaseProxy((DatabaseProxyListener)null, 0);
            databaseProxy.getCameraRecordingStatistics(response, granularity);
            resultCode = response.getResultCode();
        }
        catch (ConfigurationException | SeeTecException | JDOMException exception) {
            this.logger.error("Could not get Camera Recording Statistics from MDS [" + exception.getMessage() + "]");
            resultCode = -20001;
        }
        finally {
            if (databaseProxy != null) {
                databaseProxy.shutdown();
            }
        }
        return resultCode;
    }

    private ContentStatistic setVideoInformation(ContentStatistic contentStatistic, long since, long till, RspGetFrameStatistic derbyStatisticForOneVideoSource) {
        if (contentStatistic == null) {
            return null;
        }
        long videoSourceID = contentStatistic.getCameraSourceID();
        VideoSrv videoSrv = null;
        try {
            videoSrv = (VideoSrv)this.core.getDeviceLifeCycleInformation().getService(videoSourceID);
        }
        catch (Exception ex) {
            this.logger.info("No VideoSrv registered for videoSourceID [" + videoSourceID + "]");
        }
        if (videoSrv != null) {
            TimeRangeInfoContainer recordingInfos = videoSrv.getRecordingInfos();
            TimeRangeList timeRangeInfoList = recordingInfos.getTimeRangeInfo();
            TimeRangeList timeRangeInfoForTimerange = timeRangeInfoList.getTimeRangeInfoForTimerange(since, till, -1);
            RspGetFrameStatistic derbyStatistic = derbyStatisticForOneVideoSource == null ? new RspGetFrameStatistic(0) : derbyStatisticForOneVideoSource;
            contentStatistic.setPacketLossRatio(Long.valueOf(derbyStatistic.getDataPacketLossRatio()));
            long videoFramesStandardDropppedAll = derbyStatistic.getVideoFramesStandardDroppped();
            int videoFramesStandardStoredAll = derbyStatistic.getVideoFramesStandardStored();
            long dataStandardReceivedAll = derbyStatistic.getDataStandardReceived();
            long standardTimeRangeDerby = derbyStatistic.getStandardTimerange();
            long videoFramesAlarmDropppedAll = derbyStatistic.getVideoFramesAlarmDroppped();
            int videoFramesAlarmStoredAll = derbyStatistic.getVideoFramesAlarmStored();
            long dataAlarmReceivedAll = derbyStatistic.getDataAlarmReceived();
            long alarmTimeRangeDerby = derbyStatistic.getAlarmTimerange();
            long videoFramesPreAlarmDropppedAll = derbyStatistic.getVideoFramesPreAlarmDroppped();
            int videoFramesPreAlarmStoredAll = derbyStatistic.getVideoFramesPreAlarmStored();
            long preAlarmTimeRangeDerby = derbyStatistic.getPreAlarmTimerange();
            TimeRangeResult timeRangeResult = this.sumTimeRanges(timeRangeInfoForTimerange);
            TrackStatistic standardTrack = contentStatistic.getStandardTrack();
            standardTrack.setAmountOfDroppedFrames(videoFramesStandardDropppedAll);
            standardTrack.setAmountOfFrames((long)videoFramesStandardStoredAll);
            long milliFpsStandard = this.calculateFPS(videoFramesStandardStoredAll, standardTimeRangeDerby);
            long bitrateStandard = this.calculateBitrate(dataStandardReceivedAll, standardTimeRangeDerby);
            standardTrack.setVideoFramerate(Long.valueOf(milliFpsStandard));
            standardTrack.setVideoBitrate(Long.valueOf(bitrateStandard));
            standardTrack.setActualTimerange(timeRangeResult.getTimeRangeStandard());
            TrackStatistic alarmTrack = contentStatistic.getAlarmTrack();
            alarmTrack.setAmountOfDroppedFrames(videoFramesAlarmDropppedAll);
            alarmTrack.setAmountOfFrames((long)videoFramesAlarmStoredAll);
            long milliFpsAlarm = this.calculateFPS(videoFramesAlarmStoredAll, alarmTimeRangeDerby);
            long bitrateAlarm = this.calculateBitrate(dataAlarmReceivedAll, alarmTimeRangeDerby);
            alarmTrack.setVideoFramerate(Long.valueOf(milliFpsAlarm));
            alarmTrack.setVideoBitrate(Long.valueOf(bitrateAlarm));
            alarmTrack.setActualTimerange(timeRangeResult.getTimeRangeAlarm());
            TrackStatistic preAlarmTrack = new TrackStatistic();
            preAlarmTrack.setAmountOfDroppedFrames(videoFramesPreAlarmDropppedAll);
            preAlarmTrack.setAmountOfFrames((long)videoFramesPreAlarmStoredAll);
            long milliFpsPreAlarm = this.calculateFPS(videoFramesPreAlarmStoredAll, preAlarmTimeRangeDerby);
            preAlarmTrack.setVideoFramerate(Long.valueOf(milliFpsPreAlarm));
            contentStatistic.setPreAlarmTrack(preAlarmTrack);
            Long expectedVideoBitrateStandard = standardTrack.getExpectedVideoBitrate();
            Long expectedVideoBitrateAlarm = alarmTrack.getExpectedVideoBitrate();
            if (expectedVideoBitrateAlarm == null) {
                expectedVideoBitrateAlarm = 0L;
            }
            if (expectedVideoBitrateStandard == null) {
                expectedVideoBitrateStandard = 0L;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("***");
                this.logger.debug("*** TimeRange Standard: " + derbyStatistic.getStandardTimerange() / 1000L);
                this.logger.debug("*** Expected bitrate Standard: " + expectedVideoBitrateStandard / 1024L);
                this.logger.debug("*** Actual bitrate Standard (kbps): " + bitrateStandard / 1024L);
                this.logger.debug("*** VideoFramesStandard (Stored): " + videoFramesStandardStoredAll);
                this.logger.debug("*** VideoFramesStandard (Dropped): " + videoFramesStandardDropppedAll);
                this.logger.debug("*** FPS Standard: " + milliFpsStandard);
                this.logger.debug("*** Data Standard received: " + dataStandardReceivedAll);
                this.logger.debug("***");
                this.logger.debug("*** TimeRange Alarm: " + derbyStatistic.getAlarmTimerange() / 1000L);
                this.logger.debug("*** Expected bitrate Alarm: " + expectedVideoBitrateAlarm / 1024L);
                this.logger.debug("*** Actual bitrate Alarm (kbps): " + bitrateAlarm / 1024L);
                this.logger.debug("*** VideoFramesAlarm (Stored): " + videoFramesAlarmStoredAll);
                this.logger.debug("*** VideoFramesAlarm (Dropped): " + videoFramesAlarmDropppedAll);
                this.logger.debug("*** FPS Alarm: " + milliFpsAlarm);
                this.logger.debug("*** Data Alarm received: " + dataAlarmReceivedAll);
                this.logger.debug("***");
                this.logger.debug("*** TimeRange PreAlarm: " + derbyStatistic.getPreAlarmTimerange() / 1000L);
                this.logger.debug("*** VideoFramesPreAlarm (Stored): " + videoFramesPreAlarmStoredAll);
                this.logger.debug("*** VideoFramesPreAlarm (Dropped): " + videoFramesPreAlarmDropppedAll);
                this.logger.debug("*** FPS PreAlarm: " + milliFpsPreAlarm);
            }
        }
        return contentStatistic;
    }

    private long calculateFPS(int framesStored, long timeRange) {
        long milliFps = 0L;
        if (timeRange > 1000L) {
            milliFps = (long)framesStored * 1000L / (timeRange / 1000L);
        }
        return milliFps;
    }

    private long calculateBitrate(long dataReceived, long timeRange) {
        long bitrate = 0L;
        if (timeRange > 1000L) {
            bitrate = dataReceived / (timeRange / 1000L);
        }
        return bitrate;
    }

    protected TimeRangeResult sumTimeRanges(TimeRangeList timeRangeInfoForTimerange) {
        TimeRangeResult timeRangeResult = new TimeRangeResult();
        for (TimeRangeInfo timeRangeInfo : timeRangeInfoForTimerange) {
            if (timeRangeInfo.isFailover()) continue;
            if (timeRangeInfo.isAlarmTrack()) {
                timeRangeResult.increaseTimeRangeAlarm(timeRangeInfo.getLength());
                continue;
            }
            timeRangeResult.increaseTimeRangeStandard(timeRangeInfo.getLength());
        }
        return timeRangeResult;
    }

    private void setTrackInformation(TrackStatistic track, VideoSourceParameter videoSourceParameter) throws ConfigurationException {
        track.setExpectedCodec(Integer.valueOf(videoSourceParameter.getMediaCodec().getType()));
        try {
            track.setExpectedWidth(Integer.valueOf(videoSourceParameter.getImageSize()[0]));
            track.setExpectedHeight(Integer.valueOf(videoSourceParameter.getImageSize()[1]));
        }
        catch (Exception exception) {
            this.logger.info("Unable to read resolution for recording info for" + videoSourceParameter.getEntity().toString() + " [" + exception.getMessage() + "]");
        }
        if (videoSourceParameter.getBandwidthControl() == 1) {
            track.setExpectedVideoBitrate(Long.valueOf(videoSourceParameter.getBandWidth()));
        } else if (videoSourceParameter.getBandwidthControl() == 0) {
            track.setExpectedVideoBitrate(Long.valueOf(-2L));
        }
        track.setExpectedVideoFramerate(Long.valueOf(videoSourceParameter.getFramerate()));
    }
}

