/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.shared.AlarmOccurrence;
import de.seetec.v5.re.cm.shared.communication.DatabaseProxy;
import de.seetec.v5.re.shared.srpc.RspGetAlarmInstance;
import de.seetec.v5.re.shared.srpc.RspGetAlarmInstances;
import de.seetec.v5.re.shared.srpc.RspGetAlarmScenarioOccurrencies;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.DefaultSystemTimeProvider;
import de.seetec.v5.shared.SystemTimeProvider;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlarmProcessor
extends Basic
implements Runnable {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.shared.AlarmProcessor";
    private final Logger logger;
    private Core core = null;
    private Thread myThread = null;
    private final Hashtable<Long, Long> referedMDB = new Hashtable();
    private final Hashtable<Long, DatabaseProxy> mdsProxies = new Hashtable();
    List<AlarmOccurrence> alarmsTerminated = Collections.synchronizedList(new LinkedList());
    private final List<AlarmOccurrence> alarmsInProgress = new LinkedList<AlarmOccurrence>();

    public AlarmProcessor() {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    public int init(Core core) {
        this.core = core;
        if (this.core == null) {
            return -21601;
        }
        this.myThread = new Thread((Runnable)this, this.toString());
        this.myThread.start();
        return 0;
    }

    private boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            while (!this.isShutdown()) {
                LinkedList<AlarmOccurrence> alarmOccurrenceToTransfer;
                DatabaseProxy mdsProxy;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Object referedMDB = null;
                long tsAbsolute = 0x1000000000000000L;
                Object object = this.alarmsTerminated;
                synchronized (object) {
                    if (this.alarmsTerminated.size() <= 0) {
                        continue;
                    }
                    mdsProxy = this.getMDSProxy(this.alarmsTerminated.get((int)0).contentID);
                    alarmOccurrenceToTransfer = new LinkedList<AlarmOccurrence>();
                    while (this.alarmsTerminated.size() > 0 && this.referedMDB.get(this.referedMDB.get(this.alarmsTerminated.get((int)0).contentID)) == referedMDB) {
                        if (tsAbsolute > this.alarmsTerminated.get((int)0).tsAlarmStart) {
                            tsAbsolute = this.alarmsTerminated.get((int)0).tsAlarmStart;
                        }
                        alarmOccurrenceToTransfer.add(this.alarmsTerminated.remove(0));
                    }
                }
                object = this.mdsProxies;
                synchronized (object) {
                    LinkedList<Long[]> alarmInstances = new LinkedList<Long[]>();
                    for (int i = 0; i < alarmOccurrenceToTransfer.size(); ++i) {
                        AlarmOccurrence alarmOccurrence = (AlarmOccurrence)alarmOccurrenceToTransfer.get(i);
                        alarmInstances.add(new Long[]{alarmOccurrence.contentID, alarmOccurrence.alarmScriptID, alarmOccurrence.alarmInstanceID, alarmOccurrence.tsAlarmStart, alarmOccurrence.tsAlarmEnd});
                    }
                    int errorCode = mdsProxy.writeAlarmInstances(alarmInstances);
                    if (errorCode != 0) {
                        this.logger.warn("Could not write AlarmInstances to " + (Object)((Object)mdsProxy) + " because of error [" + errorCode + "]");
                    }
                }
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void announceMDB(Long contentID, Long mdbID) {
        Hashtable<Long, Long> hashtable = this.referedMDB;
        synchronized (hashtable) {
            this.referedMDB.put(contentID, mdbID);
        }
    }

    public RspGetAlarmInstance createRspGetAlarmInstance(long contentID, long alarmInstanceID) {
        ArrayList<Long[]> resultList = new ArrayList<Long[]>();
        try {
            DatabaseProxy mdsProxy = this.getMDSProxy(contentID);
            int errorCode = mdsProxy.getAlarmInstance(contentID, alarmInstanceID, resultList);
            if (errorCode != 0) {
                this.logger.warn("Could not get AlarmInstance from " + (Object)((Object)mdsProxy) + " because of error [" + errorCode + "]");
            }
            Long[] alarmInstance = (Long[])resultList.get(0);
            long tsAlarmStart = alarmInstance[0];
            long tsAlarmEnd = alarmInstance[1];
            return new RspGetAlarmInstance(Integer.valueOf(errorCode), Long.valueOf(tsAlarmStart), Long.valueOf(tsAlarmEnd));
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return new RspGetAlarmInstance(Integer.valueOf(-1), Long.valueOf(-1L), Long.valueOf(-1L));
        }
    }

    public RspGetAlarmInstances createRspGetAlarmInstances(Long contentID, Long tsStart, Long tsEnd) {
        List alarmInstances = null;
        LinkedList<List<Long[]>> vResult = new LinkedList<List<Long[]>>();
        try {
            DatabaseProxy mdsProxy = this.getMDSProxy(contentID);
            int errorCode = mdsProxy.getAlarmInstances(contentID, tsStart, tsEnd, vResult);
            if (errorCode != 0) {
                this.logger.warn("Could not get AlarmInstances from " + (Object)((Object)mdsProxy) + " because of error [" + errorCode + "]");
            }
            if (vResult.size() > 0) {
                alarmInstances = (List)vResult.get(0);
            }
            return new RspGetAlarmInstances(Integer.valueOf(errorCode), alarmInstances);
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return new RspGetAlarmInstances(Integer.valueOf(-1), alarmInstances);
        }
    }

    public RspGetAlarmScenarioOccurrencies createRspGetAlarmScenarioOccurrencies(final DatabaseProxy[] proxies, final long contentID, final long tsStart, final long tsEnd) {
        int errorCode = 0;
        LinkedList resultList = new LinkedList();
        if (proxies == null || proxies.length <= 0) {
            errorCode = -20002;
            return new RspGetAlarmScenarioOccurrencies(Integer.valueOf(errorCode), Collections.emptyList());
        }
        ExecutorService es = Executors.newFixedThreadPool(proxies.length);
        ArrayList<Callable<RspGetAlarmScenarioOccurrencies>> tasks = new ArrayList<Callable<RspGetAlarmScenarioOccurrencies>>();
        tasks.add(new Callable<RspGetAlarmScenarioOccurrencies>(){

            @Override
            public RspGetAlarmScenarioOccurrencies call() throws Exception {
                return AlarmProcessor.this.getAlarmScenarioOccurrenciesFromProxy(proxies[0], contentID, tsStart, tsEnd);
            }
        });
        if (proxies.length > 1 && proxies[1] != null) {
            tasks.add(new Callable<RspGetAlarmScenarioOccurrencies>(){

                @Override
                public RspGetAlarmScenarioOccurrencies call() throws Exception {
                    return AlarmProcessor.this.getAlarmScenarioOccurrenciesFromProxy(proxies[1], contentID, tsStart, tsEnd);
                }
            });
        }
        List<Object> results = Collections.emptyList();
        try {
            results = es.invokeAll(tasks);
        }
        catch (InterruptedException ex) {
            this.logger.error((Object)ex, (Throwable)ex);
        }
        es.shutdown();
        this.logger.info(String.format("Merging results of %s proxies.", results.size()));
        Iterator<Object> itr = results.iterator();
        while (itr.hasNext()) {
            RspGetAlarmScenarioOccurrencies rsp;
            try {
                rsp = (RspGetAlarmScenarioOccurrencies)((Future)itr.next()).get();
            }
            catch (InterruptedException ex) {
                errorCode = -23032;
                continue;
            }
            catch (ExecutionException ex) {
                errorCode = -23032;
                continue;
            }
            if (null == rsp) continue;
            if (rsp.getResultCode() == 0) {
                resultList.addAll(rsp.getAlarmScenarioOccurencies());
                continue;
            }
            errorCode = rsp.getResultCode();
        }
        if (!resultList.isEmpty()) {
            errorCode = 0;
        }
        RspGetAlarmScenarioOccurrencies result = new RspGetAlarmScenarioOccurrencies(Integer.valueOf(errorCode), resultList);
        return result;
    }

    private RspGetAlarmScenarioOccurrencies getAlarmScenarioOccurrenciesFromProxy(DatabaseProxy proxy, long contentID, long start, long end) {
        ArrayList outResult = new ArrayList();
        int errorCode = proxy.getAlarmScenarioOccurrencies(contentID, start, end, outResult);
        RspGetAlarmScenarioOccurrencies response = errorCode == 0 ? (outResult.isEmpty() ? new RspGetAlarmScenarioOccurrencies(Integer.valueOf(0), Collections.emptyList()) : (RspGetAlarmScenarioOccurrencies)outResult.get(0)) : new RspGetAlarmScenarioOccurrencies(Integer.valueOf(errorCode), Collections.emptyList());
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAlarmStarted(long contentID, long alarmScriptID, long alarmInstanceID, long preAlarmTimerange, long tsMaxRecording) {
        List<AlarmOccurrence> list = this.alarmsInProgress;
        synchronized (list) {
            if (this.alarmsInProgress.size() > 10000) {
                this.logger.warn("Too many AlarmsInProgress queued, so clearing the queue now!");
                this.alarmsInProgress.clear();
            }
            if (this.alarmsTerminated != null && this.alarmsTerminated.size() > 10000) {
                this.logger.warn("Too many AlarmsTerminated queued, so clearing the queue now!");
                this.alarmsTerminated.clear();
            }
            for (int i = 0; i < this.alarmsInProgress.size(); ++i) {
                AlarmOccurrence alarmOccurrence = this.alarmsInProgress.get(i);
                if (alarmOccurrence.contentID != contentID || alarmOccurrence.alarmInstanceID != alarmInstanceID) continue;
                alarmOccurrence.tsAlarmEnd = tsMaxRecording;
                this.logger.info("Extend " + alarmOccurrence);
                return;
            }
            AlarmOccurrence alarmOccurrence = new AlarmOccurrence(contentID, alarmScriptID, alarmInstanceID, preAlarmTimerange, tsMaxRecording);
            this.alarmsInProgress.add(alarmOccurrence);
            this.logger.info("Adding " + alarmOccurrence);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAlarmStopped(long contentID, long alarmScriptID, long alarmInstanceID) {
        List<AlarmOccurrence> list = this.alarmsInProgress;
        synchronized (list) {
            if (this.alarmsInProgress.size() > 10000) {
                this.logger.warn("Too many AlarmsInProgress queued, so clearing the queue now!");
                this.alarmsInProgress.clear();
            }
            if (this.alarmsTerminated != null && this.alarmsTerminated.size() > 10000) {
                this.logger.warn("Too many AlarmsTerminated queued, so clearing the queue now!");
                this.alarmsTerminated.clear();
            }
            for (int i = 0; i < this.alarmsInProgress.size(); ++i) {
                AlarmOccurrence alarmOccurrence = this.alarmsInProgress.get(i);
                if (alarmOccurrence.contentID != contentID || alarmOccurrence.alarmInstanceID != alarmInstanceID) continue;
                alarmOccurrence.tsAlarmEnd = System.currentTimeMillis();
                this.logger.info("Stopped: " + alarmOccurrence + ", Delay=[" + (System.currentTimeMillis() - alarmOccurrence.tsAlarmEnd) + " ms]");
                if (alarmOccurrence.alarmInstanceID == -1L) {
                    alarmOccurrence.alarmInstanceID = Basic.createInt8UID((SystemTimeProvider)new DefaultSystemTimeProvider());
                    this.logger.info("AlarmInstanceID created for " + alarmOccurrence);
                }
                this.alarmsInProgress.remove(i);
                this.alarmsTerminated.add(alarmOccurrence);
                return;
            }
            this.logger.warn("Inconsistency: No AlarmOccurrence for ContentID=[" + contentID + "], AlarmScriptID=[" + alarmScriptID + "], AlarmInstanceID=[" + alarmInstanceID + "] found :-(");
        }
    }

    private DatabaseProxy getMDSProxy(Long contentID) throws SeeTecException {
        Long mdbID = this.referedMDB.get(contentID);
        DatabaseProxy mdsProxy = this.mdsProxies.get(contentID);
        if (mdbID == null) {
            throw new SeeTecException(-1, "Cannot determine <mdbID> for content[" + contentID + "]");
        }
        if (mdsProxy != null && mdsProxy.isShutdown()) {
            this.logger.warn((Object)((Object)mdsProxy) + " is already shutting down, so discarding instance and creating a new one!");
            this.mdsProxies.remove(contentID);
            mdsProxy = null;
        }
        if (mdsProxy == null) {
            mdsProxy = this.core.createDatabaseProxy(null, mdbID);
            if (mdsProxy == null) {
                throw new SeeTecException(-1, "Could not create <MDSProxy> for content [" + contentID + "]");
            }
            this.mdsProxies.put(contentID, mdsProxy);
            this.logger.info((Object)((Object)mdsProxy) + " created for " + this);
        }
        return mdsProxy;
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.shared.AlarmProcessor@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", AlarmsInProgress=[" + (this.alarmsInProgress != null ? this.alarmsInProgress.size() : 0) + "], AlarmsTerminated=[" + (this.alarmsTerminated != null ? this.alarmsTerminated.size() : 0) + "], IsShutdown=[" + this.isShutdown() + "]]";
    }
}

