/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.firmware;

import de.seetec.v5.re.cm.firmware.FirmwareManager;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.StandardOpenOption;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FirmwareManagerImpl
implements FirmwareManager {
    private final Logger logger = LogManager.getLogger((String)FirmwareManagerImpl.class.getSimpleName());
    private final String baseDirectory;

    public FirmwareManagerImpl(String baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Path values from requests are sanitized")
    public boolean isFirmwareAvailable(String filename) {
        this.logger.info("Check firmware in folder " + this.baseDirectory);
        File file = new File(this.baseDirectory, FilenameUtils.getName((String)filename));
        return file.exists();
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Path values from requests are sanitized")
    public void deleteFirmware(String filename) throws IOException {
        File file = new File(this.baseDirectory, FilenameUtils.getName((String)filename));
        if (!file.exists()) {
            throw new NoSuchFileException(file.getAbsolutePath());
        }
        Files.delete(file.toPath());
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Path values from requests are sanitized")
    public void sendFirmware(String filename, byte[] data) throws IOException {
        Files.write(new File(this.baseDirectory, FilenameUtils.getName((String)filename)).toPath(), data, StandardOpenOption.CREATE);
    }

    @Override
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Path values from requests are sanitized")
    public byte[] readFirmware(String filename) throws IOException {
        File file = new File(this.baseDirectory, FilenameUtils.getName((String)filename));
        if (!file.exists()) {
            throw new NoSuchFileException(file.getAbsolutePath());
        }
        return Files.readAllBytes(file.toPath());
    }
}

