/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.filesystemwatcher;

import de.seetec.v5.re.cm.filesystemwatcher.FileSystemWatcherServerIntf;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.ExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class JpegFileSystemWatcherBase
implements Runnable {
    protected Logger logger = LogManager.getLogger((String)this.getClass().getName());
    protected ExecutorService scheduler = null;
    private FileSystemWatcherServerIntf fileSystemWatcherIntf;
    protected Path directoryOfInterest;
    protected WatchService watcher = null;

    protected int init(FileSystemWatcherServerIntf fileSystemWatcherIntf, Path directoryOfInterest) {
        this.fileSystemWatcherIntf = fileSystemWatcherIntf;
        if (this.fileSystemWatcherIntf == null) {
            return -20002;
        }
        this.directoryOfInterest = directoryOfInterest;
        if (this.directoryOfInterest == null) {
            return -20002;
        }
        try {
            this.watcher = FileSystems.getDefault().newWatchService();
            directoryOfInterest.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE);
            directoryOfInterest.register(this.watcher, StandardWatchEventKinds.ENTRY_MODIFY);
        }
        catch (IOException x) {
            this.shutdown();
            this.logger.error("Can't watch directory: " + directoryOfInterest + ". Reason: " + x.getMessage());
            return -20022;
        }
        return 0;
    }

    protected void changeFileCreationTime(String foundFile, long newTimestamp) throws IOException {
        BasicFileAttributeView attributes = Files.getFileAttributeView(Paths.get(this.directoryOfInterest + "\\" + foundFile, new String[0]), BasicFileAttributeView.class, new LinkOption[0]);
        FileTime time = FileTime.fromMillis(newTimestamp);
        attributes.setTimes(null, null, time);
    }

    protected int readFile(Path fileToRead) {
        int errorCode = -20022;
        try {
            byte[] content = Files.readAllBytes(fileToRead);
            if (content.length > 2) {
                if (content[content.length - 2] == -1 && content[content.length - 1] == -39) {
                    this.fileSystemWatcherIntf.fileCreated(this.directoryOfInterest, fileToRead.getFileName(), content);
                    errorCode = 0;
                } else {
                    this.logger.info(String.format("File '%s' not a complete JPEG, yet. Content size is: %s", fileToRead.getFileName(), content.length));
                }
            }
        }
        catch (IOException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("IOException while reading file. Give a re-try in next iteration for file " + fileToRead.getFileName());
            }
        }
        catch (InterruptedException ex) {
            try {
                this.fileSystemWatcherIntf.error(this.directoryOfInterest, fileToRead.getFileName(), -20000, "Can't notify about file creation.");
            }
            catch (InterruptedException ex1) {
                this.logger.error(String.format("Can't send error '%s' about directory '%s' to %s", -20022, this.directoryOfInterest, this.fileSystemWatcherIntf));
            }
        }
        return errorCode;
    }

    public int shutdown() {
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
        if (this.watcher != null) {
            try {
                this.watcher.close();
            }
            catch (IOException ex) {
                this.logger.error("Error while closing watcher for " + this);
            }
        }
        return 0;
    }
}

