/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.vivotek.smart.sip;

import de.seetec.v5.re.cm.device.video.vivotek.smart.sip.SipHandler;
import de.seetec.v5.re.cm.device.video.vivotek.smart.sip.SipMessage;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SipReader
implements Runnable {
    private final SipHandler callback;
    private final DatagramSocket socket;
    private Thread myThread;
    private volatile boolean shutdown;
    private Logger logger = null;

    public SipReader(SipHandler callback, DatagramSocket socket) {
        this.callback = callback;
        this.socket = socket;
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    @Override
    public void run() {
        SipMessage previousSipMessage = null;
        while (!this.isShutdown()) {
            try {
                byte[] buffer = new byte[4096];
                DatagramPacket packet = new DatagramPacket(buffer, 4096);
                this.socket.receive(packet);
                int len = packet.getLength();
                if (len <= 0) continue;
                byte[] baosContent = new byte[len];
                System.arraycopy(buffer, 0, baosContent, 0, len);
                SipMessage sipMessage = SipMessage.createSipMessage(new String(baosContent));
                if (previousSipMessage != null && sipMessage == previousSipMessage) continue;
                previousSipMessage = sipMessage;
                this.callback.deliverSipMessage(sipMessage);
            }
            catch (IOException ex) {
                this.logger.warn("Exception while readingt audio out: " + ex.getMessage());
                this.shutdown();
            }
        }
    }

    boolean isShutdown() {
        return this.shutdown;
    }

    protected void init() {
        this.shutdown = false;
        this.myThread = new Thread((Runnable)this, this.toString());
        this.myThread.start();
    }

    void shutdown() {
        this.shutdown = true;
    }
}

