/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.vivotek.smart.sip;

import de.seetec.v5.re.cm.device.shared.net.rtp.RtpSenderPacket;
import de.seetec.v5.re.cm.device.shared.net.udp.UdpWriterUnicast;
import de.seetec.v5.re.cm.device.video.vivotek.smart.sip.SdpPacket;
import de.seetec.v5.re.cm.device.video.vivotek.smart.sip.SipMessage;
import de.seetec.v5.re.cm.device.video.vivotek.smart.sip.SipMessageAck;
import de.seetec.v5.re.cm.device.video.vivotek.smart.sip.SipMessageBusy;
import de.seetec.v5.re.cm.device.video.vivotek.smart.sip.SipMessageBye;
import de.seetec.v5.re.cm.device.video.vivotek.smart.sip.SipMessageInfo;
import de.seetec.v5.re.cm.device.video.vivotek.smart.sip.SipMessageInvite;
import de.seetec.v5.re.cm.device.video.vivotek.smart.sip.SipMessageOK;
import de.seetec.v5.re.cm.device.video.vivotek.smart.sip.SipMessageOptions;
import de.seetec.v5.re.cm.device.video.vivotek.smart.sip.SipMessageRinging;
import de.seetec.v5.re.cm.device.video.vivotek.smart.sip.SipMessageUnauthorized;
import de.seetec.v5.re.cm.device.video.vivotek.smart.sip.SipReader;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SipHandler {
    private String uriUserId;
    private String localTag;
    private String remoteTag;
    private String branchID;
    private String callID;
    private String localHost;
    private Logger logger = null;
    private final List<SipMessage> messageQueue = Collections.synchronizedList(new LinkedList());
    private String myUserId;
    private SipReader sipReader;
    private final NetworkParameter networkParameter;
    private int sipPort;
    private DatagramSocket socket;
    private UdpWriterUnicast udpWriterUnicast;
    private volatile boolean shutdown = true;

    public SipHandler(NetworkParameter networkParameter) {
        this.networkParameter = networkParameter;
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    private static DatagramSocket createNetworkConnection(int port, int timeout) throws IOException {
        DatagramSocket socket = new DatagramSocket();
        socket.setSoTimeout(timeout);
        return socket;
    }

    public int init() {
        this.shutdown = false;
        SipMessageOptions options = new SipMessageOptions(this.networkParameter);
        this.uriUserId = this.generateRandomString(12);
        this.myUserId = this.generateRandomString(8);
        this.localTag = this.generateRandomString(8);
        this.callID = this.generateRandomString(32);
        int cSeq = 1;
        this.branchID = "z9hG4bK-" + this.generateRandomString(32);
        try {
            this.establishConnection();
            this.sipReader = new SipReader(this, this.socket);
            this.sipReader.init();
            options.setLocalPort(this.socket.getLocalPort());
            options.setUriUserId(this.uriUserId);
            options.setMyUserId(this.myUserId);
            options.setLocalTag(this.localTag);
            options.setCallID(this.callID);
            options.setcSeq(cSeq);
            options.setBranchID(this.branchID);
            options.setRemotePort(this.sipPort);
            SipMessage response = this.sendSipMessage(options.getData().getBytes());
            if (response != null && response instanceof SipMessageOK) {
                this.localTag = this.generateRandomString(8);
                this.localHost = response.getLocalHost();
                this.branchID = "z9hG4bK-" + this.generateRandomString(32);
                this.callID = this.generateRandomString(32);
                SipMessageInvite invite = new SipMessageInvite(this.networkParameter);
                invite.setLocalPort(this.socket.getLocalPort());
                invite.setRemotePort(this.sipPort);
                invite.setUriUserId(this.uriUserId);
                invite.setMyUserId(this.myUserId);
                invite.setLocalTag(this.localTag);
                invite.setLocalHost(this.localHost);
                invite.setBranchID(this.branchID);
                invite.setCallID(this.callID);
                invite.setcSeq(cSeq);
                SdpPacket sdpPacket = new SdpPacket(this.generateRandomString(25));
                invite.setSdpPacket(sdpPacket);
                String dataToSend = invite.getData() + invite.getBody();
                response = this.sendSipMessage(dataToSend.getBytes());
                this.remoteTag = response.getRemoteTag();
                SipMessageAck ack = new SipMessageAck(this.networkParameter);
                ack.setLocalPort(this.socket.getLocalPort());
                ack.setRemotePort(this.sipPort);
                ack.setUriUserId(this.uriUserId);
                ack.setMyUserId(this.myUserId);
                ack.setLocalTag(this.localTag);
                ack.setRemoteTag(this.remoteTag);
                ack.setLocalHost(this.localHost);
                ack.setBranchID(this.branchID);
                ack.setCallID(this.callID);
                ack.setcSeq(cSeq);
                dataToSend = ack.getData();
                this.sendSipMessage(dataToSend.getBytes(), false);
                if (response instanceof SipMessageUnauthorized) {
                    this.getDigestAuthenticationData((SipMessageUnauthorized)response, this.networkParameter);
                    this.branchID = "z9hG4bK-" + this.generateRandomString(32);
                    invite.setBranchID(this.branchID);
                    invite.setcSeq(++cSeq);
                    invite.setAuthenticationLine(this.getAuthenticationLine(invite.getSipUri(), false, "INVITE"));
                    dataToSend = invite.getData() + invite.getBody();
                    response = this.sendSipMessage(dataToSend.getBytes());
                }
                if (response instanceof SipMessageRinging && (response = this.readResponse()) != null && response instanceof SipMessageOK) {
                    SdpPacket responseSdp = new SdpPacket(response.getBody().getBytes());
                    int udpPort = responseSdp.getPort();
                    if (udpPort != -1) {
                        this.udpWriterUnicast = new UdpWriterUnicast(InetAddress.getByName(this.networkParameter.getHost()), null, udpPort);
                    }
                    this.remoteTag = response.getRemoteTag();
                    this.branchID = "z9hG4bK-" + this.generateRandomString(32);
                    ack.setRemoteTag(this.remoteTag);
                    ack.setBranchID(this.branchID);
                    ack.setcSeq(cSeq);
                    dataToSend = ack.getData();
                    this.sendSipMessage(dataToSend.getBytes(), false);
                    SipKeepAliveReader sipKeepAliveReader = new SipKeepAliveReader();
                    sipKeepAliveReader.init();
                }
            }
        }
        catch (Exception ex) {
            return -20100;
        }
        return 0;
    }

    private String generateRandomString(int length) {
        String chars = "abcdef1234567890";
        StringBuilder result = new StringBuilder();
        Random rnd = new Random();
        while (result.length() < length) {
            int index = (int)(rnd.nextFloat() * (float)chars.length());
            result.append(chars.charAt(index));
        }
        return result.toString();
    }

    public void setSipPort(int sipPort) {
        this.sipPort = sipPort;
    }

    private void establishConnection() throws Exception {
        this.socket = SipHandler.createNetworkConnection(this.sipPort, this.networkParameter.getSoTimeout());
    }

    public int sendRTPPacket(RtpSenderPacket rtpData) {
        if (this.isShutdown()) {
            this.init();
        }
        try {
            this.udpWriterUnicast.send(rtpData.getData());
        }
        catch (Exception ex) {
            return -20100;
        }
        return 0;
    }

    private SipMessage sendSipMessage(byte[] data) throws UnknownHostException, IOException {
        return this.sendSipMessage(data, true);
    }

    private SipMessage sendSipMessage(byte[] data, boolean readAnswer) throws UnknownHostException, IOException {
        DatagramPacket outboundPacket = new DatagramPacket(data, data.length);
        outboundPacket.setAddress(InetAddress.getByName(this.networkParameter.getHost()));
        outboundPacket.setPort(this.sipPort);
        this.socket.send(outboundPacket);
        if (readAnswer) {
            return this.readResponse();
        }
        return null;
    }

    private SipMessage readResponse() {
        while (!this.isShutdown() && this.messageQueue.isEmpty()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.messageQueue.remove(0);
    }

    protected boolean isShutdown() {
        return this.shutdown || this.sipReader == null || this.sipReader.isShutdown();
    }

    String getAuthenticationLine(String url, boolean proxy, String command) throws Exception {
        String authentication = NetworkHelper.createDigestAuthorization((NetworkParameter)this.networkParameter, (String)this.networkParameter.getRealm(), (String)this.networkParameter.getNonce(), (String)command, (String)("sip:" + url));
        if (proxy) {
            authentication = "Proxy-" + authentication;
        }
        return authentication.replace(", algorithm=\"MD5\"", "").replace("\r\n", "").replace(", ", ",") + ",algorithm=MD5" + "\r\n";
    }

    public int shutdown() {
        return this.shutdown(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int shutdown(boolean sendByeMessage) {
        this.shutdown = true;
        if (this.sipReader != null) {
            this.sipReader.shutdown();
            this.sipReader = null;
        }
        try {
            if (sendByeMessage) {
                this.branchID = "z9hG4bK-" + this.generateRandomString(32);
                SipMessageBye sipMessageBye = new SipMessageBye(this.networkParameter);
                sipMessageBye.setAuthenticationLine(this.getAuthenticationLine(sipMessageBye.getSipUri(), true, "BYE"));
                sipMessageBye.setcSeqCommand("BYE");
                sipMessageBye.setUriUserId(this.uriUserId);
                sipMessageBye.setRemoteTag(this.remoteTag);
                sipMessageBye.setLocalTag(this.localTag);
                sipMessageBye.setCallID(this.callID);
                sipMessageBye.setLocalPort(this.socket.getLocalPort());
                sipMessageBye.setRemotePort(this.sipPort);
                sipMessageBye.setBranchID(this.branchID);
                sipMessageBye.setMyUserId(this.myUserId);
                String dataToSend = sipMessageBye.getData();
                this.sendSipMessage(dataToSend.getBytes());
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (this.udpWriterUnicast != null) {
                this.udpWriterUnicast.shutdown();
                this.udpWriterUnicast = null;
            }
        }
        return 0;
    }

    void deliverSipMessage(SipMessage sipMessage) {
        if (sipMessage instanceof SipMessageBye || sipMessage instanceof SipMessageBusy) {
            try {
                SipMessageOK sipMessageOk = new SipMessageOK(this.networkParameter);
                sipMessageOk.setcSeqCommand("BYE");
                sipMessageOk.setUriUserId(this.uriUserId);
                sipMessageOk.setRemoteTag(this.remoteTag);
                sipMessageOk.setLocalTag(this.localTag);
                sipMessageOk.setCallID(this.callID);
                sipMessageOk.setLocalPort(this.socket.getLocalPort());
                sipMessageOk.setRemotePort(this.sipPort);
                sipMessageOk.setBranchID(sipMessage.getBranchID());
                sipMessageOk.setMyUserId(this.myUserId);
                this.sendSipMessage(sipMessageOk.getData().getBytes(), false);
            }
            catch (Exception ex) {
                this.logger.warn("Exception while sending OK Message for " + this);
            }
            this.shutdown(false);
        } else if (sipMessage instanceof SipMessageInfo) {
            try {
                SipMessageOK sipMessageOk = new SipMessageOK(this.networkParameter);
                sipMessageOk.setcSeqCommand("INFO");
                sipMessageOk.setUriUserId(this.uriUserId);
                sipMessageOk.setRemoteTag(this.remoteTag);
                sipMessageOk.setLocalTag(this.localTag);
                sipMessageOk.setCallID(this.callID);
                sipMessageOk.setLocalPort(this.socket.getLocalPort());
                sipMessageOk.setRemotePort(this.sipPort);
                sipMessageOk.setBranchID(sipMessage.getBranchID());
                sipMessageOk.setMyUserId(this.myUserId);
                this.sendSipMessage(sipMessageOk.getData().getBytes(), false);
            }
            catch (Exception ex) {
                this.logger.warn("Exception while preparing Sip Message of Type OK for " + this);
            }
        } else {
            this.messageQueue.add(sipMessage);
        }
    }

    private void getDigestAuthenticationData(SipMessageUnauthorized sipResponseUnauthorized, NetworkParameter networkParameter) {
        String[] responseLines;
        String sipResponse = sipResponseUnauthorized.getData();
        for (String line : responseLines = sipResponse.split("\r\n")) {
            String[] realmNonceAlgorithm;
            String[] tagLines;
            if (!line.toLowerCase().startsWith("www-authenticate:") || !line.contains("Digest") || (tagLines = line.split("Digest ")).length <= 1) continue;
            for (String digestParameterLine : realmNonceAlgorithm = tagLines[1].split(",")) {
                if (digestParameterLine.startsWith("realm=")) {
                    networkParameter.setRealm(digestParameterLine.replace("realm=\"", "").replace("\"", ""));
                    continue;
                }
                if (!digestParameterLine.startsWith("nonce=")) continue;
                networkParameter.setNonce(digestParameterLine.replace("nonce=\"", "").replace("\"", ""));
            }
        }
    }

    protected class SipKeepAliveReader
    implements Runnable {
        private static final int KEEPALIVEINTERVAL = 35000;
        private Thread myThread = null;

        protected SipKeepAliveReader() {
        }

        public int init() {
            this.myThread = new Thread((Runnable)this, this.toString());
            this.myThread.start();
            return 0;
        }

        @Override
        public void run() {
            try {
                long time = System.currentTimeMillis();
                while (!this.isShutdown()) {
                    SipMessage messageInfo;
                    if (System.currentTimeMillis() - 35000L < time) {
                        Thread.sleep(time + 35000L - System.currentTimeMillis());
                    }
                    if (!this.isShutdown()) {
                        SipHandler.this.branchID = "z9hG4bK-" + SipHandler.this.generateRandomString(32);
                        SipMessageInfo sipMessageInfo = new SipMessageInfo(SipHandler.this.networkParameter);
                        sipMessageInfo.setUriUserId(SipHandler.this.uriUserId);
                        sipMessageInfo.setLocalTag(SipHandler.this.localTag);
                        sipMessageInfo.setRemoteTag(SipHandler.this.remoteTag);
                        sipMessageInfo.setBranchID(SipHandler.this.branchID);
                        sipMessageInfo.setCallID(SipHandler.this.callID);
                        sipMessageInfo.setLocalHost(SipHandler.this.localHost);
                        sipMessageInfo.setRemotePort(SipHandler.this.sipPort);
                        sipMessageInfo.setMyUserId(SipHandler.this.myUserId);
                        sipMessageInfo.setLocalPort(SipHandler.this.socket.getLocalPort());
                        sipMessageInfo.setAuthenticationLine(SipHandler.this.getAuthenticationLine(sipMessageInfo.getSipUri(), true, "INFO"));
                        String dataToSend = sipMessageInfo.getData();
                        SipMessage sipMessage = SipHandler.this.sendSipMessage(dataToSend.getBytes());
                        if (sipMessage instanceof SipMessageUnauthorized) {
                            SipHandler.this.getDigestAuthenticationData((SipMessageUnauthorized)sipMessage, SipHandler.this.networkParameter);
                            sipMessageInfo.setAuthenticationLine(SipHandler.this.getAuthenticationLine(sipMessageInfo.getSipUri(), false, "INFO"));
                            dataToSend = sipMessageInfo.getData();
                            SipHandler.this.sendSipMessage(dataToSend.getBytes());
                        }
                    }
                    if ((messageInfo = SipHandler.this.readResponse()) instanceof SipMessageInfo) {
                        SipMessageOK sipMessageOk = new SipMessageOK("");
                        String dataToSend = sipMessageOk.getData();
                        SipHandler.this.sendSipMessage(dataToSend.getBytes());
                    }
                    time = System.currentTimeMillis();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public boolean isShutdown() {
            return SipHandler.this.shutdown || SipHandler.this.sipReader == null || SipHandler.this.sipReader.isShutdown();
        }
    }
}

