/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.vivotek.smart.sip;

import java.net.Inet6Address;
import java.net.InetAddress;

class SdpPacket {
    private String versionLine;
    private String origin;
    private String originLine;
    private String senderLine;
    private String connectionLine;
    private String timeLine;
    private String sessionAttribute;
    private String sessionAttributeLine;
    private String port;
    private String mediaLine;
    private String bandwidthLine;
    private String rtpAttributeLine;
    private String sendReceiveAttributeLine;
    private String loopbackAddress;
    private String ipVersion = "IP4";

    public SdpPacket(String session) {
        long rand = System.currentTimeMillis();
        this.versionLine = "v=0\r\n";
        this.origin = rand / 1000L + " " + rand % 1000L;
        this.sessionAttribute = session;
        this.port = "5556";
        this.loopbackAddress = Inet6Address.getLoopbackAddress().getHostAddress();
        this.ipVersion = this.loopbackAddress.contains(".") ? "IP4" : "IP6";
        this.originLine = "o=SIP " + this.origin + " IN " + this.ipVersion + " " + this.loopbackAddress + "\r\n";
        this.senderLine = "s=SIPUA\r\n";
        this.connectionLine = "c=IN " + this.ipVersion + " " + this.loopbackAddress + "\r\n";
        this.timeLine = "t=0 0\r\n";
        this.sessionAttributeLine = "a=x-session-id:" + this.sessionAttribute + "\r\n";
        this.mediaLine = "m=audio " + this.port + " RTP/AVP 0" + "\r\n";
        this.bandwidthLine = "b=AS:64\r\n";
        this.rtpAttributeLine = "a=rtpmap:0 pcmu/8000\r\n";
        this.sendReceiveAttributeLine = "a=sendonly\r\n";
    }

    SdpPacket(byte[] data) {
        String[] dataLines;
        String dataString = new String(data);
        for (String dataLine : dataLines = dataString.split("\r\n")) {
            if (dataLine.startsWith("v")) {
                this.versionLine = dataLine;
                continue;
            }
            if (dataLine.startsWith("o")) {
                this.originLine = dataLine;
                continue;
            }
            if (dataLine.startsWith("s")) {
                this.senderLine = dataLine;
                continue;
            }
            if (dataLine.startsWith("c")) {
                this.connectionLine = dataLine;
                continue;
            }
            if (dataLine.startsWith("t")) {
                this.timeLine = dataLine;
                continue;
            }
            if (dataLine.startsWith("a=x")) {
                this.sessionAttributeLine = dataLine;
                continue;
            }
            if (dataLine.startsWith("m")) {
                this.mediaLine = dataLine;
                continue;
            }
            if (dataLine.startsWith("b")) {
                this.bandwidthLine = dataLine;
                continue;
            }
            if (dataLine.startsWith("a=rtp")) {
                this.rtpAttributeLine = dataLine;
                continue;
            }
            if (!dataLine.startsWith("a=")) continue;
            this.sendReceiveAttributeLine = dataLine;
        }
        if (this.originLine != null) {
            String loopback = InetAddress.getLoopbackAddress().getHostAddress();
            this.origin = this.originLine.replace("o=SIP ", "").replace(" IN " + this.ipVersion + " ", "").replace(loopback, "");
        }
        if (this.sessionAttributeLine != null) {
            this.sessionAttribute = this.sessionAttributeLine.replace("a=x-session-id:", "");
        }
        if (this.versionLine == null) {
            this.versionLine = "v=0\r\n";
        }
        if (this.mediaLine != null) {
            this.port = this.mediaLine.replace("m=audio ", "").replace(" RTP/AVP 0", "");
        }
    }

    public String getData() {
        return this.versionLine + this.originLine + this.senderLine + this.connectionLine + this.timeLine + this.sessionAttributeLine + this.mediaLine + this.bandwidthLine + this.rtpAttributeLine + this.sendReceiveAttributeLine;
    }

    public int getPort() {
        String[] mediaLineLines;
        if (this.mediaLine != null && !this.mediaLine.isEmpty() && (mediaLineLines = this.mediaLine.split(" ")).length > 1) {
            try {
                return Integer.parseInt(mediaLineLines[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }
}

