/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.vivotek.smart;

import de.seetec.v5.re.cm.device.shared.videosource.JPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.vivotek.smart.VivotekSmartDevice;
import de.seetec.v5.re.cm.device.video.vivotek.smart.VivotekSmartHelper;
import de.seetec.v5.re.cm.device.video.vivotek.smart.VivotekSmartIOHandler;
import de.seetec.v5.re.cm.device.video.vivotek.smart.VivotekSmartTriggerHandler;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.HttpHandlerImpl;
import de.seetec.v5.shared.net.HttpHandlerIntf;
import de.seetec.v5.shared.util.SeeTecException;

public class VivotekSmartMJPEGVideoSourceClient
extends JPEGVideoSourceClient
implements HttpHandlerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.vivotek.smart.VivotekSmartMJPEGVideoSourceClient";
    private HttpHandlerImpl httpHandler;
    private String videoPostfix = null;

    public VivotekSmartDevice getVivotekSmartDevice() {
        return (VivotekSmartDevice)this.getVideoSrv().getDevice();
    }

    @Override
    public void deliverContent(byte[] contentData) {
        if (contentData != null) {
            byte[] FFE2Header = new byte[]{-1, -30};
            byte[] JPEGMarker = new byte[]{106, 112, 101, 103};
            int index = Basic.indexOfByteArray((byte[])contentData, (byte[])FFE2Header, (int)0, (int)200);
            if (index != -1) {
                if ((index = Basic.indexOfByteArray((byte[])contentData, (byte[])JPEGMarker, (int)index, (int)200)) != -1) {
                    if (this.getVideoSrv().getDevice().getIOHandler() != null) {
                        boolean additionalDIsActive;
                        byte statusAllInputs = (byte)(contentData[index] & 0xF);
                        boolean bl = additionalDIsActive = (byte)(contentData[index + 2] & 2) == 2;
                        if (additionalDIsActive) {
                            byte statusDI7 = (byte)(contentData[index + 2] << 3 & 8);
                            byte statusDI4To6 = (byte)(contentData[index + 3] >> 5 & 7);
                            statusAllInputs = (byte)(statusAllInputs | statusDI7 << 4 | statusDI4To6 << 4);
                        }
                        ((VivotekSmartIOHandler)this.getVideoSrv().getDevice().getIOHandler()).processContent(statusAllInputs);
                    }
                    int lengthUserData = contentData[index += 11] * 4;
                    byte[] bytesToCheckForMotion = new byte[lengthUserData];
                    System.arraycopy(contentData, index + 1, bytesToCheckForMotion, 0, bytesToCheckForMotion.length);
                    if (this.getVivotekSmartTriggerHandler() != null && !this.getVivotekSmartTriggerHandler().isMetadataStreamEnabled()) {
                        this.getVivotekSmartTriggerHandler().processTriggerData(bytesToCheckForMotion, this.videoSourceNr);
                    }
                } else {
                    this.logger.warn("Following spec the JPEG should contain JPEG Marker. It doesn't. " + this.getVideoSrv().getDevice());
                    this.sendStatusService(-21650);
                    this.shutdown();
                }
            }
            super.deliverContent(contentData);
        }
    }

    @Override
    protected boolean isRunFinished() {
        return super.isRunFinished(CLASS_NAME);
    }

    @Override
    public int init() {
        try {
            this.logger.info("init started for" + this.getVideoSrv());
            int errorCode = super.init(false);
            if (errorCode != 0) {
                this.logger.error("Error while initializing. Code: " + errorCode + " for " + this);
                return errorCode;
            }
            try {
                StringBuilder sb = new StringBuilder();
                int streamID = this.listener.getDynamicVideoProfileID();
                if (this.getListener().getLiveCameraSrv().getDevice().getNumberOfVideoSources() > 1) {
                    this.videoPostfix = this.videoSourceNr == 1 ? "" : "" + this.videoSourceNr;
                    this.videoPostfix = streamID == 0 ? this.videoPostfix : this.videoPostfix + "s" + (streamID + 1);
                } else {
                    this.videoPostfix = streamID == 0 ? "" : "" + (streamID + 1);
                }
                String prefix = "videoin_c" + (this.videoSourceNr - 1) + "_s" + streamID + "_";
                int fps = (int)(this.highestFramerate / 1000L);
                this.quality = this.quality / 20000 + 1;
                this.quality = this.quality > 5 ? 5 : this.quality;
                sb.append("/cgi-bin/operator/setparam.cgi?");
                sb.append(prefix);
                sb.append("codectype=mjpeg&");
                sb.append(prefix);
                sb.append("mjpeg_maxframe=");
                sb.append(fps);
                sb.append("&");
                sb.append(prefix);
                sb.append("resolution=");
                if (this.resolutionTag != null && !this.resolutionTag.isEmpty()) {
                    sb.append(this.resolutionTag);
                } else {
                    sb.append(this.width);
                    sb.append("x");
                    sb.append(this.height);
                }
                sb.append("&videoin_c");
                sb.append(this.videoSourceNr - 1);
                sb.append("_imprinttimestamp=");
                if (this.useDateTime || this.useTitle) {
                    sb.append("1");
                } else {
                    sb.append("0");
                }
                sb.append("&videoin_c");
                sb.append(this.videoSourceNr - 1);
                sb.append("_text=");
                if (this.useTitle) {
                    sb.append(this.title);
                }
                sb.append("&");
                sb.append(prefix);
                sb.append("mjpeg_quant=");
                sb.append(this.quality);
                sb.append("&videoin_c");
                sb.append(this.videoSourceNr - 1);
                sb.append("_flip=");
                if (this.rotationAngle == 180) {
                    sb.append("1&videoin_c");
                    sb.append(this.videoSourceNr - 1);
                    sb.append("_mirror=1");
                } else if (this.rotationAngle == 0) {
                    sb.append("0&videoin_c");
                    sb.append(this.videoSourceNr - 1);
                    sb.append("_mirror=0");
                }
                sb.append("&videoin_c");
                sb.append(this.videoSourceNr - 1);
                sb.append("_rotate=");
                if (this.rotationAngle == 90) {
                    sb.append("90");
                } else if (this.rotationAngle == 270) {
                    sb.append("270");
                } else {
                    sb.append("0");
                }
                String result = this.getVivotekSmartDevice().getHttpHandler().readGetRequest(sb.toString());
                int counter = 0;
                while (result.toLowerCase().contains("mjpeg_maxframe='err_invalid'") && counter++ < 10) {
                    fps = counter % 2 == 0 ? (fps -= counter) : (fps += counter);
                    String url = "/cgi-bin/operator/setparam.cgi?" + prefix + "mjpeg_maxframe=" + fps;
                    result = this.getVivotekSmartDevice().getHttpHandler().readGetRequest(url);
                }
            }
            catch (SeeTecException see) {
                this.logger.error((Object)see, (Throwable)see);
                return see.getErrorCode();
            }
            if (this.rotationAngle == 90 || this.rotationAngle == 270) {
                int temp = this.width;
                this.width = this.height;
                this.height = temp;
            }
            this.myThread = new Thread((Runnable)this, this.toString());
            this.myThread.start();
            return errorCode;
        }
        catch (Throwable t) {
            this.logger.error("Unexpected exception while initialization for " + this, t);
            return -20000;
        }
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            while (!this.isShutdown()) {
                try {
                    this.networkParameter = ((VivotekSmartDevice)this.videoSrv.getDevice()).getNetworkParameter();
                    String serverPushURL = "/video" + this.videoPostfix + ".mjpg";
                    try {
                        int streamNumber = this.listener.getDynamicVideoProfileID();
                        serverPushURL = this.readServerPushUrl(this.videoSourceNr, streamNumber);
                    }
                    catch (Exception ex) {
                        this.logger.warn("Exception while reading server push URL. Using default URL instead for " + this);
                    }
                    this.httpHandler = new HttpHandlerImpl(this.networkParameter);
                    this.httpHandler.readServerPushRequest(serverPushURL, (HttpHandlerIntf)this);
                }
                catch (Exception e) {
                    this.logger.error("Reading configuration from " + this.getVideoSrv().getDevice() + " failed :-(", (Throwable)e);
                    this.listener.sendStatusService(-21601);
                }
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            this.listener.sendStatusService(-21651);
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    public void sendStatusService(int statusCode) {
        this.listener.sendStatusService(statusCode);
    }

    @Override
    public int shutdown() {
        if (this.httpHandler != null) {
            this.httpHandler.shutdown();
            this.httpHandler = null;
        }
        return super.shutdown();
    }

    protected String readServerPushUrl(int videoSourceNr, int streamNumber) throws SeeTecException {
        String result = this.getVivotekSmartDevice().getHttpHandler().readGetRequest("/cgi-bin/admin/getparam.cgi?");
        String urlMultiChannel = VivotekSmartHelper.getParameterValue(result, "network_http_c" + (videoSourceNr - 1) + "_s" + streamNumber + "_accessname");
        String urlSingleChannel = VivotekSmartHelper.getParameterValue(result, "network_http_s" + streamNumber + "_accessname");
        return "/" + (urlMultiChannel.isEmpty() ? urlSingleChannel : urlMultiChannel);
    }

    private VivotekSmartTriggerHandler getVivotekSmartTriggerHandler() {
        return (VivotekSmartTriggerHandler)this.videoSrv.getGenericEventHandler();
    }
}

