/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.vivotek.smart;

import de.seetec.v5.re.cm.device.shared.io.DigitalInputSrv;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.vivotek.smart.VivotekSmartDevice;
import de.seetec.v5.shared.util.SeeTecException;

public class VivotekSmartIOHandler
extends IOHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.vivotek.smart.VivotekSmartIOHandler";

    @Override
    public final void run() {
        super.setRunFinished(CLASS_NAME, false);
    }

    public void processContent(byte status) {
        DigitalInputSrv[] iServices;
        int[] inputValues = new int[super.getHighestInputNumber()];
        for (int i = 0; i < inputValues.length; ++i) {
            int mask = (int)Math.pow(2.0, i);
            inputValues[i] = status & mask;
        }
        for (DigitalInputSrv iService : iServices = super.getDigitalInputSrv()) {
            iService.checkInput(inputValues);
        }
    }

    @Override
    public int writeDigitalOutput(int number, int value, long holdTime) {
        StringBuilder url = new StringBuilder();
        try {
            IOHandler.HoldTimer holdTimer;
            int errorCode;
            url.append("/cgi-bin");
            url.append("/dido/setdo.cgi?do");
            url.append(number - 1);
            url.append("=");
            url.append(value);
            ((VivotekSmartDevice)this.device).getHttpHandler().readGetRequest(url.toString());
            if (holdTime > 0L && (errorCode = (holdTimer = new IOHandler.HoldTimer()).init(number, value > 0 ? 0 : 1, holdTime)) != 0) {
                holdTimer.shutdown();
                this.logger.warn("Creating " + holdTimer + " failed with error [" + errorCode + "] :-(");
            }
            return 0;
        }
        catch (SeeTecException ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            return ex.getErrorCode();
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -21600;
        }
    }
}

