/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.vivotek.smart;

import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.vivotek.smart.VivotekSmartDevice;
import de.seetec.v5.re.cm.device.video.vivotek.smart.VivotekSmartHelper;
import de.seetec.v5.re.cm.device.video.vivotek.smart.VivotekSmartIOHandler;
import de.seetec.v5.re.cm.device.video.vivotek.smart.VivotekSmartTriggerHandler;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MpegProfile;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;

public class VivotekSmartH26xVideoSourceClient
extends StreamingVideoSourceClientRTSP {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.vivotek.smart.VivotekSmartVideoSourceClient";
    private static final String SET_PARAM = "/cgi-bin/admin/setparam.cgi?";
    private String rtspUrl = null;
    private String streamID = null;
    private String livePostfix = "";

    public VivotekSmartDevice getVivotekSmartDevice() {
        return (VivotekSmartDevice)this.getVideoSrv().getDevice();
    }

    @Override
    public void processData(byte[] data) {
        int lengthOfHeaderExtension = 0;
        if (this.isShutdown()) {
            return;
        }
        if (data == null) {
            this.logger.error("Incoming data is null for " + this.getVideoSrv());
            return;
        }
        try {
            if ((data[0] >> 4 & 1) == 1) {
                lengthOfHeaderExtension = Basic.byteArrayToInt4((byte[])new byte[]{data[14], data[15]});
                if ((lengthOfHeaderExtension *= 4) > 0) {
                    for (int i = 16; i < lengthOfHeaderExtension + 16; ++i) {
                        int lengthOfContent;
                        if (data[i] == 0) continue;
                        if (data[i] == 1) {
                            int userDataLength;
                            if ((data[i + 1] & 0x80) == 128) {
                                byte lengthOfLengthInformation = (byte)(data[i + 1] & 0x7F);
                                byte[] lengthInformation = new byte[1 + lengthOfLengthInformation];
                                System.arraycopy(data, i + 2, lengthInformation, 1, lengthOfLengthInformation);
                                lengthOfContent = Basic.byteArrayToInt4((byte[])lengthInformation);
                                i += lengthOfLengthInformation;
                            } else {
                                lengthOfContent = data[i + 1] & 0x7F;
                            }
                            i += 10;
                            if (this.getVideoSrv().getDevice().getIOHandler() != null) {
                                boolean additionalDIsActive;
                                byte statusAllInputs = (byte)(data[i] & 0xF);
                                boolean bl = additionalDIsActive = (byte)(data[i + 2] & 2) == 2;
                                if (additionalDIsActive) {
                                    byte statusDI7 = (byte)(data[i + 2] << 3 & 8);
                                    byte statusDI4To6 = (byte)(data[i + 3] >> 5 & 7);
                                    statusAllInputs = (byte)(statusAllInputs | statusDI7 << 4 | statusDI4To6 << 4);
                                }
                                ((VivotekSmartIOHandler)this.getVideoSrv().getDevice().getIOHandler()).processContent(statusAllInputs);
                            }
                            if ((userDataLength = data[i += 11] * 4) > 0) {
                                byte[] bytesToCheck = new byte[userDataLength];
                                System.arraycopy(data, i + 1, bytesToCheck, 0, userDataLength);
                                if (this.getVivotekSmartTriggerHandler() != null && !this.getVivotekSmartTriggerHandler().isMetadataStreamEnabled()) {
                                    this.getVivotekSmartTriggerHandler().processTriggerData(bytesToCheck, this.videoSourceNr);
                                }
                            }
                            i += lengthOfContent + 1 - 21;
                            continue;
                        }
                        if ((data[i + 1] & 0x80) == 128) continue;
                        lengthOfContent = (byte)(data[i + 1] & 0x7F);
                        i += lengthOfContent + 1;
                    }
                }
            }
            if (this.videoCodec == Codec.H264 || this.videoCodec == Codec.H265) {
                this.processRtpData(data);
            }
        }
        catch (Throwable t) {
            this.logger.error("Ignoring packet due to unexpected error: " + t.getMessage(), t);
        }
    }

    @Override
    public void sendStatusService(int errorCode) {
        this.listener.sendStatusService(errorCode);
    }

    @Override
    public int init() {
        int counter;
        String result;
        int error = super.init();
        if (error != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return error;
        }
        this.networkParameter = ((VivotekSmartDevice)this.videoSrv.getDevice()).getNetworkParameter();
        this.streamID = "_s" + this.listener.getDynamicVideoProfileID();
        this.fps = (int)(this.fps / 1000L);
        StringBuilder sb = new StringBuilder(256);
        StringBuilder sbAudio = new StringBuilder(256);
        long[] allowedValues = new long[]{250L, 500L, 1000L, 2000L, 3000L, 4000L};
        this.iFrameDist = Tools.convertToCameraValues(allowedValues, (long)this.iFrameDistMS);
        this.bandwidth = (int)((double)this.bandwidth / 1.024);
        this.quality /= 20000;
        this.quality = this.quality < 1 ? 1 : this.quality;
        String codecString = "h264";
        if (this.videoCodec == Codec.H265) {
            codecString = "h265";
        } else if (this.videoCodec == Codec.MJPEG) {
            codecString = "mjpeg";
        }
        sb.append(SET_PARAM);
        try {
            this.rtspUrl = this.readRtspUrl(this.videoSourceNr, this.listener.getDynamicVideoProfileID());
        }
        catch (SeeTecException ex) {
            if (this.getListener().getLiveCameraSrv().getDevice().getNumberOfVideoSources() > 1) {
                this.livePostfix = this.videoSourceNr - 1 == 0 ? "" : "" + this.videoSourceNr;
                this.livePostfix = this.listener.getDynamicVideoProfileID() == 0 ? this.livePostfix : this.livePostfix + "s" + (this.listener.getDynamicVideoProfileID() + 1);
            } else {
                this.livePostfix = this.listener.getDynamicVideoProfileID() == 0 ? "" : "" + (this.listener.getDynamicVideoProfileID() + 1);
            }
            this.rtspUrl = "/live" + this.livePostfix + ".sdp";
        }
        if (this.isAudioEnabled) {
            sbAudio.append(SET_PARAM);
            sbAudio.append("audioin_c");
            sbAudio.append(this.videoSourceNr - 1);
            sbAudio.append(this.streamID);
            sbAudio.append("_codectype=g711&audioin_c");
            sbAudio.append(this.videoSourceNr - 1);
            sbAudio.append(this.streamID);
            sbAudio.append("_g711_mode=pcmu&audioin_c");
            sbAudio.append(this.videoSourceNr - 1);
            sbAudio.append("_mute=0");
        }
        String prefix = "videoin_c" + (this.videoSourceNr - 1) + this.streamID + "_";
        sb.append(prefix);
        sb.append("codectype=");
        sb.append(codecString);
        sb.append("&");
        sb.append(prefix);
        sb.append(codecString);
        sb.append("_maxframe=");
        sb.append(this.fps);
        sb.append("&");
        sb.append(prefix);
        sb.append(codecString);
        sb.append("_intraperiod=");
        sb.append(this.iFrameDist);
        if (this.isConstantBitrateUsed) {
            sb.append("&");
            sb.append(prefix);
            sb.append(codecString);
            sb.append("_ratecontrolmode=cbr");
            sb.append("&");
            sb.append(prefix);
            sb.append(codecString);
            sb.append("_bitrate=");
            sb.append(this.bandwidth);
        } else {
            sb.append("&");
            sb.append(prefix);
            sb.append(codecString);
            sb.append("_ratecontrolmode=vbr");
            sb.append("&");
            sb.append(prefix);
            sb.append(codecString);
            sb.append("_quant=");
            sb.append(this.quality);
            sb.append("&");
            sb.append(prefix);
            sb.append(codecString);
            sb.append("_maxvbrbitrate=");
            sb.append(this.bandwidth);
        }
        sb.append("&");
        sb.append(prefix);
        sb.append("resolution=");
        if (this.resolutionTag != null && !this.resolutionTag.isEmpty()) {
            sb.append(this.resolutionTag);
        } else {
            sb.append(this.width);
            sb.append("x");
            sb.append(this.height);
        }
        sb.append("&videoin_c");
        sb.append(this.videoSourceNr - 1);
        sb.append("_imprinttimestamp=");
        sb.append(this.useDateTime || this.useTitle ? "1" : "0");
        sb.append("&videoin_c");
        sb.append(this.videoSourceNr - 1);
        sb.append("_text=");
        if (this.useTitle) {
            sb.append(this.title);
        }
        sb.append("&videoin_c");
        sb.append(this.videoSourceNr - 1);
        sb.append("_flip=");
        if (this.rotationAngle == 180) {
            sb.append("1&videoin_c");
            sb.append(this.videoSourceNr - 1);
            sb.append("_mirror=1");
        } else {
            sb.append("0&videoin_c");
            sb.append(this.videoSourceNr - 1);
            sb.append("_mirror=0");
        }
        sb.append("&videoin_c");
        sb.append(this.videoSourceNr - 1);
        sb.append("_rotate=");
        if (this.rotationAngle == 90) {
            sb.append("90");
        } else if (this.rotationAngle == 270) {
            sb.append("270");
        } else {
            sb.append("0");
        }
        if (this.videoCodec == Codec.H264) {
            try {
                int profile = 0;
                if (this.listener.getVideoSourceParameter().getMpegProfile() == MpegProfile.MAIN) {
                    profile = 1;
                } else if (this.listener.getVideoSourceParameter().getMpegProfile() == MpegProfile.HIGH) {
                    profile = 2;
                }
                sb.append("&videoin_c");
                sb.append(this.videoSourceNr - 1);
                sb.append("_profile=");
                sb.append(profile);
            }
            catch (ConfigurationException ex) {
                this.logger.warn("Exception while reading MPEG Profile for " + this + " : " + ex.getMessage());
                this.logger.warn("Will continue to start the stream anyway...");
            }
        }
        try {
            result = this.getVivotekSmartDevice().getHttpHandler().readGetRequest(sb.toString());
            counter = 0;
            while (result.toLowerCase().contains(codecString + "_maxframe='err_invalid'") && counter++ < 10) {
                this.fps = counter % 2 == 0 ? (this.fps -= (long)counter) : (this.fps += (long)counter);
                String url = SET_PARAM + prefix + codecString + "_maxframe=" + this.fps;
                result = this.getVivotekSmartDevice().getHttpHandler().readGetRequest(url);
            }
        }
        catch (SeeTecException see) {
            this.logger.error((Object)see, (Throwable)see);
            error = see.getErrorCode();
            return error;
        }
        catch (Exception e) {
            this.logger.error((Object)e, (Throwable)e);
            return -21601;
        }
        if (this.isConstantBitrateUsed) {
            result = "";
            counter = 0;
            int[] allowedIntValues = new int[]{20000, 40000, 50000, 64000, 128000, 256000, 512000, 768000, 1000000, 1500000, 2000000, 3000000, 4000000, 6000000, 8000000, 10000000, 12000000, 14000000, 16000000, 20000000, 30000000, 40000000};
            int bandwidthLimit = 4000000;
            if (this.getVivotekSmartDevice().getNumberOfVideoSources() > 1) {
                bandwidthLimit = 1000000;
            }
            while ((result.isEmpty() || result.contains("bitrate='ERR_INVALID'")) && counter < 20) {
                ++counter;
                String url = "/cgi-bin/admin/setparam.cgi?videoin_c" + (this.videoSourceNr - 1) + this.streamID + "_" + codecString + "_bitrate=" + this.bandwidth;
                try {
                    result = this.getVivotekSmartDevice().getHttpHandler().readGetRequest(url);
                }
                catch (SeeTecException see) {
                    this.logger.error((Object)see, (Throwable)see);
                    error = see.getErrorCode();
                    return error;
                }
                catch (Exception e) {
                    this.logger.error((Object)e, (Throwable)e);
                    return -21601;
                }
                this.bandwidth = VivotekSmartHelper.getNextValue(allowedIntValues, this.bandwidth, bandwidthLimit);
            }
        }
        if (this.isAudioEnabled) {
            try {
                this.getVivotekSmartDevice().getHttpHandler().readGetRequest(sbAudio.toString());
            }
            catch (SeeTecException see) {
                this.logger.error((Object)see, (Throwable)see);
                error = see.getErrorCode();
                return error;
            }
            catch (Exception e) {
                this.logger.error("Reading/Setting audio configuration from " + this.getVideoSrv().getDevice() + " failed :-(", (Throwable)e);
                return -21601;
            }
        }
        this.rtspSettings = new RTSPStreamSettings();
        try {
            error = this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), "rtsp://" + this.getHost() + this.rtspUrl, this.printDebug, this.transmissionID, this.networkParameter.getSoTimeout(), this.isAudioEnabled, 4, this.rtspUrl);
            if (error != 0) {
                this.logger.error("Initialization of RTSPSettings failed with errorCode: " + error + " for " + this.getVideoSrv());
                return error;
            }
        }
        catch (ConfigurationException ex) {
            this.logger.warn("Could not initialize rtspSettings for " + this);
            this.logger.warn((Object)ex, (Throwable)ex);
        }
        if (this.rotationAngle == 90 || this.rotationAngle == 270) {
            int temp = this.width;
            this.width = this.height;
            this.height = temp;
        }
        this.rtspSettings.setUserAgent("RTPExPlayer");
        this.rtspSettings.setCheckResolutionWidth(true, new int[]{this.width, this.height}, 10);
        try {
            this.rtspHandler = this.rtspSettings.getRTSPHandler();
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while starting RTSP Handling for " + this.getVideoSrv() + " : " + ex.getMessage());
            return ex.getErrorCode();
        }
        error = this.rtspHandler.start();
        if (error != 0) {
            this.logger.error("Start of RTSPHandler failed with errorCode: " + error + " for " + this.getVideoSrv());
            return error;
        }
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        return super.shutdown();
    }

    protected String readRtspUrl(int videoSourceNr, int streamNumber) throws SeeTecException {
        String result = this.getVivotekSmartDevice().getHttpHandler().readGetRequest("/cgi-bin/admin/getparam.cgi?");
        String urlMultiChannel = VivotekSmartHelper.getParameterValue(result, "network_rtsp_c" + (videoSourceNr - 1) + "_s" + streamNumber + "_accessname");
        String urlSingleChannel = VivotekSmartHelper.getParameterValue(result, "network_rtsp_s" + streamNumber + "_accessname");
        return "/" + (urlMultiChannel.isEmpty() ? urlSingleChannel : urlMultiChannel);
    }

    private VivotekSmartTriggerHandler getVivotekSmartTriggerHandler() {
        return (VivotekSmartTriggerHandler)this.videoSrv.getGenericEventHandler();
    }
}

