/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.vivotek.smart;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VivotekSmartEvent {
    private static String CLASS_NAME = "de.seetec.v5.re.cm.device.video.vivotek.smart.VivotekSmartEvent";
    private String name;
    private String triggerName;
    private int channel;
    private boolean active;
    private Logger logger = null;
    private String action = "";

    public VivotekSmartEvent(String eventData) {
        String[] htmlElements;
        this.logger = LogManager.getLogger((String)CLASS_NAME);
        for (String htmlElement : htmlElements = eventData.split("\r\n")) {
            String[] eventElements;
            if (!htmlElement.contains("Code=")) continue;
            for (String eventElement : eventElements = htmlElement.split(";")) {
                if (eventElement.contains("Code=")) {
                    this.triggerName = eventElement.replace("Code=", "");
                    this.name = VivotekSmartEvent.matchNames(this.triggerName);
                    continue;
                }
                if (eventElement.contains("action=")) {
                    this.action = eventElement.replace("action=", "");
                    continue;
                }
                if (!eventElement.contains("index=")) continue;
                try {
                    this.channel = Integer.parseInt(eventElement.replace("index=", "") + 1);
                }
                catch (NumberFormatException ex) {
                    this.logger.warn("Error while trying to convert channel number to integer for inputstring " + eventElement.replace("index=", ""));
                }
            }
        }
    }

    VivotekSmartEvent(String eventName, int sourceNumber) {
        this.name = eventName;
        this.channel = sourceNumber;
    }

    public String getName() {
        return this.name;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public String getAction() {
        return this.action;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int channel) {
        this.channel = channel;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public static String matchNames(String triggerName) {
        if (triggerName == null || triggerName.isEmpty()) {
            return "";
        }
        switch (triggerName) {
            case "seq": {
                return "Periodic condition";
            }
            case "boot": {
                return "System boot";
            }
            case "motion": {
                return "Video motion detection";
            }
            case "recnotify": {
                return "Recording notification";
            }
            case "tampering": {
                return "Tamper detection";
            }
            case "vi": {
                return "Virtual input";
            }
            case "vadp": {
                return "VACP trigger";
            }
            case "di": {
                return "Digital input";
            }
            case "volalarm": {
                return "Audio detection";
            }
            case "temperature": {
                return "Temperature detection";
            }
            case "pir": {
                return "PIR detection";
            }
            case "visignal": {
                return "Video input signal loss";
            }
            case "backup": {
                return "Backing up recorded files";
            }
            case "smartsd": {
                return "Lifetime detection of SD card";
            }
            case "shockalarm": {
                return "Shock detection";
            }
            case "quarantine": {
                return "Quarantine";
            }
            case "cyberattack": {
                return "CyberAttack";
            }
            case "bruteforceattack": {
                return "BruteForceAttack";
            }
        }
        return triggerName;
    }

    public static String getExtendedEventName(String eventNameFromConfiguration) {
        if (eventNameFromConfiguration == null || eventNameFromConfiguration.isEmpty()) {
            return "";
        }
        switch (eventNameFromConfiguration) {
            case "Video motion detection Window 1": 
            case "Video motion detection Window 2": 
            case "Video motion detection Window 3": 
            case "Video motion detection Window 4": 
            case "Video motion detection Window 5": 
            case "Video motion detection ended Window 1": 
            case "Video motion detection ended Window 2": 
            case "Video motion detection ended Window 3": 
            case "Video motion detection ended Window 4": 
            case "Video motion detection ended Window 5": {
                return "tns1:VideoAnalytics/Motion";
            }
            case "Tamper detection": {
                return "tns1:Device/Tampering";
            }
            case "ImageTooBlurry": {
                return "tns1:VideoSource/ImageTooBlurry/ImagingService";
            }
            case "ImageTooDark": {
                return "tns1:VideoSource/ImageTooDark/ImagingService";
            }
            case "ImageTooBright": {
                return "tns1:VideoSource/ImageTooBright/ImagingService";
            }
            case "GlobalSceneChange": {
                return "tns1:VideoSource/GlobalSceneChange/ImagingService";
            }
            case "Lifetime detection of SD card": {
                return "tns1:Device/Trigger/SmartSD";
            }
            case "Audio detection": {
                return "tns1:Device/Trigger/VolAlarm";
            }
            case "Shock detection": {
                return "tns1:Device/Trigger/ShockAlarm";
            }
        }
        return eventNameFromConfiguration;
    }
}

