/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.vivotek.smart;

import de.seetec.v5.re.cm.configuration.definition.camera.FeaturesType;
import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.AudioCapabilitiesType;
import de.seetec.v5.re.cm.configuration.definition.device.AudioCodecsType;
import de.seetec.v5.re.cm.configuration.definition.device.AvailableIOsType;
import de.seetec.v5.re.cm.configuration.definition.device.BitrateSettingsType;
import de.seetec.v5.re.cm.configuration.definition.device.CameraResolutionType;
import de.seetec.v5.re.cm.configuration.definition.device.CaptureModeDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.CodecType;
import de.seetec.v5.re.cm.configuration.definition.device.CommentsType;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceGroupMembershipsType;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceNetworkDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.GenericEventDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.ImageRotationCapabilitiesType;
import de.seetec.v5.re.cm.configuration.definition.device.MiscVideoServerCapabilitiesType;
import de.seetec.v5.re.cm.configuration.definition.device.MultiStreamingDefinitionsType;
import de.seetec.v5.re.cm.configuration.definition.device.RtspSettingsType;
import de.seetec.v5.re.cm.configuration.definition.device.StreamDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedApiVersionsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedCameraResolutionsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedCaptureModesType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedGenericEventsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedMPEGProfileIDs;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedRotationAnglesType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedTransmissionTypeIDsType;
import de.seetec.v5.re.cm.configuration.definition.device.SupportedVideoSourceEntityTypesType;
import de.seetec.v5.re.cm.configuration.definition.device.VirtualCameraDefinitionType;
import de.seetec.v5.re.cm.device.shared.VideoServer;
import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.device.video.vivotek.smart.VivotekSmartEvent;
import de.seetec.v5.re.cm.device.video.vivotek.smart.VivotekSmartHelper;
import de.seetec.v5.re.cm.device.video.vivotek.smart.VivotekSmartIOHandler;
import de.seetec.v5.re.cm.device.video.vivotek.smart.VivotekSmartResolutions;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaID;
import de.seetec.v5.re.shared.MpegProfile;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.HTTPStatusCode;
import de.seetec.v5.shared.net.HttpHandlerImpl;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.xml.sax.SAXException;

public class VivotekSmartDevice
extends VideoServer {
    private static final long DEFAULT_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    private static final long MAX_VIDEOSTREAM_NETWORK_TIMEOUT = TimeUnit.SECONDS.toMillis(20L);
    private static final long MIN_VIDEOSTREAM_NETWORK_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    private final int legacyTimeout = (int)TimeUnit.SECONDS.toMillis(5L);
    private String currentName;
    private HttpHandlerImpl httpHandler;
    private final Object SEMAPHORE = new Object();
    private NetworkParameter networkParameter;

    @Override
    protected IOHandler createIOHandler() {
        return new VivotekSmartIOHandler();
    }

    public NetworkParameter getNetworkParameter() {
        if (this.networkParameter == null) {
            try {
                this.networkParameter = this.getDeviceCnf().getNetworkParameter();
                this.networkParameter.checkAndSetTimeout(this.legacyTimeout);
            }
            catch (ConfigurationException ex) {
                this.getLogger().error("Could not get NetworkParameters from Device configuration for " + this + " : " + ex.getMessage());
            }
        }
        return this.networkParameter;
    }

    @Override
    protected boolean isSupportingIO() {
        return true;
    }

    @SuppressFBWarnings(value={"HARD_CODE_PASSWORD"}, justification="Mentionned hard-coded password is just empty default pass which is a proper default setting in this case.")
    protected VirtualCameraDefinitionType getVirtualCameraDefinitionType() {
        VirtualCameraDefinitionType virtualCameraDefinitionType = new VirtualCameraDefinitionType();
        virtualCameraDefinitionType.setCanVirtualCamera(false);
        virtualCameraDefinitionType.setCanVirtualCameraCropping(false);
        virtualCameraDefinitionType.setNoOfVirtualCameras(0);
        return virtualCameraDefinitionType;
    }

    @SuppressFBWarnings(value={"HARD_CODE_PASSWORD"}, justification="The hardcoded password is just a factory default that get overwritten.")
    protected DeviceNetworkDefinitionType getDeviceNetworkDefinitionType() throws SeeTecException, SAXException {
        DeviceNetworkDefinitionType deviceNetworkDefinitionType = new DeviceNetworkDefinitionType();
        deviceNetworkDefinitionType.setCanChangeHttpPort(true);
        deviceNetworkDefinitionType.setCanChangeHttpsPort(true);
        deviceNetworkDefinitionType.setDefaultHttpPort(80);
        deviceNetworkDefinitionType.setDefaultHttpsPort(443);
        deviceNetworkDefinitionType.setDefaultPassword("");
        deviceNetworkDefinitionType.setDefaultUserName("");
        deviceNetworkDefinitionType.setUseAuthentication(true);
        deviceNetworkDefinitionType.setCanHttps(true);
        deviceNetworkDefinitionType.setMinVideoStreamNetworkTimeout(MIN_VIDEOSTREAM_NETWORK_TIMEOUT);
        deviceNetworkDefinitionType.setMaxVideoStreamNetworkTimeout(MAX_VIDEOSTREAM_NETWORK_TIMEOUT);
        deviceNetworkDefinitionType.setDefaultVideoStreamNetworkTimeout(DEFAULT_TIMEOUT);
        return deviceNetworkDefinitionType;
    }

    protected StreamDefinitionType getCommonStreamDefinitionType() {
        StreamDefinitionType streamDefinitionType = new StreamDefinitionType();
        streamDefinitionType.setNoOfHWMDInputs(0);
        streamDefinitionType.setDefaultMilliFPS(1000);
        streamDefinitionType.setHideFPSField(false);
        streamDefinitionType.setHideIFrameField(false);
        streamDefinitionType.setMinIFrameDistance(1);
        streamDefinitionType.setMaxIFrameDistance(Integer.MAX_VALUE);
        streamDefinitionType.setHideKompressionField(false);
        streamDefinitionType.setHideBandwithField(false);
        streamDefinitionType.setEncodingIntervalMin(0);
        streamDefinitionType.setEncodingIntervalMax(0);
        streamDefinitionType.setRtspSettings(this.getRtspSettingsType());
        streamDefinitionType.setDefaultCameraResolutionIndex(0);
        streamDefinitionType.setDefaultTransmissionTypeIndex(0);
        return streamDefinitionType;
    }

    protected RtspSettingsType getRtspSettingsType() {
        RtspSettingsType rtspSettingsType = new RtspSettingsType();
        rtspSettingsType.setDefaultRtspPort(554);
        rtspSettingsType.setCanChangeRtspPort(true);
        rtspSettingsType.setCanMultipleRtspPorts(false);
        return rtspSettingsType;
    }

    protected SupportedCameraResolutionsType getSupportedCameraResolutionsType(String capabilities, Codec codec) {
        SupportedCameraResolutionsType supportedCameraResolutionsType = new SupportedCameraResolutionsType();
        String[] resolutions = VivotekSmartHelper.getMultipleParameterValues(capabilities, "capability_videoin_resolution");
        String codecName = "mjpeg";
        if (codec == Codec.H264) {
            codecName = "h264";
        } else if (codec == Codec.H265) {
            codecName = "h265";
        }
        int[] framerates = VivotekSmartHelper.getMultipleParameterNumericalValues(capabilities, "capability_videoin_" + codecName + "_maxframerate");
        if (framerates.length == 0) {
            framerates = VivotekSmartHelper.getMultipleParameterNumericalValues(capabilities, "capability_videoin_maxframerate");
        }
        if (framerates.length >= resolutions.length) {
            for (int i = 0; i < framerates.length; ++i) {
                int height;
                int width;
                if (resolutions.length <= i) continue;
                String resolution = resolutions[i].trim();
                String resolutionTag = "";
                String resolutionTagForClient = "";
                if (resolution.contains("x")) {
                    String[] resolutionLines = resolution.split("x");
                    if (resolutionLines.length != 2) continue;
                    try {
                        width = Integer.parseInt(resolutionLines[0]);
                        height = Integer.parseInt(resolutionLines[1]);
                    }
                    catch (NumberFormatException ex) {
                        this.getLogger().warn("Could not parse resolution value " + resolution + " for " + this);
                        continue;
                    }
                    resolutionTag = resolutionTagForClient = width + "x" + height;
                } else {
                    VivotekSmartResolutions vivotekSmartResolutions = VivotekSmartResolutions.valueOfString(resolution);
                    width = vivotekSmartResolutions.getWidth();
                    height = vivotekSmartResolutions.getHeightPAL();
                    String heightNtsc = Integer.toString(vivotekSmartResolutions.getHeightNTSC());
                    resolutionTagForClient = resolution + "(" + width + "x" + height + "/" + width + "x" + heightNtsc + ")";
                    resolutionTag = resolution;
                }
                CameraResolutionType cameraResolutionType = new CameraResolutionType();
                cameraResolutionType.setDisplayResolution(resolutionTagForClient);
                cameraResolutionType.setWidth(width);
                cameraResolutionType.setHeight(height);
                cameraResolutionType.setMaxMilliFPS(framerates[i] * 1000);
                cameraResolutionType.setMinMilliFPS(1);
                cameraResolutionType.setResolution(resolutionTag);
                cameraResolutionType.setSupportedFrameRates(null);
                supportedCameraResolutionsType.getCameraResolution().add(cameraResolutionType);
            }
        } else {
            for (int i = 0; i < resolutions.length; ++i) {
                int height;
                int width;
                String resolution = resolutions[i].trim();
                String resolutionTag = "";
                String resolutionTagForClient = "";
                if (resolution.contains("x")) {
                    String[] resolutionLines = resolution.split("x");
                    if (resolutionLines.length != 2) continue;
                    try {
                        width = Integer.parseInt(resolutionLines[0]);
                        height = Integer.parseInt(resolutionLines[1]);
                    }
                    catch (NumberFormatException ex) {
                        this.getLogger().warn("Could not parse resolution value " + resolution + " for " + this);
                        continue;
                    }
                    resolutionTag = resolutionTagForClient = width + "x" + height;
                } else {
                    VivotekSmartResolutions vivotekSmartResolutions = VivotekSmartResolutions.valueOfString(resolution);
                    width = vivotekSmartResolutions.getWidth();
                    height = vivotekSmartResolutions.getHeightPAL();
                    String heightNtsc = Integer.toString(vivotekSmartResolutions.getHeightNTSC());
                    resolutionTagForClient = resolution + "(" + width + "x" + height + "/" + width + "x" + heightNtsc + ")";
                    resolutionTag = resolution;
                }
                CameraResolutionType cameraResolutionType = new CameraResolutionType();
                cameraResolutionType.setDisplayResolution(resolutionTagForClient);
                cameraResolutionType.setWidth(width);
                cameraResolutionType.setHeight(height);
                int fps = 25;
                fps = framerates.length > i ? framerates[i] : framerates[framerates.length - 1];
                cameraResolutionType.setMaxMilliFPS(fps * 1000);
                cameraResolutionType.setMinMilliFPS(1);
                cameraResolutionType.setResolution(resolutionTag);
                cameraResolutionType.setSupportedFrameRates(null);
                supportedCameraResolutionsType.getCameraResolution().add(cameraResolutionType);
            }
        }
        return supportedCameraResolutionsType;
    }

    protected MultiStreamingDefinitionsType getMultiStreamingDefinitionsType(String capabilities, int numberOfStreams) {
        MultiStreamingDefinitionsType multiStreamingDefinitionsType = new MultiStreamingDefinitionsType();
        String[] codecs = VivotekSmartHelper.getMultipleParameterValues(capabilities, "capability_videoin_codec");
        try {
            block12: for (String codec : codecs) {
                CodecType codecType;
                StreamDefinitionType streamDefinitionType = this.getCommonStreamDefinitionType();
                switch (codec) {
                    case "h264": {
                        streamDefinitionType.setSupportedCameraResolutions(this.getSupportedCameraResolutionsType(capabilities, Codec.H264));
                        codecType = new CodecType();
                        codecType.setValue(Codec.H264.getType());
                        SupportedMPEGProfileIDs supportedMpegProfileIds = new SupportedMPEGProfileIDs();
                        supportedMpegProfileIds.getInt().add(MpegProfile.BASELINE.getType());
                        supportedMpegProfileIds.getInt().add(MpegProfile.MAIN.getType());
                        supportedMpegProfileIds.getInt().add(MpegProfile.HIGH.getType());
                        SupportedTransmissionTypeIDsType supportedTransmissionTypeIDsType = new SupportedTransmissionTypeIDsType();
                        supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_UDP_UNICAST.getType());
                        supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_TCP.getType());
                        supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_HTTP_UNICAST.getType());
                        streamDefinitionType.setSupportedTransmissionTypeIDs(supportedTransmissionTypeIDsType);
                        BitrateSettingsType bitrateSettingsType = new BitrateSettingsType();
                        bitrateSettingsType.setCanVBR(true);
                        bitrateSettingsType.setCanVBRQuality(true);
                        bitrateSettingsType.setCanVBRBandwidth(true);
                        bitrateSettingsType.setCanCBR(true);
                        bitrateSettingsType.setCanCBRQuality(false);
                        bitrateSettingsType.setMaxBandwidth(0x2800000);
                        bitrateSettingsType.setMinBandwidth(1024);
                        bitrateSettingsType.setSupportedBitrates(null);
                        streamDefinitionType.setBitrateSettings(bitrateSettingsType);
                        streamDefinitionType.setSupportedMPEGProfileIDs(supportedMpegProfileIds);
                        break;
                    }
                    case "h265": {
                        streamDefinitionType.setSupportedCameraResolutions(this.getSupportedCameraResolutionsType(capabilities, Codec.H265));
                        codecType = new CodecType();
                        codecType.setValue(Codec.H265.getType());
                        SupportedTransmissionTypeIDsType supportedTransmissionTypeIDsType = new SupportedTransmissionTypeIDsType();
                        supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_UDP_UNICAST.getType());
                        supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_TCP.getType());
                        supportedTransmissionTypeIDsType.getInt().add(TransmissionType.RTP_OVER_RTSP_OVER_HTTP_UNICAST.getType());
                        streamDefinitionType.setSupportedTransmissionTypeIDs(supportedTransmissionTypeIDsType);
                        BitrateSettingsType bitrateSettingsType = new BitrateSettingsType();
                        bitrateSettingsType.setCanVBR(true);
                        bitrateSettingsType.setCanVBRQuality(true);
                        bitrateSettingsType.setCanVBRBandwidth(true);
                        bitrateSettingsType.setCanCBR(true);
                        bitrateSettingsType.setCanCBRQuality(false);
                        bitrateSettingsType.setMaxBandwidth(0x2800000);
                        bitrateSettingsType.setMinBandwidth(1024);
                        bitrateSettingsType.setSupportedBitrates(null);
                        streamDefinitionType.setBitrateSettings(bitrateSettingsType);
                        break;
                    }
                    case "mjpeg": {
                        streamDefinitionType.setSupportedCameraResolutions(this.getSupportedCameraResolutionsType(capabilities, Codec.MJPEG));
                        codecType = new CodecType();
                        codecType.setValue(Codec.MJPEG.getType());
                        SupportedTransmissionTypeIDsType supportedTransmissionTypeIDsType = new SupportedTransmissionTypeIDsType();
                        supportedTransmissionTypeIDsType.getInt().add(TransmissionType.HTTP_SERVERPUSH.getType());
                        streamDefinitionType.setSupportedTransmissionTypeIDs(supportedTransmissionTypeIDsType);
                        streamDefinitionType.setHideKompressionField(false);
                        streamDefinitionType.setBitrateSettings(null);
                        break;
                    }
                    default: {
                        continue block12;
                    }
                }
                streamDefinitionType.setMaxNumberOfStreams(numberOfStreams);
                streamDefinitionType.setStreamingMode(codecType);
                streamDefinitionType.setName(codec.toUpperCase());
                multiStreamingDefinitionsType.getStreamDefinition().add(streamDefinitionType);
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Problems while getting streaming definitions from device for " + this, (Throwable)ex);
            throw ex;
        }
        return multiStreamingDefinitionsType;
    }

    protected AudioCapabilitiesType getAudioCapabilitiesType(String capabilities) {
        int audioValue;
        AudioCapabilitiesType audioCapabilitiesType = new AudioCapabilitiesType();
        try {
            audioValue = VivotekSmartHelper.getParameterNumericalValue(capabilities, "capability_naudioin");
            if (audioValue > 0) {
                audioCapabilitiesType.setCanAudio(true);
                AudioCodecsType audioCodecsType = VivotekSmartHelper.getAudioCodecs(capabilities);
                audioCapabilitiesType.setAudioCodecs(audioCodecsType);
            } else {
                audioCapabilitiesType.setCanAudio(false);
                audioCapabilitiesType.setAudioCodecs(null);
            }
        }
        catch (SeeTecException ex) {
            this.getLogger().warn("Exception while reading audio capabilities. Maybe audio is not available for " + this);
        }
        try {
            audioValue = VivotekSmartHelper.getParameterNumericalValue(capabilities, "capability_naudioout");
            if (audioValue > 0) {
                audioCapabilitiesType.setCanAudioOut(true);
            } else {
                audioCapabilitiesType.setCanAudioOut(false);
            }
        }
        catch (SeeTecException ex) {
            this.getLogger().warn("Exception while reading audio capabilities. Maybe audio is not available for " + this);
        }
        return audioCapabilitiesType;
    }

    protected ImageRotationCapabilitiesType getImageRotationCapabilitiesType(String capabilities) {
        ImageRotationCapabilitiesType imageRotationCapabilitiesType = new ImageRotationCapabilitiesType();
        SupportedRotationAnglesType supportedRotationAnglesType = new SupportedRotationAnglesType();
        imageRotationCapabilitiesType.setCanRotateJPEGImage(true);
        imageRotationCapabilitiesType.setCanRotateMPEGImage(true);
        supportedRotationAnglesType.getInt().add(0);
        supportedRotationAnglesType.getInt().add(180000);
        int canRotate = 0;
        try {
            canRotate = VivotekSmartHelper.getParameterNumericalValue(capabilities, "capability_videoin_c0_rotation");
        }
        catch (Exception ex) {
            this.logger.info("Corridor mode not supported for " + this);
        }
        if (canRotate == 1) {
            supportedRotationAnglesType.getInt().add(90000);
            supportedRotationAnglesType.getInt().add(270000);
        }
        imageRotationCapabilitiesType.setSupportedRotationAngles(supportedRotationAnglesType);
        return imageRotationCapabilitiesType;
    }

    private CameraResolutionType getCaptureModeCameraResolutionType(MultiStreamingDefinitionsType multiStreamingDefinitionsType) throws SeeTecException {
        CameraResolutionType captureModeCameraResolutionType = new CameraResolutionType();
        CameraResolutionType cameraResolutionType = VivotekSmartHelper.getBiggestResolution(multiStreamingDefinitionsType);
        captureModeCameraResolutionType.setDisplayResolution("DefaultCaptureMode");
        captureModeCameraResolutionType.setWidth(cameraResolutionType.getWidth());
        captureModeCameraResolutionType.setHeight(cameraResolutionType.getHeight());
        captureModeCameraResolutionType.setMaxMilliFPS(cameraResolutionType.getMaxMilliFPS());
        captureModeCameraResolutionType.setMinMilliFPS(1);
        captureModeCameraResolutionType.setResolution(cameraResolutionType.getResolution());
        captureModeCameraResolutionType.setSupportedFrameRates(null);
        return captureModeCameraResolutionType;
    }

    protected AvailableIOsType getAvailableIOsType(String capabilities) {
        int i;
        AvailableIOsType availableIOsType = new AvailableIOsType();
        int numberOfInputs = 0;
        int numberOfOutputs = 0;
        try {
            numberOfInputs = VivotekSmartHelper.getParameterNumericalValue(capabilities, "capability_ndi");
            numberOfOutputs = VivotekSmartHelper.getParameterNumericalValue(capabilities, "capability_ndo");
        }
        catch (Exception ex) {
            this.getLogger().error("Problems while geting IO definitions from device for " + this, (Throwable)ex);
        }
        for (i = 0; i < numberOfInputs; ++i) {
            availableIOsType.getInputOutputCapabilities().add(0);
        }
        for (i = 0; i < numberOfOutputs; ++i) {
            availableIOsType.getInputOutputCapabilities().add(1);
        }
        return availableIOsType;
    }

    protected MiscVideoServerCapabilitiesType getMiscVideoServerCapabilitiesType(String capabilities) throws SeeTecException {
        MiscVideoServerCapabilitiesType miscVideoServerCapabilitiesType = new MiscVideoServerCapabilitiesType();
        miscVideoServerCapabilitiesType.setCanTimeDate(true);
        miscVideoServerCapabilitiesType.setCanTitle(true);
        int tamperingValue = 0;
        try {
            tamperingValue = VivotekSmartHelper.getParameterNumericalValue(capabilities, "capability_tampering");
        }
        catch (Exception ex) {
            this.getLogger().error("Exception while reading Tampering capabilities. Asuming tampering is NOT available for " + this);
        }
        if (tamperingValue == 1) {
            miscVideoServerCapabilitiesType.setCanDetectTampering(true);
        } else {
            miscVideoServerCapabilitiesType.setCanDetectTampering(false);
        }
        miscVideoServerCapabilitiesType.setCanDetectVideoloss(false);
        miscVideoServerCapabilitiesType.setNoOfRS232S(0);
        miscVideoServerCapabilitiesType.setCanTimeshift(false);
        miscVideoServerCapabilitiesType.setPTZSpeedMultiplier(100);
        miscVideoServerCapabilitiesType.setCanPTZ(true);
        return miscVideoServerCapabilitiesType;
    }

    @Override
    protected DeviceDefinition getDeviceDefinitionFromDevice(String signature, String manufacturer, String name, String comments) throws SeeTecException {
        block10: {
            try {
                String capabilities = this.getHttpHandler().readGetRequest("/cgi-bin/admin/getparam.cgi?");
                String firmware = VivotekSmartHelper.getParameterValue(capabilities, "system_info_firmwareversion");
                this.currentName = VivotekSmartHelper.getParameterValue(capabilities, "system_info_modelname");
                String currentComments = "RE_APP_VERSION::7.1.1_23";
                String currentCaptureMode = VivotekSmartHelper.getParameterValue(capabilities, "videoin_c0_crop_size") + "_" + VivotekSmartHelper.getParameterValue(capabilities, "videoin_c0_mode");
                if (signature != null && signature.equals(firmware) && manufacturer != null && name != null && name.equals(this.currentName) && this.getCurrentCaptureModeFromDefinition().equals(currentCaptureMode) && comments != null && comments.equals(currentComments)) break block10;
                DeviceDefinition deviceDefinition = new DeviceDefinition();
                deviceDefinition.setCountFirstChannelOnly(true);
                deviceDefinition.setSignature(firmware);
                deviceDefinition.setManufacturer("Vivotek Smart Driver (H.264/H.265 Generation");
                CommentsType commentsType = new CommentsType();
                commentsType.getString().add(currentComments);
                deviceDefinition.setName(this.currentName);
                deviceDefinition.setComments(commentsType);
                deviceDefinition.setDefaultMediaID(MediaID.VIDEO_SERVER_DIGITAL.getType());
                String apiVersion = "WebAPI";
                SupportedApiVersionsType supportedApiVersionsType = new SupportedApiVersionsType();
                supportedApiVersionsType.getString().add("WebAPI");
                deviceDefinition.setSupportedApiVersions(supportedApiVersionsType);
                deviceDefinition.setDefaultApiVersion("WebAPI");
                try {
                    deviceDefinition.setNoOfCams(VivotekSmartHelper.getParameterNumericalValue(capabilities, "capability_nvideoin"));
                }
                catch (SeeTecException ex) {
                    this.getLogger().warn("Exception while reading number of video sources. Will asume one source");
                    deviceDefinition.setNoOfCams(1);
                }
                VirtualCameraDefinitionType virtualCameraDefinitionType = this.getVirtualCameraDefinitionType();
                deviceDefinition.setVirtualCameraDefinition(virtualCameraDefinitionType);
                DeviceNetworkDefinitionType deviceNetworkDefinitionType = this.getDeviceNetworkDefinitionType();
                deviceDefinition.setDeviceNetworkDefinition(deviceNetworkDefinitionType);
                int numberOfStreams = 3;
                try {
                    numberOfStreams = VivotekSmartHelper.getParameterNumericalValue(capabilities, "capability_nmediastream");
                }
                catch (SeeTecException ex) {
                    this.getLogger().warn("Could not read number of streams. Asuming 3 for " + this);
                }
                MultiStreamingDefinitionsType multiStreamingDefinitionsType = this.getMultiStreamingDefinitionsType(capabilities, numberOfStreams);
                SupportedCaptureModesType supportedCaptureModesType = new SupportedCaptureModesType();
                CaptureModeDefinitionType captureModeDefinitionType = new CaptureModeDefinitionType();
                CameraResolutionType captureModeCameraResolutionType = this.getCaptureModeCameraResolutionType(multiStreamingDefinitionsType);
                captureModeDefinitionType.setRebootRequired(false);
                captureModeDefinitionType.setModeSuffix(VivotekSmartHelper.getParameterValue(capabilities, "videoin_c0_crop_size") + "_" + VivotekSmartHelper.getParameterValue(capabilities, "videoin_c0_mode"));
                captureModeDefinitionType.setMaxTotalNumberOfStreams(numberOfStreams);
                captureModeDefinitionType.setDefaultStreamDefinitionIndex(0);
                captureModeDefinitionType.setResolution(captureModeCameraResolutionType);
                captureModeDefinitionType.setMultiStreamingDefinitions(multiStreamingDefinitionsType);
                supportedCaptureModesType.getCaptureModeDefinition().add(captureModeDefinitionType);
                deviceDefinition.setSupportedCaptureModes(supportedCaptureModesType);
                deviceDefinition.setDefaultCaptureModeIndex(0);
                ImageRotationCapabilitiesType imageRotationCapabilitiesType = this.getImageRotationCapabilitiesType(capabilities);
                deviceDefinition.setImageRotationCapabilities(imageRotationCapabilitiesType);
                AudioCapabilitiesType audioCapabilitiesType = this.getAudioCapabilitiesType(capabilities);
                deviceDefinition.setAudioCapabilities(audioCapabilitiesType);
                AvailableIOsType availableIOsType = this.getAvailableIOsType(capabilities);
                deviceDefinition.setAvailableIOs(availableIOsType);
                MiscVideoServerCapabilitiesType miscVideoServerCapabilitiesType = this.getMiscVideoServerCapabilitiesType(capabilities);
                SupportedVideoSourceEntityTypesType supportedVideoSourceEntityTypesType = new SupportedVideoSourceEntityTypesType();
                supportedVideoSourceEntityTypesType.getLong().add(212439L);
                deviceDefinition.setSupportedVideoSourceEntityTypes(supportedVideoSourceEntityTypesType);
                deviceDefinition.setMiscVideoServerCapabilities(miscVideoServerCapabilitiesType);
                deviceDefinition.setSupportedGenericEvents(this.getGenericEventTrigger());
                DeviceGroupMembershipsType deviceGroupMembershipsType = new DeviceGroupMembershipsType();
                deviceGroupMembershipsType.getDeviceGroups().add("ShowChannelSelector");
                deviceGroupMembershipsType.getDeviceGroups().add("GenericDriver");
                deviceGroupMembershipsType.getDeviceGroups().add("ConfigurableVideoStreamNetworkTimeout");
                deviceGroupMembershipsType.getDeviceGroups().add("PresetsImportable");
                String zoomRatio = "";
                String maxZoomRatio = "";
                try {
                    zoomRatio = this.getHttpHandler().readGetRequest("/cgi-bin/camctrl/camctrl.cgi?getratio");
                    maxZoomRatio = this.getHttpHandler().readGetRequest("/cgi-bin/camctrl/camctrl.cgi?getmaxratio");
                }
                catch (Exception ex) {
                    this.getLogger().info("Could not read Zoom Ratio or Max Zoom Ratio for " + this + ". Zoom Area will not be supported");
                }
                if (!zoomRatio.isEmpty() && !maxZoomRatio.isEmpty()) {
                    deviceGroupMembershipsType.getDeviceGroups().add("OpticalZoomAreaSupported");
                }
                deviceGroupMembershipsType.getDeviceGroups().add("GenericEventTrigger");
                deviceDefinition.setDeviceGroupMemberships(deviceGroupMembershipsType);
                deviceDefinition.setEntityType(202442L);
                deviceDefinition.setName(this.currentName);
                return deviceDefinition;
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception while reading information from " + this + ": " + ex.getMessage(), (Throwable)ex);
                throw ex;
            }
            catch (Throwable exception) {
                this.getLogger().warn("Error while reading information from " + this + ": " + exception.getMessage(), exception);
                throw new SeeTecException(-21600, exception.getMessage());
            }
        }
        return null;
    }

    public FeaturesType getPtzfeaturesType(String capabilities) throws SeeTecException, SAXException {
        FeaturesType featuresType = new FeaturesType();
        boolean supportsIris = false;
        boolean supportsDayNight = false;
        boolean supportsPan = false;
        boolean supportsTilt = false;
        boolean supportsZoom = false;
        boolean supportsFocus = false;
        try {
            int ptzCapabilities = VivotekSmartHelper.getParameterNumericalValue(capabilities, "capability_ptzenabled");
            supportsPan = (ptzCapabilities & 4) == 4;
            supportsTilt = (ptzCapabilities & 8) == 8;
            supportsZoom = (ptzCapabilities & 0x10) == 16;
            supportsFocus = (ptzCapabilities & 0x20) == 32;
            supportsIris = (ptzCapabilities & 0x40) == 64;
        }
        catch (SeeTecException ex) {
            this.getLogger().warn("Could not read PTZ capabilities for " + this);
        }
        try {
            supportsDayNight = VivotekSmartHelper.getParameterNumericalValue(capabilities, "capability_daynight_c0_ircutfilter") == 1;
        }
        catch (SeeTecException ex) {
            this.getLogger().warn("Could not read Zero-Lux capabilities for " + this);
        }
        if (supportsZoom) {
            try {
                int maxZoom = this.getMaxZoom(capabilities);
                featuresType.setCanAbsoluteZoom(true);
                featuresType.setMinAbsoluteZoom(0);
                featuresType.setMaxAbsoluteZoom(maxZoom);
            }
            catch (Exception ex) {
                this.getLogger().warn("Exception while reading absolute zoom capabilities for " + this);
            }
        }
        featuresType.setMinPan(-180000);
        featuresType.setMaxPan(180000);
        featuresType.setCanRelativePan(false);
        featuresType.setCanAbsolutePan(false);
        featuresType.setCanContinuousPan(supportsPan);
        featuresType.setMinTilt(0);
        featuresType.setMaxTilt(90000);
        featuresType.setCanRelativeTilt(false);
        featuresType.setCanAbsoluteTilt(false);
        featuresType.setCanContinuousTilt(supportsTilt);
        featuresType.setCanPreset(true);
        featuresType.setCanContinuousZoom(supportsZoom);
        featuresType.setCanRelativeZoom(false);
        featuresType.setMinZoom(0);
        featuresType.setMaxZoom(100000);
        featuresType.setCanCenterPT(true);
        featuresType.setCanFocus(supportsFocus);
        featuresType.setCanAutoFocus(supportsFocus);
        featuresType.setCanIris(supportsIris);
        featuresType.setCanAutoIris(supportsIris);
        featuresType.setCanNullLux(supportsDayNight);
        featuresType.setCanAutoNullLux(supportsDayNight);
        featuresType.setMinSpeed(0);
        featuresType.setMaxSpeed(100000);
        featuresType.setPTZMinContinuousLevel(10000);
        featuresType.setPTZMaxContinuousLevel(100000);
        featuresType.setPTZContinuousSpeedFactor(1000);
        return featuresType;
    }

    @Override
    protected VideoCameraDefinition getVideoCameraDefinitionFromDevice() throws SeeTecException {
        try {
            boolean ptzAvailable = true;
            String capabilities = this.getHttpHandler().readGetRequest("/cgi-bin/admin/getparam.cgi?");
            VideoCameraDefinition videoCameraDefinition = new VideoCameraDefinition();
            videoCameraDefinition.setManufacturer("Vivotek Smart Driver (H.264/H.265 Generation");
            videoCameraDefinition.setComment("");
            videoCameraDefinition.setDefaultMediaID(ptzAvailable ? MediaID.VIDEO_SOURCE_PTZ.getType() : MediaID.VIDEO_SOURCE_DIGITAL.getType());
            videoCameraDefinition.setName(this.currentName);
            videoCameraDefinition.setEntityType(212439L);
            videoCameraDefinition.setPreferAbsolutePTZ(false);
            FeaturesType featuresType = new FeaturesType();
            if (ptzAvailable) {
                featuresType = this.getPtzfeaturesType(capabilities);
            }
            videoCameraDefinition.setFeatures(featuresType);
            if (this.logger.isDebugEnabled()) {
                String videoSourceDefinitionXml = Basic.marshalXML((Object)videoCameraDefinition);
                this.getLogger().debug(videoSourceDefinitionXml);
            }
            return videoCameraDefinition;
        }
        catch (Exception exception) {
            this.getLogger().warn("Error while reading information from " + this, (Throwable)exception);
            throw new SeeTecException(-21600, exception.getMessage());
        }
    }

    public final int checkDeviceInfos(long type, String host, int port, boolean useAuthorization, String user, String pass, int timeout) {
        String url;
        try {
            url = "/cgi-bin/anonymous/getparam.cgi?";
            this.getHttpHandler().readGetRequest("/cgi-bin/anonymous/getparam.cgi?");
        }
        catch (SeeTecException e) {
            if (e.getNetworkStatus() == HTTPStatusCode.HTTP_UNAUTHORIZED || e.getMessage().contains("Unauthorized access")) {
                return -21701;
            }
            return -21697;
        }
        catch (Exception e) {
            if (e.getMessage().contains("Unauthorized access")) {
                return -21701;
            }
            return -21697;
        }
        try {
            url = "/cgi-bin/admin/getparam.cgi?network_ipaddress&network_http_port&network_http_alternateport";
            this.getHttpHandler().readGetRequest("/cgi-bin/admin/getparam.cgi?network_ipaddress&network_http_port&network_http_alternateport");
        }
        catch (Exception e) {
            return -21701;
        }
        return 0;
    }

    @Override
    protected SupportedGenericEventsType getGenericEventTrigger() throws SeeTecException, ConfigurationException {
        SupportedGenericEventsType supportedGenericEventsType = new SupportedGenericEventsType();
        try {
            String modelName;
            Element topicSet;
            Element getEventPropertiesResponse;
            String capabilities = this.getHttpHandler().readGetRequest("/cgi-bin/admin/getparam.cgi?");
            String[] capabilityTrigger = VivotekSmartHelper.getMultipleParameterValues(capabilities, "capability_supporttriggertypes");
            List<String> availableTrigger = Arrays.asList(capabilityTrigger);
            String postRequest = "<?xml version=\"1.0\" encoding=\"utf-8\"?><s:Envelope xmlns:s=\"http://www.w3.org/2003/05/soap-envelope\" xmlns:a=\"http://www.w3.org/2005/08/addressing\"><s:Header><a:Action s:mustUnderstand=\"1\">http://www.onvif.org/ver10/events/wsdl/EventPortType/GetEventPropertiesRequest</a:Action><wsse:Security xmlns:wsse=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\" xmlns:wsu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\"><wsse:UsernameToken><wsse:Username>" + this.getNetworkParameter().getUserPWD()[0] + "</wsse:Username><wsse:Password Type=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText\">" + this.getNetworkParameter().getUserPWD()[1] + "</wsse:Password><wsse:Nonce/><wsu:Created>2014-06-19T05:11:24Z</wsu:Created></wsse:UsernameToken></wsse:Security><a:ReplyTo><a:Address>http://www.w3.org/2005/08/addressing/anonymous</a:Address></a:ReplyTo></s:Header><s:Body xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\"><GetEventProperties xmlns=\"http://www.onvif.org/ver10/events/wsdl\" /></s:Body></s:Envelope>";
            String xmlString = "";
            int numberOfSources = 1;
            try {
                numberOfSources = VivotekSmartHelper.getParameterNumericalValue(capabilities, "capability_nvideoin");
            }
            catch (SeeTecException ex) {
                this.getLogger().warn("Exception while reading number of video sources. Will asume one source");
            }
            try {
                xmlString = this.getHttpHandler().readPostRequest("/onvif/event_service", postRequest);
            }
            catch (SeeTecException ex) {
                String triggerName;
                GenericEventDefinitionType genericEventDefinitionType;
                this.getLogger().warn("Exception while trying to read capabilities. Maybe the firmware is too old. Will enable some default triggers for " + this);
                int numberOfMotionWindows = VivotekSmartHelper.getNumberOfMotionWindows(capabilities);
                for (int i = 0; i < numberOfSources; ++i) {
                    for (int j = 0; j < numberOfMotionWindows; ++j) {
                        genericEventDefinitionType = new GenericEventDefinitionType();
                        genericEventDefinitionType.setEventType(VivotekSmartEvent.matchNames("motion") + " Window " + (j + 1));
                        genericEventDefinitionType.setSourceNumber(i + 1);
                        supportedGenericEventsType.getGenericEventDefinition().add(genericEventDefinitionType);
                    }
                    triggerName = VivotekSmartEvent.matchNames("tampering");
                    genericEventDefinitionType = new GenericEventDefinitionType();
                    genericEventDefinitionType.setEventType(VivotekSmartEvent.matchNames(triggerName));
                    genericEventDefinitionType.setSourceNumber(i + 1);
                    supportedGenericEventsType.getGenericEventDefinition().add(genericEventDefinitionType);
                }
                String modelName2 = VivotekSmartHelper.getParameterValue(capabilities, "system_info_modelname");
                if (modelName2.toLowerCase().startsWith("vs")) {
                    triggerName = VivotekSmartEvent.matchNames("visignal");
                    genericEventDefinitionType = new GenericEventDefinitionType();
                    genericEventDefinitionType.setEventType(VivotekSmartEvent.matchNames(triggerName));
                    genericEventDefinitionType.setSourceNumber(1);
                    supportedGenericEventsType.getGenericEventDefinition().add(genericEventDefinitionType);
                }
                return supportedGenericEventsType;
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(xmlString.getBytes(Charset.forName("UTF-8")));
            Document cameraConf = new SAXBuilder().build((InputStream)bais);
            Element root = cameraConf.getRootElement();
            Namespace ns = root.getNamespace();
            Element body = root.getChild("Body", ns);
            Namespace tet = Namespace.getNamespace((String)"tet", (String)"http://www.onvif.org/ver10/events/wsdl");
            Namespace wstop = Namespace.getNamespace((String)"wstop", (String)"http://docs.oasis-open.org/wsn/t-1");
            Namespace tns1 = Namespace.getNamespace((String)"tns1", (String)"http://www.onvif.org/ver10/topics");
            Namespace tnsvvtk = Namespace.getNamespace((String)"tnsvvtk", (String)"http://www.vivotek.com/2009/event/topics");
            if (body != null && (getEventPropertiesResponse = body.getChild("GetEventPropertiesResponse", tet)) != null && (topicSet = getEventPropertiesResponse.getChild("TopicSet", wstop)) != null) {
                Element monitoring;
                boolean tamperingEnabled;
                Element videoSource;
                Object genericEventDefinitionType;
                Element motion;
                Element videoAnalytics;
                GenericEventDefinitionType genericEventDefinitionType2;
                Element device = topicSet.getChild("Device", tns1);
                if (device != null) {
                    Element tampering;
                    Element trigger = device.getChild("Trigger");
                    if (trigger != null) {
                        List triggersAsObjects = trigger.getChildren();
                        ArrayList<Element> triggerList = new ArrayList<Element>();
                        for (Object t : triggersAsObjects) {
                            if (!(t instanceof Element)) continue;
                            triggerList.add((Element)t);
                        }
                        for (Element triggerElement : triggerList) {
                            String triggerName = triggerElement.getName().toLowerCase();
                            if (triggerName.equals("shockalarm")) {
                                if (!VivotekSmartHelper.getParameterValue(capabilities, "capability_shockalarm_support").equals("1")) continue;
                                genericEventDefinitionType2 = new GenericEventDefinitionType();
                                genericEventDefinitionType2.setEventType(VivotekSmartEvent.matchNames(triggerName));
                                genericEventDefinitionType2.setSourceNumber(0);
                                supportedGenericEventsType.getGenericEventDefinition().add(genericEventDefinitionType2);
                                continue;
                            }
                            if (triggerName.equals("volalarm")) {
                                if (availableTrigger.isEmpty() || !availableTrigger.contains(triggerName)) continue;
                                genericEventDefinitionType2 = new GenericEventDefinitionType();
                                genericEventDefinitionType2.setEventType(VivotekSmartEvent.matchNames(triggerName));
                                genericEventDefinitionType2.setSourceNumber(0);
                                supportedGenericEventsType.getGenericEventDefinition().add(genericEventDefinitionType2);
                                continue;
                            }
                            if (!triggerName.equals("smartsd") || availableTrigger.isEmpty() || !availableTrigger.contains(triggerName)) continue;
                            genericEventDefinitionType2 = new GenericEventDefinitionType();
                            genericEventDefinitionType2.setEventType(VivotekSmartEvent.matchNames(triggerName));
                            genericEventDefinitionType2.setSourceNumber(0);
                            supportedGenericEventsType.getGenericEventDefinition().add(genericEventDefinitionType2);
                        }
                    }
                    if ((tampering = device.getChild("Tampering")) != null && (availableTrigger.isEmpty() || availableTrigger.contains("tampering"))) {
                        for (int i = 0; i < numberOfSources; ++i) {
                            String triggerName = VivotekSmartEvent.matchNames("tampering");
                            GenericEventDefinitionType genericEventDefinitionType3 = new GenericEventDefinitionType();
                            genericEventDefinitionType3.setEventType(VivotekSmartEvent.matchNames(triggerName));
                            genericEventDefinitionType3.setSourceNumber(i + 1);
                            supportedGenericEventsType.getGenericEventDefinition().add(genericEventDefinitionType3);
                        }
                    }
                }
                if ((videoAnalytics = topicSet.getChild("VideoAnalytics", tns1)) != null && (motion = videoAnalytics.getChild("Motion")) != null && (availableTrigger.isEmpty() || availableTrigger.contains("motion"))) {
                    int numberOfMotionWindows = VivotekSmartHelper.getNumberOfMotionWindows(capabilities);
                    for (int i = 0; i < numberOfSources; ++i) {
                        for (int j = 0; j < numberOfMotionWindows; ++j) {
                            genericEventDefinitionType = new GenericEventDefinitionType();
                            ((GenericEventDefinitionType)genericEventDefinitionType).setEventType(VivotekSmartEvent.matchNames("motion") + " Window " + (j + 1));
                            ((GenericEventDefinitionType)genericEventDefinitionType).setSourceNumber(i + 1);
                            supportedGenericEventsType.getGenericEventDefinition().add((GenericEventDefinitionType)genericEventDefinitionType);
                            genericEventDefinitionType = new GenericEventDefinitionType();
                            ((GenericEventDefinitionType)genericEventDefinitionType).setEventType(VivotekSmartEvent.matchNames("motion") + " ended Window " + (j + 1));
                            ((GenericEventDefinitionType)genericEventDefinitionType).setSourceNumber(i + 1);
                            supportedGenericEventsType.getGenericEventDefinition().add((GenericEventDefinitionType)genericEventDefinitionType);
                        }
                    }
                }
                if ((videoSource = topicSet.getChild("VideoSource", tns1)) != null && (tamperingEnabled = VivotekSmartHelper.getParameterValue(capabilities, "capability_tampering").equals("1"))) {
                    List tampering = videoSource.getChildren();
                    ArrayList<Element> tamperingElements = new ArrayList<Element>();
                    for (Object t : tampering) {
                        if (!(t instanceof Element)) continue;
                        tamperingElements.add((Element)t);
                    }
                    for (Element tamperingElement : tamperingElements) {
                        String name = tamperingElement.getName();
                        if (!name.equals("ImageTooBlurry") && !name.equals("ImageTooBright") && !name.equals("GlobalSceneChange") && !name.equals("ImageTooDark")) continue;
                        for (int i = 0; i < numberOfSources; ++i) {
                            GenericEventDefinitionType genericEventDefinitionType4 = new GenericEventDefinitionType();
                            genericEventDefinitionType4.setEventType(name);
                            genericEventDefinitionType4.setSourceNumber(i + 1);
                            supportedGenericEventsType.getGenericEventDefinition().add(genericEventDefinitionType4);
                        }
                    }
                }
                if ((monitoring = topicSet.getChild("Monitoring", tns1)) != null) {
                    Element bruteForceAttack;
                    Element cyberAttack;
                    Element quarantine = monitoring.getChild("Quarantine", tnsvvtk);
                    if (quarantine != null) {
                        GenericEventDefinitionType genericEventDefinitionType5 = new GenericEventDefinitionType();
                        genericEventDefinitionType5.setEventType(VivotekSmartEvent.matchNames("quarantine"));
                        genericEventDefinitionType5.setSourceNumber(0);
                        supportedGenericEventsType.getGenericEventDefinition().add(genericEventDefinitionType5);
                    }
                    if ((cyberAttack = monitoring.getChild("CyberAttack", tnsvvtk)) != null) {
                        genericEventDefinitionType = new GenericEventDefinitionType();
                        ((GenericEventDefinitionType)genericEventDefinitionType).setEventType(VivotekSmartEvent.matchNames("cyberattack"));
                        ((GenericEventDefinitionType)genericEventDefinitionType).setSourceNumber(0);
                        supportedGenericEventsType.getGenericEventDefinition().add((GenericEventDefinitionType)genericEventDefinitionType);
                    }
                    if ((bruteForceAttack = monitoring.getChild("BruteForceAttack", tnsvvtk)) != null) {
                        genericEventDefinitionType2 = new GenericEventDefinitionType();
                        genericEventDefinitionType2.setEventType(VivotekSmartEvent.matchNames("bruteforceattack"));
                        genericEventDefinitionType2.setSourceNumber(0);
                        supportedGenericEventsType.getGenericEventDefinition().add(genericEventDefinitionType2);
                    }
                }
            }
            if ((modelName = VivotekSmartHelper.getParameterValue(capabilities, "system_info_modelname")).toLowerCase().startsWith("vs")) {
                for (int i = 0; i < numberOfSources; ++i) {
                    String triggerName = VivotekSmartEvent.matchNames("visignal");
                    GenericEventDefinitionType genericEventDefinitionType = new GenericEventDefinitionType();
                    genericEventDefinitionType.setEventType(VivotekSmartEvent.matchNames(triggerName));
                    genericEventDefinitionType.setSourceNumber(i + 1);
                    supportedGenericEventsType.getGenericEventDefinition().add(genericEventDefinitionType);
                }
            }
        }
        catch (JDOMException ex) {
            this.getLogger().warn("Exception while reading smart events for " + this);
            return null;
        }
        return supportedGenericEventsType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpHandlerImpl getHttpHandler() {
        Object object = this.SEMAPHORE;
        synchronized (object) {
            if (this.httpHandler == null) {
                try {
                    this.httpHandler = new HttpHandlerImpl(this.getNetworkParameter(), true);
                }
                catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException ex) {
                    return null;
                }
            }
            return this.httpHandler;
        }
    }

    protected String getCurrentCaptureModeFromDefinition() {
        String foundDisplayResolutionInDefinition = null;
        try {
            List<CaptureModeDefinitionType> list = this.getDeviceDefinitionFromConfiguration().getSupportedCaptureModes().getCaptureModeDefinition();
            if (!list.isEmpty()) {
                foundDisplayResolutionInDefinition = list.get(0).getModeSuffix();
            }
        }
        catch (Exception e) {
            this.getLogger().warn("Could not find out currently set capture mode.");
            foundDisplayResolutionInDefinition = null;
        }
        return foundDisplayResolutionInDefinition;
    }

    public int getMaxZoom(String capabilities) throws SeeTecException {
        String maxZoomAsString = VivotekSmartHelper.getParameterValue(capabilities, "capability_ptz_maxzoom");
        int returnValue = 16384;
        if (maxZoomAsString != null && !maxZoomAsString.isEmpty()) {
            returnValue = Integer.parseInt(maxZoomAsString);
        } else {
            String url = "/cgi-bin/camctrl/camctrl.cgi?getmaxzoom";
            String result = this.getHttpHandler().readGetRequest(url);
            if (result != null && !result.isEmpty()) {
                String resultValue = result.replace("maxzoom=", "").replace("\r", "").replace("\n", "");
                try {
                    returnValue = Integer.parseInt(resultValue);
                }
                catch (NumberFormatException ex) {
                    this.logger.warn("Exception while trying to parse " + resultValue);
                }
            }
        }
        return returnValue;
    }

    public Logger getLogger() {
        return this.logger;
    }
}

