/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.vivotek.smart;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.LiveCameraSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.genericevent.GenericEventTriggerHandler;
import de.seetec.v5.re.cm.device.shared.videoprofile.VideoProfileHandler;
import de.seetec.v5.re.cm.device.shared.videosource.VideoSourceClient;
import de.seetec.v5.re.cm.device.video.vivotek.smart.VivotekSmartAudioOutServer;
import de.seetec.v5.re.cm.device.video.vivotek.smart.VivotekSmartCameraControl;
import de.seetec.v5.re.cm.device.video.vivotek.smart.VivotekSmartDevice;
import de.seetec.v5.re.cm.device.video.vivotek.smart.VivotekSmartH26xVideoSourceClient;
import de.seetec.v5.re.cm.device.video.vivotek.smart.VivotekSmartMJPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.vivotek.smart.VivotekSmartTriggerHandler;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;

public class VivotekSmartCameraSrv
extends LiveCameraSrv {
    @Override
    public CameraControl createCameraControl(Long entityType) {
        return new VivotekSmartCameraControl();
    }

    @Override
    public VideoSourceClient createVideoSourceClient(Core core, VideoProfileHandler listener) throws SeeTecException {
        VideoSourceClient videoSourceClient = null;
        this.logger.info("Creating new [VideoSourceClient] with VideoProfileHandler=" + listener + " ...");
        try {
            videoSourceClient = listener.getVideoSourceParameter().getMediaCodec() == Codec.H265 || listener.getVideoSourceParameter().getMediaCodec() == Codec.H264 ? new VivotekSmartH26xVideoSourceClient() : new VivotekSmartMJPEGVideoSourceClient();
            int errorCode = videoSourceClient.init(core, this, listener);
            if (errorCode != 0) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
                this.logger.error("Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "] :-(");
                throw new SeeTecException(errorCode, "Initializing [VideoSourceClient] for " + this + " failed with error [" + errorCode + "]");
            }
        }
        catch (SeeTecException seetecEx) {
            throw seetecEx;
        }
        catch (Throwable ex) {
            if (videoSourceClient != null) {
                videoSourceClient.shutdown();
                videoSourceClient = null;
            }
            this.logger.error((Object)ex, ex);
            this.logger.error("Creating [VideoSourceClient] for " + this + " failed :-(");
            throw new SeeTecException(-20001, "Creating [VideoSourceClient] for " + this + " failed");
        }
        return videoSourceClient;
    }

    @Override
    public ContentFrame getJpegSnapshot(Integer[] resolution) throws SeeTecException {
        throw new SeeTecException(-20009, "NOT YET IMPLEMENTED :-(");
    }

    @Override
    protected VivotekSmartAudioOutServer createAudioOutServer() {
        NetworkParameter networkParameter = ((VivotekSmartDevice)this.getDevice()).getNetworkParameter();
        VivotekSmartAudioOutServer vivotekSmartAudioOutServer = new VivotekSmartAudioOutServer(networkParameter);
        vivotekSmartAudioOutServer.init();
        return vivotekSmartAudioOutServer;
    }

    @Override
    protected GenericEventTriggerHandler createNewGenericEventTriggerHandler() {
        return new VivotekSmartTriggerHandler(this);
    }
}

