/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.vivotek.smart;

import de.seetec.v5.re.cm.configuration.definition.camera.VideoCameraDefinition;
import de.seetec.v5.re.cm.configuration.device.shared.ArrayOfCameraPreset.ArrayOfCameraPreset;
import de.seetec.v5.re.cm.configuration.device.shared.ArrayOfCameraPreset.CameraPreset;
import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.re.cm.device.shared.cameracontrol.CameraControl;
import de.seetec.v5.re.cm.device.shared.cameracontrol.PresetCnf;
import de.seetec.v5.re.cm.device.video.vivotek.smart.VivotekSmartDevice;
import de.seetec.v5.re.cm.device.video.vivotek.smart.VivotekSmartHelper;
import de.seetec.v5.re.cm.shared.PtzInfo;
import de.seetec.v5.re.cm.shared.communication.VideoServiceClientRequestHandler;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class VivotekSmartCameraControl
extends CameraControl {
    private int dividerPan;
    private int dividerTilt;
    private int dividerZoom;
    private int oldPanSpeed = 0;
    private int oldTiltSpeed = 0;
    private float maxRatio;

    @Override
    public int init(VideoSrv videoSrv, String api, String host, int port, String usr, String pwd, Vector<PresetCnf> presetList) {
        int errorCode = super.init(videoSrv, api, host, port, usr, pwd, presetList);
        try {
            VivotekSmartDevice vivotekSmartDevice = (VivotekSmartDevice)videoSrv.getDevice();
            String result = vivotekSmartDevice.getHttpHandler().readGetRequest("/cgi-bin/admin/getparam.cgi?capability_ptz_panspeedlv&capability_ptz_tiltspeedlv&capability_ptz_zoomspeedlv");
            String capabilities = vivotekSmartDevice.getHttpHandler().readGetRequest("/cgi-bin/admin/getparam.cgi?");
            int maxAbsoluteZoom = vivotekSmartDevice.getMaxZoom(capabilities);
            this.ptzInfo = new PtzInfo();
            this.ptzInfo.setMinZoom(0);
            this.ptzInfo.setMaxZoom(maxAbsoluteZoom);
            if (result != null && !result.isEmpty()) {
                int panSpeed = VivotekSmartHelper.getParameterNumericalValue(result, "capability_ptz_panspeedlv");
                int tiltSpeed = VivotekSmartHelper.getParameterNumericalValue(result, "capability_ptz_tiltspeedlv");
                int zoomSpeed = VivotekSmartHelper.getParameterNumericalValue(result, "capability_ptz_zoomspeedlv");
                this.logger.info("Max pan speed: " + panSpeed);
                this.logger.info("Max tilt speed: " + tiltSpeed);
                this.dividerPan = 100000 / panSpeed;
                this.dividerTilt = 100000 / tiltSpeed;
                this.dividerZoom = 100000 / zoomSpeed;
            }
            if ((result = ((VivotekSmartDevice)videoSrv.getDevice()).getHttpHandler().readGetRequest("/cgi-bin/camctrl/camctrl.cgi?getmaxratio")) != null && !result.isEmpty()) {
                result = result.replace("maxratio=", "").replace("\r\n", "");
                try {
                    this.maxRatio = Float.parseFloat(result);
                }
                catch (NumberFormatException ex) {
                    this.logger.warn("Could not parse \"" + result + "\" to float number. Assuming Zoom Ratio of 30");
                    this.maxRatio = 30.0f;
                }
            }
        }
        catch (Throwable ex) {
            this.logger.error("Error while requesting ptz capabilities. Stay with defaults.");
            this.dividerPan = 100;
        }
        this.getAbsolutePosition(true);
        return errorCode;
    }

    private String sendPresetCommand(String url, String command) {
        return this.sendCameraCommand(url, command);
    }

    private String sendCameraCommand(String url) {
        return this.sendCameraCommand(url, "camctrl");
    }

    private String sendCameraCommand(String url, String command) {
        return this.sendCameraCommand(url, command, false);
    }

    private String sendCameraCommand(String url, String command, boolean excludePrefix) {
        try {
            int videoSourceNr = this.videoSrv.getVideoSourceCnf().getServerEntryNo() - 1;
            int camID = this.videoSrv.getVideoSourceCnf().getPtzAddress();
            String completeUrl = command.equals("camctrl") ? "/cgi-bin/camctrl/camctrl.cgi?channel=" + videoSourceNr + "&camid=" + camID + "&" + url : (command.equals("preset") ? "/cgi-bin/operator/" + command + ".cgi?channel=" + videoSourceNr + "&" + url : (command.equals("setparam") ? (excludePrefix ? "/cgi-bin/admin/" + command + ".cgi?" + url : "/cgi-bin/admin/" + command + ".cgi?videoin_c" + videoSourceNr + "_" + url) : "/cgi-bin/viewer/" + command + ".cgi?channel=" + videoSourceNr + "&" + url));
            this.videoSrv.notifyForCameraControl();
            return ((VivotekSmartDevice)this.videoSrv.getDevice()).getHttpHandler().readGetRequest(completeUrl);
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return null;
        }
    }

    @Override
    public int setAbsolutePTZ(VideoServiceClientRequestHandler sender, Integer pan, Integer tilt, Integer zoom) {
        return 0;
    }

    @Override
    public int setAbsoluteZ(VideoServiceClientRequestHandler sender, Integer zoom) {
        String url = "/cgi-bin/camctrl/camctrl.cgi?setzoom=" + zoom;
        try {
            ((VivotekSmartDevice)this.videoSrv.getDevice()).getHttpHandler().readGetRequest(url);
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while setting absolute zoom for " + this + ": " + ex.getMessage());
            return ex.getErrorCode();
        }
        this.ptzInfo.setZoom(zoom);
        return 0;
    }

    @Override
    public int setContinuousPTZ(Integer pan, Integer tilt, Integer zoom) {
        int tiltSpeed;
        int panSpeed;
        if (pan != null) {
            this.oldPanSpeed = panSpeed = pan / this.dividerPan;
        } else {
            panSpeed = this.oldPanSpeed;
        }
        if (tilt != null) {
            this.oldTiltSpeed = tiltSpeed = tilt / this.dividerTilt;
        } else {
            tiltSpeed = this.oldTiltSpeed;
        }
        StringBuilder sb = new StringBuilder(256);
        sb.append("vx=");
        sb.append(panSpeed);
        sb.append("&vy=");
        sb.append(tiltSpeed);
        sb.append("&vs=");
        int speed = Math.max(Math.abs(panSpeed), Math.abs(tiltSpeed));
        sb.append(speed);
        this.sendCameraCommand(sb.toString());
        if (zoom != null) {
            int zoomSpeed = zoom / this.dividerZoom;
            sb = new StringBuilder(256);
            if (zoomSpeed != 0) {
                if (zoomSpeed < 0) {
                    sb.append("zooming=wide&zs=");
                } else {
                    sb.append("zooming=tele&zs=");
                }
                sb.append(Math.abs(zoomSpeed));
            } else {
                sb.append("zoom=stop");
            }
            this.sendCameraCommand(sb.toString());
        }
        return 0;
    }

    @Override
    public int setCenterPT(Integer xPosition, Integer yPosition, int[] resolution) {
        try {
            int[] pos = this.calcCenterPT(xPosition, yPosition, resolution[0], resolution[1]);
            this.sendCameraCommand("x=" + pos[0] + "&y=" + pos[1] + "&resolution=" + resolution[0] + "x" + resolution[1] + "&videosize=" + resolution[0] + "x" + resolution[1] + "&stretch=0", "camctrl");
            return 0;
        }
        catch (Exception ex) {
            this.logger.error("Exception while reading PTZ configuration for: " + this, (Throwable)ex);
            return 0;
        }
    }

    protected final int[] calcCenterPT(Integer x, Integer y, int w, int h) throws SeeTecException {
        if (x == null || x < 0 || x > 100 || y == null || y < 0 || y > 100 || w <= 0 || h <= 0) {
            throw new SeeTecException(-21653, "Invalid CenterPT parameters for " + this.videoSrv + ": x=" + x + ",y=" + y + ",w=" + w + ",h=" + h);
        }
        return new int[]{w * x / 100, h * y / 100};
    }

    @Override
    public int setZoomArea(Integer xPosition, Integer yPosition, Integer width, Integer height, int[] resolution) {
        float ratioY;
        float ratioX;
        float previousZoomRatio = this.getZoomRatio();
        float ratio = previousZoomRatio + Math.min(ratioX = 100.0f / (float)width.intValue(), ratioY = 100.0f / (float)height.intValue());
        ratio = ratio <= 0.0f ? 1.0f : ratio;
        ratio = ratio > this.maxRatio ? this.maxRatio : ratio;
        double dividerX = (double)resolution[0] / 100.0;
        double dividerY = (double)resolution[1] / 100.0;
        int middleX = xPosition + width / 2;
        int middleY = yPosition + height / 2;
        int x = (int)((double)middleX * dividerX);
        int y = (int)((double)middleY * dividerY);
        StringBuilder sb = new StringBuilder();
        sb.append("x=").append(x);
        sb.append("&y=").append(y);
        sb.append("&resolution=");
        sb.append(resolution[0]);
        sb.append("x");
        sb.append(resolution[1]);
        sb.append("&videosize=");
        sb.append(resolution[0]);
        sb.append("x");
        sb.append(resolution[1]);
        sb.append("&stretch=1");
        sb.append("&setratio=");
        sb.append(ratio);
        this.sendCameraCommand(sb.toString());
        return 0;
    }

    @Override
    public int setAbsoluteIris(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousIris(Integer value) {
        if (value != null && value != 0) {
            if (value > 0) {
                this.sendCameraCommand("iris=open");
            } else {
                this.sendCameraCommand("iris=close");
            }
        }
        return 0;
    }

    @Override
    public int setAutoIris(Boolean active) {
        if (active.booleanValue()) {
            this.sendCameraCommand("iris=auto");
        }
        return 0;
    }

    @Override
    public int setAbsoluteFocus(Integer value) {
        throw new RuntimeException("NOT YET IMPLEMENTED :-(");
    }

    @Override
    public int setContinuousFocus(Integer value) {
        if (value != null && value != 0) {
            if (value > 0) {
                this.sendCameraCommand("focus=far");
            } else {
                this.sendCameraCommand("focus=near");
            }
        }
        return 0;
    }

    @Override
    public int setAutoFocus(Boolean active) {
        if (active.booleanValue()) {
            this.sendCameraCommand("focus=auto");
        }
        return 0;
    }

    @Override
    public int setZeroLux(Boolean active) {
        if (active.booleanValue()) {
            this.sendCameraCommand("ircutcontrol_mode=night", "setparam", true);
        } else {
            this.sendCameraCommand("ircutcontrol_mode=day", "setparam", true);
        }
        return 0;
    }

    @Override
    public int setAutoZeroLux(Boolean active) {
        if (active.booleanValue()) {
            this.sendCameraCommand("ircutcontrol_mode=auto", "setparam", true);
        }
        return 0;
    }

    @Override
    public int setHomePosition() {
        this.sendCameraCommand("move=home");
        this.getAbsolutePosition(true);
        return 0;
    }

    @Override
    public int addPresetPosition(Vector<byte[]> result, Long presetID, String presetName) {
        try {
            String encodedPresetName = VivotekSmartCameraControl.encodeAndLimitPresetName(30, presetName);
            PresetCnf presetCnf = PresetCnf.createPresetCnf((long)presetID, encodedPresetName);
            this.presetList.addElement(presetCnf);
            result.addElement(presetCnf.getPresetCnf());
            this.sendPresetCommand("addpos=" + encodedPresetName, "preset");
        }
        catch (UnsupportedEncodingException ex) {
            this.logger.warn("Could not encode/decode Preset name [" + presetName + "] for " + this);
            return -20001;
        }
        return 0;
    }

    @Override
    public int setPresetPosition(String presetName) {
        this.sendCameraCommand("recall=" + presetName, "recall");
        this.getAbsolutePosition(true);
        return 0;
    }

    @Override
    public int removePresetPosition(String presetName) {
        int errorCode = -21683;
        try {
            String encodedPresetName = presetName.trim();
            for (int i = 0; i < this.presetList.size(); ++i) {
                PresetCnf presetCnf = (PresetCnf)this.presetList.elementAt(i);
                if (!encodedPresetName.equals(presetCnf.getPresetName())) continue;
                this.presetList.removeElementAt(i);
                this.sendPresetCommand("delpos=" + encodedPresetName, "preset");
                errorCode = 0;
                break;
            }
            if (errorCode != 0) {
                this.logger.error("Preset [" + presetName + "] is not available for " + this);
                this.logger.error("PresetList=" + this.presetList);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            this.logger.error("Removing preset [" + presetName + "] failed :-(");
            errorCode = -21600;
        }
        return errorCode;
    }

    private float getZoomRatio() {
        try {
            String result = ((VivotekSmartDevice)this.videoSrv.getDevice()).getHttpHandler().readGetRequest("/cgi-bin/camctrl/camctrl.cgi?getratio");
            if (result != null && !result.isEmpty()) {
                result = result.replace("zoom=", "").replace("\r\n", "").trim();
                return Float.parseFloat(result);
            }
        }
        catch (Exception ex) {
            this.logger.warn("Exception while reading current zoom ratio for " + this);
        }
        return 1.0f;
    }

    @Override
    public int addCameraPresets(ArrayOfCameraPreset presets) {
        if (presets == null) {
            this.logger.warn("Received null camera presets object in addCameraPresets!");
            return -20002;
        }
        List<CameraPreset> cameraPresets = presets.getCameraPreset();
        for (CameraPreset cameraPreset : cameraPresets) {
            try {
                Element ptzPosition;
                byte[] cameraPresetPtzData = cameraPreset.getPtzData().getBytes();
                ByteArrayInputStream bais = new ByteArrayInputStream(cameraPresetPtzData);
                Document ptzDocument = new SAXBuilder().build((InputStream)bais);
                String presetPosition = "1";
                Element root = ptzDocument.getRootElement();
                if (root != null && (ptzPosition = root.getChild("PresetPosition")) != null) {
                    presetPosition = ptzPosition.getText().trim();
                }
                PresetCnf presetCnf = PresetCnf.createPresetCnf(cameraPreset.getId(), presetPosition, cameraPreset.getName());
                this.presetList.addElement(presetCnf);
                this.logger.info("Adding preset configuration: " + presetCnf);
            }
            catch (JDOMException ex) {
                this.logger.warn("Exception while parsing XML data: " + ex.getMessage());
            }
        }
        return 0;
    }

    @Override
    public ArrayOfCameraPreset getPresetsFromCamera() {
        try {
            int videoSourceNr = this.videoSrv.getVideoSourceCnf().getServerEntryNo() - 1;
            String url = "/cgi-bin/admin/getparam.cgi?";
            byte[] capabilities = ((VivotekSmartDevice)this.videoSrv.getDevice()).getHttpHandler().readGetRequestAsByteArray(url);
            String capabilityString = new String(capabilities, "UTF-8");
            int numberOfPresets = VivotekSmartHelper.getParameterNumericalValue(capabilityString, "capability_npreset");
            ArrayOfCameraPreset arrayOfCameraPreset = new ArrayOfCameraPreset();
            for (int i = 0; i < numberOfPresets; ++i) {
                String presetName = URLDecoder.decode(VivotekSmartHelper.getParameterValue(capabilityString, "camctrl_c" + videoSourceNr + "_preset_i" + i + "_name"), "UTF-8");
                if (presetName.isEmpty()) continue;
                CameraPreset cameraPreset = new CameraPreset();
                PresetCnf presetCnf = PresetCnf.createPresetCnf(cameraPreset.getId(), Integer.toString(i), presetName);
                cameraPreset.setName(presetName);
                cameraPreset.setPtzData(new String(presetCnf.getPresetCnf(), "UTF-8"));
                arrayOfCameraPreset.getCameraPreset().add(cameraPreset);
            }
            return arrayOfCameraPreset;
        }
        catch (Exception ex) {
            this.logger.error(ex + " for " + this, (Throwable)ex);
            return new ArrayOfCameraPreset();
        }
    }

    public static String encodeAndLimitPresetName(int numberOfDigits, String presetName) throws UnsupportedEncodingException {
        if (presetName == null || presetName.isEmpty()) {
            return "";
        }
        String encodedPresetName = presetName.trim().replace("\"", "").replace("'", "").replace("<", "").replace(">", "").replace("&", "").replace(";", "").replace("`", "").replace(" ", "");
        encodedPresetName = URLEncoder.encode(encodedPresetName, "UTF-8");
        while (encodedPresetName.length() > numberOfDigits) {
            encodedPresetName = URLDecoder.decode(encodedPresetName, "UTF-8");
            encodedPresetName = encodedPresetName.substring(0, encodedPresetName.length() - 1);
            encodedPresetName = URLEncoder.encode(encodedPresetName, "UTF-8");
        }
        return URLDecoder.decode(encodedPresetName, "UTF-8");
    }

    private void getAbsolutePosition(boolean sendStatus) {
        VideoCameraDefinition config = this.videoSrv.getDevice().getVideoCameraDefinitionFromConfiguration();
        if (config == null || !config.getFeatures().isCanAbsoluteZoom()) {
            return;
        }
        try {
            String url = "/cgi-bin/camctrl/camctrl.cgi?getpan";
            String result = ((VivotekSmartDevice)this.videoSrv.getDevice()).getHttpHandler().readGetRequest(url);
            int pan = VivotekSmartHelper.getParameterNumericalValue(result, "pan");
            url = "/cgi-bin/camctrl/camctrl.cgi?gettilt";
            result = ((VivotekSmartDevice)this.videoSrv.getDevice()).getHttpHandler().readGetRequest(url);
            int tilt = VivotekSmartHelper.getParameterNumericalValue(result, "tilt");
            url = "/cgi-bin/camctrl/camctrl.cgi?getzoom";
            result = ((VivotekSmartDevice)this.videoSrv.getDevice()).getHttpHandler().readGetRequest(url);
            int zoom = VivotekSmartHelper.getParameterNumericalValue(result, "zoom");
            this.ptzInfo.setPan(pan);
            this.ptzInfo.setTilt(tilt);
            this.ptzInfo.setZoom(zoom);
            if (sendStatus) {
                this.videoSrv.sendStatusAbsolutePTZ(null, this.ptzInfo.getPan(), this.ptzInfo.getTilt(), this.ptzInfo.getZoom());
            }
        }
        catch (Throwable ex) {
            this.logger.error(ex + " for " + this, ex);
        }
    }
}

