/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.vivotek.jpeg;

import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushContent;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushHandler;
import de.seetec.v5.re.cm.device.shared.net.httpserverpush.HttpServerPushListenerIntf;
import de.seetec.v5.re.cm.device.shared.videosource.JPEGVideoSourceClient;
import de.seetec.v5.re.cm.device.video.vivotek.VivotekCameraSrv;
import de.seetec.v5.re.cm.device.video.vivotek.VivotekDevice;
import de.seetec.v5.re.cm.device.video.vivotek.VivotekHardwareMotionDetection;
import de.seetec.v5.re.cm.device.video.vivotek.VivotekIOHandler;
import de.seetec.v5.re.cm.device.video.vivotek.VivotekMotionDetectionHandler;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;

public class VivotekJPEGVideoSourceClient
extends JPEGVideoSourceClient
implements HttpServerPushListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.vivotek.jpeg.VivotekJPEGVideoSourceClient";
    private HttpServerPushHandler httpServerPushHandler = null;
    private String videoPostfix = null;

    @Override
    protected boolean isRunFinished() {
        return super.isRunFinished(CLASS_NAME);
    }

    @Override
    public int init() {
        try {
            int errorCode = 0;
            this.logger.info("init started for" + this.getVideoSrv());
            errorCode = super.init(false);
            if (errorCode != 0) {
                this.logger.error("Error while initializing. Code: " + errorCode + " for " + this);
                return errorCode;
            }
            try {
                StringBuilder sb = new StringBuilder();
                int streamID = this.listener.getDynamicVideoProfileID();
                if (this.getListener().getLiveCameraSrv().getDevice().getNumberOfVideoSources() > 1) {
                    this.videoPostfix = this.videoSourceNr - 1 == 0 ? "" : "" + this.videoSourceNr;
                    this.videoPostfix = streamID == 0 ? this.videoPostfix : this.videoPostfix + "s" + (streamID + 1);
                } else {
                    String string = this.videoPostfix = streamID == 0 ? "" : "" + (streamID + 1);
                }
                if (this.getVideoSrv().getEntityType() == 212434L) {
                    streamID = ((VivotekCameraSrv)this.getVideoSrv()).getStreamNumber(this.listener.getDynamicVideoProfileID());
                    this.videoPostfix = "" + (1 + streamID);
                }
                String prefix = "videoin_c" + (this.videoSourceNr - 1) + "_s" + streamID + "_";
                int[] allowedValues = new int[]{1, 2, 3, 5, 10, 15, 20, 25, 30, 60};
                int fps = Tools.convertToCameraValues(allowedValues, (int)(this.highestFramerate / 1000L));
                if (this.getVideoSrv().getEntityType() == 212431L) {
                    int[] allowedFramerates = new int[]{1, 2, 3, 5, 8, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55, 60};
                    fps = Tools.convertToCameraValues(allowedFramerates, (int)(this.highestFramerate / 1000L));
                }
                this.quality /= 20000;
                this.quality = this.quality < 1 ? 1 : this.quality;
                sb.append("/cgi-bin/operator/setparam.cgi?");
                sb.append(prefix);
                sb.append("codectype=mjpeg");
                sb.append("&");
                sb.append(prefix);
                sb.append("mjpeg_maxframe=");
                sb.append(fps);
                sb.append("&");
                sb.append(prefix);
                sb.append("resolution=");
                if (this.getVideoSrv().getEntityType() == 212407L || this.getVideoSrv().getEntityType() == 212425L || this.getVideoSrv().getEntityType() == 212429L || this.getVideoSrv().getEntityType() == 212437L) {
                    sb.append(((VivotekCameraSrv)this.getVideoSrv()).getResolutionName(this.width));
                } else if (this.resolutionTag != null && !this.resolutionTag.isEmpty()) {
                    sb.append(this.resolutionTag);
                } else {
                    sb.append(this.width);
                    sb.append("x");
                    sb.append(this.height);
                }
                sb.append("&videoin_c");
                sb.append(this.videoSourceNr - 1);
                sb.append("_");
                sb.append("imprinttimestamp=");
                if (this.useDateTime) {
                    sb.append("1");
                } else {
                    sb.append("0");
                }
                sb.append("&videoin_c");
                sb.append(this.videoSourceNr - 1);
                sb.append("_");
                sb.append("text=");
                if (this.useTitle) {
                    sb.append(this.title);
                }
                if (this.getVideoSrv().getEntityType() == 212434L || this.getVideoSrv().getEntityType() == 212436L) {
                    sb.append("&");
                    sb.append(prefix);
                    sb.append("mjpeg_ratecontrolmode=vbr");
                }
                sb.append("&");
                sb.append(prefix);
                sb.append("mjpeg_quant=");
                sb.append(this.quality);
                sb.append("&videoin_c");
                sb.append(this.videoSourceNr - 1);
                sb.append("_");
                sb.append("flip=");
                if (this.rotationAngle == 180) {
                    sb.append("1");
                    sb.append("&videoin_c");
                    sb.append(this.videoSourceNr - 1);
                    sb.append("_");
                    sb.append("mirror=1");
                } else if (this.rotationAngle == 0) {
                    sb.append("0");
                    sb.append("&videoin_c");
                    sb.append(this.videoSourceNr - 1);
                    sb.append("_");
                    sb.append("mirror=0");
                }
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)sb.toString(), (int)Integer.MAX_VALUE);
            }
            catch (SeeTecException see) {
                this.logger.error((Object)see, (Throwable)see);
                return see.getErrorCode();
            }
            this.myThread = new Thread((Runnable)this, this.toString());
            this.myThread.start();
            return errorCode;
        }
        catch (Throwable t) {
            this.logger.error("Unexpected exception while initialization for " + this, t);
            return -20000;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        int errorCode = 0;
        super.setRunFinished(CLASS_NAME, false);
        try {
            while (!this.isShutdown()) {
                try {
                    String serverPushURL = "/video" + this.videoPostfix + ".mjpg";
                    boolean bAsynchronous = false;
                    this.httpServerPushHandler = new HttpServerPushHandler();
                    int legacyTimeout = ((VivotekDevice)this.videoSrv.getDevice()).legacyTimeout;
                    this.networkParameter.checkAndSetTimeout(legacyTimeout);
                    errorCode = this.httpServerPushHandler.init(this, this.networkParameter, serverPushURL);
                    if (errorCode != 0) {
                        this.logger.error("Error [" + errorCode + "] with " + this.httpServerPushHandler);
                    } else {
                        errorCode = this.httpServerPushHandler.startServerPush(bAsynchronous);
                    }
                    if (this.httpServerPushHandler == null) continue;
                    this.httpServerPushHandler.shutdown();
                }
                catch (Exception e) {
                    this.logger.error("Reading configuration from " + this.getVideoSrv().getDevice() + " failed :-(", (Throwable)e);
                    errorCode = -21601;
                    this.listener.sendStatusService(errorCode);
                }
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            errorCode = -21651;
            this.listener.sendStatusService(errorCode);
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    @Override
    public void sendStatusService(int nStatusCode) {
        this.listener.sendStatusService(nStatusCode);
    }

    @Override
    public void notifyForNetworkProblems() {
        this.sendStatusService(-21603);
        this.listener.notifyForNetworkProblems();
        this.shutdown();
    }

    @Override
    public void deliverContent(HttpServerPushContent httpServerPushContent) {
        byte[] contentData = httpServerPushContent.getContentBody();
        if (contentData != null) {
            byte[] FFE2Header = new byte[]{-1, -30};
            byte[] JPEGMarker = new byte[]{106, 112, 101, 103};
            int index = -1;
            int lengthUserData = -1;
            index = Basic.indexOfByteArray((byte[])contentData, (byte[])FFE2Header, (int)0, (int)200);
            if (index != -1) {
                if ((index = Basic.indexOfByteArray((byte[])contentData, (byte[])JPEGMarker, (int)index, (int)200)) != -1) {
                    if (this.getVideoSrv().getDevice().getIOHandler() != null) {
                        boolean additionalDIsActive;
                        byte statusAllInputs = (byte)(contentData[index] & 0xF);
                        boolean bl = additionalDIsActive = (byte)(contentData[index + 2] & 2) == 2;
                        if (additionalDIsActive) {
                            byte statusDI7 = (byte)(contentData[index + 2] << 3 & 8);
                            byte statusDI4To6 = (byte)(contentData[index + 3] >> 5 & 7);
                            statusAllInputs = (byte)(statusAllInputs | statusDI7 << 4 | statusDI4To6 << 4);
                        }
                        ((VivotekIOHandler)this.getVideoSrv().getDevice().getIOHandler()).processContent(statusAllInputs);
                    }
                    lengthUserData = contentData[index += 11] * 4;
                    byte[] bytesToCheckForMotion = new byte[lengthUserData];
                    System.arraycopy(contentData, index + 1, bytesToCheckForMotion, 0, bytesToCheckForMotion.length);
                    if (this.listener.hasHardwareMotionDetection() && this.getVideoSrv().getHardwareMotionDetection() != null) {
                        ((VivotekMotionDetectionHandler)((Object)((VivotekHardwareMotionDetection)this.getVideoSrv().getHardwareMotionDetection()).getMotionDetectionHandler())).processMotionDetection(bytesToCheckForMotion);
                    }
                } else {
                    this.logger.warn("Following spec the JPEG should contain JPEG Marker. It doesn't. " + this.getVideoSrv().getDevice());
                    this.sendStatusService(-21650);
                    this.shutdown();
                }
            }
            super.deliverContent(contentData);
        }
    }
}

