/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.sony.mpeg;

import de.seetec.v5.re.cm.device.shared.net.NetworkCallback;
import de.seetec.v5.re.cm.device.shared.net.udp.UdpReaderUnicast;
import de.seetec.v5.re.cm.device.shared.net.udp.UdpWriterUnicast;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelper;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelperH264;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelperMpeg4;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClient;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Random;

public class SonyMPEGVideoSourceClient
extends StreamingVideoSourceClient
implements NetworkCallback {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.sony.mpeg.SonyMPEGVideoSourceClient";
    final int[] MPEG_BITRATES = new int[]{0, 64, 128, 256, 384, 512, 768, 1024, 1536, 2048};
    final int[] H264_BITRATES = new int[]{0, 32, 64, 128, 256, 384, 512, 768, 1024, 1536};
    private UdpReaderUnicast udpReader = null;
    private UdpReaderUnicast udpRTCPReader = null;
    private UdpReaderUnicast udpReaderAudio = null;
    private UdpReaderUnicast udpRTCPAudioReader = null;
    private UdpWriterUnicast udpRTCPAudioWriter = null;
    private String parameterPrefix = "";
    private String codec = "mpeg4";
    private static final int SERVER_PORT = 50001;
    private static final int SERVER_PORT_AUDIO = 50003;

    @Override
    public int init() {
        int[] allowedValues;
        this.receiverReport[0] = -127;
        this.receiverReport[1] = -55;
        this.receiverReport[2] = 0;
        this.receiverReport[3] = 7;
        Random random = new Random(System.currentTimeMillis());
        byte[] myssrc = new byte[4];
        random.nextBytes(myssrc);
        System.arraycopy(myssrc, 0, this.receiverReport, 4, myssrc.length);
        this.completeFrame = new ByteArrayOutputStream();
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        if (this.videoCodec == Codec.MPEG4) {
            allowedValues = new int[this.MPEG_BITRATES.length];
            System.arraycopy(this.MPEG_BITRATES, 0, allowedValues, 0, this.MPEG_BITRATES.length);
            this.parameterPrefix = "M4";
            this.codec = "mpeg4";
        } else if (this.videoCodec == Codec.H264) {
            allowedValues = new int[this.H264_BITRATES.length];
            System.arraycopy(this.H264_BITRATES, 0, allowedValues, 0, this.H264_BITRATES.length);
            this.parameterPrefix = "H264";
            this.codec = this.parameterPrefix.toLowerCase();
        } else {
            allowedValues = new int[]{};
        }
        this.fps /= 1000L;
        if (this.fps > 22L) {
            this.fps = 25L;
        } else if (this.fps > 18L && this.fps <= 22L) {
            this.fps = 20L;
        } else if (this.fps > 10L && this.fps <= 14L) {
            this.fps = 12L;
        } else if (this.fps > 7L && this.fps <= 10L) {
            this.fps = 8L;
        }
        if (this.fps > 8L && this.width == 640 && this.videoCodec == Codec.H264) {
            this.logger.info("H264 is capable for 8 fps only. Reduce it.");
            this.fps = 8L;
        }
        this.iFrameDist /= 1000L;
        this.iFrameDist = this.iFrameDist <= 0L ? 1L : this.iFrameDist;
        this.iFrameDist = this.iFrameDist > 5L ? 5L : this.iFrameDist;
        this.bandwidth /= 1024;
        if (this.bandwidth == 0) {
            this.bandwidth = allowedValues[allowedValues.length - 1];
        } else {
            for (int i = 0; i < allowedValues.length; ++i) {
                int n;
                if (allowedValues[i] > this.bandwidth) {
                    int middle = (allowedValues[i] + allowedValues[i - 1]) / 2;
                    this.bandwidth = this.bandwidth > middle ? allowedValues[i] : allowedValues[i - 1];
                    break;
                }
                if (i == allowedValues.length - 1) {
                    n = allowedValues[allowedValues.length - 1];
                    this.bandwidth = this.bandwidth;
                } else {
                    n = this.bandwidth;
                }
                this.bandwidth = n;
            }
        }
        String audioCodecAsString = "";
        if (this.isAudioEnabled) {
            try {
                audioCodecAsString = this.audioCodec + "_" + this.audioBitrate / 1000;
                this.logger.info("Audio Parameter: " + audioCodecAsString + ".");
            }
            catch (Exception e) {
                this.logger.error("Reading audio configuration from " + this.getVideoSrv().getDevice() + " failed :-(", (Throwable)e);
                return -21601;
            }
        }
        this.logger.info("Requested resolution: " + this.width + "x" + this.height + " (Bandwidth: " + this.bandwidth + ",fps: " + this.fps + ",iFrameDist:" + this.iFrameDist + ") for " + this.getVideoSrv());
        StringBuilder content = new StringBuilder("ImageCodec=");
        content.append(this.codec);
        content.append("&");
        content.append(this.parameterPrefix);
        content.append("ImageSize=");
        content.append(this.width);
        content.append("%2C2&");
        content.append("ImageSize=");
        content.append(this.width);
        content.append("%2C2&");
        content.append(this.parameterPrefix);
        content.append("FrameRate=");
        content.append(this.fps);
        content.append("&");
        content.append(this.parameterPrefix);
        content.append("BitRate=");
        content.append(this.bandwidth);
        content.append("&");
        content.append(this.parameterPrefix);
        content.append("IFrameInterval=");
        content.append(this.iFrameDist);
        if (this.isAudioEnabled) {
            content.append("&AudioIn=on&AudInCodec=");
            if (this.audioCodec.name().contains("G711")) {
                content.append("g711");
            } else {
                content.append(this.audioCodec.name().toLowerCase());
            }
            content.append("_");
            content.append(this.audioBitrate / 1000);
        }
        try {
            NetworkHelper.readPostRequest((NetworkParameter)this.networkParameter, (String)"/command/camera.cgi", (String)content.toString(), (int)Integer.MAX_VALUE, (boolean)false);
        }
        catch (SeeTecException e) {
            if (e.getErrorCode() == -21657) {
                return -21657;
            }
            this.logger.error("Exception while setting initial parameters for " + this.getVideoSrv(), (Throwable)e);
            return e.getErrorCode();
        }
        this.udpReader = new UdpReaderUnicast(this);
        this.udpReader.init(524288, 5000, true, true);
        this.logger.info("UDP port is " + this.udpReader.getPort() + " for " + this.getVideoSrv());
        try {
            this.udpRTCPReader = new UdpReaderUnicast(this, this.udpReader.getPort() + 1, InetAddress.getByName(this.getHost()), 50001);
            this.udpRTCPReader.init(524288, 50000, true);
        }
        catch (Exception e) {
            this.logger.error((Object)e, (Throwable)e);
            return -21603;
        }
        StringBuffer url = new StringBuffer("/");
        if (this.getVideoSrv().getDevice().getDeviceType() == 200623L) {
            url.append("command/image.cgi?ChannelNO=1");
            url.append("&UdpMode=unicast&UdpPort=");
        } else {
            url.append(this.codec);
            url.append("?UdpMode=unicast&UdpPort=");
        }
        url.append(this.udpReader.getPort());
        try {
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MIN_VALUE);
        }
        catch (SeeTecException e) {
            this.logger.error("Exception while setting udp mode for " + this.getVideoSrv());
            return e.getErrorCode();
        }
        if (this.isAudioEnabled) {
            this.logger.info("Audio enabled for " + this.getVideoSrv());
            this.setLegacyAudioSourceClient(new StreamingVideoSourceClient.LegacyAudioSourceClient(this));
            this.udpReaderAudio = new UdpReaderUnicast(this.getLegacyAudioSourceClient());
            this.udpReaderAudio.init(524288, 5000, true, true);
            this.logger.info("UDP audio port '" + this.udpReaderAudio.getPort() + "' opened for " + this.getVideoSrv());
            try {
                this.udpRTCPAudioReader = new UdpReaderUnicast(this.getLegacyAudioSourceClient(), this.udpReaderAudio.getPort() + 1, InetAddress.getByName(this.getHost()), 50003);
                this.udpRTCPAudioReader.init(524288, 50000, true);
                this.udpRTCPAudioWriter = new UdpWriterUnicast(InetAddress.getByName(this.getHost()), this.udpRTCPAudioReader.getSocket(), 50003);
                this.getLegacyAudioSourceClient().init(this.udpRTCPAudioWriter);
            }
            catch (Exception e) {
                this.logger.error((Object)e, (Throwable)e);
                return -21603;
            }
            url = new StringBuffer("/audio?UdpMode=unicast&UdpPort=");
            url.append(this.udpReaderAudio.getPort());
            try {
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)url.toString(), (int)Integer.MIN_VALUE);
            }
            catch (SeeTecException e) {
                this.logger.error("Exception while setting udp mode for " + this.getVideoSrv());
                return e.getErrorCode();
            }
        }
        this.publishRTSPUrl(url.toString());
        this.logger.info("Init done for " + this.getVideoSrv());
        return 0;
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        byte[] rtcpBye = new byte[8];
        rtcpBye[0] = -127;
        rtcpBye[1] = -53;
        rtcpBye[2] = 0;
        rtcpBye[3] = 1;
        if (this.receiverReport != null) {
            rtcpBye[4] = this.receiverReport[7];
            rtcpBye[5] = this.receiverReport[6];
            rtcpBye[6] = this.receiverReport[5];
            rtcpBye[7] = this.receiverReport[4];
        }
        if (this.isAudioEnabled) {
            if (this.getLegacyAudioSourceClient() != null && this.getLegacyAudioSourceClient().getReceiverReportAudio() != null) {
                rtcpBye[4] = this.getLegacyAudioSourceClient().getReceiverReportAudio()[7];
                rtcpBye[5] = this.getLegacyAudioSourceClient().getReceiverReportAudio()[6];
                rtcpBye[6] = this.getLegacyAudioSourceClient().getReceiverReportAudio()[5];
                rtcpBye[7] = this.getLegacyAudioSourceClient().getReceiverReportAudio()[4];
            }
            if (this.udpRTCPAudioReader != null) {
                this.udpRTCPAudioReader.send(rtcpBye);
            }
        }
        if (this.udpRTCPReader != null) {
            this.udpRTCPReader.send(rtcpBye);
            this.udpRTCPReader.shutdown();
        }
        this.udpRTCPReader = null;
        if (this.udpRTCPAudioReader != null) {
            this.udpRTCPAudioReader.shutdown();
        }
        this.udpRTCPAudioReader = null;
        if (this.udpRTCPAudioWriter != null) {
            this.udpRTCPAudioWriter.shutdown();
        }
        this.udpRTCPAudioWriter = null;
        if (this.udpReader != null) {
            this.udpReader.shutdown();
        }
        this.udpReader = null;
        if (this.udpReaderAudio != null) {
            this.udpReaderAudio.shutdown();
        }
        this.udpReaderAudio = null;
        super.shutdown();
        this.completeFrame = null;
        this.audioCodec = null;
        this.parameterPrefix = null;
        this.codec = null;
        this.receiverReport = null;
        return 0;
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error + " for " + this.getVideoSrv());
        this.listener.sendStatusService(error);
        this.shutdown();
        if (this.getVideoSrv() != null && this.getVideoSrv().getHardwareMotionDetection() != null) {
            this.getVideoSrv().getHardwareMotionDetection().notifyForNetworkProblems();
        }
    }

    @Override
    public synchronized void onUdpData(byte[] data) {
        byte[] completeFrameAsByteArray = null;
        if (this.isShutdown()) {
            return;
        }
        if (data == null) {
            this.logger.error("Incoming data is null");
            return;
        }
        try {
            if (data.length >= 2 && data[0] == -128 && data[1] == -56) {
                System.arraycopy(data, 4, this.receiverReport, 8, 4);
                System.arraycopy(data, 10, this.receiverReport, 24, 4);
                this.udpRTCPReader.send(this.receiverReport);
                return;
            }
            System.arraycopy(data, 2, this.receiverReport, 18, 2);
            this.checkForPacketLoss(data);
            try {
                if (data.length <= 13) {
                    return;
                }
                this.completeFrame.write(data, 12, data.length - 12);
                this.completeFrame.flush();
            }
            catch (IOException e) {
                this.logger.error("Error cummulating data for a frame.", (Throwable)e);
            }
            if (!StreamingHelper.isFollowUp(data)) {
                Codec mediaCodec;
                int mediaType;
                completeFrameAsByteArray = this.completeFrame.toByteArray();
                this.completeFrame.reset();
                if (this.codec.equals("mpeg4")) {
                    int[] currentResolution;
                    mediaType = StreamingHelperMpeg4.checkForMPEG4Part2MediaType(completeFrameAsByteArray);
                    mediaCodec = Codec.MPEG4;
                    if (mediaType == 33 && (currentResolution = StreamingHelperMpeg4.extractMPEG4Part2Resolution(completeFrameAsByteArray)) != null) {
                        this.width = currentResolution[0];
                        this.height = currentResolution[1];
                    }
                } else if (this.codec.equals("h264")) {
                    int skip;
                    int startIndex;
                    int[] resolutionFromStream;
                    mediaType = this.checkForSonyH264MediaType(completeFrameAsByteArray);
                    mediaCodec = Codec.H264;
                    if (mediaType == 33 && (resolutionFromStream = StreamingHelperH264.extractH264Resolution(completeFrameAsByteArray, startIndex = Basic.indexOfByteArray((byte[])completeFrameAsByteArray, (byte[])StreamingHelper.START_SEQUENCE, (int)(skip = 0), (int)(completeFrameAsByteArray.length - skip), (boolean)true))) != null) {
                        this.width = resolutionFromStream[0];
                        this.height = resolutionFromStream[1];
                    }
                } else {
                    this.logger.fatal("StreamingMode not MPEG4 and not H264. Data can't be handled in here!");
                    return;
                }
                if (mediaType >= 0) {
                    MediaFrame mediaFrame = StreamingHelper.createSeeTecVideoFrameHeader(mediaCodec, this.width, this.height, completeFrameAsByteArray);
                    this.deliverFrameCreateServerTimestamp(mediaType, mediaFrame);
                }
            }
        }
        catch (Throwable t) {
            this.logger.error("Ignoring packet due to unexpected error: " + t.getMessage(), t);
        }
    }

    protected int checkForSonyH264MediaType(byte[] completeFrameAsByteArray) {
        int skip = 4;
        int mediaType = StreamingHelperH264.checkForH264MediaType(this.getVideoSrv().getDevice(), completeFrameAsByteArray, skip);
        switch (mediaType) {
            case 7: {
                break;
            }
            case 8: {
                skip = 1;
                mediaType = StreamingHelperH264.checkForH264MediaType(this.getVideoSrv().getDevice(), completeFrameAsByteArray, skip);
                break;
            }
        }
        mediaType = mediaType == 7 ? 33 : mediaType;
        return mediaType;
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }
}

