/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.sony.mpeg;

import de.seetec.v5.re.cm.device.shared.net.rtsp.HttpStreamHandler;
import de.seetec.v5.re.cm.device.shared.net.rtsp.HttpStreamListenerIntf;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingHelper;
import de.seetec.v5.re.cm.device.shared.videosource.StreamingVideoSourceClientRTSP;
import de.seetec.v5.re.cm.device.video.sony.SonyCameraSrv;
import de.seetec.v5.re.cm.device.video.sony.SonyDevice;
import de.seetec.v5.re.cm.shared.Tools;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.SSLConstantsIntf;
import de.seetec.v5.shared.net.NetworkHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;

public class SonyH264VideoSourceClient_5thGen
extends StreamingVideoSourceClientRTSP
implements HttpStreamListenerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.sony.mpeg.SonyH264VideoSourceClient_5thGen";
    private ByteArrayOutputStream baos = null;
    private int streamNumber = 1;
    private boolean isPalFormat = false;
    final int[] allowedBitrates = new int[]{64, 128, 256, 384, 512, 768, 1024, 1536, 2048, 3072, 4096, 5120, 6144, 7168, 8192};
    private SonyDevice sonyDevice = null;
    private HttpStreamHandler httpStreamHandler = null;
    private AudioHandler audioHandler = null;
    private Thread audioHandlerThread = null;

    private int setHttpParameters(long frameRate, long iFrameDistance, int bandWidth) {
        byte[] result;
        try {
            result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/command/inquiry.cgi?inqjs=camera", (int)Integer.MAX_VALUE, (boolean)false, (String)("ImageCodec" + this.streamNumber));
            if (result != null && !new String(result).contains("ImageCodec" + this.streamNumber + "=\"h264\"")) {
                this.logger.info("Changing codec: setting H.264 for stream " + this.streamNumber);
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)("/command/camera.cgi?ImageCodec" + this.streamNumber + "=h264"), (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
                NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/command/inquiry.cgi?inqjs=camera", (int)Integer.MAX_VALUE, (boolean)true);
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException ex) {
            this.logger.info("Exception occured while interrupting thread: " + ex.getMessage() + " for " + this);
        }
        catch (SeeTecException ex) {
            this.logger.info("Exception occured while retrieving camera setup: " + ex.getMessage() + " for " + this);
            return ex.getErrorCode();
        }
        StringBuilder sbStreamParameters = new StringBuilder(256);
        sbStreamParameters.append("/command/camera.cgi?FrameRate");
        sbStreamParameters.append(this.streamNumber).append("=");
        sbStreamParameters.append(frameRate);
        sbStreamParameters.append("&IFrameInterval").append(this.streamNumber).append("=");
        sbStreamParameters.append(iFrameDistance);
        if (this.getVideoSrv().getDevice().getDeviceType() != 200633L) {
            if (this.isAudioEnabled) {
                sbStreamParameters.append("&AudioIn=on");
                if (this.audioCodec == Codec.G711U) {
                    sbStreamParameters.append("&AudInCodec=g711_64");
                } else if (this.audioCodec == Codec.G726) {
                    sbStreamParameters.append("&AudInCodec=g726_40");
                }
            } else {
                sbStreamParameters.append("&AudioIn=off");
            }
        }
        if (this.isConstantBitrateUsed) {
            sbStreamParameters.append("&Bitrate").append(this.streamNumber).append("=").append(bandWidth);
        } else {
            sbStreamParameters.append("&AutoRateCtrl").append(this.streamNumber).append("=on");
        }
        try {
            result = NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)sbStreamParameters.toString(), (int)Integer.MAX_VALUE, (boolean)false, null, (boolean)true);
            NetworkHelper.readGetRequest((NetworkParameter)this.networkParameter, (String)"/command/inquiry.cgi?inqjs=camera", (int)Integer.MAX_VALUE, (boolean)true);
        }
        catch (SeeTecException ex) {
            this.logger.error("Error setting parameters on camera: " + (Object)((Object)ex));
            return ex.getErrorCode();
        }
        if (new String(result).contains("204")) {
            return 0;
        }
        return -20001;
    }

    @Override
    protected int init() {
        int[] allowedValues;
        this.errorCode = super.init();
        if (this.errorCode != 0) {
            this.logger.error("Error while initializing. Code: " + this.errorCode + " for " + this);
            return this.errorCode;
        }
        SonyCameraSrv sonyCameraSrv = (SonyCameraSrv)this.getVideoSrv();
        try {
            this.streamNumber = sonyCameraSrv.getStreamNumber(this.listener.getDynamicVideoProfileID());
            this.isPalFormat = sonyCameraSrv.isPalFormat();
        }
        catch (SeeTecException ex) {
            this.logger.error("Exception while getting stream number for " + this);
            return ex.getErrorCode();
        }
        this.sonyDevice = (SonyDevice)sonyCameraSrv.getDevice();
        long entityType = super.getVideoSrv().getEntityType();
        this.networkParameter.setSoTimeout(5000);
        try {
            this.errorCode = this.sonyDevice.setRTSPPort(this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort());
            if (this.errorCode != 0) {
                this.logger.error("Could not set RTSP Port ");
                return this.errorCode;
            }
        }
        catch (ConfigurationException exception) {
            this.logger.warn("RTSP port could not be read", (Throwable)exception);
        }
        this.iFrameDist = this.iFrameDistMS / 1000;
        this.iFrameDist = this.iFrameDist < 1L ? 1L : this.iFrameDist;
        this.iFrameDist = this.iFrameDist > 5L ? 5L : this.iFrameDist;
        this.quality /= 10000;
        this.quality = this.quality > 10 ? 10 : this.quality;
        this.quality = this.quality < 0 ? 0 : this.quality;
        this.fps /= 1000L;
        if (entityType == 210528L || entityType == 210535L || entityType == 210536L || entityType == 210541L || entityType == 210537L || entityType == 210542L) {
            allowedValues = new int[]{1, 2, 3, 4, 5, 6, 8, 10, 12, 15, 16, 20, 25, 30};
            this.fps = Tools.convertToCameraValues(allowedValues, (int)this.fps);
        } else if (entityType == 210540L) {
            allowedValues = new int[]{1, 2, 3, 4, 5, 6, 8, 10, 12, 15, 16, 20, 25, 30};
            this.fps = Tools.convertToCameraValues(allowedValues, (int)this.fps);
        } else if (entityType == 210526L || entityType == 210532L || entityType == 210527L || entityType == 210533L || entityType == 210529L || entityType == 210538L || entityType == 210534L) {
            allowedValues = new int[]{1, 2, 3, 4, 5, 6, 8, 10, 15, 20, 25, 30};
            this.fps = Tools.convertToCameraValues(allowedValues, (int)this.fps);
        } else if (entityType == 210539L) {
            allowedValues = new int[]{1, 2, 3, 4, 5, 6, 8, 12, 16, 20, 25};
            this.fps = Tools.convertToCameraValues(allowedValues, (int)this.fps);
        } else if (this.isPalFormat) {
            allowedValues = new int[]{1, 2, 3, 4, 5, 6, 8, 12, 16, 20, 25};
            this.fps = Tools.convertToCameraValues(allowedValues, (int)this.fps);
        } else {
            allowedValues = new int[]{1, 2, 3, 4, 5, 6, 8, 10, 15, 20, 25, 30};
            this.fps = Tools.convertToCameraValues(allowedValues, (int)this.fps);
        }
        if (this.width >= 1920) {
            this.fps = this.fps > 25L ? 25L : this.fps;
        }
        this.bandwidth /= 1024;
        if (this.bandwidth == 0) {
            this.bandwidth = this.allowedBitrates[this.allowedBitrates.length - 1];
        } else if (this.bandwidth <= this.allowedBitrates[0]) {
            this.bandwidth = this.allowedBitrates[0];
        } else if (this.bandwidth >= this.allowedBitrates[this.allowedBitrates.length - 1]) {
            this.bandwidth = this.allowedBitrates[this.allowedBitrates.length - 1];
        } else {
            for (int i = 0; i < this.allowedBitrates.length; ++i) {
                int n;
                if (this.allowedBitrates[i] > this.bandwidth) {
                    int middle = (this.allowedBitrates[i] + this.allowedBitrates[i - 1]) / 2;
                    this.bandwidth = this.bandwidth > middle ? this.allowedBitrates[i] : this.allowedBitrates[i - 1];
                    break;
                }
                if (i == this.allowedBitrates.length - 1) {
                    n = this.allowedBitrates[this.allowedBitrates.length - 1];
                    this.bandwidth = this.bandwidth;
                } else {
                    n = this.bandwidth;
                }
                this.bandwidth = n;
            }
        }
        if (!this.isPalFormat && this.width == 720 && this.height == 576) {
            this.height = 480;
        }
        if ((this.errorCode = this.setHttpParameters(this.fps, this.iFrameDist, this.bandwidth)) != 0) {
            this.logger.error("Could not set Video Parameters using http: " + this.errorCode);
            return this.errorCode;
        }
        this.rtspUrl = "rtsp://" + this.getHost() + "/media/video" + this.streamNumber;
        if (this.transmissionID == TransmissionType.HTTP) {
            String url = "/image" + this.streamNumber;
            if (this.isAudioEnabled) {
                this.audioHandler = new AudioHandler();
                this.audioHandlerThread = new Thread((Runnable)this.audioHandler, this.audioHandler.toString());
                this.audioHandlerThread.start();
            }
            this.httpStreamHandler = new HttpStreamHandler();
            this.errorCode = this.httpStreamHandler.init(this, this.networkParameter, url);
            if (this.errorCode != 0) {
                this.logger.error("Exception while initializing HTTP stream handler for " + this + " Error: " + this.errorCode);
                return this.errorCode;
            }
            this.errorCode = this.httpStreamHandler.startStreaming(true, false);
            if (this.errorCode != 0) {
                this.logger.error("Exception while starting HTTP reading for " + this + " Error: " + this.errorCode);
                return this.errorCode;
            }
        } else {
            this.rtspSettings = new RTSPStreamSettings();
            try {
                if (this.rtspSettings.init(this, this.audioSourceClient, this.networkParameter, this.listener.getVideoSourceParameter().getRtspPort(), this.rtspUrl, this.printDebug, this.transmissionID, 15000, this.isAudioEnabled, 4, this.rtspUrl) != 0) {
                    this.logger.error("Error while initializing Settings for RTSP streaming for " + this);
                    return -20001;
                }
            }
            catch (ConfigurationException ex) {
                this.logger.warn("Could not initialize rtspSettings for " + this);
                this.logger.warn((Object)ex, (Throwable)ex);
            }
            this.rtspSettings.setRange("npt=now-");
            this.rtspSettings.setKeepAliveInterval(30000);
            try {
                this.rtspHandler = this.rtspSettings.getRTSPHandler();
            }
            catch (SeeTecException ex) {
                this.logger.error("Exception while retrieving RTSP Handler for " + this + ": " + ex.getMessage());
                return ex.getErrorCode();
            }
            if (this.rtspHandler.start() != 0) {
                this.logger.error("Error while startint RTSP Handler for " + this);
                return -20001;
            }
        }
        this.publishRTSPUrl(this.rtspUrl);
        this.logger.info("init done for" + this.getVideoSrv());
        return 0;
    }

    @Override
    public synchronized int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.rtspHandler != null) {
            this.rtspHandler.shutdown();
            this.rtspHandler = null;
        }
        if (this.audioHandler != null) {
            this.audioHandler.shutdown();
            this.audioHandler = null;
        }
        super.shutdown();
        this.logger.info("shutdown done for " + this.getVideoSrv());
        return 0;
    }

    @Override
    public boolean isShutdown() {
        if (this.transmissionID == TransmissionType.HTTP && this.isAudioEnabled) {
            if (this.audioHandler == null) {
                return true;
            }
            return this.isShutdown(CLASS_NAME) || this.audioHandler.isShutdown();
        }
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public void onNetworkError(int error) {
        if (this.isShutdown()) {
            return;
        }
        this.logger.warn("Shutting down : " + error);
        this.listener.sendStatusService(error);
        this.shutdown();
    }

    @Override
    public synchronized void deliverRawContent(byte[] rawHTTPContent) {
        try {
            if (rawHTTPContent != null && rawHTTPContent.length > 0) {
                int firstIndex;
                if (this.baos == null) {
                    this.baos = new ByteArrayOutputStream();
                }
                this.baos.write(rawHTTPContent);
                byte[] data = this.baos.toByteArray();
                this.baos.reset();
                while (true) {
                    firstIndex = Basic.indexOfByteArray((byte[])data, (byte[])StreamingHelper.START_SEQUENCE, (int)0, (boolean)true);
                    int secondIndex = Basic.indexOfByteArray((byte[])data, (byte[])StreamingHelper.START_SEQUENCE, (int)(firstIndex + StreamingHelper.START_SEQUENCE.length), (boolean)true);
                    if (firstIndex == -1 || secondIndex == -1) break;
                    this.deliverH264Data(Arrays.copyOfRange(data, firstIndex, secondIndex), true, Long.MIN_VALUE);
                    ByteArrayOutputStream tmp = new ByteArrayOutputStream();
                    tmp.write(data, 0, firstIndex);
                    tmp.write(data, secondIndex, data.length - secondIndex);
                    data = tmp.toByteArray();
                }
                if (firstIndex != -1) {
                    this.baos.write(data, firstIndex, data.length - firstIndex);
                    return;
                }
                this.baos.write(data);
                return;
            }
        }
        catch (Exception e) {
            this.logger.error("Content length: " + rawHTTPContent.length + " for " + this.getVideoSrv(), (Throwable)e);
            if (rawHTTPContent.length < 100) {
                this.logger.error("Content: " + Basic.byteArrayToHexString((byte[])rawHTTPContent, (int)0, (int)rawHTTPContent.length));
            }
            this.logger.error("Content: " + Basic.byteArrayToHexString((byte[])rawHTTPContent, (int)0, (int)100));
        }
    }

    @Override
    public void sendStatusService(int statusCode) {
        if (this.listener != null) {
            this.listener.sendStatusService(statusCode);
        } else {
            this.logger.error("Listener null for " + this);
        }
    }

    @Override
    public void notifyForNetworkProblems() {
        this.logger.error("Network problem from HTTPStreamHandler signalied. Shutting down.");
        this.listener.sendStatusService(-21656);
        this.shutdown();
    }

    @Override
    public void processData(byte[] data) {
        this.processRtpData(data);
    }

    private class AudioHandler
    implements HttpStreamListenerIntf,
    Runnable {
        private boolean isShutdown = true;
        private boolean headerRemoved;

        private AudioHandler() {
        }

        @Override
        public void run() {
            String url = "/audio";
            SonyH264VideoSourceClient_5thGen.this.httpStreamHandler = new HttpStreamHandler();
            if ((SonyH264VideoSourceClient_5thGen.this.errorCode = SonyH264VideoSourceClient_5thGen.this.httpStreamHandler.init(this, SonyH264VideoSourceClient_5thGen.this.networkParameter, url)) != 0) {
                SonyH264VideoSourceClient_5thGen.this.logger.error("Exception while initializing HTTP stream handler for " + this + " Error: " + SonyH264VideoSourceClient_5thGen.this.errorCode);
            }
            if ((SonyH264VideoSourceClient_5thGen.this.errorCode = SonyH264VideoSourceClient_5thGen.this.httpStreamHandler.startStreaming(true, false)) != 0) {
                SonyH264VideoSourceClient_5thGen.this.logger.error("Exception while starting HTTP reading for " + this + " Error: " + SonyH264VideoSourceClient_5thGen.this.errorCode);
            }
            this.isShutdown = false;
        }

        @Override
        public boolean isShutdown() {
            return this.isShutdown && SonyH264VideoSourceClient_5thGen.this.httpStreamHandler.isShutdown();
        }

        @Override
        public void deliverRawContent(byte[] data) {
            if (!this.headerRemoved && Basic.indexOfByteArray((byte[])data, (byte[])SSLConstantsIntf.DOUBLE_CRLF_BYTE, (int)0) != -1) {
                this.headerRemoved = true;
                return;
            }
            try {
                MediaFrame mediaFrame = StreamingHelper.createSeeTecAudioFrameHeader(SonyH264VideoSourceClient_5thGen.this.audioCodec, SonyH264VideoSourceClient_5thGen.this.audioBitrate % 8000 == 0 ? (int)(SonyH264VideoSourceClient_5thGen.this.audioBitrate / 8000) : 0, data);
                SonyH264VideoSourceClient_5thGen.this.deliverFrameCreateServerTimestamp(16, mediaFrame);
            }
            catch (Throwable t) {
                SonyH264VideoSourceClient_5thGen.this.logger.error("Ignoring packet due to unexpected error: " + t.getMessage(), t);
            }
        }

        @Override
        public void notifyForNetworkProblems() {
            this.sendStatusService(-21603);
            SonyH264VideoSourceClient_5thGen.this.listener.notifyForNetworkProblems();
            this.shutdown();
        }

        @Override
        public void sendStatusService(int statusCode) {
            SonyH264VideoSourceClient_5thGen.this.listener.sendStatusService(statusCode);
        }

        private void shutdown() {
            if (SonyH264VideoSourceClient_5thGen.this.httpStreamHandler != null) {
                SonyH264VideoSourceClient_5thGen.this.httpStreamHandler.shutdown();
                SonyH264VideoSourceClient_5thGen.this.httpStreamHandler = null;
            }
            this.isShutdown = true;
        }
    }
}

